/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cli;

import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.solr.cli.ConfigSetDownloadTool;
import org.apache.solr.cli.ConfigSetUploadTool;
import org.apache.solr.cli.LinkConfigTool;
import org.apache.solr.cli.SolrCLI;
import org.apache.solr.cli.ToolBase;
import org.apache.solr.cli.ToolRuntime;
import org.apache.solr.cli.UpdateACLTool;
import org.apache.solr.cli.ZkCpTool;
import org.apache.solr.cli.ZkLsTool;
import org.apache.solr.cli.ZkMkrootTool;
import org.apache.solr.cli.ZkMvTool;

public class ZkToolHelp
extends ToolBase {
    public ZkToolHelp(ToolRuntime runtime) {
        super(runtime);
    }

    @Override
    public List<Option> getOptions() {
        return List.of(Option.builder().longOpt("print-zk-subcommand-usage").desc("Reminds user to prepend zk to invoke the command.").required(false).build(), Option.builder().longOpt("print-long-zk-usage").required(false).desc("Invokes the detailed help for zk commands.").build());
    }

    @Override
    public String getName() {
        return "zk-tool-help";
    }

    @Override
    public void runImpl(CommandLine cli) throws Exception {
        SolrCLI.raiseLogLevelUnlessVerbose(cli);
        if (cli.hasOption("print-zk-subcommand-usage")) {
            String scriptCommand = cli.getArgs()[0];
            SolrCLI.print("You must invoke this subcommand using the zk command.   bin/solr zk " + scriptCommand + ".");
        }
        if (cli.hasOption("print-long-zk-usage")) {
            SolrCLI.print("usage:");
            SolrCLI.print(new ZkLsTool(this.runtime).getUsage());
            SolrCLI.print(new ZkCpTool(this.runtime).getUsage());
            SolrCLI.print(new ZkMvTool(this.runtime).getUsage());
            SolrCLI.print(new ConfigSetUploadTool(this.runtime).getUsage());
            SolrCLI.print(new ConfigSetDownloadTool(this.runtime).getUsage());
            SolrCLI.print(new ZkMkrootTool(this.runtime).getUsage());
            SolrCLI.print(new LinkConfigTool(this.runtime).getUsage());
            SolrCLI.print(new UpdateACLTool(this.runtime).getUsage());
            SolrCLI.print("");
            SolrCLI.print("Pass --help or -h after any COMMAND to see command-specific usage information such as: ./solr zk ls --help");
        }
    }
}

