/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.drawable;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import net.sf.sdedit.config.SequenceConfiguration;
import net.sf.sdedit.diagram.Lifeline;
import net.sf.sdedit.drawable.Drawable;
import net.sf.sdedit.drawable.DrawableLabel;
import net.sf.sdedit.drawable.Strokes;

public class LabeledBox
extends Drawable {
    private int headWidth;
    private int headHeight;
    private int padding;
    private Stroke stroke;
    private Lifeline lifeline;

    public LabeledBox(Lifeline lifeline, String _label, int y, boolean anonymous, boolean underlined) {
        super(lifeline.getDiagram());
        this.setTop(y);
        DrawableLabel dlabel = this.addLabel();
        dlabel.setUnderlined(underlined);
        this.lifeline = lifeline;
        String label = lifeline.isExternal() ? "" : (!_label.equals("") ? _label : (anonymous ? ":" + lifeline.getType() : lifeline.getName() + ":" + lifeline.getType()));
        dlabel.setLabel(label.split("\\\\n"));
        SequenceConfiguration conf = lifeline.getDiagram().getConfiguration();
        this.headWidth = conf.getHeadWidth();
        this.headHeight = conf.getHeadHeight();
        this.padding = conf.getHeadLabelPadding();
        if (lifeline.isExternal()) {
            this.setWidth(lifeline.getDiagram().mainLifelineWidth);
        } else {
            this.setWidth(2 + Math.max(2 * this.padding + dlabel.textWidth(), this.headWidth));
        }
        this.stroke = lifeline.isAlwaysActive() ? Strokes.getStroke(Strokes.StrokeType.SOLID, 2) : Strokes.getStroke(Strokes.StrokeType.SOLID, 1);
        int extraHeight = (int)(((double)dlabel.getNumLines() - 1.0) * ((double)dlabel.textHeight() / 1.0 * (double)dlabel.getNumLines()));
        this.setHeight(this.headHeight + 4 + extraHeight);
    }

    @Override
    public boolean isVisible() {
        return !this.lifeline.isExternal() && super.isVisible();
    }

    @Override
    protected void drawObject(Graphics2D g2d) {
        int axis = this.getLeft() + this.getWidth() / 2;
        int top = this.getTop();
        int width = this.getWidth();
        int headHeight = this.getHeight() - 4;
        if (this.lifeline.getDiagram().getConfiguration().isShouldShadowParticipants()) {
            g2d.fillRect(axis - width / 2 + 2, top + 2, width + 2, headHeight + 2);
        }
        g2d.setColor(this.lifeline.getDiagram().getConfiguration().getLabeledBoxBgColor());
        g2d.fillRect(axis - width / 2, top, width, headHeight);
        g2d.setColor(Color.BLACK);
        g2d.setStroke(this.stroke);
        g2d.drawRect(axis - width / 2, top, width, headHeight);
        g2d.setStroke(Strokes.defaultStroke());
        int left = axis - this.getLabel().textWidth() / 2;
        int baseLine = top + headHeight / 2;
        int textHeight = this.getLabel().textHeight();
        if (this.getLabel().getNumLines() > 1) {
            baseLine = top + 2 + textHeight;
        }
        this.getLabel().drawLabel(g2d, left, baseLine, Color.BLACK, this.lifeline.getDiagram().getConfiguration().getLabeledBoxBgColor());
    }

    @Override
    public void computeLayoutInformation() {
    }
}

