/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.formatter;

import com.intellij.formatting.ASTBlock;
import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.FormattingMode;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.WrapType;
import com.intellij.lang.ASTNode;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.TokenType;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.jetbrains.python.PyElementTypes;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.PythonCodeStyleService;
import com.jetbrains.python.PythonDialectsTokenSetProvider;
import com.jetbrains.python.ast.PyAstArgumentList;
import com.jetbrains.python.ast.PyAstBinaryExpression;
import com.jetbrains.python.ast.PyAstCallExpression;
import com.jetbrains.python.ast.PyAstClass;
import com.jetbrains.python.ast.PyAstComprehensionElement;
import com.jetbrains.python.ast.PyAstConditionalStatementPart;
import com.jetbrains.python.ast.PyAstDictLiteralExpression;
import com.jetbrains.python.ast.PyAstEllipsisLiteralExpression;
import com.jetbrains.python.ast.PyAstElsePart;
import com.jetbrains.python.ast.PyAstExpression;
import com.jetbrains.python.ast.PyAstExpressionStatement;
import com.jetbrains.python.ast.PyAstFile;
import com.jetbrains.python.ast.PyAstForStatement;
import com.jetbrains.python.ast.PyAstFromImportStatement;
import com.jetbrains.python.ast.PyAstFunction;
import com.jetbrains.python.ast.PyAstIfPart;
import com.jetbrains.python.ast.PyAstIfStatement;
import com.jetbrains.python.ast.PyAstImportStatementBase;
import com.jetbrains.python.ast.PyAstKeyValueExpression;
import com.jetbrains.python.ast.PyAstKeywordArgument;
import com.jetbrains.python.ast.PyAstNamedParameter;
import com.jetbrains.python.ast.PyAstParameterList;
import com.jetbrains.python.ast.PyAstParenthesizedExpression;
import com.jetbrains.python.ast.PyAstPassStatement;
import com.jetbrains.python.ast.PyAstRaiseStatement;
import com.jetbrains.python.ast.PyAstReturnStatement;
import com.jetbrains.python.ast.PyAstSequenceExpression;
import com.jetbrains.python.ast.PyAstSliceItem;
import com.jetbrains.python.ast.PyAstStatement;
import com.jetbrains.python.ast.PyAstStatementList;
import com.jetbrains.python.ast.PyAstStatementListContainer;
import com.jetbrains.python.ast.PyAstStatementPart;
import com.jetbrains.python.ast.PyAstSubscriptionExpression;
import com.jetbrains.python.ast.PyAstTryExceptStatement;
import com.jetbrains.python.ast.PyAstTupleExpression;
import com.jetbrains.python.ast.PyAstWhileStatement;
import com.jetbrains.python.ast.PyAstWithItem;
import com.jetbrains.python.ast.PyAstWithStatement;
import com.jetbrains.python.ast.impl.PyPsiUtilsCore;
import com.jetbrains.python.ast.impl.PyUtilCore;
import com.jetbrains.python.formatter.PyBlockContext;
import com.jetbrains.python.formatter.PyCodeStyleSettings;
import com.jetbrains.python.formatter.PyFormattableInjectedBlock;
import com.jetbrains.python.pyi.PyiUtilCore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyBlock
implements ASTBlock {
    private static final TokenSet STATEMENT_OR_DECLARATION = PythonDialectsTokenSetProvider.getInstance().getStatementTokens();
    private static final TokenSet ourListElementTypes = TokenSet.create((IElementType[])new IElementType[]{PyElementTypes.LIST_LITERAL_EXPRESSION, PyElementTypes.LIST_COMP_EXPRESSION, PyElementTypes.DICT_LITERAL_EXPRESSION, PyElementTypes.DICT_COMP_EXPRESSION, PyElementTypes.SET_LITERAL_EXPRESSION, PyElementTypes.SET_COMP_EXPRESSION, PyElementTypes.ARGUMENT_LIST, PyElementTypes.PARAMETER_LIST, PyElementTypes.TUPLE_EXPRESSION, PyElementTypes.PARENTHESIZED_EXPRESSION, PyElementTypes.SUBSCRIPTION_EXPRESSION, PyElementTypes.GENERATOR_EXPRESSION, PyElementTypes.SEQUENCE_PATTERN, PyElementTypes.MAPPING_PATTERN, PyElementTypes.PATTERN_ARGUMENT_LIST, PyElementTypes.TYPE_PARAMETER_LIST});
    private static final TokenSet ourCollectionLiteralTypes = TokenSet.create((IElementType[])new IElementType[]{PyElementTypes.LIST_LITERAL_EXPRESSION, PyElementTypes.LIST_COMP_EXPRESSION, PyElementTypes.DICT_LITERAL_EXPRESSION, PyElementTypes.DICT_COMP_EXPRESSION, PyElementTypes.SET_LITERAL_EXPRESSION, PyElementTypes.SET_COMP_EXPRESSION});
    private static final TokenSet ourHangingIndentOwners = TokenSet.create((IElementType[])new IElementType[]{PyElementTypes.LIST_LITERAL_EXPRESSION, PyElementTypes.LIST_COMP_EXPRESSION, PyElementTypes.DICT_LITERAL_EXPRESSION, PyElementTypes.DICT_COMP_EXPRESSION, PyElementTypes.SET_LITERAL_EXPRESSION, PyElementTypes.SET_COMP_EXPRESSION, PyElementTypes.ARGUMENT_LIST, PyElementTypes.PARAMETER_LIST, PyElementTypes.TUPLE_EXPRESSION, PyElementTypes.PARENTHESIZED_EXPRESSION, PyElementTypes.GENERATOR_EXPRESSION, PyElementTypes.FUNCTION_DECLARATION, PyElementTypes.CALL_EXPRESSION, PyElementTypes.FROM_IMPORT_STATEMENT, PyElementTypes.SEQUENCE_PATTERN, PyElementTypes.MAPPING_PATTERN, PyElementTypes.PATTERN_ARGUMENT_LIST, PyElementTypes.WITH_STATEMENT, PyElementTypes.TYPE_PARAMETER_LIST});
    private static final boolean ALIGN_CONDITIONS_WITHOUT_PARENTHESES = false;
    private final PyBlock myParent;
    private final Alignment myAlignment;
    private final Indent myIndent;
    private final ASTNode myNode;
    private final Wrap myWrap;
    private final PyBlockContext myContext;
    private List<PyBlock> mySubBlocks;
    private Map<ASTNode, PyBlock> mySubBlockByNode;
    private final boolean myEmptySequence;
    private Alignment myChildAlignment;
    private Alignment myDictAlignment;
    private Wrap myDictWrapping;
    private Wrap myListWrapping;
    private Wrap mySetWrapping;
    private Wrap myTupleWrapping;
    private Wrap myFromImportWrapping;
    private Wrap myParameterListWrapping;
    private Wrap myArgumentListWrapping;
    private static final TokenSet stopAtTokens = TokenSet.orSet((TokenSet[])new TokenSet[]{TokenSet.create((IElementType[])new IElementType[]{PyElementTypes.FSTRING_NODE}), PythonDialectsTokenSetProvider.getInstance().getStatementTokens()});

    public PyBlock(@Nullable PyBlock parent, @NotNull ASTNode node, @Nullable Alignment alignment, @NotNull Indent indent, @Nullable Wrap wrap, @NotNull PyBlockContext context) {
        if (node == null) {
            PyBlock.$$$reportNull$$$0(0);
        }
        if (indent == null) {
            PyBlock.$$$reportNull$$$0(1);
        }
        if (context == null) {
            PyBlock.$$$reportNull$$$0(2);
        }
        this.mySubBlocks = null;
        this.mySubBlockByNode = null;
        this.myChildAlignment = null;
        this.myDictAlignment = null;
        this.myDictWrapping = null;
        this.myListWrapping = null;
        this.mySetWrapping = null;
        this.myTupleWrapping = null;
        this.myFromImportWrapping = null;
        this.myParameterListWrapping = null;
        this.myArgumentListWrapping = null;
        this.myParent = parent;
        this.myAlignment = alignment;
        this.myIndent = indent;
        this.myNode = node;
        this.myWrap = wrap;
        this.myContext = context;
        this.myEmptySequence = PyBlock.isEmptySequence(node);
        CommonCodeStyleSettings settings = this.myContext.getSettings();
        PyCodeStyleSettings pySettings = this.myContext.getPySettings();
        if (node.getElementType() == PyElementTypes.DICT_LITERAL_EXPRESSION) {
            this.myDictAlignment = Alignment.createAlignment((boolean)true);
            this.myDictWrapping = Wrap.createWrap((int)pySettings.DICT_WRAPPING, (boolean)true);
        } else if (node.getElementType() == PyElementTypes.LIST_LITERAL_EXPRESSION) {
            this.myListWrapping = Wrap.createWrap((int)pySettings.LIST_WRAPPING, (boolean)pySettings.LIST_NEW_LINE_AFTER_LEFT_BRACKET);
        } else if (node.getElementType() == PyElementTypes.SET_LITERAL_EXPRESSION) {
            this.mySetWrapping = Wrap.createWrap((int)pySettings.SET_WRAPPING, (boolean)pySettings.SET_NEW_LINE_AFTER_LEFT_BRACE);
        } else if (node.getElementType() == PyElementTypes.TUPLE_EXPRESSION && node.getTreeParent().getElementType() == PyElementTypes.PARENTHESIZED_EXPRESSION) {
            this.myTupleWrapping = Wrap.createWrap((int)pySettings.TUPLE_WRAPPING, (boolean)pySettings.TUPLE_NEW_LINE_AFTER_LEFT_PARENTHESIS);
        } else if (node.getElementType() == PyElementTypes.FROM_IMPORT_STATEMENT) {
            this.myFromImportWrapping = Wrap.createWrap((int)pySettings.FROM_IMPORT_WRAPPING, (boolean)false);
        } else if (node.getElementType() == PyElementTypes.PARAMETER_LIST) {
            this.myParameterListWrapping = Wrap.createWrap((int)settings.METHOD_PARAMETERS_WRAP, (boolean)settings.METHOD_PARAMETERS_LPAREN_ON_NEXT_LINE);
        } else if (node.getElementType() == PyElementTypes.ARGUMENT_LIST) {
            this.myArgumentListWrapping = Wrap.createWrap((int)settings.CALL_PARAMETERS_WRAP, (boolean)settings.CALL_PARAMETERS_LPAREN_ON_NEXT_LINE);
        }
    }

    @NotNull
    public ASTNode getNode() {
        ASTNode aSTNode = this.myNode;
        if (aSTNode == null) {
            PyBlock.$$$reportNull$$$0(3);
        }
        return aSTNode;
    }

    @NotNull
    public TextRange getTextRange() {
        TextRange textRange = this.myNode.getTextRange();
        if (textRange == null) {
            PyBlock.$$$reportNull$$$0(4);
        }
        return textRange;
    }

    private Alignment getAlignmentForChildren() {
        if (this.myChildAlignment == null) {
            this.myChildAlignment = Alignment.createAlignment();
        }
        return this.myChildAlignment;
    }

    @NotNull
    public List<Block> getSubBlocks() {
        if (this.mySubBlocks == null) {
            this.mySubBlockByNode = this.buildSubBlocks();
            this.mySubBlocks = new ArrayList<PyBlock>(this.mySubBlockByNode.values());
        }
        List<PyBlock> list = Collections.unmodifiableList(this.mySubBlocks);
        if (list == null) {
            PyBlock.$$$reportNull$$$0(5);
        }
        return list;
    }

    @Nullable
    private PyBlock getSubBlockByNode(@NotNull ASTNode node) {
        if (node == null) {
            PyBlock.$$$reportNull$$$0(6);
        }
        return this.mySubBlockByNode.get(node);
    }

    @Nullable
    private PyBlock getSubBlockByIndex(int index) {
        return this.mySubBlocks.get(index);
    }

    @NotNull
    private Map<ASTNode, PyBlock> buildSubBlocks() {
        LinkedHashMap<ASTNode, PyBlock> blocks = new LinkedHashMap<ASTNode, PyBlock>();
        for (ASTNode child : this.getSubBlockNodes()) {
            IElementType childType = child.getElementType();
            if (child.getTextRange().isEmpty() || childType == TokenType.WHITE_SPACE) continue;
            blocks.put(child, this.buildSubBlock(child));
        }
        Map<ASTNode, PyBlock> map2 = Collections.unmodifiableMap(blocks);
        if (map2 == null) {
            PyBlock.$$$reportNull$$$0(7);
        }
        return map2;
    }

    @NotNull
    protected Iterable<ASTNode> getSubBlockNodes() {
        if (this.myNode.getElementType() == PyElementTypes.BINARY_EXPRESSION) {
            ArrayList<ASTNode> result2 = new ArrayList<ASTNode>();
            PyBlock.collectChildrenOperatorAndOperandNodes(this.myNode, result2);
            ArrayList<ASTNode> arrayList = result2;
            if (arrayList == null) {
                PyBlock.$$$reportNull$$$0(8);
            }
            return arrayList;
        }
        List<ASTNode> list = Arrays.asList(this.myNode.getChildren(null));
        if (list == null) {
            PyBlock.$$$reportNull$$$0(9);
        }
        return list;
    }

    private static void collectChildrenOperatorAndOperandNodes(@NotNull ASTNode node, @NotNull List<ASTNode> result2) {
        if (node == null) {
            PyBlock.$$$reportNull$$$0(10);
        }
        if (result2 == null) {
            PyBlock.$$$reportNull$$$0(11);
        }
        if (node.getElementType() == PyElementTypes.BINARY_EXPRESSION) {
            for (ASTNode child : node.getChildren(null)) {
                PyBlock.collectChildrenOperatorAndOperandNodes(child, result2);
            }
        } else {
            result2.add(node);
        }
    }

    @NotNull
    private PyBlock buildSubBlock(@NotNull ASTNode child) {
        PyCodeStyleSettings settings;
        Alignment childAlignment;
        Indent childIndent;
        Wrap childWrap;
        IElementType childType;
        IElementType parentType;
        block59: {
            block67: {
                block68: {
                    block66: {
                        block64: {
                            block65: {
                                block63: {
                                    block62: {
                                        IElementType grandparentType;
                                        block61: {
                                            block60: {
                                                block58: {
                                                    if (child == null) {
                                                        PyBlock.$$$reportNull$$$0(12);
                                                    }
                                                    parentType = this.myNode.getElementType();
                                                    ASTNode grandParentNode = this.myNode.getTreeParent();
                                                    grandparentType = grandParentNode == null ? null : grandParentNode.getElementType();
                                                    childType = child.getElementType();
                                                    childWrap = null;
                                                    childIndent = Indent.getNoneIndent();
                                                    childAlignment = null;
                                                    settings = this.myContext.getPySettings();
                                                    if (childType == PyElementTypes.STATEMENT_LIST) {
                                                        if (PyBlock.hasLineBreaksBeforeInSameParent(child, 1) || this.needLineBreakInStatement()) {
                                                            childIndent = Indent.getNormalIndent();
                                                        }
                                                    } else if (childType == PyElementTypes.CASE_CLAUSE) {
                                                        childIndent = Indent.getNormalIndent();
                                                    } else if (childType == PyElementTypes.IMPORT_ELEMENT) {
                                                        childWrap = parentType == PyElementTypes.FROM_IMPORT_STATEMENT ? this.myFromImportWrapping : Wrap.createWrap((WrapType)WrapType.NORMAL, (boolean)true);
                                                        childIndent = Indent.getNormalIndent();
                                                    }
                                                    if (childType == PyTokenTypes.END_OF_LINE_COMMENT && (parentType == PyElementTypes.FROM_IMPORT_STATEMENT || parentType == PyElementTypes.MATCH_STATEMENT)) {
                                                        childIndent = Indent.getNormalIndent();
                                                    }
                                                    if (ourListElementTypes.contains(parentType)) {
                                                        if (!(childType == PyElementTypes.TUPLE_EXPRESSION && parentType == PyElementTypes.PARENTHESIZED_EXPRESSION || parentType == PyElementTypes.TUPLE_EXPRESSION && grandparentType != PyElementTypes.PARENTHESIZED_EXPRESSION || PyTokenTypes.ALL_BRACES.contains(childType) || childType == PyTokenTypes.COMMA || this.isSliceOperand(child))) {
                                                            childWrap = Wrap.createWrap((WrapType)WrapType.NORMAL, (boolean)true);
                                                        }
                                                        if (this.needListAlignment(child) && !this.myEmptySequence) {
                                                            childAlignment = this.getAlignmentForChildren();
                                                        }
                                                        if (childType == PyTokenTypes.END_OF_LINE_COMMENT) {
                                                            childIndent = Indent.getNormalIndent();
                                                        }
                                                    }
                                                    if (parentType != PyElementTypes.BINARY_EXPRESSION) break block58;
                                                    if (childType != PyElementTypes.BINARY_EXPRESSION) {
                                                        boolean parenthesised;
                                                        PyBlock topmostBinary = this.findTopmostBinaryExpressionBlock(child);
                                                        assert (topmostBinary != null);
                                                        PyBlock binaryParentBlock = topmostBinary.myParent;
                                                        ASTNode binaryParentNode = binaryParentBlock.myNode;
                                                        IElementType binaryParentType = binaryParentNode.getElementType();
                                                        if (ourListElementTypes.contains(binaryParentType) && this.needListAlignment(child) && !this.myEmptySequence) {
                                                            childAlignment = binaryParentBlock.getChildAlignment();
                                                        }
                                                        boolean bl = parenthesised = binaryParentType == PyElementTypes.PARENTHESIZED_EXPRESSION;
                                                        if (binaryParentType != PyElementTypes.RETURN_STATEMENT && binaryParentType != PyElementTypes.YIELD_EXPRESSION) {
                                                            if (!(childAlignment != null || topmostBinary == null || parenthesised && PyBlock.isIfCondition(binaryParentNode) || PyBlock.isCondition(topmostBinary.myNode))) {
                                                                childAlignment = topmostBinary.getAlignmentForChildren();
                                                            }
                                                            childIndent = parenthesised ? Indent.getContinuationIndent() : Indent.getContinuationWithoutFirstIndent();
                                                        } else {
                                                            childIndent = Indent.getNormalIndent();
                                                        }
                                                    }
                                                    break block59;
                                                }
                                                if (parentType != PyElementTypes.OR_PATTERN) break block60;
                                                childAlignment = this.getAlignmentForChildren();
                                                break block59;
                                            }
                                            if (parentType != PyElementTypes.SEQUENCE_PATTERN && parentType != PyElementTypes.MAPPING_PATTERN) break block61;
                                            childIndent = PyTokenTypes.CLOSE_BRACES.contains(childType) && !settings.HANG_CLOSING_BRACKETS || PyTokenTypes.OPEN_BRACES.contains(childType) ? Indent.getNoneIndent() : Indent.getNormalIndent();
                                            break block59;
                                        }
                                        if (!ourCollectionLiteralTypes.contains(parentType) && (parentType != PyElementTypes.TUPLE_EXPRESSION || grandparentType != PyElementTypes.PARENTHESIZED_EXPRESSION)) break block62;
                                        childIndent = PyTokenTypes.CLOSE_BRACES.contains(childType) && !settings.HANG_CLOSING_BRACKETS || PyTokenTypes.OPEN_BRACES.contains(childType) ? Indent.getNoneIndent() : (settings.USE_CONTINUATION_INDENT_FOR_COLLECTION_AND_COMPREHENSIONS ? Indent.getContinuationIndent() : Indent.getNormalIndent());
                                        break block59;
                                    }
                                    if (parentType != PyElementTypes.STRING_LITERAL_EXPRESSION) break block63;
                                    if (PyTokenTypes.STRING_NODES.contains(childType) || childType == PyElementTypes.FSTRING_NODE) {
                                        if (childType == PyTokenTypes.TRIPLE_QUOTED_STRING && this.myContext.getPySettings().FORMAT_INJECTED_FRAGMENTS && PyBlock.isInsideInjection(child)) {
                                            return this.createInjectedBlock(child, this.myContext.getPySettings().ADD_INDENT_INSIDE_INJECTIONS ? Indent.getNormalIndent() : Indent.getNoneIndent());
                                        }
                                        childAlignment = this.getAlignmentForChildren();
                                    }
                                    break block59;
                                }
                                if (parentType != PyElementTypes.FROM_IMPORT_STATEMENT) break block64;
                                if (this.myNode.findChildByType((IElementType)PyTokenTypes.LPAR) == null) break block59;
                                if (childType == PyElementTypes.IMPORT_ELEMENT) {
                                    if (settings.ALIGN_MULTILINE_IMPORTS) {
                                        childAlignment = this.getAlignmentForChildren();
                                    } else {
                                        childIndent = Indent.getNormalIndent();
                                    }
                                }
                                if (childType != PyTokenTypes.RPAR) break block59;
                                childIndent = Indent.getNoneIndent();
                                if (PyBlock.hasHangingIndent(this.myNode.getPsi()) || settings.FROM_IMPORT_NEW_LINE_AFTER_LEFT_PARENTHESIS) break block65;
                                childAlignment = this.getAlignmentForChildren();
                                break block59;
                            }
                            if (!settings.HANG_CLOSING_BRACKETS) break block59;
                            childIndent = Indent.getNormalIndent();
                            break block59;
                        }
                        if (!PyBlock.isValueOfKeyValuePair(child)) break block66;
                        childIndent = Indent.getNormalIndent();
                        break block59;
                    }
                    if (PyBlock.hasHangingIndent(this.myNode.getPsi()) || parentType != PyElementTypes.PARENTHESIZED_EXPRESSION && (parentType != PyElementTypes.ARGUMENT_LIST || !this.myContext.getSettings().ALIGN_MULTILINE_PARAMETERS_IN_CALLS) && (parentType != PyElementTypes.PARAMETER_LIST || !this.myContext.getSettings().ALIGN_MULTILINE_PARAMETERS) || PyBlock.isIndentNext(child) || PyBlock.hasLineBreaksBeforeInSameParent(this.myNode.getFirstChildNode(), 1) || ourListElementTypes.contains(childType)) break block67;
                    if (PyTokenTypes.ALL_BRACES.contains(childType)) break block68;
                    childAlignment = this.getAlignmentForChildren();
                    childIndent = Indent.getNormalIndent();
                    break block59;
                }
                if (childType != PyTokenTypes.RPAR) break block59;
                childIndent = settings.HANG_CLOSING_BRACKETS ? (settings.USE_CONTINUATION_INDENT_FOR_COLLECTION_AND_COMPREHENSIONS ? Indent.getContinuationIndent() : Indent.getNormalIndent()) : Indent.getNoneIndent();
                break block59;
            }
            if (this.myNode.getElementType() == PyElementTypes.SLICE_ITEM) {
                childAlignment = this.getChildAlignment();
            } else if (parentType == PyElementTypes.GENERATOR_EXPRESSION || parentType == PyElementTypes.PARENTHESIZED_EXPRESSION) {
                if (childType == PyElementTypes.TUPLE_EXPRESSION) {
                    if (PyBlock.isIndentNext(child.getTreeParent())) {
                        childIndent = Indent.getNormalIndent();
                    }
                } else {
                    boolean tupleOrGenerator;
                    boolean bl = tupleOrGenerator = parentType == PyElementTypes.GENERATOR_EXPRESSION || ((PyAstParenthesizedExpression)this.myNode.getPsi(PyAstParenthesizedExpression.class)).getContainedExpression() instanceof PyAstTupleExpression;
                    if (!((childType != PyTokenTypes.RPAR || tupleOrGenerator && settings.HANG_CLOSING_BRACKETS) && PyBlock.hasLineBreaksBeforeInSameParent(child, 1))) {
                        childIndent = Indent.getNoneIndent();
                    } else if (childType == PyElementTypes.BINARY_EXPRESSION && parentType == PyElementTypes.PARENTHESIZED_EXPRESSION) {
                        childIndent = Indent.getNoneIndent();
                    } else {
                        boolean useWiderIndent = PyBlock.isIndentNext(child) || settings.USE_CONTINUATION_INDENT_FOR_COLLECTION_AND_COMPREHENSIONS;
                        childIndent = useWiderIndent ? Indent.getContinuationIndent() : Indent.getNormalIndent();
                    }
                }
            } else if (parentType == PyElementTypes.ARGUMENT_LIST || parentType == PyElementTypes.PATTERN_ARGUMENT_LIST || parentType == PyElementTypes.PARAMETER_LIST) {
                childIndent = childType == PyTokenTypes.RPAR && !settings.HANG_CLOSING_BRACKETS ? Indent.getNoneIndent() : (parentType == PyElementTypes.PARAMETER_LIST && settings.USE_CONTINUATION_INDENT_FOR_PARAMETERS || parentType == PyElementTypes.ARGUMENT_LIST && settings.USE_CONTINUATION_INDENT_FOR_ARGUMENTS || this.argumentMayHaveSameIndentAsFollowingStatementList() ? Indent.getContinuationIndent() : Indent.getNormalIndent());
            } else if (parentType == PyElementTypes.SUBSCRIPTION_EXPRESSION) {
                PyAstExpression indexExpression = ((PyAstSubscriptionExpression)this.myNode.getPsi()).getIndexExpression();
                if (indexExpression != null && child == indexExpression.getNode()) {
                    childIndent = Indent.getNormalIndent();
                }
            } else if (parentType == PyElementTypes.REFERENCE_EXPRESSION && child != this.myNode.getFirstChildNode()) {
                childIndent = Indent.getNoneIndent();
                if (PyBlock.hasLineBreaksBeforeInSameParent(child, 1)) {
                    if (this.isInControlStatement()) {
                        childIndent = Indent.getContinuationIndent();
                    } else {
                        PyBlock b = this.myParent;
                        while (b != null) {
                            if (b.getNode().getPsi() instanceof PyAstParenthesizedExpression || b.getNode().getPsi() instanceof PyAstArgumentList || b.getNode().getPsi() instanceof PyAstParameterList) {
                                childAlignment = PyBlock.getAlignmentOfChild(b, 1);
                                break;
                            }
                            b = b.myParent;
                        }
                    }
                }
            }
        }
        childWrap = this.getSpecialWrapForContainers(child, childType, childWrap, parentType);
        if (PyBlock.isAfterStatementList(child) && !PyBlock.hasLineBreaksBeforeInSameParent(child, 2) && child.getElementType() != PyTokenTypes.END_OF_LINE_COMMENT) {
            childIndent = Indent.getNormalIndent();
        }
        if (settings.DICT_ALIGNMENT == PyCodeStyleSettings.DICT_ALIGNMENT_ON_VALUE) {
            if (PyBlock.isValueOfKeyValuePairOfDictLiteral(child) && !PyBlock.isOpeningBracket(child.getFirstChildNode())) {
                childAlignment = this.myParent.myDictAlignment;
            } else if (PyBlock.isValueOfKeyValuePairOfDictLiteral(this.myNode) && PyBlock.isOpeningBracket(child)) {
                childAlignment = this.myParent.myParent.myDictAlignment;
            }
        } else if (this.myContext.getPySettings().DICT_ALIGNMENT == PyCodeStyleSettings.DICT_ALIGNMENT_ON_COLON && PyBlock.isChildOfKeyValuePairOfDictLiteral(child) && childType == PyTokenTypes.COLON) {
            childAlignment = this.myParent.myDictAlignment;
        }
        if (parentType == PyElementTypes.WITH_STATEMENT && PyBlock.isInsideWithStatementParentheses(this.myNode, child)) {
            if (this.needListAlignment(child)) {
                childAlignment = this.getAlignmentForChildren();
            } else {
                childIndent = Indent.getNormalIndent();
            }
            if (childType == PyTokenTypes.RPAR && !settings.HANG_CLOSING_BRACKETS) {
                childIndent = Indent.getNoneIndent();
            }
        }
        for (ASTNode prev = child.getTreePrev(); prev != null && prev.getElementType() == TokenType.WHITE_SPACE; prev = prev.getTreePrev()) {
            if (!prev.textContains('\\') || childIndent.equals(Indent.getContinuationIndent((boolean)false)) || childIndent.equals(Indent.getContinuationIndent((boolean)true))) continue;
            childIndent = PyBlock.isIndentNext(child) ? Indent.getContinuationIndent() : Indent.getNormalIndent();
            break;
        }
        if (TreeUtil.findParent((ASTNode)child, (IElementType)PyElementTypes.FSTRING_FRAGMENT) != null) {
            childWrap = Wrap.createWrap((WrapType)WrapType.NONE, (boolean)false);
        }
        return new PyBlock(this, child, childAlignment, childIndent, childWrap, this.myContext);
    }

    @Nullable
    private Wrap getSpecialWrapForContainers(@NotNull ASTNode child, @NotNull IElementType childType, @Nullable Wrap childWrap, @Nullable IElementType parentType) {
        if (child == null) {
            PyBlock.$$$reportNull$$$0(13);
        }
        if (childType == null) {
            PyBlock.$$$reportNull$$$0(14);
        }
        if (childType != PyTokenTypes.COMMA && childType != PyTokenTypes.END_OF_LINE_COMMENT) {
            if (childType != PyTokenTypes.LPAR && childType != PyTokenTypes.RPAR) {
                if (parentType == PyElementTypes.PARAMETER_LIST) {
                    return this.myParameterListWrapping;
                }
                if (parentType == PyElementTypes.ARGUMENT_LIST) {
                    return this.myArgumentListWrapping;
                }
                if (parentType == PyElementTypes.TUPLE_EXPRESSION && !PyBlock.isInsideSubscriptionExpression(child)) {
                    return this.myTupleWrapping;
                }
            }
            if (childType != PyTokenTypes.LBRACKET && childType != PyTokenTypes.RBRACKET && parentType == PyElementTypes.LIST_LITERAL_EXPRESSION && !PyBlock.isInsideSubscriptionExpression(child)) {
                return this.myListWrapping;
            }
            if (childType != PyTokenTypes.LBRACE && childType != PyTokenTypes.RBRACE && parentType == PyElementTypes.SET_LITERAL_EXPRESSION) {
                return this.mySetWrapping;
            }
        }
        if (childType == PyElementTypes.KEY_VALUE_EXPRESSION && PyBlock.isChildOfDictLiteral(child)) {
            return this.myDictWrapping;
        }
        return childWrap;
    }

    private static boolean isInsideSubscriptionExpression(ASTNode child) {
        return PsiTreeUtil.getParentOfType((PsiElement)child.getPsi(), PyAstSubscriptionExpression.class) != null;
    }

    private static boolean isInsideWithStatementParentheses(@NotNull ASTNode withStatement, @NotNull ASTNode node) {
        ASTNode openingParenthesis;
        if (withStatement == null) {
            PyBlock.$$$reportNull$$$0(15);
        }
        if (node == null) {
            PyBlock.$$$reportNull$$$0(16);
        }
        if ((openingParenthesis = withStatement.findChildByType((IElementType)PyTokenTypes.LPAR)) == null) {
            return false;
        }
        if (node.getStartOffset() < openingParenthesis.getStartOffset()) {
            return false;
        }
        ASTNode closingParenthesis = withStatement.findChildByType((IElementType)PyTokenTypes.RPAR);
        if (closingParenthesis != null) {
            return node.getStartOffset() <= closingParenthesis.getStartOffset();
        }
        ASTNode afterParentheses = (ASTNode)ObjectUtils.chooseNotNull((Object)withStatement.findChildByType((IElementType)PyTokenTypes.COLON), (Object)withStatement.findChildByType(PyElementTypes.STATEMENT_LIST));
        return afterParentheses == null || node.getStartOffset() < afterParentheses.getStartOffset();
    }

    private static boolean isIfCondition(@NotNull ASTNode node) {
        PsiElement element;
        PyAstIfPart ifPart;
        if (node == null) {
            PyBlock.$$$reportNull$$$0(17);
        }
        return (ifPart = (PyAstIfPart)ObjectUtils.tryCast((Object)(element = node.getPsi()).getParent(), PyAstIfPart.class)) != null && ifPart.getCondition() == element && !ifPart.isElif();
    }

    private static boolean isCondition(@NotNull ASTNode node) {
        PsiElement element;
        PyAstConditionalStatementPart conditionalStatement;
        if (node == null) {
            PyBlock.$$$reportNull$$$0(18);
        }
        return (conditionalStatement = (PyAstConditionalStatementPart)ObjectUtils.tryCast((Object)(element = node.getPsi()).getParent(), PyAstConditionalStatementPart.class)) != null && conditionalStatement.getCondition() == element;
    }

    @Nullable
    private PyBlock findTopmostBinaryExpressionBlock(@NotNull ASTNode child) {
        if (child == null) {
            PyBlock.$$$reportNull$$$0(19);
        }
        assert (child.getElementType() != PyElementTypes.BINARY_EXPRESSION);
        PyBlock parentBlock = this;
        PyBlock alignmentOwner = null;
        while (parentBlock != null && parentBlock.myNode.getElementType() == PyElementTypes.BINARY_EXPRESSION) {
            alignmentOwner = parentBlock;
            parentBlock = parentBlock.myParent;
        }
        return alignmentOwner;
    }

    private static boolean isOpeningBracket(@Nullable ASTNode node) {
        return node != null && PyTokenTypes.OPEN_BRACES.contains(node.getElementType()) && node == node.getTreeParent().getFirstChildNode();
    }

    private static boolean isValueOfKeyValuePairOfDictLiteral(@NotNull ASTNode node) {
        if (node == null) {
            PyBlock.$$$reportNull$$$0(20);
        }
        return PyBlock.isValueOfKeyValuePair(node) && PyBlock.isChildOfDictLiteral(node.getTreeParent());
    }

    private static boolean isChildOfKeyValuePairOfDictLiteral(@NotNull ASTNode node) {
        if (node == null) {
            PyBlock.$$$reportNull$$$0(21);
        }
        return PyBlock.isChildOfKeyValuePair(node) && PyBlock.isChildOfDictLiteral(node.getTreeParent());
    }

    private static boolean isChildOfDictLiteral(@NotNull ASTNode node) {
        ASTNode nodeParent;
        if (node == null) {
            PyBlock.$$$reportNull$$$0(22);
        }
        return (nodeParent = node.getTreeParent()) != null && nodeParent.getElementType() == PyElementTypes.DICT_LITERAL_EXPRESSION;
    }

    private static boolean isChildOfKeyValuePair(@NotNull ASTNode node) {
        ASTNode nodeParent;
        if (node == null) {
            PyBlock.$$$reportNull$$$0(23);
        }
        return (nodeParent = node.getTreeParent()) != null && nodeParent.getElementType() == PyElementTypes.KEY_VALUE_EXPRESSION;
    }

    private static boolean isValueOfKeyValuePair(@NotNull ASTNode node) {
        if (node == null) {
            PyBlock.$$$reportNull$$$0(24);
        }
        return PyBlock.isChildOfKeyValuePair(node) && ((PyAstKeyValueExpression)node.getTreeParent().getPsi(PyAstKeyValueExpression.class)).getValue() == node.getPsi();
    }

    private static boolean isEmptySequence(@NotNull ASTNode node) {
        if (node == null) {
            PyBlock.$$$reportNull$$$0(25);
        }
        return node.getPsi() instanceof PyAstSequenceExpression && ((PyAstSequenceExpression)node.getPsi()).isEmpty();
    }

    private boolean argumentMayHaveSameIndentAsFollowingStatementList() {
        if (this.myNode.getElementType() != PyElementTypes.ARGUMENT_LIST) {
            return false;
        }
        PsiElement header = PyBlock.getControlStatementHeader(this.myNode);
        if (header instanceof PyAstStatementListContainer) {
            PyAstStatementList statementList = ((PyAstStatementListContainer)header).getStatementList();
            return PyUtilCore.onSameLine(header, this.myNode.getPsi()) && !PyUtilCore.onSameLine(header, (PsiElement)statementList);
        }
        return false;
    }

    private static boolean hasHangingIndent(@NotNull PsiElement elem) {
        if (elem == null) {
            PyBlock.$$$reportNull$$$0(26);
        }
        if (elem instanceof PyAstCallExpression) {
            PyAstArgumentList argumentList = ((PyAstCallExpression)elem).getArgumentList();
            return argumentList != null && PyBlock.hasHangingIndent((PsiElement)argumentList);
        }
        if (elem instanceof PyAstFunction) {
            return PyBlock.hasHangingIndent((PsiElement)((PyAstFunction)elem).getParameterList());
        }
        PsiElement firstChild = elem instanceof PyAstFromImportStatement ? ((PyAstFromImportStatement)elem).getLeftParen() : (elem instanceof PyAstWithStatement ? PyPsiUtilsCore.getFirstChildOfType(elem, PyTokenTypes.LPAR) : elem.getFirstChild());
        if (firstChild == null) {
            return false;
        }
        IElementType elementType = elem.getNode().getElementType();
        ASTNode firstChildNode = firstChild.getNode();
        if (ourHangingIndentOwners.contains(elementType) && PyTokenTypes.OPEN_BRACES.contains(firstChildNode.getElementType())) {
            if (PyBlock.hasLineBreakAfterIgnoringComments(firstChildNode)) {
                return true;
            }
            PsiElement firstItem = PyBlock.getFirstItem(elem);
            if (firstItem == null) {
                return !PyTokenTypes.CLOSE_BRACES.contains(elem.getLastChild().getNode().getElementType());
            }
            if (firstItem instanceof PyAstNamedParameter) {
                PyAstExpression defaultValue = ((PyAstNamedParameter)firstItem).getDefaultValue();
                return defaultValue != null && PyBlock.hasHangingIndent((PsiElement)defaultValue);
            }
            if (firstItem instanceof PyAstKeywordArgument) {
                PyAstExpression valueExpression = ((PyAstKeywordArgument)firstItem).getValueExpression();
                return valueExpression != null && PyBlock.hasHangingIndent((PsiElement)valueExpression);
            }
            if (firstItem instanceof PyAstKeyValueExpression) {
                PyAstExpression value = ((PyAstKeyValueExpression)firstItem).getValue();
                return value != null && PyBlock.hasHangingIndent((PsiElement)value);
            }
            if (firstItem instanceof PyAstWithItem) {
                PyAstExpression contextExpression = ((PyAstWithItem)firstItem).getExpression();
                return PyBlock.hasHangingIndent((PsiElement)contextExpression);
            }
            return PyBlock.hasHangingIndent(firstItem);
        }
        return false;
    }

    @Nullable
    private static PsiElement getFirstItem(@NotNull PsiElement elem) {
        if (elem == null) {
            PyBlock.$$$reportNull$$$0(27);
        }
        Object[] items = PsiElement.EMPTY_ARRAY;
        if (elem instanceof PyAstSequenceExpression) {
            items = ((PyAstSequenceExpression)elem).getElements();
        } else if (elem instanceof PyAstParameterList) {
            items = ((PyAstParameterList)elem).getParameters();
        } else if (elem instanceof PyAstArgumentList) {
            items = ((PyAstArgumentList)elem).getArguments();
        } else if (elem instanceof PyAstFromImportStatement) {
            items = ((PyAstFromImportStatement)elem).getImportElements();
        } else if (elem instanceof PyAstWithStatement) {
            items = ((PyAstWithStatement)elem).getWithItems();
        } else if (elem instanceof PyAstParenthesizedExpression) {
            PyAstExpression containedExpression = ((PyAstParenthesizedExpression)elem).getContainedExpression();
            if (containedExpression instanceof PyAstTupleExpression) {
                items = ((PyAstTupleExpression)containedExpression).getElements();
            } else if (containedExpression != null) {
                return containedExpression;
            }
        } else if (elem instanceof PyAstComprehensionElement) {
            return ((PyAstComprehensionElement)elem).getResultExpression();
        }
        return (PsiElement)ArrayUtil.getFirstElement((Object[])items);
    }

    private static boolean breaksAlignment(IElementType type2) {
        return type2 != PyElementTypes.BINARY_EXPRESSION;
    }

    private static Alignment getAlignmentOfChild(@NotNull PyBlock b, int childNum) {
        if (b == null) {
            PyBlock.$$$reportNull$$$0(28);
        }
        if (b.getSubBlocks().size() > childNum) {
            ChildAttributes attributes = b.getChildAttributes(childNum);
            return attributes.getAlignment();
        }
        return null;
    }

    private static boolean isIndentNext(@NotNull ASTNode child) {
        PsiElement psi;
        if (child == null) {
            PyBlock.$$$reportNull$$$0(29);
        }
        return (psi = PsiTreeUtil.getParentOfType((PsiElement)child.getPsi(), PyAstStatement.class)) instanceof PyAstIfStatement || psi instanceof PyAstForStatement || psi instanceof PyAstWithStatement || psi instanceof PyAstClass || psi instanceof PyAstFunction || psi instanceof PyAstTryExceptStatement || psi instanceof PyAstElsePart || psi instanceof PyAstIfPart || psi instanceof PyAstWhileStatement;
    }

    private static boolean isSubscriptionOperand(@NotNull ASTNode child) {
        if (child == null) {
            PyBlock.$$$reportNull$$$0(30);
        }
        return child.getTreeParent().getElementType() == PyElementTypes.SUBSCRIPTION_EXPRESSION && child.getPsi() == ((PyAstSubscriptionExpression)child.getTreeParent().getPsi()).getOperand();
    }

    private boolean isInControlStatement() {
        return PyBlock.getControlStatementHeader(this.myNode) != null;
    }

    @Nullable
    private static PsiElement getControlStatementHeader(@NotNull ASTNode node) {
        PyAstStatementPart statementPart;
        if (node == null) {
            PyBlock.$$$reportNull$$$0(31);
        }
        if ((statementPart = (PyAstStatementPart)PsiTreeUtil.getParentOfType((PsiElement)node.getPsi(), PyAstStatementPart.class, (boolean)false, (Class[])new Class[]{PyAstStatementList.class})) != null) {
            return statementPart;
        }
        PyAstWithItem withItem = (PyAstWithItem)PsiTreeUtil.getParentOfType((PsiElement)node.getPsi(), PyAstWithItem.class);
        if (withItem != null) {
            return withItem.getParent();
        }
        return null;
    }

    private boolean isSliceOperand(@NotNull ASTNode child) {
        PyAstSubscriptionExpression subscription;
        PsiElement psiElement;
        if (child == null) {
            PyBlock.$$$reportNull$$$0(32);
        }
        if ((psiElement = this.myNode.getPsi()) instanceof PyAstSubscriptionExpression && (subscription = (PyAstSubscriptionExpression)psiElement).getIndexExpression() instanceof PyAstSliceItem) {
            PyAstExpression operand = subscription.getOperand();
            return operand.getNode() == child;
        }
        return false;
    }

    private static boolean isAfterStatementList(@NotNull ASTNode child) {
        PsiElement prev;
        if (child == null) {
            PyBlock.$$$reportNull$$$0(33);
        }
        if (!((prev = child.getPsi().getPrevSibling()) instanceof PyAstStatement)) {
            return false;
        }
        PsiElement lastChild = PsiTreeUtil.getDeepestLast((PsiElement)prev);
        return lastChild.getParent() instanceof PyAstStatementList;
    }

    private boolean needListAlignment(@NotNull ASTNode child) {
        ASTNode prevNode;
        IElementType childType;
        if (child == null) {
            PyBlock.$$$reportNull$$$0(34);
        }
        if (PyTokenTypes.OPEN_BRACES.contains(childType = child.getElementType())) {
            return false;
        }
        if (PyTokenTypes.CLOSE_BRACES.contains(childType)) {
            ASTNode prevNonSpace = PyBlock.findPrevNonSpaceNode(child);
            if (prevNonSpace != null && prevNonSpace.getElementType() == PyTokenTypes.COMMA && this.myContext.getMode() == FormattingMode.ADJUST_INDENT) {
                return true;
            }
            return !(PyBlock.hasHangingIndent(this.myNode.getPsi()) || this.myNode.getElementType() == PyElementTypes.DICT_LITERAL_EXPRESSION && this.myContext.getPySettings().DICT_NEW_LINE_AFTER_LEFT_BRACE || this.myNode.getElementType() == PyElementTypes.LIST_LITERAL_EXPRESSION && this.myContext.getPySettings().LIST_NEW_LINE_AFTER_LEFT_BRACKET || this.myNode.getElementType() == PyElementTypes.SET_LITERAL_EXPRESSION && this.myContext.getPySettings().SET_NEW_LINE_AFTER_LEFT_BRACE || this.myNode.getElementType() == PyElementTypes.PARENTHESIZED_EXPRESSION && prevNonSpace != null && prevNonSpace.getElementType() == PyElementTypes.TUPLE_EXPRESSION && this.myContext.getPySettings().TUPLE_NEW_LINE_AFTER_LEFT_PARENTHESIS);
        }
        if (this.myNode.getElementType() == PyElementTypes.ARGUMENT_LIST) {
            if (!this.myContext.getSettings().ALIGN_MULTILINE_PARAMETERS_IN_CALLS || PyBlock.hasHangingIndent(this.myNode.getPsi())) {
                return false;
            }
            return childType != PyTokenTypes.COMMA;
        }
        if (this.myNode.getElementType() == PyElementTypes.PARAMETER_LIST) {
            return !PyBlock.hasHangingIndent(this.myNode.getPsi()) && this.myContext.getSettings().ALIGN_MULTILINE_PARAMETERS;
        }
        if (this.myNode.getElementType() == PyElementTypes.SUBSCRIPTION_EXPRESSION) {
            return false;
        }
        if (childType == PyTokenTypes.COMMA) {
            return false;
        }
        if (this.myNode.getElementType() == PyElementTypes.PARENTHESIZED_EXPRESSION) {
            if (childType == PyElementTypes.STRING_LITERAL_EXPRESSION) {
                return true;
            }
            if (childType != PyElementTypes.TUPLE_EXPRESSION && childType != PyElementTypes.GENERATOR_EXPRESSION) {
                return false;
            }
        }
        if (this.myNode.getElementType() == PyElementTypes.WITH_STATEMENT) {
            return this.myNode.findChildByType((IElementType)PyTokenTypes.LPAR) != null && !PyBlock.hasHangingIndent(this.myNode.getPsi());
        }
        if (this.myNode.getElementType() == PyElementTypes.TUPLE_EXPRESSION && (prevNode = this.myNode.getTreeParent()).getElementType() != PyElementTypes.PARENTHESIZED_EXPRESSION) {
            return false;
        }
        return this.myContext.getPySettings().ALIGN_COLLECTIONS_AND_COMPREHENSIONS && !PyBlock.hasHangingIndent(this.myNode.getPsi());
    }

    @Nullable
    private static ASTNode findPrevNonSpaceNode(@NotNull ASTNode node) {
        if (node == null) {
            PyBlock.$$$reportNull$$$0(35);
        }
        while (PyBlock.isWhitespace(node = node.getTreePrev())) {
        }
        return node;
    }

    private static boolean isWhitespace(@Nullable ASTNode node) {
        return node != null && (node.getElementType() == TokenType.WHITE_SPACE || PyTokenTypes.WHITESPACE.contains(node.getElementType()));
    }

    private static boolean hasLineBreaksBeforeInSameParent(@NotNull ASTNode node, int minCount) {
        ASTNode treePrev;
        if (node == null) {
            PyBlock.$$$reportNull$$$0(36);
        }
        return (treePrev = node.getTreePrev()) != null && PyBlock.isWhitespaceWithLineBreaks(TreeUtil.findLastLeaf((ASTNode)treePrev), minCount) || PyBlock.isWhitespaceWithLineBreaks(node.getFirstChildNode(), minCount);
    }

    private static boolean hasLineBreakAfterIgnoringComments(@NotNull ASTNode node) {
        if (node == null) {
            PyBlock.$$$reportNull$$$0(37);
        }
        ASTNode next = TreeUtil.nextLeaf((ASTNode)node);
        while (next != null) {
            if (PyBlock.isWhitespace(next)) {
                if (next.textContains('\n')) {
                    return true;
                }
            } else {
                if (next.getElementType() != PyTokenTypes.END_OF_LINE_COMMENT) break;
                return true;
            }
            next = TreeUtil.nextLeaf((ASTNode)next);
        }
        return false;
    }

    private static boolean isWhitespaceWithLineBreaks(@Nullable ASTNode node, int minCount) {
        if (PyBlock.isWhitespace(node)) {
            if (minCount == 1) {
                return node.textContains('\n');
            }
            String prevNodeText = node.getText();
            int count = 0;
            for (int i = 0; i < prevNodeText.length(); ++i) {
                if (prevNodeText.charAt(i) != '\n' || ++count != minCount) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    public Wrap getWrap() {
        return this.myWrap;
    }

    @Nullable
    public Indent getIndent() {
        assert (this.myIndent != null);
        return this.myIndent;
    }

    @Nullable
    public Alignment getAlignment() {
        return this.myAlignment;
    }

    @Nullable
    public Spacing getSpacing(@Nullable Block child1, @NotNull Block child2) {
        if (child2 == null) {
            PyBlock.$$$reportNull$$$0(38);
        }
        CommonCodeStyleSettings settings = this.myContext.getSettings();
        PyCodeStyleSettings pySettings = this.myContext.getPySettings();
        if (child1 instanceof ASTBlock && child2 instanceof ASTBlock) {
            PyAstNamedParameter namedParameter;
            ASTNode lastLeaf;
            LeafElement firstLeaf;
            PsiElement nonCommentAfter;
            ASTNode node1 = ((ASTBlock)child1).getNode();
            ASTNode node2 = ((ASTBlock)child2).getNode();
            IElementType childType1 = node1.getElementType();
            PsiElement psi1 = node1.getPsi();
            PsiElement psi2 = node2.getPsi();
            if (psi2 instanceof PyAstStatementList) {
                PyAstStatement[] statements;
                if (this.myNode.getElementType() == PyElementTypes.CLASS_DECLARATION && (statements = ((PyAstStatementList)psi2).getStatements()).length > 0 && statements[0] instanceof PyAstFunction) {
                    return this.getBlankLinesForOption(pySettings.BLANK_LINES_BEFORE_FIRST_METHOD);
                }
                if (childType1 == PyTokenTypes.COLON && this.needLineBreakInStatement()) {
                    return Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)true, (int)settings.KEEP_BLANK_LINES_IN_CODE);
                }
            }
            if (psi1 instanceof PsiComment && this.myNode.getPsi() instanceof PsiFile) {
                return Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)true, (int)2);
            }
            if (psi2 instanceof PsiComment && PyBlock.hasLineBreaksBeforeInSameParent(node2, 1) && (nonCommentAfter = PyPsiUtilsCore.getNextNonCommentSibling(psi2, true)) != null) {
                psi2 = nonCommentAfter;
            }
            node2 = psi2.getNode();
            IElementType childType2 = psi2.getNode().getElementType();
            child2 = this.getSubBlockByNode(node2);
            if (PyBlock.isInsideFStringFragmentWithEqualsSign(this.myNode)) {
                return Spacing.getReadOnlySpacing();
            }
            if (childType1 == PyTokenTypes.FSTRING_FRAGMENT_START && (firstLeaf = TreeUtil.findFirstLeaf((ASTNode)node2)) != null && firstLeaf.getElementType() == PyTokenTypes.LBRACE) {
                return Spacing.createSpacing((int)1, (int)1, (int)0, (boolean)false, (int)0);
            }
            if (childType2 == PyTokenTypes.FSTRING_FRAGMENT_END && (lastLeaf = TreeUtil.findLastLeaf((ASTNode)node1)) != null && lastLeaf.getElementType() == PyTokenTypes.RBRACE) {
                return Spacing.createSpacing((int)1, (int)1, (int)0, (boolean)false, (int)0);
            }
            if ((childType1 == PyTokenTypes.EQ || childType2 == PyTokenTypes.EQ) && (namedParameter = (PyAstNamedParameter)ObjectUtils.tryCast((Object)this.myNode.getPsi(), PyAstNamedParameter.class)) != null && namedParameter.getAnnotation() != null) {
                return Spacing.createSpacing((int)1, (int)1, (int)0, (boolean)settings.KEEP_LINE_BREAKS, (int)settings.KEEP_BLANK_LINES_IN_CODE);
            }
            if (psi1 instanceof PyAstImportStatementBase) {
                if (psi2 instanceof PyAstImportStatementBase) {
                    Boolean leftImportIsGroupStart = (Boolean)psi1.getCopyableUserData(PythonCodeStyleService.IMPORT_GROUP_BEGIN);
                    Boolean rightImportIsGroupStart = (Boolean)psi2.getCopyableUserData(PythonCodeStyleService.IMPORT_GROUP_BEGIN);
                    psi1.putCopyableUserData(PythonCodeStyleService.IMPORT_GROUP_BEGIN, null);
                    if (rightImportIsGroupStart != null) {
                        return Spacing.createSpacing((int)0, (int)0, (int)2, (boolean)true, (int)1);
                    }
                    if (leftImportIsGroupStart != null) {
                        return Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)false, (int)0);
                    }
                }
                if (psi2 instanceof PyAstStatement && !(psi2 instanceof PyAstImportStatementBase)) {
                    if (PyUtilCore.isTopLevel(psi1)) {
                        if (PyElementTypes.CLASS_OR_FUNCTION.contains(childType2)) {
                            return this.getBlankLinesForOption(Math.max(settings.BLANK_LINES_AFTER_IMPORTS, pySettings.BLANK_LINES_AROUND_TOP_LEVEL_CLASSES_FUNCTIONS));
                        }
                        return this.getBlankLinesForOption(settings.BLANK_LINES_AFTER_IMPORTS);
                    }
                    return this.getBlankLinesForOption(pySettings.BLANK_LINES_AFTER_LOCAL_IMPORTS);
                }
            }
            if (psi2 instanceof PyAstImportStatementBase && PyUtilCore.isAssignmentToModuleLevelDunderName(psi1)) {
                return Spacing.createSpacing((int)0, (int)0, (int)2, (boolean)settings.KEEP_LINE_BREAKS, (int)settings.KEEP_BLANK_LINES_IN_DECLARATIONS);
            }
            if ((PyElementTypes.CLASS_OR_FUNCTION.contains(childType1) && STATEMENT_OR_DECLARATION.contains(childType2) || STATEMENT_OR_DECLARATION.contains(childType1) && PyElementTypes.CLASS_OR_FUNCTION.contains(childType2)) && PyUtilCore.isTopLevel(psi1)) {
                return this.getBlankLinesForOption(pySettings.BLANK_LINES_AROUND_TOP_LEVEL_CLASSES_FUNCTIONS);
            }
        }
        return this.myContext.getSpacingBuilder().getSpacing((Block)this, child1, child2);
    }

    @NotNull
    private Spacing getBlankLinesForOption(int minBlankLines) {
        int lineFeeds = minBlankLines + 1;
        Spacing spacing = Spacing.createSpacing((int)0, (int)0, (int)lineFeeds, (boolean)this.myContext.getSettings().KEEP_LINE_BREAKS, (int)this.myContext.getSettings().KEEP_BLANK_LINES_IN_DECLARATIONS);
        if (spacing == null) {
            PyBlock.$$$reportNull$$$0(39);
        }
        return spacing;
    }

    private boolean needLineBreakInStatement() {
        PsiElement psiElement = this.myNode.getPsi();
        boolean isInStubFile = PyiUtilCore.isInsideStub(psiElement);
        if (psiElement instanceof PyAstStatementListContainer) {
            PyAstStatement statement = (PyAstStatement)PsiTreeUtil.getParentOfType((PsiElement)psiElement, PyAstStatement.class);
            if (statement != null) {
                Collection parts = PsiTreeUtil.collectElementsOfType((PsiElement)statement, (Class[])new Class[]{PyAstStatementPart.class});
                return parts.size() == 1 && this.myContext.getPySettings().NEW_LINE_AFTER_COLON && !isInStubFile || parts.size() > 1 && this.myContext.getPySettings().NEW_LINE_AFTER_COLON_MULTI_CLAUSE;
            }
            return this.myContext.getPySettings().NEW_LINE_AFTER_COLON && !isInStubFile;
        }
        return false;
    }

    @NotNull
    public ChildAttributes getChildAttributes(int newChildIndex) {
        int statementListsBelow = 0;
        if (newChildIndex > 0) {
            if (this.myNode.getPsi() instanceof PyAstFile || this.myNode.getElementType() == PyTokenTypes.COLON) {
                ChildAttributes childAttributes = ChildAttributes.DELEGATE_TO_PREV_CHILD;
                if (childAttributes == null) {
                    PyBlock.$$$reportNull$$$0(40);
                }
                return childAttributes;
            }
            PyBlock insertAfterBlock = this.getSubBlockByIndex(newChildIndex - 1);
            ASTNode prevNode = insertAfterBlock.getNode();
            PsiElement prevElt = prevNode.getPsi();
            if (this.myNode.getElementType() == PyElementTypes.WITH_STATEMENT && PyBlock.isInsideWithStatementParentheses(this.myNode, prevNode)) {
                ASTNode openingParenthesis = this.myNode.findChildByType((IElementType)PyTokenTypes.LPAR);
                for (int i = newChildIndex - 1; i >= 0; --i) {
                    PyBlock prevBlock = this.mySubBlocks.get(i);
                    if (prevBlock.myNode == openingParenthesis) break;
                    if (prevBlock.getAlignment() == null) continue;
                    return new ChildAttributes(Indent.getNormalIndent(), prevBlock.getAlignment());
                }
                return new ChildAttributes(Indent.getNormalIndent(), null);
            }
            if (prevElt instanceof PyAstStatementList) {
                if (PyBlock.dedentAfterLastStatement((PyAstStatementList)prevElt)) {
                    return new ChildAttributes(Indent.getNoneIndent(), this.getChildAlignment());
                }
                ChildAttributes childAttributes = ChildAttributes.DELEGATE_TO_PREV_CHILD;
                if (childAttributes == null) {
                    PyBlock.$$$reportNull$$$0(41);
                }
                return childAttributes;
            }
            if (prevElt instanceof PyAstStatementPart) {
                ChildAttributes childAttributes = ChildAttributes.DELEGATE_TO_PREV_CHILD;
                if (childAttributes == null) {
                    PyBlock.$$$reportNull$$$0(42);
                }
                return childAttributes;
            }
            ASTNode lastChild = insertAfterBlock.getNode();
            while (lastChild != null) {
                IElementType lastType = lastChild.getElementType();
                if (lastType == PyElementTypes.STATEMENT_LIST && PyBlock.hasLineBreaksBeforeInSameParent(lastChild, 1)) {
                    if (PyBlock.dedentAfterLastStatement((PyAstStatementList)lastChild.getPsi())) break;
                    ++statementListsBelow;
                } else if (statementListsBelow > 0 && lastChild.getPsi() instanceof PsiErrorElement) {
                    ++statementListsBelow;
                }
                if (this.myNode.getElementType() == PyElementTypes.STATEMENT_LIST && lastChild.getPsi() instanceof PsiErrorElement) {
                    ChildAttributes childAttributes = ChildAttributes.DELEGATE_TO_PREV_CHILD;
                    if (childAttributes == null) {
                        PyBlock.$$$reportNull$$$0(43);
                    }
                    return childAttributes;
                }
                lastChild = PyBlock.getLastNonSpaceChild(lastChild, true);
            }
        }
        if (statementListsBelow > 0) {
            int indent = this.myContext.getSettings().getIndentOptions().INDENT_SIZE;
            return new ChildAttributes(Indent.getSpaceIndent((int)(indent * statementListsBelow)), null);
        }
        Indent childIndent = this.getChildIndent(newChildIndex);
        Alignment childAlignment = this.getChildAlignment();
        return new ChildAttributes(childIndent, childAlignment);
    }

    private static boolean dedentAfterLastStatement(@NotNull PyAstStatementList statementList) {
        PyAstStatement[] statements;
        if (statementList == null) {
            PyBlock.$$$reportNull$$$0(44);
        }
        if ((statements = statementList.getStatements()).length == 0) {
            return false;
        }
        PyAstStatement last = statements[statements.length - 1];
        return last instanceof PyAstReturnStatement || last instanceof PyAstRaiseStatement || last instanceof PyAstPassStatement || PyBlock.isEllipsis(last);
    }

    private static boolean isEllipsis(@NotNull PyAstStatement statement) {
        PyAstExpression expression;
        if (statement == null) {
            PyBlock.$$$reportNull$$$0(45);
        }
        return statement instanceof PyAstExpressionStatement && (expression = ((PyAstExpressionStatement)statement).getExpression()) instanceof PyAstEllipsisLiteralExpression;
    }

    @Nullable
    private Alignment getChildAlignment() {
        IElementType nodeType = this.myNode.getElementType();
        if (ourListElementTypes.contains(nodeType) || nodeType == PyElementTypes.SLICE_ITEM || nodeType == PyElementTypes.STRING_LITERAL_EXPRESSION) {
            PyAstKeyValueExpression lastElement;
            PyAstExpression parenthesized;
            if (this.isInControlStatement()) {
                return null;
            }
            PsiElement elem = this.myNode.getPsi();
            if (elem instanceof PyAstParameterList && !this.myContext.getSettings().ALIGN_MULTILINE_PARAMETERS) {
                return null;
            }
            if ((elem instanceof PyAstSequenceExpression || elem instanceof PyAstComprehensionElement) && !this.myContext.getPySettings().ALIGN_COLLECTIONS_AND_COMPREHENSIONS) {
                return null;
            }
            if (elem instanceof PyAstParenthesizedExpression && (parenthesized = ((PyAstParenthesizedExpression)elem).getContainedExpression()) instanceof PyAstTupleExpression && !this.myContext.getPySettings().ALIGN_COLLECTIONS_AND_COMPREHENSIONS) {
                return null;
            }
            if (elem instanceof PyAstDictLiteralExpression && ((lastElement = (PyAstKeyValueExpression)ArrayUtil.getLastElement((Object[])((PyAstDictLiteralExpression)elem).getElements())) == null || lastElement.getValue() == null)) {
                return null;
            }
            if (elem instanceof PyAstWithStatement && PyPsiUtilsCore.getFirstChildOfType(elem, PyTokenTypes.LPAR) == null) {
                return null;
            }
            return this.getAlignmentForChildren();
        }
        return null;
    }

    @NotNull
    private Indent getChildIndent(int newChildIndex) {
        PyAstKeyValueExpression keyValue;
        IElementType parentType = this.myNode.getElementType();
        ASTNode afterNode = this.getAfterNode(newChildIndex);
        ASTNode lastChild = PyBlock.getLastNonSpaceChild(this.myNode, false);
        if (lastChild != null && lastChild.getElementType() == PyElementTypes.STATEMENT_LIST && this.mySubBlocks.size() >= newChildIndex) {
            if (afterNode == null) {
                Indent indent = Indent.getNoneIndent();
                if (indent == null) {
                    PyBlock.$$$reportNull$$$0(46);
                }
                return indent;
            }
            if (afterNode.getElementType() == PyElementTypes.STATEMENT_LIST || afterNode.getElementType() == PyTokenTypes.COLON) {
                Indent indent = Indent.getNormalIndent();
                if (indent == null) {
                    PyBlock.$$$reportNull$$$0(47);
                }
                return indent;
            }
            ASTNode lastFirstChild = lastChild.getFirstChildNode();
            if (lastFirstChild != null && lastFirstChild == lastChild.getLastChildNode() && lastFirstChild.getPsi() instanceof PsiErrorElement) {
                Indent indent = Indent.getNormalIndent();
                if (indent == null) {
                    PyBlock.$$$reportNull$$$0(48);
                }
                return indent;
            }
        }
        if (parentType == PyElementTypes.MATCH_STATEMENT && afterNode != null && afterNode.getElementType() == PyTokenTypes.COLON) {
            Indent indent = Indent.getNormalIndent();
            if (indent == null) {
                PyBlock.$$$reportNull$$$0(49);
            }
            return indent;
        }
        if (afterNode != null && afterNode.getElementType() == PyElementTypes.KEY_VALUE_EXPRESSION && (keyValue = (PyAstKeyValueExpression)afterNode.getPsi()) != null && keyValue.getValue() == null) {
            Indent indent = Indent.getContinuationIndent();
            if (indent == null) {
                PyBlock.$$$reportNull$$$0(50);
            }
            return indent;
        }
        PyCodeStyleSettings settings = this.myContext.getPySettings();
        if (parentType == PyElementTypes.PARAMETER_LIST && settings.USE_CONTINUATION_INDENT_FOR_PARAMETERS || parentType == PyElementTypes.ARGUMENT_LIST && settings.USE_CONTINUATION_INDENT_FOR_ARGUMENTS) {
            Indent indent = Indent.getContinuationIndent();
            if (indent == null) {
                PyBlock.$$$reportNull$$$0(51);
            }
            return indent;
        }
        if (ourCollectionLiteralTypes.contains(parentType) || parentType == PyElementTypes.TUPLE_EXPRESSION) {
            Indent indent = settings.USE_CONTINUATION_INDENT_FOR_COLLECTION_AND_COMPREHENSIONS ? Indent.getContinuationIndent() : Indent.getNormalIndent();
            if (indent == null) {
                PyBlock.$$$reportNull$$$0(52);
            }
            return indent;
        }
        if (ourListElementTypes.contains(parentType) || this.myNode.getPsi() instanceof PyAstStatementPart) {
            Indent indent = Indent.getNormalIndent();
            if (indent == null) {
                PyBlock.$$$reportNull$$$0(53);
            }
            return indent;
        }
        if (afterNode != null) {
            for (ASTNode wsAfter = afterNode.getTreeNext(); wsAfter != null && wsAfter.getElementType() == TokenType.WHITE_SPACE; wsAfter = wsAfter.getTreeNext()) {
                if (wsAfter.getText().indexOf(92) < 0) continue;
                Indent indent = Indent.getNormalIndent();
                if (indent == null) {
                    PyBlock.$$$reportNull$$$0(54);
                }
                return indent;
            }
        }
        Indent indent = Indent.getNoneIndent();
        if (indent == null) {
            PyBlock.$$$reportNull$$$0(55);
        }
        return indent;
    }

    @Nullable
    private ASTNode getAfterNode(int newChildIndex) {
        int prevIndex;
        if (newChildIndex == 0) {
            return null;
        }
        for (prevIndex = newChildIndex - 1; prevIndex > 0 && this.getSubBlockByIndex(prevIndex).getNode().getElementType() == PyTokenTypes.END_OF_LINE_COMMENT; --prevIndex) {
        }
        return this.getSubBlockByIndex(prevIndex).getNode();
    }

    private static ASTNode getLastNonSpaceChild(@NotNull ASTNode node, boolean acceptError) {
        ASTNode lastChild;
        if (node == null) {
            PyBlock.$$$reportNull$$$0(56);
        }
        for (lastChild = node.getLastChildNode(); lastChild != null && (lastChild.getElementType() == TokenType.WHITE_SPACE || !acceptError && lastChild.getPsi() instanceof PsiErrorElement); lastChild = lastChild.getTreePrev()) {
        }
        return lastChild;
    }

    public boolean isIncomplete() {
        PsiElement psiElement;
        ASTNode lastChild;
        if (!PsiTreeUtil.hasErrorElements((PsiElement)this.myNode.getPsi())) {
            if (this.myNode.getPsi() instanceof PsiFile) {
                return false;
            }
            PsiElement element = this.myNode.getPsi().getNextSibling();
            while (element instanceof PsiWhiteSpace) {
                element = element.getNextSibling();
            }
            if (element != null) {
                return false;
            }
        }
        if ((lastChild = PyBlock.getLastNonSpaceChild(this.myNode, false)) != null) {
            PyAstBinaryExpression binaryExpression;
            ASTNode statementListPrev;
            if (lastChild.getElementType() == PyElementTypes.STATEMENT_LIST && (statementListPrev = lastChild.getTreePrev()) != null && statementListPrev.getText().indexOf(10) >= 0) {
                return true;
            }
            if (lastChild.getElementType() == PyElementTypes.BINARY_EXPRESSION && (binaryExpression = (PyAstBinaryExpression)lastChild.getPsi()).getRightExpression() == null) {
                return true;
            }
            if (PyBlock.isIncompleteCall(lastChild)) {
                return true;
            }
        }
        if ((psiElement = this.myNode.getPsi()) instanceof PyAstArgumentList) {
            PyAstArgumentList argumentList = (PyAstArgumentList)psiElement;
            return argumentList.getClosingParen() == null;
        }
        return PyBlock.isIncompleteCall(this.myNode) || PyBlock.isIncompleteExpressionWithBrackets(this.myNode.getPsi());
    }

    private static boolean isIncompleteCall(@NotNull ASTNode node) {
        PyAstCallExpression callExpression;
        PyAstArgumentList argumentList;
        if (node == null) {
            PyBlock.$$$reportNull$$$0(57);
        }
        return node.getElementType() == PyElementTypes.CALL_EXPRESSION && ((argumentList = (callExpression = (PyAstCallExpression)node.getPsi()).getArgumentList()) == null || argumentList.getClosingParen() == null);
    }

    private static boolean isIncompleteExpressionWithBrackets(@NotNull PsiElement elem) {
        if (elem == null) {
            PyBlock.$$$reportNull$$$0(58);
        }
        if (elem instanceof PyAstSequenceExpression || elem instanceof PyAstComprehensionElement || elem instanceof PyAstParenthesizedExpression) {
            return PyTokenTypes.OPEN_BRACES.contains(elem.getFirstChild().getNode().getElementType()) && !PyTokenTypes.CLOSE_BRACES.contains(elem.getLastChild().getNode().getElementType());
        }
        return false;
    }

    public boolean isLeaf() {
        return this.myNode.getFirstChildNode() == null;
    }

    @NotNull
    private PyFormattableInjectedBlock createInjectedBlock(@NotNull ASTNode child, @NotNull Indent indent) {
        if (child == null) {
            PyBlock.$$$reportNull$$$0(59);
        }
        if (indent == null) {
            PyBlock.$$$reportNull$$$0(60);
        }
        return new PyFormattableInjectedBlock(this, child, this.getAlignmentForChildren(), Wrap.createWrap((WrapType)WrapType.NONE, (boolean)false), indent, this.myContext.getSettings().getRootSettings(), this.myContext);
    }

    private static boolean isInsideInjection(@NotNull ASTNode node) {
        ASTNode parent;
        if (node == null) {
            PyBlock.$$$reportNull$$$0(61);
        }
        return (parent = node.getTreeParent()) != null && InjectedLanguageManager.getInstance((Project)node.getPsi().getProject()).hasInjections(parent.getPsi());
    }

    private static boolean isInsideFStringFragmentWithEqualsSign(@NotNull ASTNode node) {
        ASTNode fStringFragmentParent;
        if (node == null) {
            PyBlock.$$$reportNull$$$0(62);
        }
        ASTNode aSTNode = fStringFragmentParent = node.getElementType() == PyElementTypes.FSTRING_FRAGMENT ? node : TreeUtil.findParent((ASTNode)node, (TokenSet)TokenSet.create((IElementType[])new IElementType[]{PyElementTypes.FSTRING_FRAGMENT}), (TokenSet)stopAtTokens);
        if (fStringFragmentParent == null) {
            return false;
        }
        return fStringFragmentParent.findChildByType((IElementType)PyTokenTypes.EQ) != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 7, 8, 9, 39, 40, 41, 42, 43, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indent";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/formatter/PyBlock";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 12: 
            case 13: 
            case 19: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 34: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childType";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "withStatement";
                break;
            }
            case 26: 
            case 27: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elem";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "b";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child2";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statementList";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/formatter/PyBlock";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getNode";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextRange";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubBlocks";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "buildSubBlocks";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubBlockNodes";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getBlankLinesForOption";
                break;
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildAttributes";
                break;
            }
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildIndent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getSubBlockByNode";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "collectChildrenOperatorAndOperandNodes";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "buildSubBlock";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getSpecialWrapForContainers";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isInsideWithStatementParentheses";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isIfCondition";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isCondition";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "findTopmostBinaryExpressionBlock";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isValueOfKeyValuePairOfDictLiteral";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isChildOfKeyValuePairOfDictLiteral";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isChildOfDictLiteral";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isChildOfKeyValuePair";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isValueOfKeyValuePair";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "isEmptySequence";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "hasHangingIndent";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getFirstItem";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getAlignmentOfChild";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "isIndentNext";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "isSubscriptionOperand";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getControlStatementHeader";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "isSliceOperand";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "isAfterStatementList";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "needListAlignment";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "findPrevNonSpaceNode";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "hasLineBreaksBeforeInSameParent";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "hasLineBreakAfterIgnoringComments";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getSpacing";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "dedentAfterLastStatement";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "isEllipsis";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "getLastNonSpaceChild";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "isIncompleteCall";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "isIncompleteExpressionWithBrackets";
                break;
            }
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "createInjectedBlock";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "isInsideInjection";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "isInsideFStringFragmentWithEqualsSign";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 7, 8, 9, 39, 40, 41, 42, 43, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55 -> new IllegalStateException(string);
        };
    }
}

