/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.configuration;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.get.GetRequest;
import org.opensearch.action.get.GetResponse;
import org.opensearch.common.settings.Settings;
import org.opensearch.core.action.ActionListener;
import org.opensearch.security.DefaultObjectMapper;
import org.opensearch.security.configuration.SecurityConfigVersionDocument;
import org.opensearch.transport.client.Client;

public class SecurityConfigVersionsLoader {
    private static final Logger log = LogManager.getLogger(SecurityConfigVersionsLoader.class);
    private final Client client;
    private final String opensearchSecurityConfigVersionsIndex;

    public SecurityConfigVersionsLoader(Client client, Settings settings) {
        this.client = client;
        this.opensearchSecurityConfigVersionsIndex = settings.get("plugins.security.config_versions_index_name", ".opensearch_security_config_versions");
    }

    private void getSecurityConfigVersionDocAsync(final ActionListener<SecurityConfigVersionDocument> listener) {
        GetRequest getRequest = new GetRequest(this.opensearchSecurityConfigVersionsIndex, "opensearch_security_config_versions");
        this.client.get(getRequest, (ActionListener)new ActionListener<GetResponse>(){

            public void onResponse(GetResponse getResponse) {
                try {
                    if (!getResponse.isExists()) {
                        log.warn("Config versions document not found in {}", (Object)SecurityConfigVersionsLoader.this.opensearchSecurityConfigVersionsIndex);
                        listener.onResponse((Object)new SecurityConfigVersionDocument());
                        return;
                    }
                    SecurityConfigVersionDocument doc = DefaultObjectMapper.readValue(getResponse.getSourceAsString(), SecurityConfigVersionDocument.class);
                    doc.setSeqNo(getResponse.getSeqNo());
                    doc.setPrimaryTerm(getResponse.getPrimaryTerm());
                    listener.onResponse((Object)doc);
                }
                catch (IOException e) {
                    log.error("Failed to parse config versions doc", (Throwable)e);
                    listener.onFailure((Exception)e);
                }
            }

            public void onFailure(Exception e) {
                log.error("Failed to load config versions doc from {}", (Object)SecurityConfigVersionsLoader.this.opensearchSecurityConfigVersionsIndex, (Object)e);
                listener.onFailure(e);
            }
        });
    }

    public void loadLatestVersionAsync(final ActionListener<SecurityConfigVersionDocument.Version<?>> listener) {
        this.getSecurityConfigVersionDocAsync(new ActionListener<SecurityConfigVersionDocument>(this){

            public void onResponse(SecurityConfigVersionDocument doc) {
                List<SecurityConfigVersionDocument.Version<?>> versions = doc.getVersions();
                if (versions == null || versions.isEmpty()) {
                    listener.onResponse(null);
                } else {
                    SecurityConfigVersionsLoader.sortVersionsById(versions);
                    listener.onResponse(versions.get(versions.size() - 1));
                }
            }

            public void onFailure(Exception e) {
                listener.onFailure(e);
            }
        });
    }

    public SecurityConfigVersionDocument.Version<?> loadLatestVersion() {
        final CountDownLatch latch = new CountDownLatch(1);
        final AtomicReference result = new AtomicReference();
        final Exception[] failure = new Exception[1];
        this.loadLatestVersionAsync(new ActionListener<SecurityConfigVersionDocument.Version<?>>(this){

            public void onResponse(SecurityConfigVersionDocument.Version<?> version) {
                result.set(version);
                latch.countDown();
            }

            public void onFailure(Exception e) {
                failure[0] = e;
                latch.countDown();
            }
        });
        try {
            if (!latch.await(10L, TimeUnit.SECONDS)) {
                throw new RuntimeException("Timeout waiting for loadLatestVersionAsync()");
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted while waiting for config version load", e);
        }
        if (failure[0] != null) {
            throw new RuntimeException("Failed to load latest config version", failure[0]);
        }
        return (SecurityConfigVersionDocument.Version)result.get();
    }

    public SecurityConfigVersionDocument loadFullDocument() {
        final AtomicReference result = new AtomicReference();
        final Exception[] error = new Exception[1];
        final CountDownLatch latch = new CountDownLatch(1);
        this.getSecurityConfigVersionDocAsync(new ActionListener<SecurityConfigVersionDocument>(this){

            public void onResponse(SecurityConfigVersionDocument doc) {
                result.set(doc);
                latch.countDown();
            }

            public void onFailure(Exception e) {
                error[0] = e;
                latch.countDown();
            }
        });
        try {
            if (!latch.await(10L, TimeUnit.SECONDS)) {
                throw new RuntimeException("Timeout while loading full config version document");
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted while loading full config version document", e);
        }
        if (error[0] != null) {
            throw new RuntimeException("Failed to load full config version document", error[0]);
        }
        return result.get() != null ? (SecurityConfigVersionDocument)result.get() : new SecurityConfigVersionDocument();
    }

    public static <T> void sortVersionsById(List<SecurityConfigVersionDocument.Version<?>> versions) {
        versions.sort((v1, v2) -> {
            try {
                int n1 = Integer.parseInt(v1.getVersion_id().substring(1));
                int n2 = Integer.parseInt(v2.getVersion_id().substring(1));
                return Integer.compare(n1, n2);
            }
            catch (Exception e) {
                log.warn("Invalid version_id format", (Throwable)e);
                return 0;
            }
        });
    }
}

