/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.snapshot;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch.snapshot.RepositorySettings;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class Repository
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, Repository> {
    @Nullable
    private final RepositorySettings settings;
    @Nullable
    private final String type;
    @Nullable
    private final String uuid;
    public static final JsonpDeserializer<Repository> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Repository::setupRepositoryDeserializer);

    private Repository(Builder builder) {
        this.settings = builder.settings;
        this.type = builder.type;
        this.uuid = builder.uuid;
    }

    public static Repository of(Function<Builder, ObjectBuilder<Repository>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final RepositorySettings settings() {
        return this.settings;
    }

    @Nullable
    public final String type() {
        return this.type;
    }

    @Nullable
    public final String uuid() {
        return this.uuid;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.settings != null) {
            generator.writeKey("settings");
            this.settings.serialize(generator, mapper);
        }
        if (this.type != null) {
            generator.writeKey("type");
            generator.write(this.type);
        }
        if (this.uuid != null) {
            generator.writeKey("uuid");
            generator.write(this.uuid);
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupRepositoryDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::settings, RepositorySettings._DESERIALIZER, "settings");
        op.add(Builder::type, JsonpDeserializer.stringDeserializer(), "type");
        op.add(Builder::uuid, JsonpDeserializer.stringDeserializer(), "uuid");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.settings);
        result = 31 * result + Objects.hashCode(this.type);
        result = 31 * result + Objects.hashCode(this.uuid);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Repository other = (Repository)o;
        return Objects.equals(this.settings, other.settings) && Objects.equals(this.type, other.type) && Objects.equals(this.uuid, other.uuid);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, Repository> {
        @Nullable
        private RepositorySettings settings;
        @Nullable
        private String type;
        @Nullable
        private String uuid;

        public Builder() {
        }

        private Builder(Repository o) {
            this.settings = o.settings;
            this.type = o.type;
            this.uuid = o.uuid;
        }

        private Builder(Builder o) {
            this.settings = o.settings;
            this.type = o.type;
            this.uuid = o.uuid;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder settings(@Nullable RepositorySettings value) {
            this.settings = value;
            return this;
        }

        @Nonnull
        public final Builder settings(Function<RepositorySettings.Builder, ObjectBuilder<RepositorySettings>> fn) {
            return this.settings(fn.apply(new RepositorySettings.Builder()).build());
        }

        @Nonnull
        public final Builder type(@Nullable String value) {
            this.type = value;
            return this;
        }

        @Nonnull
        public final Builder uuid(@Nullable String value) {
            this.uuid = value;
            return this;
        }

        @Override
        @Nonnull
        public Repository build() {
            this._checkSingleUse();
            return new Repository(this);
        }
    }
}

