/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.indices;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class DataStreamStats
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, DataStreamStats> {
    private final int backingIndices;
    @Nonnull
    private final String dataStream;
    private final long maximumTimestamp;
    @Nullable
    private final String storeSize;
    private final long storeSizeBytes;
    public static final JsonpDeserializer<DataStreamStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DataStreamStats::setupDataStreamStatsDeserializer);

    private DataStreamStats(Builder builder) {
        this.backingIndices = ApiTypeHelper.requireNonNull(builder.backingIndices, this, "backingIndices");
        this.dataStream = ApiTypeHelper.requireNonNull(builder.dataStream, this, "dataStream");
        this.maximumTimestamp = ApiTypeHelper.requireNonNull(builder.maximumTimestamp, this, "maximumTimestamp");
        this.storeSize = builder.storeSize;
        this.storeSizeBytes = ApiTypeHelper.requireNonNull(builder.storeSizeBytes, this, "storeSizeBytes");
    }

    public static DataStreamStats of(Function<Builder, ObjectBuilder<DataStreamStats>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final int backingIndices() {
        return this.backingIndices;
    }

    @Nonnull
    public final String dataStream() {
        return this.dataStream;
    }

    public final long maximumTimestamp() {
        return this.maximumTimestamp;
    }

    @Nullable
    public final String storeSize() {
        return this.storeSize;
    }

    public final long storeSizeBytes() {
        return this.storeSizeBytes;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("backing_indices");
        generator.write(this.backingIndices);
        generator.writeKey("data_stream");
        generator.write(this.dataStream);
        generator.writeKey("maximum_timestamp");
        generator.write(this.maximumTimestamp);
        if (this.storeSize != null) {
            generator.writeKey("store_size");
            generator.write(this.storeSize);
        }
        generator.writeKey("store_size_bytes");
        generator.write(this.storeSizeBytes);
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupDataStreamStatsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::backingIndices, JsonpDeserializer.integerDeserializer(), "backing_indices");
        op.add(Builder::dataStream, JsonpDeserializer.stringDeserializer(), "data_stream");
        op.add(Builder::maximumTimestamp, JsonpDeserializer.longDeserializer(), "maximum_timestamp");
        op.add(Builder::storeSize, JsonpDeserializer.stringDeserializer(), "store_size");
        op.add(Builder::storeSizeBytes, JsonpDeserializer.longDeserializer(), "store_size_bytes");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Integer.hashCode(this.backingIndices);
        result = 31 * result + this.dataStream.hashCode();
        result = 31 * result + Long.hashCode(this.maximumTimestamp);
        result = 31 * result + Objects.hashCode(this.storeSize);
        result = 31 * result + Long.hashCode(this.storeSizeBytes);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataStreamStats other = (DataStreamStats)o;
        return this.backingIndices == other.backingIndices && this.dataStream.equals(other.dataStream) && this.maximumTimestamp == other.maximumTimestamp && Objects.equals(this.storeSize, other.storeSize) && this.storeSizeBytes == other.storeSizeBytes;
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, DataStreamStats> {
        private Integer backingIndices;
        private String dataStream;
        private Long maximumTimestamp;
        @Nullable
        private String storeSize;
        private Long storeSizeBytes;

        public Builder() {
        }

        private Builder(DataStreamStats o) {
            this.backingIndices = o.backingIndices;
            this.dataStream = o.dataStream;
            this.maximumTimestamp = o.maximumTimestamp;
            this.storeSize = o.storeSize;
            this.storeSizeBytes = o.storeSizeBytes;
        }

        private Builder(Builder o) {
            this.backingIndices = o.backingIndices;
            this.dataStream = o.dataStream;
            this.maximumTimestamp = o.maximumTimestamp;
            this.storeSize = o.storeSize;
            this.storeSizeBytes = o.storeSizeBytes;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder backingIndices(int value) {
            this.backingIndices = value;
            return this;
        }

        @Nonnull
        public final Builder dataStream(String value) {
            this.dataStream = value;
            return this;
        }

        @Nonnull
        public final Builder maximumTimestamp(long value) {
            this.maximumTimestamp = value;
            return this;
        }

        @Nonnull
        public final Builder storeSize(@Nullable String value) {
            this.storeSize = value;
            return this;
        }

        @Nonnull
        public final Builder storeSizeBytes(long value) {
            this.storeSizeBytes = value;
            return this;
        }

        @Override
        @Nonnull
        public DataStreamStats build() {
            this._checkSingleUse();
            return new DataStreamStats(this);
        }
    }
}

