/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.core.search;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonEnum;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.JsonpSerializable;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch.core.search.CompletionSuggester;
import org.opensearch.client.opensearch.core.search.FieldSuggesterVariant;
import org.opensearch.client.opensearch.core.search.PhraseSuggester;
import org.opensearch.client.opensearch.core.search.TermSuggester;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.TaggedUnion;
import org.opensearch.client.util.TaggedUnionUtils;

@JsonpDeserializable
public class FieldSuggester
implements TaggedUnion<Kind, FieldSuggesterVariant>,
PlainJsonSerializable {
    private final Kind _kind;
    private final FieldSuggesterVariant _value;
    @Nullable
    private final String prefix;
    @Nullable
    private final String regex;
    @Nullable
    private final String text;
    public static final JsonpDeserializer<FieldSuggester> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, FieldSuggester::setupFieldSuggesterDeserializer, Builder::build);

    @Override
    public final Kind _kind() {
        return this._kind;
    }

    @Override
    public final FieldSuggesterVariant _get() {
        return this._value;
    }

    public FieldSuggester(FieldSuggesterVariant value) {
        this._kind = ApiTypeHelper.requireNonNull(value._fieldSuggesterKind(), this, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(value, this, "<variant value>");
        this.prefix = null;
        this.regex = null;
        this.text = null;
    }

    private FieldSuggester(Builder builder) {
        this.prefix = builder.prefix;
        this.regex = builder.regex;
        this.text = builder.text;
        this._kind = ApiTypeHelper.requireNonNull(builder._kind, builder, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(builder._value, builder, "<variant value>");
    }

    public static FieldSuggester of(Function<Builder, ObjectBuilder<FieldSuggester>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String prefix() {
        return this.prefix;
    }

    @Nullable
    public final String regex() {
        return this.regex;
    }

    @Nullable
    public final String text() {
        return this.text;
    }

    public boolean isCompletion() {
        return this._kind == Kind.Completion;
    }

    public CompletionSuggester completion() {
        return (CompletionSuggester)TaggedUnionUtils.get(this, Kind.Completion);
    }

    public boolean isPhrase() {
        return this._kind == Kind.Phrase;
    }

    public PhraseSuggester phrase() {
        return (PhraseSuggester)TaggedUnionUtils.get(this, Kind.Phrase);
    }

    public boolean isTerm() {
        return this._kind == Kind.Term;
    }

    public TermSuggester term() {
        return (TermSuggester)TaggedUnionUtils.get(this, Kind.Term);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        if (this.prefix != null) {
            generator.writeKey("prefix");
            generator.write(this.prefix);
        }
        if (this.regex != null) {
            generator.writeKey("regex");
            generator.write(this.regex);
        }
        if (this.text != null) {
            generator.writeKey("text");
            generator.write(this.text);
        }
        generator.writeKey(this._kind.jsonValue());
        if (this._value instanceof JsonpSerializable) {
            ((JsonpSerializable)((Object)this._value)).serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupFieldSuggesterDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::prefix, JsonpDeserializer.stringDeserializer(), "prefix");
        op.add(Builder::regex, JsonpDeserializer.stringDeserializer(), "regex");
        op.add(Builder::text, JsonpDeserializer.stringDeserializer(), "text");
        op.add(Builder::completion, CompletionSuggester._DESERIALIZER, "completion");
        op.add(Builder::phrase, PhraseSuggester._DESERIALIZER, "phrase");
        op.add(Builder::term, TermSuggester._DESERIALIZER, "term");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this._kind);
        result = 31 * result + Objects.hashCode(this._value);
        result = 31 * result + Objects.hashCode(this.prefix);
        result = 31 * result + Objects.hashCode(this.regex);
        result = 31 * result + Objects.hashCode(this.text);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FieldSuggester other = (FieldSuggester)o;
        return Objects.equals(this._kind, other._kind) && Objects.equals(this._value, other._value) && Objects.equals(this.prefix, other.prefix) && Objects.equals(this.regex, other.regex) && Objects.equals(this.text, other.text);
    }

    public static class Builder
    extends ObjectBuilderBase {
        private Kind _kind;
        private FieldSuggesterVariant _value;
        @Nullable
        private String prefix;
        @Nullable
        private String regex;
        @Nullable
        private String text;

        public Builder() {
        }

        private Builder(FieldSuggester o) {
            this.prefix = o.prefix;
            this.regex = o.regex;
            this.text = o.text;
            this._kind = o._kind;
            this._value = o._value;
        }

        @Nonnull
        public final Builder prefix(@Nullable String value) {
            this.prefix = value;
            return this;
        }

        @Nonnull
        public final Builder regex(@Nullable String value) {
            this.regex = value;
            return this;
        }

        @Nonnull
        public final Builder text(@Nullable String value) {
            this.text = value;
            return this;
        }

        public ContainerBuilder completion(CompletionSuggester v) {
            this._kind = Kind.Completion;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder completion(Function<CompletionSuggester.Builder, ObjectBuilder<CompletionSuggester>> fn) {
            return this.completion(fn.apply(new CompletionSuggester.Builder()).build());
        }

        public ContainerBuilder phrase(PhraseSuggester v) {
            this._kind = Kind.Phrase;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder phrase(Function<PhraseSuggester.Builder, ObjectBuilder<PhraseSuggester>> fn) {
            return this.phrase(fn.apply(new PhraseSuggester.Builder()).build());
        }

        public ContainerBuilder term(TermSuggester v) {
            this._kind = Kind.Term;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder term(Function<TermSuggester.Builder, ObjectBuilder<TermSuggester>> fn) {
            return this.term(fn.apply(new TermSuggester.Builder()).build());
        }

        protected FieldSuggester build() {
            this._checkSingleUse();
            return new FieldSuggester(this);
        }

        public class ContainerBuilder
        implements ObjectBuilder<FieldSuggester> {
            private ContainerBuilder() {
            }

            @Nonnull
            public final ContainerBuilder prefix(@Nullable String value) {
                Builder.this.prefix = value;
                return this;
            }

            @Nonnull
            public final ContainerBuilder regex(@Nullable String value) {
                Builder.this.regex = value;
                return this;
            }

            @Nonnull
            public final ContainerBuilder text(@Nullable String value) {
                Builder.this.text = value;
                return this;
            }

            @Override
            public FieldSuggester build() {
                return Builder.this.build();
            }
        }
    }

    public static enum Kind implements JsonEnum
    {
        Completion("completion"),
        Phrase("phrase"),
        Term("term");

        private final String jsonValue;

        private Kind(String jsonValue) {
            this.jsonValue = jsonValue;
        }

        @Override
        public String jsonValue() {
            return this.jsonValue;
        }
    }
}

