/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.cluster;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.opensearch._types.ErrorResponse;
import org.opensearch.client.opensearch._types.ExpandWildcard;
import org.opensearch.client.opensearch._types.HealthStatus;
import org.opensearch.client.opensearch._types.RequestBase;
import org.opensearch.client.opensearch._types.Time;
import org.opensearch.client.opensearch._types.WaitForActiveShards;
import org.opensearch.client.opensearch._types.WaitForEvents;
import org.opensearch.client.opensearch.cluster.HealthResponse;
import org.opensearch.client.opensearch.cluster.WaitForNodes;
import org.opensearch.client.opensearch.cluster.health.ClusterHealthLevel;
import org.opensearch.client.transport.Endpoint;
import org.opensearch.client.transport.endpoints.SimpleEndpoint;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

public final class HealthRequest
extends RequestBase
implements ToCopyableBuilder<Builder, HealthRequest> {
    @Nullable
    private final String awarenessAttribute;
    @Nullable
    private final Time clusterManagerTimeout;
    @Nonnull
    private final List<ExpandWildcard> expandWildcards;
    @Nonnull
    private final List<String> index;
    @Nullable
    private final ClusterHealthLevel level;
    @Nullable
    private final Boolean local;
    @Deprecated
    @Nullable
    private final Time masterTimeout;
    @Nullable
    private final Time timeout;
    @Nullable
    private final WaitForActiveShards waitForActiveShards;
    @Nullable
    private final WaitForEvents waitForEvents;
    @Nullable
    private final Boolean waitForNoInitializingShards;
    @Nullable
    private final Boolean waitForNoRelocatingShards;
    @Nullable
    private final WaitForNodes waitForNodes;
    @Nullable
    private final HealthStatus waitForStatus;
    public static final Endpoint<HealthRequest, HealthResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<HealthRequest, HealthResponse>(request -> "GET", request -> {
        boolean _index = true;
        boolean propsSet = false;
        if (ApiTypeHelper.isDefined(request.index())) {
            propsSet |= true;
        }
        if (!propsSet) {
            return "/_cluster/health";
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_cluster/health/");
            SimpleEndpoint.pathEncode(String.join((CharSequence)",", request.index), buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        request.applyQueryParameters(params);
        return params;
    }, SimpleEndpoint.emptyMap(), false, HealthResponse._DESERIALIZER);

    private HealthRequest(Builder builder) {
        super(builder);
        this.awarenessAttribute = builder.awarenessAttribute;
        this.clusterManagerTimeout = builder.clusterManagerTimeout;
        this.expandWildcards = ApiTypeHelper.unmodifiable(builder.expandWildcards);
        this.index = ApiTypeHelper.unmodifiable(builder.index);
        this.level = builder.level;
        this.local = builder.local;
        this.masterTimeout = builder.masterTimeout;
        this.timeout = builder.timeout;
        this.waitForActiveShards = builder.waitForActiveShards;
        this.waitForEvents = builder.waitForEvents;
        this.waitForNoInitializingShards = builder.waitForNoInitializingShards;
        this.waitForNoRelocatingShards = builder.waitForNoRelocatingShards;
        this.waitForNodes = builder.waitForNodes;
        this.waitForStatus = builder.waitForStatus;
    }

    public static HealthRequest of(Function<Builder, ObjectBuilder<HealthRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String awarenessAttribute() {
        return this.awarenessAttribute;
    }

    @Nullable
    public final Time clusterManagerTimeout() {
        return this.clusterManagerTimeout;
    }

    @Nonnull
    public final List<ExpandWildcard> expandWildcards() {
        return this.expandWildcards;
    }

    @Nonnull
    public final List<String> index() {
        return this.index;
    }

    @Nullable
    public final ClusterHealthLevel level() {
        return this.level;
    }

    @Nullable
    public final Boolean local() {
        return this.local;
    }

    @Deprecated
    @Nullable
    public final Time masterTimeout() {
        return this.masterTimeout;
    }

    @Nullable
    public final Time timeout() {
        return this.timeout;
    }

    @Nullable
    public final WaitForActiveShards waitForActiveShards() {
        return this.waitForActiveShards;
    }

    @Nullable
    public final WaitForEvents waitForEvents() {
        return this.waitForEvents;
    }

    @Nullable
    public final Boolean waitForNoInitializingShards() {
        return this.waitForNoInitializingShards;
    }

    @Nullable
    public final Boolean waitForNoRelocatingShards() {
        return this.waitForNoRelocatingShards;
    }

    @Nullable
    public final WaitForNodes waitForNodes() {
        return this.waitForNodes;
    }

    @Nullable
    public final HealthStatus waitForStatus() {
        return this.waitForStatus;
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    @Override
    protected void applyQueryParameters(@Nonnull Map<String, String> params) {
        super.applyQueryParameters(params);
        if (this.awarenessAttribute != null) {
            params.put("awareness_attribute", this.awarenessAttribute);
        }
        if (this.clusterManagerTimeout != null) {
            params.put("cluster_manager_timeout", this.clusterManagerTimeout._toJsonString());
        }
        if (ApiTypeHelper.isDefined(this.expandWildcards)) {
            params.put("expand_wildcards", this.expandWildcards.stream().map(v -> v.jsonValue()).collect(Collectors.joining(",")));
        }
        if (this.level != null) {
            params.put("level", this.level.jsonValue());
        }
        if (this.local != null) {
            params.put("local", String.valueOf(this.local));
        }
        if (this.masterTimeout != null) {
            params.put("master_timeout", this.masterTimeout._toJsonString());
        }
        if (this.timeout != null) {
            params.put("timeout", this.timeout._toJsonString());
        }
        if (this.waitForActiveShards != null) {
            params.put("wait_for_active_shards", this.waitForActiveShards._toJsonString());
        }
        if (this.waitForEvents != null) {
            params.put("wait_for_events", this.waitForEvents.jsonValue());
        }
        if (this.waitForNoInitializingShards != null) {
            params.put("wait_for_no_initializing_shards", String.valueOf(this.waitForNoInitializingShards));
        }
        if (this.waitForNoRelocatingShards != null) {
            params.put("wait_for_no_relocating_shards", String.valueOf(this.waitForNoRelocatingShards));
        }
        if (this.waitForNodes != null) {
            params.put("wait_for_nodes", this.waitForNodes._toJsonString());
        }
        if (this.waitForStatus != null) {
            params.put("wait_for_status", this.waitForStatus.jsonValue());
        }
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.awarenessAttribute);
        result = 31 * result + Objects.hashCode(this.clusterManagerTimeout);
        result = 31 * result + Objects.hashCode(this.expandWildcards);
        result = 31 * result + Objects.hashCode(this.index);
        result = 31 * result + Objects.hashCode(this.level);
        result = 31 * result + Objects.hashCode(this.local);
        result = 31 * result + Objects.hashCode(this.masterTimeout);
        result = 31 * result + Objects.hashCode(this.timeout);
        result = 31 * result + Objects.hashCode(this.waitForActiveShards);
        result = 31 * result + Objects.hashCode(this.waitForEvents);
        result = 31 * result + Objects.hashCode(this.waitForNoInitializingShards);
        result = 31 * result + Objects.hashCode(this.waitForNoRelocatingShards);
        result = 31 * result + Objects.hashCode(this.waitForNodes);
        result = 31 * result + Objects.hashCode(this.waitForStatus);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HealthRequest other = (HealthRequest)o;
        return Objects.equals(this.awarenessAttribute, other.awarenessAttribute) && Objects.equals(this.clusterManagerTimeout, other.clusterManagerTimeout) && Objects.equals(this.expandWildcards, other.expandWildcards) && Objects.equals(this.index, other.index) && Objects.equals(this.level, other.level) && Objects.equals(this.local, other.local) && Objects.equals(this.masterTimeout, other.masterTimeout) && Objects.equals(this.timeout, other.timeout) && Objects.equals(this.waitForActiveShards, other.waitForActiveShards) && Objects.equals(this.waitForEvents, other.waitForEvents) && Objects.equals(this.waitForNoInitializingShards, other.waitForNoInitializingShards) && Objects.equals(this.waitForNoRelocatingShards, other.waitForNoRelocatingShards) && Objects.equals(this.waitForNodes, other.waitForNodes) && Objects.equals(this.waitForStatus, other.waitForStatus);
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, HealthRequest> {
        @Nullable
        private String awarenessAttribute;
        @Nullable
        private Time clusterManagerTimeout;
        @Nullable
        private List<ExpandWildcard> expandWildcards;
        @Nullable
        private List<String> index;
        @Nullable
        private ClusterHealthLevel level;
        @Nullable
        private Boolean local;
        @Nullable
        private Time masterTimeout;
        @Nullable
        private Time timeout;
        @Nullable
        private WaitForActiveShards waitForActiveShards;
        @Nullable
        private WaitForEvents waitForEvents;
        @Nullable
        private Boolean waitForNoInitializingShards;
        @Nullable
        private Boolean waitForNoRelocatingShards;
        @Nullable
        private WaitForNodes waitForNodes;
        @Nullable
        private HealthStatus waitForStatus;

        public Builder() {
        }

        private Builder(HealthRequest o) {
            super(o);
            this.awarenessAttribute = o.awarenessAttribute;
            this.clusterManagerTimeout = o.clusterManagerTimeout;
            this.expandWildcards = Builder._listCopy(o.expandWildcards);
            this.index = Builder._listCopy(o.index);
            this.level = o.level;
            this.local = o.local;
            this.masterTimeout = o.masterTimeout;
            this.timeout = o.timeout;
            this.waitForActiveShards = o.waitForActiveShards;
            this.waitForEvents = o.waitForEvents;
            this.waitForNoInitializingShards = o.waitForNoInitializingShards;
            this.waitForNoRelocatingShards = o.waitForNoRelocatingShards;
            this.waitForNodes = o.waitForNodes;
            this.waitForStatus = o.waitForStatus;
        }

        private Builder(Builder o) {
            super(o);
            this.awarenessAttribute = o.awarenessAttribute;
            this.clusterManagerTimeout = o.clusterManagerTimeout;
            this.expandWildcards = Builder._listCopy(o.expandWildcards);
            this.index = Builder._listCopy(o.index);
            this.level = o.level;
            this.local = o.local;
            this.masterTimeout = o.masterTimeout;
            this.timeout = o.timeout;
            this.waitForActiveShards = o.waitForActiveShards;
            this.waitForEvents = o.waitForEvents;
            this.waitForNoInitializingShards = o.waitForNoInitializingShards;
            this.waitForNoRelocatingShards = o.waitForNoRelocatingShards;
            this.waitForNodes = o.waitForNodes;
            this.waitForStatus = o.waitForStatus;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder awarenessAttribute(@Nullable String value) {
            this.awarenessAttribute = value;
            return this;
        }

        @Nonnull
        public final Builder clusterManagerTimeout(@Nullable Time value) {
            this.clusterManagerTimeout = value;
            return this;
        }

        @Nonnull
        public final Builder clusterManagerTimeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.clusterManagerTimeout(fn.apply(new Time.Builder()).build());
        }

        @Nonnull
        public final Builder expandWildcards(List<ExpandWildcard> list) {
            this.expandWildcards = Builder._listAddAll(this.expandWildcards, list);
            return this;
        }

        @Nonnull
        public final Builder expandWildcards(ExpandWildcard value, ExpandWildcard ... values) {
            this.expandWildcards = Builder._listAdd(this.expandWildcards, value, values);
            return this;
        }

        @Nonnull
        public final Builder index(List<String> list) {
            this.index = Builder._listAddAll(this.index, list);
            return this;
        }

        @Nonnull
        public final Builder index(String value, String ... values) {
            this.index = Builder._listAdd(this.index, value, values);
            return this;
        }

        @Nonnull
        public final Builder level(@Nullable ClusterHealthLevel value) {
            this.level = value;
            return this;
        }

        @Nonnull
        public final Builder local(@Nullable Boolean value) {
            this.local = value;
            return this;
        }

        @Deprecated
        @Nonnull
        public final Builder masterTimeout(@Nullable Time value) {
            this.masterTimeout = value;
            return this;
        }

        @Deprecated
        @Nonnull
        public final Builder masterTimeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.masterTimeout(fn.apply(new Time.Builder()).build());
        }

        @Nonnull
        public final Builder timeout(@Nullable Time value) {
            this.timeout = value;
            return this;
        }

        @Nonnull
        public final Builder timeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.timeout(fn.apply(new Time.Builder()).build());
        }

        @Nonnull
        public final Builder waitForActiveShards(@Nullable WaitForActiveShards value) {
            this.waitForActiveShards = value;
            return this;
        }

        @Nonnull
        public final Builder waitForActiveShards(Function<WaitForActiveShards.Builder, ObjectBuilder<WaitForActiveShards>> fn) {
            return this.waitForActiveShards(fn.apply(new WaitForActiveShards.Builder()).build());
        }

        @Nonnull
        public final Builder waitForEvents(@Nullable WaitForEvents value) {
            this.waitForEvents = value;
            return this;
        }

        @Nonnull
        public final Builder waitForNoInitializingShards(@Nullable Boolean value) {
            this.waitForNoInitializingShards = value;
            return this;
        }

        @Nonnull
        public final Builder waitForNoRelocatingShards(@Nullable Boolean value) {
            this.waitForNoRelocatingShards = value;
            return this;
        }

        @Nonnull
        public final Builder waitForNodes(@Nullable WaitForNodes value) {
            this.waitForNodes = value;
            return this;
        }

        @Nonnull
        public final Builder waitForNodes(Function<WaitForNodes.Builder, ObjectBuilder<WaitForNodes>> fn) {
            return this.waitForNodes(fn.apply(new WaitForNodes.Builder()).build());
        }

        @Nonnull
        public final Builder waitForStatus(@Nullable HealthStatus value) {
            this.waitForStatus = value;
            return this;
        }

        @Override
        @Nonnull
        public HealthRequest build() {
            this._checkSingleUse();
            return new HealthRequest(this);
        }
    }
}

