/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.sparse.codec;

import java.io.IOException;
import org.apache.lucene.codecs.FieldsConsumer;
import org.apache.lucene.codecs.FieldsProducer;
import org.apache.lucene.codecs.PostingsFormat;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentWriteState;
import org.opensearch.neuralsearch.sparse.codec.CodecUtilWrapper;
import org.opensearch.neuralsearch.sparse.codec.MergeHelper;
import org.opensearch.neuralsearch.sparse.codec.SparsePostingsConsumer;
import org.opensearch.neuralsearch.sparse.codec.SparsePostingsProducer;
import org.opensearch.neuralsearch.sparse.codec.SparseTermsLuceneReader;

public class SparsePostingsFormat
extends PostingsFormat {
    private final PostingsFormat delegate;

    public SparsePostingsFormat(PostingsFormat delegate) {
        super(delegate.getName());
        this.delegate = delegate;
    }

    public FieldsConsumer fieldsConsumer(SegmentWriteState state) throws IOException {
        return new SparsePostingsConsumer(this.delegate.fieldsConsumer(state), state, new MergeHelper());
    }

    public FieldsProducer fieldsProducer(SegmentReadState state) throws IOException {
        return new SparsePostingsProducer(this.delegate.fieldsProducer(state), state, () -> new SparseTermsLuceneReader(state, new CodecUtilWrapper()));
    }
}

