/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.state.store;

import com.amazon.randomcutforest.CommonUtils;
import com.amazon.randomcutforest.config.Precision;
import com.amazon.randomcutforest.state.IStateMapper;
import com.amazon.randomcutforest.state.store.PointStoreState;
import com.amazon.randomcutforest.store.PointStore;
import com.amazon.randomcutforest.store.PointStoreLarge;
import com.amazon.randomcutforest.util.ArrayPacking;
import java.util.Arrays;
import lombok.Generated;

public class PointStoreMapper
implements IStateMapper<PointStore, PointStoreState> {
    private boolean compressionEnabled = true;
    private int numberOfTrees = 255;

    @Override
    public PointStore toModel(PointStoreState state, long seed) {
        CommonUtils.checkNotNull(state.getRefCount(), "refCount must not be null");
        CommonUtils.checkNotNull(state.getPointData(), "pointData must not be null");
        CommonUtils.checkArgument(Precision.valueOf(state.getPrecision()) == Precision.FLOAT_32, "precision must be " + (Object)((Object)Precision.FLOAT_32));
        int indexCapacity = state.getIndexCapacity();
        int dimensions = state.getDimensions();
        float[] store = ArrayPacking.unpackFloats(state.getPointData(), state.getCurrentStoreCapacity() * dimensions);
        int startOfFreeSegment = state.getStartOfFreeSegment();
        int[] refCount = ArrayPacking.unpackInts(state.getRefCount(), indexCapacity, state.isCompressed());
        int[] locationList = new int[indexCapacity];
        Arrays.fill(locationList, PointStore.INFEASIBLE_LOCN);
        int[] tempList = ArrayPacking.unpackInts(state.getLocationList(), state.isCompressed());
        if (!state.getVersion().equals("3.0")) {
            int shingleSize = state.getShingleSize();
            int baseDimension = dimensions / shingleSize;
            for (int i = 0; i < tempList.length; ++i) {
                CommonUtils.checkArgument(tempList[i] % baseDimension == 0, "the location field should be a multiple of dimension/shingle size for versions before 3.0");
                locationList[i] = tempList[i] / baseDimension;
            }
        } else {
            int[] duplicateRefs = null;
            if (state.getDuplicateRefs() != null) {
                duplicateRefs = ArrayPacking.unpackInts(state.getDuplicateRefs(), state.isCompressed());
                CommonUtils.checkArgument(duplicateRefs.length % 2 == 0, " corrupt duplicates");
                for (int i = 0; i < duplicateRefs.length; i += 2) {
                    int n = duplicateRefs[i];
                    refCount[n] = refCount[n] + duplicateRefs[i + 1];
                }
            }
            int nextLocation = 0;
            for (int i = 0; i < indexCapacity; ++i) {
                if (refCount[i] > 0) {
                    locationList[i] = tempList[nextLocation];
                    ++nextLocation;
                    continue;
                }
                locationList[i] = PointStoreLarge.INFEASIBLE_LOCN;
            }
            CommonUtils.checkArgument(nextLocation == tempList.length, "incorrect location encoding");
        }
        return ((PointStore.Builder)((PointStore.Builder)((PointStore.Builder)((PointStore.Builder)((PointStore.Builder)((PointStore.Builder)((PointStore.Builder)((PointStore.Builder)((PointStore.Builder)((PointStore.Builder)((PointStore.Builder)((PointStore.Builder)((PointStore.Builder)((PointStore.Builder)((PointStore.Builder)PointStore.builder().internalRotationEnabled(state.isRotationEnabled())).internalShinglingEnabled(state.isInternalShinglingEnabled())).dynamicResizingEnabled(state.isDynamicResizingEnabled())).directLocationEnabled(state.isDirectLocationMap())).indexCapacity(indexCapacity)).currentStoreCapacity(state.getCurrentStoreCapacity())).capacity(state.getCapacity())).shingleSize(state.getShingleSize())).dimensions(state.getDimensions())).locationList(locationList)).nextTimeStamp(state.getLastTimeStamp())).startOfFreeSegment(startOfFreeSegment)).refCount(refCount)).knownShingle(state.getInternalShingle())).store(store)).build();
    }

    @Override
    public PointStoreState toState(PointStore model) {
        model.compact();
        PointStoreState state = new PointStoreState();
        state.setVersion("3.0");
        state.setCompressed(this.compressionEnabled);
        state.setDimensions(model.getDimensions());
        state.setCapacity(model.getCapacity());
        state.setShingleSize(model.getShingleSize());
        state.setDirectLocationMap(false);
        state.setInternalShinglingEnabled(model.isInternalShinglingEnabled());
        state.setLastTimeStamp(model.getNextSequenceIndex());
        if (model.isInternalShinglingEnabled()) {
            state.setInternalShingle(CommonUtils.toDoubleArray(model.getInternalShingle()));
            state.setRotationEnabled(model.isInternalRotationEnabled());
        }
        state.setDynamicResizingEnabled(true);
        if (state.isDynamicResizingEnabled()) {
            state.setCurrentStoreCapacity(model.getCurrentStoreCapacity());
            state.setIndexCapacity(model.getIndexCapacity());
        }
        state.setStartOfFreeSegment(model.getStartOfFreeSegment());
        state.setPrecision(Precision.FLOAT_32.name());
        int[] refcount = model.getRefCount();
        int[] tempList = model.getLocationList();
        int[] locationList = new int[model.getIndexCapacity()];
        int[] duplicateRefs = new int[2 * model.getIndexCapacity()];
        int size = 0;
        int duplicateSize = 0;
        for (int i = 0; i < refcount.length; ++i) {
            if (refcount[i] <= 0) continue;
            locationList[size] = tempList[i];
            ++size;
            if (refcount[i] <= this.numberOfTrees) continue;
            duplicateRefs[duplicateSize] = i;
            duplicateRefs[duplicateSize + 1] = refcount[i] - this.numberOfTrees;
            refcount[i] = this.numberOfTrees;
            duplicateSize += 2;
        }
        state.setRefCount(ArrayPacking.pack(refcount, refcount.length, state.isCompressed()));
        state.setDuplicateRefs(ArrayPacking.pack(duplicateRefs, duplicateSize, state.isCompressed()));
        state.setLocationList(ArrayPacking.pack(locationList, size, state.isCompressed()));
        state.setPointData(ArrayPacking.pack(model.getStore(), model.getStartOfFreeSegment()));
        return state;
    }

    public PointStore convertFromDouble(PointStoreState state) {
        CommonUtils.checkNotNull(state.getRefCount(), "refCount must not be null");
        CommonUtils.checkNotNull(state.getPointData(), "pointData must not be null");
        CommonUtils.checkArgument(Precision.valueOf(state.getPrecision()) == Precision.FLOAT_64, "precision must be " + (Object)((Object)Precision.FLOAT_64));
        int indexCapacity = state.getIndexCapacity();
        int dimensions = state.getDimensions();
        float[] store = CommonUtils.toFloatArray(ArrayPacking.unpackDoubles(state.getPointData(), state.getCurrentStoreCapacity() * dimensions));
        int startOfFreeSegment = state.getStartOfFreeSegment();
        int[] refCount = ArrayPacking.unpackInts(state.getRefCount(), indexCapacity, state.isCompressed());
        int[] locationList = new int[indexCapacity];
        int[] tempList = ArrayPacking.unpackInts(state.getLocationList(), state.isCompressed());
        System.arraycopy(tempList, 0, locationList, 0, tempList.length);
        if (!state.getVersion().equals("3.0")) {
            this.transformArray(locationList, dimensions / state.getShingleSize());
        }
        return ((PointStore.Builder)((PointStore.Builder)((PointStore.Builder)((PointStore.Builder)((PointStore.Builder)((PointStore.Builder)((PointStore.Builder)((PointStore.Builder)((PointStore.Builder)((PointStore.Builder)((PointStore.Builder)((PointStore.Builder)((PointStore.Builder)((PointStore.Builder)((PointStore.Builder)PointStore.builder().internalRotationEnabled(state.isRotationEnabled())).internalShinglingEnabled(state.isInternalShinglingEnabled())).dynamicResizingEnabled(state.isDynamicResizingEnabled())).directLocationEnabled(state.isDirectLocationMap())).indexCapacity(indexCapacity)).currentStoreCapacity(state.getCurrentStoreCapacity())).capacity(state.getCapacity())).shingleSize(state.getShingleSize())).dimensions(state.getDimensions())).locationList(locationList)).nextTimeStamp(state.getLastTimeStamp())).startOfFreeSegment(startOfFreeSegment)).refCount(refCount)).knownShingle(state.getInternalShingle())).store(store)).build();
    }

    void transformArray(int[] location, int baseDimension) {
        CommonUtils.checkArgument(baseDimension > 0, "incorrect invocation");
        for (int i = 0; i < location.length; ++i) {
            if (location[i] <= 0) continue;
            location[i] = location[i] / baseDimension;
        }
    }

    @Generated
    public boolean isCompressionEnabled() {
        return this.compressionEnabled;
    }

    @Generated
    public int getNumberOfTrees() {
        return this.numberOfTrees;
    }

    @Generated
    public void setCompressionEnabled(boolean compressionEnabled) {
        this.compressionEnabled = compressionEnabled;
    }

    @Generated
    public void setNumberOfTrees(int numberOfTrees) {
        this.numberOfTrees = numberOfTrees;
    }
}

