/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.analysis;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.analysis.TokenFilterDefinition;
import org.opensearch.client.opensearch._types.analysis.TokenFilterDefinitionVariant;
import org.opensearch.client.opensearch._types.analysis.TokenizerBase;
import org.opensearch.client.opensearch._types.analysis.TokenizerDefinition;
import org.opensearch.client.opensearch._types.analysis.TokenizerDefinitionVariant;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class IcuTokenizer
extends TokenizerBase
implements TokenFilterDefinitionVariant,
TokenizerDefinitionVariant,
ToCopyableBuilder<Builder, IcuTokenizer> {
    @Nonnull
    private final String ruleFiles;
    public static final JsonpDeserializer<IcuTokenizer> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, IcuTokenizer::setupIcuTokenizerDeserializer);

    private IcuTokenizer(Builder builder) {
        super(builder);
        this.ruleFiles = ApiTypeHelper.requireNonNull(builder.ruleFiles, this, "ruleFiles");
    }

    public static IcuTokenizer of(Function<Builder, ObjectBuilder<IcuTokenizer>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public TokenFilterDefinition.Kind _tokenFilterDefinitionKind() {
        return TokenFilterDefinition.Kind.IcuTokenizer;
    }

    @Override
    public TokenizerDefinition.Kind _tokenizerDefinitionKind() {
        return TokenizerDefinition.Kind.IcuTokenizer;
    }

    @Nonnull
    public final String ruleFiles() {
        return this.ruleFiles;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "icu_tokenizer");
        super.serializeInternal(generator, mapper);
        generator.writeKey("rule_files");
        generator.write(this.ruleFiles);
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupIcuTokenizerDeserializer(ObjectDeserializer<Builder> op) {
        IcuTokenizer.setupTokenizerBaseDeserializer(op);
        op.add(Builder::ruleFiles, JsonpDeserializer.stringDeserializer(), "rule_files");
        op.ignore("type");
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.ruleFiles.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IcuTokenizer other = (IcuTokenizer)o;
        return this.ruleFiles.equals(other.ruleFiles);
    }

    public static class Builder
    extends TokenizerBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, IcuTokenizer> {
        private String ruleFiles;

        public Builder() {
        }

        private Builder(IcuTokenizer o) {
            super(o);
            this.ruleFiles = o.ruleFiles;
        }

        private Builder(Builder o) {
            super(o);
            this.ruleFiles = o.ruleFiles;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder ruleFiles(String value) {
            this.ruleFiles = value;
            return this;
        }

        @Override
        @Nonnull
        public IcuTokenizer build() {
            this._checkSingleUse();
            return new IcuTokenizer(this);
        }
    }
}

