/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.painless.ir;

import org.opensearch.painless.ClassWriter;
import org.opensearch.painless.Location;
import org.opensearch.painless.MethodWriter;
import org.opensearch.painless.ir.ArgumentsNode;
import org.opensearch.painless.ir.ExpressionNode;
import org.opensearch.painless.lookup.PainlessMethod;
import org.opensearch.painless.phase.IRTreeVisitor;
import org.opensearch.painless.symbol.WriteScope;

public class InvokeCallNode
extends ArgumentsNode {
    private PainlessMethod method;
    private Class<?> box;

    public void setMethod(PainlessMethod method) {
        this.method = method;
    }

    public PainlessMethod getMethod() {
        return this.method;
    }

    public void setBox(Class<?> box) {
        this.box = box;
    }

    public Class<?> getBox() {
        return this.box;
    }

    @Override
    public <Scope> void visit(IRTreeVisitor<Scope> irTreeVisitor, Scope scope) {
        irTreeVisitor.visitInvokeCall(this, scope);
    }

    @Override
    public <Scope> void visitChildren(IRTreeVisitor<Scope> irTreeVisitor, Scope scope) {
        for (ExpressionNode argumentNode : this.getArgumentNodes()) {
            argumentNode.visit(irTreeVisitor, scope);
        }
    }

    public InvokeCallNode(Location location) {
        super(location);
    }

    @Override
    protected void write(ClassWriter classWriter, MethodWriter methodWriter, WriteScope writeScope) {
        methodWriter.writeDebugInfo(this.getLocation());
        if (this.box.isPrimitive()) {
            methodWriter.box(MethodWriter.getType(this.box));
        }
        for (ExpressionNode argumentNode : this.getArgumentNodes()) {
            argumentNode.write(classWriter, methodWriter, writeScope);
        }
        methodWriter.invokeMethodCall(this.method);
    }
}

