/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.ProviderException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.MGF1ParameterSpec;
import java.security.spec.PSSParameterSpec;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.X509ObjectIdentifiers;
import org.bouncycastle.crypto.Algorithm;
import org.bouncycastle.crypto.AsymmetricKey;
import org.bouncycastle.crypto.AsymmetricPrivateKey;
import org.bouncycastle.crypto.AsymmetricPublicKey;
import org.bouncycastle.crypto.DigestAlgorithm;
import org.bouncycastle.crypto.OutputSigner;
import org.bouncycastle.crypto.OutputVerifier;
import org.bouncycastle.crypto.Parameters;
import org.bouncycastle.crypto.SignatureOperatorFactory;
import org.bouncycastle.crypto.UpdateOutputStream;
import org.bouncycastle.crypto.fips.FipsAlgorithm;
import org.bouncycastle.crypto.fips.FipsDigestAlgorithm;
import org.bouncycastle.crypto.fips.FipsEdEC;
import org.bouncycastle.crypto.fips.FipsRSA;
import org.bouncycastle.crypto.general.RSA;
import org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider;
import org.bouncycastle.jcajce.provider.DigestUtil;
import org.bouncycastle.jcajce.provider.PrivateKeyConverter;
import org.bouncycastle.jcajce.provider.PublicKeyConverter;
import org.bouncycastle.jcajce.provider.Utils;
import org.bouncycastle.jcajce.spec.EdDSASigParameterSpec;

class BaseSignature
extends SignatureSpi
implements PKCSObjectIdentifiers,
X509ObjectIdentifiers {
    private static final byte TRAILER_IMPLICIT = -68;
    private final SignatureOperatorFactory operatorFactory;
    private final PublicKeyConverter publicKeyConverter;
    private final PrivateKeyConverter privateKeyConverter;
    private final BouncyCastleFipsProvider fipsProvider;
    private final AlgorithmParameterSpec originalSpec;
    protected Parameters parameters;
    protected OutputVerifier verifier;
    protected OutputSigner signer;
    protected UpdateOutputStream dataStream;
    protected AlgorithmParameters engineParams;
    protected AlgorithmParameterSpec paramSpec;
    protected AsymmetricKey key;
    protected boolean isInitState = true;

    protected BaseSignature(BouncyCastleFipsProvider bouncyCastleFipsProvider, SignatureOperatorFactory signatureOperatorFactory, PublicKeyConverter publicKeyConverter, PrivateKeyConverter privateKeyConverter, Parameters parameters) {
        this.fipsProvider = bouncyCastleFipsProvider;
        this.operatorFactory = signatureOperatorFactory;
        this.publicKeyConverter = publicKeyConverter;
        this.privateKeyConverter = privateKeyConverter;
        this.parameters = parameters;
        this.originalSpec = null;
    }

    protected BaseSignature(BouncyCastleFipsProvider bouncyCastleFipsProvider, SignatureOperatorFactory signatureOperatorFactory, PublicKeyConverter publicKeyConverter, PrivateKeyConverter privateKeyConverter, Parameters parameters, AlgorithmParameterSpec algorithmParameterSpec) {
        this.fipsProvider = bouncyCastleFipsProvider;
        this.operatorFactory = signatureOperatorFactory;
        this.publicKeyConverter = publicKeyConverter;
        this.privateKeyConverter = privateKeyConverter;
        this.parameters = parameters;
        this.paramSpec = algorithmParameterSpec;
        this.originalSpec = algorithmParameterSpec;
    }

    @Override
    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        this.key = this.publicKeyConverter.convertKey(this.parameters.getAlgorithm(), publicKey);
        this.initVerify();
        this.isInitState = true;
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        this.key = this.privateKeyConverter.convertKey(this.parameters.getAlgorithm(), privateKey);
        this.initSign(this.fipsProvider.getDefaultSecureRandom());
        this.isInitState = true;
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey, SecureRandom secureRandom) throws InvalidKeyException {
        this.key = this.privateKeyConverter.convertKey(this.parameters.getAlgorithm(), privateKey);
        this.initSign(secureRandom != null ? secureRandom : this.fipsProvider.getDefaultSecureRandom());
        this.isInitState = true;
    }

    @Override
    protected void engineUpdate(byte by) throws SignatureException {
        this.isInitState = false;
        this.dataStream.update(by);
    }

    @Override
    protected void engineUpdate(byte[] byArray, int n, int n2) throws SignatureException {
        this.isInitState = false;
        this.dataStream.update(byArray, n, n2);
    }

    @Override
    protected byte[] engineSign() throws SignatureException {
        try {
            this.isInitState = true;
            return this.signer.getSignature();
        }
        catch (Exception exception) {
            throw new SignatureException(exception.toString(), exception);
        }
    }

    @Override
    protected boolean engineVerify(byte[] byArray) throws SignatureException {
        try {
            this.isInitState = true;
            return this.verifier.isVerified(byArray);
        }
        catch (Exception exception) {
            throw new SignatureException(exception.toString(), exception);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void engineSetParameter(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        if (algorithmParameterSpec == null) {
            if (this.originalSpec == null) return;
            algorithmParameterSpec = this.originalSpec;
        }
        if (!this.isInitState) {
            throw new ProviderException("cannot call setParameter in the middle of update");
        }
        if (algorithmParameterSpec instanceof PSSParameterSpec) {
            DigestAlgorithm digestAlgorithm;
            Object object;
            PSSParameterSpec pSSParameterSpec = (PSSParameterSpec)algorithmParameterSpec;
            if (this.originalSpec instanceof PSSParameterSpec) {
                object = (PSSParameterSpec)this.originalSpec;
                if (this.originalSpec != PSSParameterSpec.DEFAULT && !DigestUtil.isSameDigest(((PSSParameterSpec)object).getDigestAlgorithm(), pSSParameterSpec.getDigestAlgorithm())) {
                    throw new InvalidAlgorithmParameterException("Parameter must be using " + ((PSSParameterSpec)object).getDigestAlgorithm());
                }
            }
            object = DigestUtil.getDigestID(pSSParameterSpec.getDigestAlgorithm());
            String string = pSSParameterSpec.getMGFAlgorithm();
            if (!(string.equalsIgnoreCase("MGF1") || string.equals(PKCSObjectIdentifiers.id_mgf1.getId()) || string.equalsIgnoreCase("SHAKE128") || string.equals(NISTObjectIdentifiers.id_shake128.getId()) || string.equalsIgnoreCase("SHAKE256") || string.equals(NISTObjectIdentifiers.id_shake256.getId()))) {
                throw new InvalidAlgorithmParameterException("Unknown mask generation function specified");
            }
            if (pSSParameterSpec.getMGFParameters() != null && !(pSSParameterSpec.getMGFParameters() instanceof MGF1ParameterSpec)) {
                throw new InvalidAlgorithmParameterException("Unknown MGF parameters");
            }
            MGF1ParameterSpec mGF1ParameterSpec = (MGF1ParameterSpec)pSSParameterSpec.getMGFParameters();
            if (mGF1ParameterSpec != null) {
                if (!DigestUtil.isSameDigest(mGF1ParameterSpec.getDigestAlgorithm(), pSSParameterSpec.getDigestAlgorithm())) {
                    throw new InvalidAlgorithmParameterException("Digest algorithm for MGF should be the same as for PSS parameters.");
                }
                digestAlgorithm = DigestUtil.getDigestID(mGF1ParameterSpec.getDigestAlgorithm());
            } else {
                digestAlgorithm = DigestUtil.getDigestID(string);
            }
            if (digestAlgorithm == null) {
                throw new InvalidAlgorithmParameterException("No match on MGF digest algorithm: " + mGF1ParameterSpec.getDigestAlgorithm());
            }
            if (!(digestAlgorithm instanceof FipsAlgorithm)) {
                throw new InvalidAlgorithmParameterException("Digest algorithm not supported: " + mGF1ParameterSpec.getDigestAlgorithm());
            }
            this.parameters = FipsRSA.PSS.withDigestAlgorithm((FipsDigestAlgorithm)object).withMGFDigest((FipsDigestAlgorithm)digestAlgorithm).withSaltLength(pSSParameterSpec.getSaltLength()).withTrailer(this.getPssTrailer(pSSParameterSpec.getTrailerField()));
            this.paramSpec = pSSParameterSpec;
            this.reInit();
            return;
        } else if (algorithmParameterSpec instanceof EdDSASigParameterSpec) {
            Algorithm algorithm = this.parameters.getAlgorithm();
            if (algorithm == null && this.key != null) {
                algorithm = this.key.getAlgorithm();
            }
            if (algorithm == null) throw new InvalidAlgorithmParameterException("cannot identify algorithm, call initSign/initVerify first");
            if (((EdDSASigParameterSpec)algorithmParameterSpec).getContext() == null) return;
            this.paramSpec = algorithmParameterSpec;
            this.parameters = new FipsEdEC.ParametersWithContext((FipsAlgorithm)algorithm, ((EdDSASigParameterSpec)algorithmParameterSpec).getContext());
            this.reInit();
            return;
        } else {
            if (!(this.parameters instanceof RSA.PSSSignatureParameters) && !(this.parameters instanceof FipsRSA.PSSSignatureParameters)) throw new InvalidAlgorithmParameterException("unknown AlgorithmParameterSpec in signature");
            throw new InvalidAlgorithmParameterException("only PSSParameterSpec supported");
        }
    }

    private void reInit() throws InvalidAlgorithmParameterException {
        if (this.key instanceof AsymmetricPublicKey) {
            this.initVerify();
        } else if (this.key instanceof AsymmetricPrivateKey) {
            try {
                this.initSign(this.appRandom);
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new InvalidAlgorithmParameterException("parameter inappropriate for key:" + invalidKeyException.getMessage());
            }
        }
    }

    private void initVerify() {
        this.verifier = this.operatorFactory.createVerifier((AsymmetricPublicKey)this.key, this.parameters);
        this.dataStream = this.verifier.getVerifyingStream();
    }

    private void initSign(SecureRandom secureRandom) throws InvalidKeyException {
        this.appRandom = secureRandom;
        try {
            this.signer = Utils.addRandomIfNeeded(this.operatorFactory.createSigner((AsymmetricPrivateKey)this.key, this.parameters), secureRandom);
            this.dataStream = this.signer.getSigningStream();
        }
        catch (Exception exception) {
            throw new InvalidKeyException("cannot initialize for signing: " + exception.getMessage(), exception);
        }
    }

    private byte getPssTrailer(int n) {
        if (n == 1) {
            return -68;
        }
        throw new IllegalArgumentException("unknown trailer field");
    }

    @Override
    protected AlgorithmParameters engineGetParameters() {
        if (this.engineParams == null && this.paramSpec != null) {
            try {
                this.engineParams = AlgorithmParameters.getInstance("PSS", this.fipsProvider);
                this.engineParams.init(this.paramSpec);
            }
            catch (Exception exception) {
                throw new IllegalStateException(exception.toString(), exception);
            }
        }
        return this.engineParams;
    }

    @Override
    protected void engineSetParameter(String string, Object object) {
        throw new UnsupportedOperationException("SetParameter unsupported");
    }

    @Override
    protected Object engineGetParameter(String string) {
        throw new UnsupportedOperationException("GetParameter unsupported");
    }
}

