/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.tabs.tab_film.filter;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.FilterList;
import ca.odell.glazedlists.swing.DefaultEventComboBoxModel;
import ca.odell.glazedlists.swing.GlazedListsSwing;
import com.jidesoft.swing.CheckBoxList;
import com.jidesoft.swing.CheckBoxListSelectionModel;
import com.jidesoft.swing.JideSplitButton;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import mediathek.config.Daten;
import mediathek.controller.SenderFilmlistLoadApprover;
import mediathek.daten.ListeFilme;
import mediathek.filmeSuchen.ListenerFilmeLaden;
import mediathek.filmeSuchen.ListenerFilmeLadenEvent;
import mediathek.gui.messages.ReloadTableDataEvent;
import mediathek.gui.messages.TableModelChangeEvent;
import mediathek.gui.tabs.tab_film.filter.FilmLengthSlider;
import mediathek.gui.tabs.tab_film.filter.zeitraum.ZeitraumSpinner;
import mediathek.gui.tabs.tab_film.filter_selection.FilterSelectionComboBox;
import mediathek.gui.tabs.tab_film.filter_selection.FilterSelectionComboBoxModel;
import mediathek.mainwindow.MediathekGui;
import mediathek.swing.AutoCompletionComboBox2;
import mediathek.swing.IconUtils;
import mediathek.tool.ApplicationConfiguration;
import mediathek.tool.EventListWithEmptyFirstEntry;
import mediathek.tool.FilterConfiguration;
import mediathek.tool.FilterDTO;
import mediathek.tool.GermanStringSorter;
import mediathek.tool.MessageBus;
import mediathek.tool.SVGIconUtilities;
import net.engio.mbassy.listener.Handler;
import net.miginfocom.layout.AC;
import net.miginfocom.layout.CC;
import net.miginfocom.layout.LC;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.sync.LockMode;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jdesktop.swingx.VerticalLayout;
import org.jetbrains.annotations.NotNull;
import org.kordamp.ikonli.Ikon;
import org.kordamp.ikonli.fontawesome6.FontAwesomeSolid;

public class SwingFilterDialog
extends JDialog {
    private static final Logger logger = LogManager.getLogger();
    private final FilterSelectionComboBoxModel filterSelectionComboBoxModel;
    private final Configuration config = ApplicationConfiguration.getConfiguration();
    private final JToggleButton filterToggleButton;
    private final FilterConfiguration filterConfig;
    private final EventList<String> sourceThemaList = new BasicEventList();
    private final RenameFilterAction renameFilterAction = new RenameFilterAction();
    private final DeleteCurrentFilterAction deleteCurrentFilterAction = new DeleteCurrentFilterAction();
    private final AddNewFilterAction addNewFilterAction = new AddNewFilterAction();
    private final ResetCurrentFilterAction resetCurrentFilterAction = new ResetCurrentFilterAction();
    private FilterSelectionComboBox cboxFilterSelection;
    private JideSplitButton btnSplit;
    private JCheckBox cbShowNewOnly;
    private JCheckBox cbShowBookMarkedOnly;
    private JCheckBox cbShowOnlyHq;
    private JCheckBox cbShowSubtitlesOnly;
    private JCheckBox cbShowOnlyLivestreams;
    private JCheckBox cbShowUnseenOnly;
    private JCheckBox cbDontShowAbos;
    private JCheckBox cbDontShowSignLanguage;
    private JCheckBox cbDontShowTrailers;
    private JCheckBox cbDontShowAudioVersions;
    private JCheckBox cbDontShowDuplicates;
    private JLabel label3;
    public CheckBoxList senderList;
    private JLabel label4;
    private AutoCompletionComboBox2 jcbThema;
    private JButton btnResetThema;
    private JLabel label5;
    private JLabel lblMinFilmLengthValue;
    private JLabel label7;
    private JLabel lblMaxFilmLengthValue;
    private JSlider filmLengthSlider;
    private JLabel label1;
    public ZeitraumSpinner spZeitraum;
    private JLabel label2;

    public SwingFilterDialog(@NotNull Window owner, @NotNull FilterSelectionComboBoxModel model, @NotNull JToggleButton filterToggleButton, @NotNull FilterConfiguration filterConfig) {
        super(owner);
        this.filterSelectionComboBoxModel = model;
        this.filterToggleButton = filterToggleButton;
        this.filterConfig = filterConfig;
        this.initComponents();
        this.setupRoundControls();
        this.btnSplit.setIcon((Icon)SVGIconUtilities.createSVGIcon("icons/fontawesome/ellipsis-vertical.svg"));
        this.populateSplitButton();
        ToggleVisibilityKeyHandler handler = new ToggleVisibilityKeyHandler(this);
        handler.installHandler(filterToggleButton.getAction());
        this.setupButtons();
        this.setupCheckBoxes();
        this.setupThemaComboBox();
        this.setupFilmLengthSlider();
        this.setupZeitraumSpinner();
        this.restoreConfigSettings();
        this.filterSelectionComboBoxModel.addListDataListener(new FilterSelectionDataListener());
        this.restoreWindowSizeFromConfig();
        this.restoreDialogVisibility();
        this.addComponentListener(new FilterDialogComponentListener());
        MessageBus.getMessageBus().subscribe((Object)this);
        Daten.getInstance().getFilmeLaden().addAdListener(new FilmeLadenListener());
    }

    private void setupRoundControls() {
        this.cboxFilterSelection.putClientProperty("JComponent.roundRect", true);
        this.jcbThema.putClientProperty("JComponent.roundRect", true);
        this.spZeitraum.putClientProperty("JComponent.roundRect", true);
    }

    private void populateSplitButton() {
        this.btnSplit.add((Action)this.renameFilterAction);
        this.btnSplit.add((Action)this.addNewFilterAction);
        this.btnSplit.add((Action)this.deleteCurrentFilterAction);
        this.btnSplit.addSeparator();
        this.btnSplit.add((Action)this.resetCurrentFilterAction);
    }

    private void setupButtons() {
        this.checkDeleteCurrentFilterButtonState();
        this.btnResetThema.setAction(new ResetThemaAction());
    }

    private void setupCheckBoxes() {
        this.cbShowNewOnly.addActionListener(actionEvent -> {
            this.filterConfig.setShowNewOnly(this.cbShowNewOnly.isSelected());
            MessageBus.getMessageBus().publish((Object)new ReloadTableDataEvent());
        });
        this.cbShowBookMarkedOnly.addActionListener(actionEvent -> {
            this.filterConfig.setShowBookMarkedOnly(this.cbShowBookMarkedOnly.isSelected());
            MessageBus.getMessageBus().publish((Object)new ReloadTableDataEvent());
        });
        this.cbShowOnlyHq.addActionListener(actionEvent -> {
            this.filterConfig.setShowHighQualityOnly(this.cbShowOnlyHq.isSelected());
            MessageBus.getMessageBus().publish((Object)new ReloadTableDataEvent());
        });
        this.cbShowSubtitlesOnly.addActionListener(actionEvent -> {
            this.filterConfig.setShowSubtitlesOnly(this.cbShowSubtitlesOnly.isSelected());
            MessageBus.getMessageBus().publish((Object)new ReloadTableDataEvent());
        });
        this.cbShowOnlyLivestreams.addActionListener(actionEvent -> {
            this.filterConfig.setShowLivestreamsOnly(this.cbShowOnlyLivestreams.isSelected());
            MessageBus.getMessageBus().publish((Object)new ReloadTableDataEvent());
        });
        this.cbShowUnseenOnly.addActionListener(actionEvent -> {
            this.filterConfig.setShowUnseenOnly(this.cbShowUnseenOnly.isSelected());
            MessageBus.getMessageBus().publish((Object)new ReloadTableDataEvent());
        });
        this.cbDontShowAbos.addActionListener(actionEvent -> {
            this.filterConfig.setDontShowAbos(this.cbDontShowAbos.isSelected());
            MessageBus.getMessageBus().publish((Object)new ReloadTableDataEvent());
        });
        this.cbDontShowSignLanguage.addActionListener(actionEvent -> {
            this.filterConfig.setDontShowSignLanguage(this.cbDontShowSignLanguage.isSelected());
            MessageBus.getMessageBus().publish((Object)new ReloadTableDataEvent());
        });
        this.cbDontShowTrailers.addActionListener(actionEvent -> {
            this.filterConfig.setDontShowTrailers(this.cbDontShowTrailers.isSelected());
            MessageBus.getMessageBus().publish((Object)new ReloadTableDataEvent());
        });
        this.cbDontShowAudioVersions.addActionListener(actionEvent -> {
            this.filterConfig.setDontShowAudioVersions(this.cbDontShowAudioVersions.isSelected());
            MessageBus.getMessageBus().publish((Object)new ReloadTableDataEvent());
        });
        this.cbDontShowDuplicates.addActionListener(actionEvent -> {
            this.filterConfig.setDontShowDuplicates(this.cbDontShowDuplicates.isSelected());
            MessageBus.getMessageBus().publish((Object)new ReloadTableDataEvent());
        });
        this.cboxFilterSelection.setMaximumSize(new Dimension(500, 100));
    }

    private void setupFilmLengthSlider() {
        FilmLengthSlider slider = (FilmLengthSlider)((Object)this.filmLengthSlider);
        this.lblMinFilmLengthValue.setText(String.valueOf(slider.getLowValue()));
        this.lblMaxFilmLengthValue.setText(slider.getHighValueText());
        slider.addChangeListener(changeEvent -> {
            this.lblMinFilmLengthValue.setText(String.valueOf(slider.getLowValue()));
            this.lblMaxFilmLengthValue.setText(slider.getHighValueText());
            if (!slider.getValueIsAdjusting()) {
                this.filterConfig.setFilmLengthMin(slider.getLowValue());
                this.filterConfig.setFilmLengthMax(slider.getHighValue());
                MessageBus.getMessageBus().publish((Object)new ReloadTableDataEvent());
            }
        });
    }

    private List<String> getThemaList(@NotNull List<String> selectedSenders) {
        ArrayList<String> finalList = new ArrayList<String>();
        ListeFilme blackList = Daten.getInstance().getListeFilmeNachBlackList();
        if (selectedSenders.isEmpty()) {
            finalList.addAll(blackList.getThemenUnprocessed(""));
        } else {
            for (String sender : selectedSenders) {
                finalList.addAll(blackList.getThemenUnprocessed(sender));
            }
        }
        return finalList.parallelStream().distinct().sorted(GermanStringSorter.getInstance()).toList();
    }

    private void updateThemaComboBox() {
        String aktuellesThema = (String)this.jcbThema.getSelectedItem();
        List<String> selectedSenders = this.filterConfig.getCheckedChannels().stream().toList();
        List<String> tempThemaList = this.getThemaList(selectedSenders);
        this.sourceThemaList.getReadWriteLock().writeLock().lock();
        this.sourceThemaList.clear();
        this.sourceThemaList.addAll(tempThemaList);
        this.sourceThemaList.getReadWriteLock().writeLock().unlock();
        if (!this.sourceThemaList.contains((Object)aktuellesThema) && aktuellesThema != null && !aktuellesThema.isEmpty()) {
            this.sourceThemaList.add((Object)aktuellesThema);
        }
        this.jcbThema.setSelectedItem(aktuellesThema);
    }

    private JPopupMenu createPopupMenu() {
        JPopupMenu popupMenu = new JPopupMenu();
        popupMenu.add(new ResetThemaButtonAction());
        return popupMenu;
    }

    private void setupThemaComboBox() {
        this.jcbThema.setComponentPopupMenu(this.createPopupMenu());
        DefaultEventComboBoxModel model = GlazedListsSwing.eventComboBoxModel((EventList)new EventListWithEmptyFirstEntry(this.sourceThemaList));
        this.jcbThema.setModel(model);
        String thema = this.filterConfig.getThema();
        if (!this.sourceThemaList.contains((Object)thema)) {
            this.sourceThemaList.add((Object)thema);
        }
        this.jcbThema.setSelectedItem(thema);
        this.jcbThema.addActionListener(actionEvent -> {
            String sel = (String)this.jcbThema.getSelectedItem();
            if (sel != null) {
                this.filterConfig.setThema(sel);
            }
            MessageBus.getMessageBus().publish((Object)new ReloadTableDataEvent());
        });
    }

    private void setupZeitraumSpinner() {
        try {
            this.spZeitraum.restoreFilterConfig(this.filterConfig);
            this.spZeitraum.installFilterConfigurationChangeListener(this.filterConfig);
        }
        catch (Exception e) {
            logger.error("Failed to setup zeitraum spinner", (Throwable)e);
        }
    }

    private void checkDeleteCurrentFilterButtonState() {
        this.deleteCurrentFilterAction.setEnabled(this.filterConfig.getAvailableFilterCount() > 1);
    }

    private void restoreConfigSettings() {
        this.cbShowNewOnly.setSelected(this.filterConfig.isShowNewOnly());
        this.cbShowBookMarkedOnly.setSelected(this.filterConfig.isShowBookMarkedOnly());
        this.cbShowOnlyHq.setSelected(this.filterConfig.isShowHighQualityOnly());
        this.cbShowSubtitlesOnly.setSelected(this.filterConfig.isShowSubtitlesOnly());
        this.cbShowOnlyLivestreams.setSelected(this.filterConfig.isShowLivestreamsOnly());
        this.cbShowUnseenOnly.setSelected(this.filterConfig.isShowUnseenOnly());
        this.cbDontShowAbos.setSelected(this.filterConfig.isDontShowAbos());
        this.cbDontShowSignLanguage.setSelected(this.filterConfig.isDontShowSignLanguage());
        this.cbDontShowTrailers.setSelected(this.filterConfig.isDontShowTrailers());
        this.cbDontShowAudioVersions.setSelected(this.filterConfig.isDontShowAudioVersions());
        this.cbDontShowDuplicates.setSelected(this.filterConfig.isDontShowDuplicates());
        this.jcbThema.setSelectedItem(this.filterConfig.getThema());
        ((SenderCheckBoxList)this.senderList).restoreFilterConfig();
        ((FilmLengthSlider)((Object)this.filmLengthSlider)).restoreFilterConfig(this.filterConfig);
        this.spZeitraum.restoreFilterConfig(this.filterConfig);
    }

    private void enableControls(boolean enable) {
        this.cboxFilterSelection.setEnabled(enable);
        this.btnSplit.setEnabled(enable);
        this.renameFilterAction.setEnabled(enable);
        this.addNewFilterAction.setEnabled(enable);
        this.resetCurrentFilterAction.setEnabled(enable);
        this.btnResetThema.setEnabled(enable);
        this.cbShowNewOnly.setEnabled(enable);
        this.cbShowBookMarkedOnly.setEnabled(enable);
        this.cbShowOnlyHq.setEnabled(enable);
        this.cbShowSubtitlesOnly.setEnabled(enable);
        this.cbShowOnlyLivestreams.setEnabled(enable);
        this.cbShowUnseenOnly.setEnabled(enable);
        this.cbDontShowAbos.setEnabled(enable);
        this.cbDontShowSignLanguage.setEnabled(enable);
        this.cbDontShowTrailers.setEnabled(enable);
        this.cbDontShowAudioVersions.setEnabled(enable);
        this.cbDontShowDuplicates.setEnabled(enable);
        this.label3.setEnabled(enable);
        this.senderList.setEnabled(enable);
        this.label4.setEnabled(enable);
        this.jcbThema.setEnabled(enable);
        this.label5.setEnabled(enable);
        this.label7.setEnabled(enable);
        this.lblMinFilmLengthValue.setEnabled(enable);
        this.lblMaxFilmLengthValue.setEnabled(enable);
        this.filmLengthSlider.setEnabled(enable);
        this.spZeitraum.setEnabled(enable);
        this.label1.setEnabled(enable);
        this.label2.setEnabled(enable);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.enableControls(enabled);
    }

    @Handler
    private void handleTableModelChangeEvent(TableModelChangeEvent e) {
        SwingUtilities.invokeLater(() -> {
            boolean enable = !e.active;
            this.setEnabled(enable);
            this.enableControls(enable);
            if (e.active) {
                this.deleteCurrentFilterAction.setEnabled(false);
            } else {
                this.checkDeleteCurrentFilterButtonState();
            }
        });
    }

    private void restoreDialogVisibility() {
        boolean visible = this.config.getBoolean("application.ui.filter_dialog.visible", false);
        this.setVisible(visible);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreWindowSizeFromConfig() {
        try {
            this.config.lock(LockMode.READ);
            int width = this.config.getInt("application.ui.filter_dialog.width");
            int height = this.config.getInt("application.ui.filter_dialog.height");
            int x = this.config.getInt("application.ui.filter_dialog.location.x");
            int y = this.config.getInt("application.ui.filter_dialog.location.y");
            this.setBounds(x, y, width, height);
        }
        catch (NoSuchElementException noSuchElementException) {
        }
        finally {
            this.config.unlock(LockMode.READ);
        }
    }

    private void createUIComponents() {
        this.cboxFilterSelection = new FilterSelectionComboBox(this.filterSelectionComboBoxModel);
    }

    private void initComponents() {
        this.createUIComponents();
        JPanel pnlFilterCommon = new JPanel();
        this.btnSplit = new JideSplitButton();
        JSeparator separator2 = new JSeparator();
        JPanel pnlShowOnly = new JPanel();
        this.cbShowNewOnly = new JCheckBox();
        this.cbShowBookMarkedOnly = new JCheckBox();
        this.cbShowOnlyHq = new JCheckBox();
        this.cbShowSubtitlesOnly = new JCheckBox();
        this.cbShowOnlyLivestreams = new JCheckBox();
        JSeparator separator3 = new JSeparator();
        JPanel pnlDontShow = new JPanel();
        this.cbShowUnseenOnly = new JCheckBox();
        this.cbDontShowAbos = new JCheckBox();
        this.cbDontShowSignLanguage = new JCheckBox();
        this.cbDontShowTrailers = new JCheckBox();
        this.cbDontShowAudioVersions = new JCheckBox();
        this.cbDontShowDuplicates = new JCheckBox();
        JSeparator separator4 = new JSeparator();
        JPanel pnlSenderlist = new JPanel();
        this.label3 = new JLabel();
        JScrollPane scpSenderList = new JScrollPane();
        this.senderList = new SenderCheckBoxList();
        JSeparator separator5 = new JSeparator();
        JPanel pnlThema = new JPanel();
        this.label4 = new JLabel();
        this.jcbThema = new AutoCompletionComboBox2();
        this.btnResetThema = new JButton();
        JSeparator separator6 = new JSeparator();
        JPanel pnlFlimlength = new JPanel();
        this.label5 = new JLabel();
        this.lblMinFilmLengthValue = new JLabel();
        JPanel hSpacer1 = new JPanel(null);
        this.label7 = new JLabel();
        this.lblMaxFilmLengthValue = new JLabel();
        this.filmLengthSlider = new FilmLengthSlider();
        JSeparator separator7 = new JSeparator();
        JPanel pnlZeitraum = new JPanel();
        this.label1 = new JLabel();
        this.spZeitraum = new ZeitraumSpinner();
        this.label2 = new JLabel();
        this.setType(Window.Type.UTILITY);
        this.setTitle("Filter");
        Container contentPane = this.getContentPane();
        contentPane.setLayout((LayoutManager)new MigLayout(new LC().fillX().insets("5").hideMode(3), new AC().align("left"), new AC().gap().shrink(0.0f).align("top").gap("0").gap("0").shrink(0.0f).gap("0").gap("0").shrink(0.0f).gap().grow().fill().gap().shrink(0.0f).gap().gap().shrink(0.0f).gap().gap().shrink(0.0f).gap()));
        pnlFilterCommon.setLayout((LayoutManager)new MigLayout(new LC().fillX().insets("0").hideMode(3), new AC().grow().fill().gap().fill(), new AC().fill()));
        this.cboxFilterSelection.setMaximumSize(null);
        this.cboxFilterSelection.setPreferredSize(null);
        this.cboxFilterSelection.setMinimumSize(new Dimension(50, 10));
        pnlFilterCommon.add((Component)this.cboxFilterSelection, new CC().cell(new int[]{0, 0}));
        this.btnSplit.setAlwaysDropdown(true);
        pnlFilterCommon.add((Component)this.btnSplit, new CC().cell(new int[]{1, 0}));
        contentPane.add((Component)pnlFilterCommon, new CC().cell(new int[]{0, 0}).growX());
        contentPane.add((Component)separator2, new CC().cell(new int[]{0, 1}).growX());
        pnlShowOnly.setLayout((LayoutManager)new VerticalLayout());
        this.cbShowNewOnly.setText("Nur neue Filme anzeigen");
        pnlShowOnly.add(this.cbShowNewOnly);
        this.cbShowBookMarkedOnly.setText("Nur gemerkte Filme anzeigen");
        pnlShowOnly.add(this.cbShowBookMarkedOnly);
        this.cbShowOnlyHq.setText("Nur High Quality(HQ) Filme anzeigen");
        pnlShowOnly.add(this.cbShowOnlyHq);
        this.cbShowSubtitlesOnly.setText("Nur Filme mit Untertitel anzeigen");
        pnlShowOnly.add(this.cbShowSubtitlesOnly);
        this.cbShowOnlyLivestreams.setText("Nur Livestreams anzeigen");
        pnlShowOnly.add(this.cbShowOnlyLivestreams);
        contentPane.add((Component)pnlShowOnly, new CC().cell(new int[]{0, 2}).growX());
        contentPane.add((Component)separator3, new CC().cell(new int[]{0, 3}).growX());
        pnlDontShow.setLayout((LayoutManager)new VerticalLayout());
        this.cbShowUnseenOnly.setText("Gesehene Filme nicht anzeigen");
        pnlDontShow.add(this.cbShowUnseenOnly);
        this.cbDontShowAbos.setText("Abos nicht anzeigen");
        pnlDontShow.add(this.cbDontShowAbos);
        this.cbDontShowSignLanguage.setText("Geb\u00e4rdensprache nicht anzeigen");
        pnlDontShow.add(this.cbDontShowSignLanguage);
        this.cbDontShowTrailers.setText("Trailer/Teaser/Vorschau nicht anzeigen");
        pnlDontShow.add(this.cbDontShowTrailers);
        this.cbDontShowAudioVersions.setText("H\u00f6rfassungen ausblenden");
        pnlDontShow.add(this.cbDontShowAudioVersions);
        this.cbDontShowDuplicates.setText("Duplikate nicht anzeigen");
        pnlDontShow.add(this.cbDontShowDuplicates);
        contentPane.add((Component)pnlDontShow, new CC().cell(new int[]{0, 4}).growX());
        contentPane.add((Component)separator4, new CC().cell(new int[]{0, 5}).growX());
        pnlSenderlist.setPreferredSize(new Dimension(258, 220));
        pnlSenderlist.setLayout((LayoutManager)new MigLayout(new LC().fill().insets("0").hideMode(3), new AC().align("left"), new AC().gap().grow()));
        this.label3.setText("Sender:");
        pnlSenderlist.add((Component)this.label3, new CC().cell(new int[]{0, 0}));
        scpSenderList.setPreferredSize(null);
        scpSenderList.setMaximumSize(null);
        this.senderList.setSelectionMode(0);
        this.senderList.setMaximumSize(null);
        this.senderList.setMinimumSize(null);
        this.senderList.setPreferredSize(null);
        scpSenderList.setViewportView((Component)this.senderList);
        pnlSenderlist.add((Component)scpSenderList, new CC().cell(new int[]{0, 1}).grow().minHeight("50"));
        contentPane.add((Component)pnlSenderlist, new CC().cell(new int[]{0, 6}).growX());
        contentPane.add((Component)separator5, new CC().cell(new int[]{0, 7}).growX());
        pnlThema.setLayout((LayoutManager)new MigLayout(new LC().fillX().insets("0").hideMode(3), new AC().align("left").gap().grow().fill().gap().fill(), new AC()));
        this.label4.setText("Thema:");
        pnlThema.add((Component)this.label4, new CC().cell(new int[]{0, 0}));
        this.jcbThema.setMinimumSize(new Dimension(50, 10));
        this.jcbThema.setPreferredSize(null);
        this.jcbThema.setMaximumSize(null);
        pnlThema.add((Component)this.jcbThema, new CC().cell(new int[]{1, 0}).growX());
        pnlThema.add((Component)this.btnResetThema, new CC().cell(new int[]{2, 0}));
        contentPane.add((Component)pnlThema, new CC().cell(new int[]{0, 8}).growX());
        contentPane.add((Component)separator6, new CC().cell(new int[]{0, 9}).growX());
        pnlFlimlength.setLayout((LayoutManager)new MigLayout(new LC().fill().insets("0").hideMode(3), new AC().fill().gap().fill().gap().grow().fill().gap().fill().gap().fill(), new AC().gap("0")));
        this.label5.setText("Mindestl\u00e4nge:");
        pnlFlimlength.add((Component)this.label5, new CC().cell(new int[]{0, 0}));
        this.lblMinFilmLengthValue.setText("0");
        pnlFlimlength.add((Component)this.lblMinFilmLengthValue, new CC().cell(new int[]{1, 0}));
        pnlFlimlength.add((Component)hSpacer1, new CC().cell(new int[]{2, 0}).growX());
        this.label7.setText("Maximall\u00e4nge:");
        pnlFlimlength.add((Component)this.label7, new CC().cell(new int[]{3, 0}));
        this.lblMaxFilmLengthValue.setText("100");
        pnlFlimlength.add((Component)this.lblMaxFilmLengthValue, new CC().cell(new int[]{4, 0}));
        pnlFlimlength.add((Component)this.filmLengthSlider, new CC().cell(new int[]{0, 1, 5, 1}).growX());
        contentPane.add((Component)pnlFlimlength, new CC().cell(new int[]{0, 10}).growX());
        contentPane.add((Component)separator7, new CC().cell(new int[]{0, 11}).growX());
        pnlZeitraum.setLayout((LayoutManager)new MigLayout(new LC().fillX().insets("0").hideMode(3), new AC().align("left").gap().grow().fill().gap().fill(), new AC()));
        this.label1.setText("Zeitraum:");
        pnlZeitraum.add((Component)this.label1, new CC().cell(new int[]{0, 0}));
        pnlZeitraum.add((Component)this.spZeitraum, new CC().cell(new int[]{1, 0}));
        this.label2.setText("Tage");
        pnlZeitraum.add((Component)this.label2, new CC().cell(new int[]{2, 0}));
        contentPane.add((Component)pnlZeitraum, new CC().cell(new int[]{0, 12}).growX());
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }

    private class RenameFilterAction
    extends AbstractAction {
        private static final String STR_RENAME_FILTER = "Filter umbenennen";

        public RenameFilterAction() {
            this.putValue("SmallIcon", SVGIconUtilities.createSVGIcon("icons/fontawesome/pen-to-square.svg"));
            this.putValue("ShortDescription", STR_RENAME_FILTER);
            this.putValue("Name", "Filter umbenennen...");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String fltName = SwingFilterDialog.this.filterConfig.getCurrentFilter().name();
            String s = (String)JOptionPane.showInputDialog(MediathekGui.ui(), "Neuer Name des Filters:", STR_RENAME_FILTER, -1, null, null, fltName);
            if (s != null) {
                if (!s.isEmpty()) {
                    String fName = s.trim();
                    if (!fName.equals(fltName)) {
                        Optional<FilterDTO> existingFilter = SwingFilterDialog.this.filterConfig.findFilterForName(fName);
                        existingFilter.ifPresentOrElse(filterDTO -> JOptionPane.showMessageDialog(MediathekGui.ui(), String.format("Filter %s existiert bereits.\nAktion wird abgebrochen", fName), "MediathekView", 0), () -> {
                            Configuration config = ApplicationConfiguration.getConfiguration();
                            config.lock(LockMode.WRITE);
                            String thema = SwingFilterDialog.this.filterConfig.getThema();
                            SwingFilterDialog.this.filterConfig.setThema("");
                            SwingFilterDialog.this.filterConfig.renameCurrentFilter(fName);
                            SwingFilterDialog.this.filterConfig.setThema(thema);
                            config.unlock(LockMode.WRITE);
                            logger.trace("Renamed filter \"{}\" to \"{}\"", (Object)fltName, (Object)fName);
                        });
                    } else {
                        logger.warn("New and old filter name are identical...doing nothing");
                    }
                } else {
                    JOptionPane.showMessageDialog(MediathekGui.ui(), "Filtername darf nicht leer sein!", "MediathekView", 0);
                    logger.warn("Rename filter text was empty...doing nothing");
                }
            }
        }
    }

    private class DeleteCurrentFilterAction
    extends AbstractAction {
        private static final String STR_DELETE_CURRENT_FILTER = "Aktuellen Filter l\u00f6schen";

        public DeleteCurrentFilterAction() {
            this.putValue("SmallIcon", SVGIconUtilities.createSVGIcon("icons/fontawesome/trash-can.svg"));
            this.putValue("ShortDescription", STR_DELETE_CURRENT_FILTER);
            this.putValue("Name", "Aktuellen Filter l\u00f6schen...");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int res = JOptionPane.showConfirmDialog(MediathekGui.ui(), "M\u00f6chten Sie wirklich den aktuellen Filter l\u00f6schen?", "MediathekView", 0);
            if (res == 0) {
                FilterDTO filterToDelete = SwingFilterDialog.this.filterConfig.getCurrentFilter();
                SwingFilterDialog.this.filterConfig.deleteFilter(filterToDelete);
                SwingFilterDialog.this.checkDeleteCurrentFilterButtonState();
            }
        }
    }

    private class AddNewFilterAction
    extends AbstractAction {
        private static final String STR_ACTION_NAME = "Neuen Filter anlegen";

        public AddNewFilterAction() {
            this.putValue("SmallIcon", SVGIconUtilities.createSVGIcon("icons/fontawesome/plus.svg"));
            this.putValue("ShortDescription", STR_ACTION_NAME);
            this.putValue("Name", "Neuen Filter anlegen...");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String newFilterName = (String)JOptionPane.showInputDialog(MediathekGui.ui(), "Filtername:", STR_ACTION_NAME, -1, null, null, String.format("Filter %d", SwingFilterDialog.this.filterConfig.getAvailableFilters().size() + 1));
            if (newFilterName != null) {
                SwingFilterDialog.this.filterConfig.findFilterForName(newFilterName).ifPresentOrElse(filterDTO -> JOptionPane.showMessageDialog(MediathekGui.ui(), "Ein Filter mit dem gew\u00e4hlten Namen existiert bereits!", STR_ACTION_NAME, 0), () -> {
                    FilterDTO newFilter = new FilterDTO(UUID.randomUUID(), newFilterName);
                    SwingFilterDialog.this.filterConfig.addNewFilter(newFilter);
                    SwingFilterDialog.this.checkDeleteCurrentFilterButtonState();
                    SwingFilterDialog.this.filterSelectionComboBoxModel.setSelectedItem(newFilter);
                });
            }
        }
    }

    private class ResetCurrentFilterAction
    extends AbstractAction {
        public ResetCurrentFilterAction() {
            this.putValue("SmallIcon", IconUtils.of((Ikon)FontAwesomeSolid.RECYCLE));
            this.putValue("ShortDescription", "Aktuellen Filter zur\u00fccksetzen");
            this.putValue("Name", "Aktuellen Filter zur\u00fccksetzen...");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int result2 = JOptionPane.showConfirmDialog(MediathekGui.ui(), "Sind Sie sicher dass Sie den Filter zur\u00fccksetzen m\u00f6chten?", "Filter zur\u00fccksetzen", 0);
            if (result2 == 0) {
                SwingFilterDialog.this.filterConfig.clearCurrentFilter();
                SwingFilterDialog.this.restoreConfigSettings();
            }
        }
    }

    public static class ToggleVisibilityKeyHandler {
        private static final String TOGGLE_FILTER_VISIBILITY = "toggle_dialog_visibility";
        private final JRootPane rootPane;

        public ToggleVisibilityKeyHandler(JDialog dlg) {
            this.rootPane = dlg.getRootPane();
        }

        public void installHandler(Action action) {
            InputMap inputMap = this.rootPane.getInputMap(2);
            inputMap.put(KeyStroke.getKeyStroke(123, 0), TOGGLE_FILTER_VISIBILITY);
            this.rootPane.getActionMap().put(TOGGLE_FILTER_VISIBILITY, action);
        }
    }

    private class FilterSelectionDataListener
    implements ListDataListener {
        private FilterSelectionDataListener() {
        }

        @Override
        public void intervalAdded(ListDataEvent e) {
            SwingFilterDialog.this.restoreConfigSettings();
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
            SwingFilterDialog.this.restoreConfigSettings();
        }

        @Override
        public void contentsChanged(ListDataEvent e) {
            SwingFilterDialog.this.restoreConfigSettings();
        }
    }

    public class FilterDialogComponentListener
    extends ComponentAdapter {
        @Override
        public void componentResized(ComponentEvent e) {
            this.storeWindowPosition(e);
        }

        @Override
        public void componentMoved(ComponentEvent e) {
            this.storeWindowPosition(e);
        }

        @Override
        public void componentShown(ComponentEvent e) {
            this.storeDialogVisibility();
            SwingFilterDialog.this.filterToggleButton.setSelected(true);
        }

        @Override
        public void componentHidden(ComponentEvent e) {
            this.storeWindowPosition(e);
            this.storeDialogVisibility();
            SwingFilterDialog.this.filterToggleButton.setSelected(false);
        }

        private void storeDialogVisibility() {
            SwingFilterDialog.this.config.setProperty("application.ui.filter_dialog.visible", (Object)SwingFilterDialog.this.isVisible());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void storeWindowPosition(ComponentEvent e) {
            Component component = e.getComponent();
            Dimension dims = component.getSize();
            Point loc = component.getLocation();
            try {
                SwingFilterDialog.this.config.lock(LockMode.WRITE);
                SwingFilterDialog.this.config.setProperty("application.ui.filter_dialog.width", (Object)dims.width);
                SwingFilterDialog.this.config.setProperty("application.ui.filter_dialog.height", (Object)dims.height);
                SwingFilterDialog.this.config.setProperty("application.ui.filter_dialog.location.x", (Object)loc.x);
                SwingFilterDialog.this.config.setProperty("application.ui.filter_dialog.location.y", (Object)loc.y);
            }
            finally {
                SwingFilterDialog.this.config.unlock(LockMode.WRITE);
            }
        }
    }

    private class FilmeLadenListener
    extends ListenerFilmeLaden {
        private FilmeLadenListener() {
        }

        @Override
        public void start(ListenerFilmeLadenEvent event) {
            SwingFilterDialog.this.setEnabled(false);
        }

        @Override
        public void fertig(ListenerFilmeLadenEvent event) {
            SwingFilterDialog.this.updateThemaComboBox();
            SwingFilterDialog.this.setEnabled(true);
        }
    }

    private class ResetThemaAction
    extends AbstractAction {
        protected static final String STR_RESET_THEMA = "Thema zur\u00fccksetzen";

        public ResetThemaAction() {
            this.putValue("SmallIcon", SVGIconUtilities.createSVGIcon("icons/fontawesome/trash-can.svg"));
            this.putValue("ShortDescription", STR_RESET_THEMA);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SwingFilterDialog.this.filterConfig.setThema("");
            SwingFilterDialog.this.jcbThema.setSelectedIndex(0);
        }
    }

    private class ResetThemaButtonAction
    extends ResetThemaAction {
        public ResetThemaButtonAction() {
            this.putValue("Name", "Thema zur\u00fccksetzen");
        }
    }

    private class SenderCheckBoxList
    extends CheckBoxList {
        private static final String CONFIG_SENDERLIST_VERTICAL_WRAP = "senderlist.vertical_wrap";
        private final JCheckBoxMenuItem miVerticalWrap = new JCheckBoxMenuItem("Senderliste vertikal umbrechen", false);

        public SenderCheckBoxList() {
            this.setVisibleRowCount(-1);
            this.setupSenderList();
            this.restoreVerticalWrapState();
        }

        private void restoreVerticalWrapState() {
            if (ApplicationConfiguration.getConfiguration().getBoolean(CONFIG_SENDERLIST_VERTICAL_WRAP, true)) {
                this.miVerticalWrap.doClick();
            }
        }

        protected void setupSenderList() {
            EventList<String> allSenders = Daten.getInstance().getAllSendersList();
            FilterList filteredList = new FilterList(allSenders, SenderFilmlistLoadApprover::isApproved);
            this.setModel((ListModel)GlazedListsSwing.eventListModel((EventList)filteredList));
            this.getCheckBoxListSelectionModel().addListSelectionListener(e -> {
                if (!e.getValueIsAdjusting()) {
                    List<String> newSelectedSenderList = this.getSelectedSenders();
                    SwingFilterDialog.this.filterConfig.setCheckedChannels(newSelectedSenderList);
                    SwingFilterDialog.this.updateThemaComboBox();
                    MessageBus.getMessageBus().publish((Object)new ReloadTableDataEvent());
                }
            });
            this.setupContextMenu();
        }

        protected void setupContextMenu() {
            JPopupMenu contextMenu = new JPopupMenu();
            JMenuItem menuItem = new JMenuItem("Alle Senderfilter zur\u00fccksetzen");
            menuItem.addActionListener(actionEvent -> this.selectNone());
            contextMenu.add(menuItem);
            contextMenu.addSeparator();
            this.miVerticalWrap.addActionListener(actionEvent -> {
                boolean selected = this.miVerticalWrap.isSelected();
                ApplicationConfiguration.getConfiguration().setProperty(CONFIG_SENDERLIST_VERTICAL_WRAP, (Object)selected);
                if (selected) {
                    this.setLayoutOrientation(1);
                } else {
                    this.setLayoutOrientation(0);
                }
                this.repaint();
            });
            contextMenu.add(this.miVerticalWrap);
            this.setComponentPopupMenu(contextMenu);
        }

        protected List<String> getSelectedSenders() {
            ArrayList<String> newSelectedSenderList = new ArrayList<String>();
            ListModel senderListModel = this.getModel();
            CheckBoxListSelectionModel cblsm = this.getCheckBoxListSelectionModel();
            for (int i = 0; i < senderListModel.getSize(); ++i) {
                if (!cblsm.isSelectedIndex(i)) continue;
                Object item = senderListModel.getElementAt(i);
                newSelectedSenderList.add(item.toString());
            }
            return newSelectedSenderList;
        }

        public void restoreFilterConfig() {
            Set<String> checkedSenders = SwingFilterDialog.this.filterConfig.getCheckedChannels();
            CheckBoxListSelectionModel cblsm = this.getCheckBoxListSelectionModel();
            ListModel senderListModel = this.getModel();
            this.selectNone();
            cblsm.setValueIsAdjusting(true);
            for (int i = 0; i < senderListModel.getSize(); ++i) {
                String item = (String)senderListModel.getElementAt(i);
                if (!checkedSenders.contains(item)) continue;
                this.getCheckBoxListSelectionModel().addSelectionInterval(i, i);
            }
            cblsm.setValueIsAdjusting(false);
        }
    }
}

