/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.dependency.perceptron.transition.parser;

import com.hankcs.hanlp.dependency.perceptron.learning.AveragedPerceptron;
import com.hankcs.hanlp.dependency.perceptron.transition.configuration.BeamElement;
import com.hankcs.hanlp.dependency.perceptron.transition.configuration.Configuration;
import com.hankcs.hanlp.dependency.perceptron.transition.configuration.Instance;
import com.hankcs.hanlp.dependency.perceptron.transition.configuration.State;
import com.hankcs.hanlp.dependency.perceptron.transition.features.FeatureExtractor;
import com.hankcs.hanlp.dependency.perceptron.transition.parser.Action;
import com.hankcs.hanlp.dependency.perceptron.transition.parser.ArcEager;
import java.util.ArrayList;
import java.util.concurrent.Callable;

public class PartialTreeBeamScorerThread
implements Callable<ArrayList<BeamElement>> {
    boolean isDecode;
    AveragedPerceptron classifier;
    Configuration configuration;
    Instance instance;
    ArrayList<Integer> dependencyRelations;
    int featureLength;
    int b;

    public PartialTreeBeamScorerThread(boolean isDecode, AveragedPerceptron classifier, Instance instance, Configuration configuration, ArrayList<Integer> dependencyRelations, int featureLength, int b) {
        this.isDecode = isDecode;
        this.classifier = classifier;
        this.configuration = configuration;
        this.instance = instance;
        this.dependencyRelations = dependencyRelations;
        this.featureLength = featureLength;
        this.b = b;
    }

    @Override
    public ArrayList<BeamElement> call() throws Exception {
        float addedScore;
        float score;
        float addedScore2;
        float score2;
        ArrayList<BeamElement> elements = new ArrayList<BeamElement>(this.dependencyRelations.size() * 2 + 3);
        boolean isNonProjective = false;
        if (this.instance.isNonprojective()) {
            isNonProjective = true;
        }
        State currentState = this.configuration.state;
        float prevScore = this.configuration.score;
        boolean canShift = ArcEager.canDo(Action.Shift, currentState);
        boolean canReduce = ArcEager.canDo(Action.Reduce, currentState);
        boolean canRightArc = ArcEager.canDo(Action.RightArc, currentState);
        boolean canLeftArc = ArcEager.canDo(Action.LeftArc, currentState);
        Object[] features = FeatureExtractor.extractAllParseFeatures(this.configuration, this.featureLength);
        if (canShift && (isNonProjective || this.instance.actionCost(Action.Shift, -1, currentState) == 0)) {
            score2 = this.classifier.shiftScore(features, this.isDecode);
            addedScore2 = score2 + prevScore;
            elements.add(new BeamElement(addedScore2, this.b, 0, -1));
        }
        if (canReduce && (isNonProjective || this.instance.actionCost(Action.Reduce, -1, currentState) == 0)) {
            score2 = this.classifier.reduceScore(features, this.isDecode);
            addedScore2 = score2 + prevScore;
            elements.add(new BeamElement(addedScore2, this.b, 1, -1));
        }
        if (canRightArc) {
            float[] rightArcScores = this.classifier.rightArcScores(features, this.isDecode);
            for (int dependency : this.dependencyRelations) {
                if (!isNonProjective && this.instance.actionCost(Action.RightArc, dependency, currentState) != 0) continue;
                score = rightArcScores[dependency];
                addedScore = score + prevScore;
                elements.add(new BeamElement(addedScore, this.b, 2, dependency));
            }
        }
        if (canLeftArc) {
            float[] leftArcScores = this.classifier.leftArcScores(features, this.isDecode);
            for (int dependency : this.dependencyRelations) {
                if (!isNonProjective && this.instance.actionCost(Action.LeftArc, dependency, currentState) != 0) continue;
                score = leftArcScores[dependency];
                addedScore = score + prevScore;
                elements.add(new BeamElement(addedScore, this.b, 3, dependency));
            }
        }
        if (elements.size() == 0) {
            PartialTreeBeamScorerThread.addAvailableBeamElements(elements, prevScore, canShift, canReduce, canRightArc, canLeftArc, features, this.classifier, this.isDecode, this.b, this.dependencyRelations);
        }
        return elements;
    }

    public static void addAvailableBeamElements(ArrayList<BeamElement> elements, float prevScore, boolean canShift, boolean canReduce, boolean canRightArc, boolean canLeftArc, Object[] features, AveragedPerceptron classifier, boolean isDecode, int b, ArrayList<Integer> dependencyRelations) {
        float addedScore;
        float score;
        float addedScore2;
        float score2;
        if (canShift) {
            score2 = classifier.shiftScore(features, isDecode);
            addedScore2 = score2 + prevScore;
            elements.add(new BeamElement(addedScore2, b, 0, -1));
        }
        if (canReduce) {
            score2 = classifier.reduceScore(features, isDecode);
            addedScore2 = score2 + prevScore;
            elements.add(new BeamElement(addedScore2, b, 1, -1));
        }
        if (canRightArc) {
            float[] rightArcScores = classifier.rightArcScores(features, isDecode);
            for (int dependency : dependencyRelations) {
                score = rightArcScores[dependency];
                addedScore = score + prevScore;
                elements.add(new BeamElement(addedScore, b, 2, dependency));
            }
        }
        if (canLeftArc) {
            float[] leftArcScores = classifier.leftArcScores(features, isDecode);
            for (int dependency : dependencyRelations) {
                score = leftArcScores[dependency];
                addedScore = score + prevScore;
                elements.add(new BeamElement(addedScore, b, 3, dependency));
            }
        }
    }
}

