/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Locale;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.AbstractClassJavaType;
import org.hibernate.type.descriptor.java.CoercionException;
import org.hibernate.type.descriptor.java.CoercionHelper;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.VersionJavaType;
import org.hibernate.type.descriptor.java.spi.PrimitiveJavaType;
import org.hibernate.type.descriptor.jdbc.JdbcType;

public class ByteJavaType
extends AbstractClassJavaType<Byte>
implements PrimitiveJavaType<Byte>,
VersionJavaType<Byte> {
    private static final Byte ZERO = 0;
    public static final ByteJavaType INSTANCE = new ByteJavaType();

    public ByteJavaType() {
        super(Byte.class);
    }

    @Override
    public boolean useObjectEqualsHashCode() {
        return true;
    }

    @Override
    public String toString(Byte value) {
        return value == null ? null : value.toString();
    }

    @Override
    public Byte fromString(CharSequence string) {
        return Byte.valueOf(string.toString());
    }

    @Override
    public boolean isInstance(Object value) {
        return value instanceof Byte;
    }

    @Override
    public <X> X unwrap(Byte value, Class<X> type, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        if (Byte.class.isAssignableFrom(type) || type == Object.class) {
            return (X)value;
        }
        if (Short.class.isAssignableFrom(type)) {
            return (X)Short.valueOf(value.shortValue());
        }
        if (Integer.class.isAssignableFrom(type)) {
            return (X)Integer.valueOf(value.intValue());
        }
        if (Long.class.isAssignableFrom(type)) {
            return (X)Long.valueOf(value.longValue());
        }
        if (Double.class.isAssignableFrom(type)) {
            return (X)Double.valueOf(value.doubleValue());
        }
        if (Float.class.isAssignableFrom(type)) {
            return (X)Float.valueOf(value.floatValue());
        }
        if (String.class.isAssignableFrom(type)) {
            return (X)value.toString();
        }
        throw this.unknownUnwrap(type);
    }

    @Override
    public <X> Byte wrap(X value, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        if (value instanceof Byte) {
            Byte byteValue = (Byte)value;
            return byteValue;
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            return number.byteValue();
        }
        if (value instanceof String) {
            String string = (String)value;
            return Byte.valueOf(string);
        }
        throw this.unknownWrap(value.getClass());
    }

    @Override
    public Class<Byte> getPrimitiveClass() {
        return Byte.TYPE;
    }

    @Override
    public Class<Byte[]> getArrayClass() {
        return Byte[].class;
    }

    @Override
    public Class<?> getPrimitiveArrayClass() {
        return byte[].class;
    }

    @Override
    public Byte getDefaultValue() {
        return (byte)0;
    }

    @Override
    public long getDefaultSqlLength(Dialect dialect, JdbcType jdbcType) {
        return 1L;
    }

    @Override
    public int getDefaultSqlPrecision(Dialect dialect, JdbcType jdbcType) {
        return 3;
    }

    @Override
    public int getDefaultSqlScale(Dialect dialect, JdbcType jdbcType) {
        return 0;
    }

    @Override
    public <X> Byte coerce(X value, JavaType.CoercionContext coercionContext) {
        if (value == null) {
            return null;
        }
        if (value instanceof Byte) {
            Byte byteValue = (Byte)value;
            return byteValue;
        }
        if (value instanceof Short) {
            Short shotValue = (Short)value;
            return CoercionHelper.toByte(shotValue);
        }
        if (value instanceof Integer) {
            Integer integerValue = (Integer)value;
            return CoercionHelper.toByte(integerValue);
        }
        if (value instanceof Long) {
            Long longValue = (Long)value;
            return CoercionHelper.toByte(longValue);
        }
        if (value instanceof Double) {
            Double doubleValue = (Double)value;
            return CoercionHelper.toByte(doubleValue);
        }
        if (value instanceof Float) {
            Float floatValue = (Float)value;
            return CoercionHelper.toByte(floatValue);
        }
        if (value instanceof BigInteger) {
            BigInteger bigInteger = (BigInteger)value;
            return CoercionHelper.toByte(bigInteger);
        }
        if (value instanceof BigDecimal) {
            BigDecimal bigDecimal = (BigDecimal)value;
            return CoercionHelper.toByte(bigDecimal);
        }
        if (value instanceof String) {
            String string = (String)value;
            return CoercionHelper.coerceWrappingError(() -> Byte.parseByte(string));
        }
        throw new CoercionException(String.format(Locale.ROOT, "Cannot coerce value '%s' [%s] to Byte", value, value.getClass().getName()));
    }

    @Override
    public Byte next(Byte current, Long length, Integer precision, Integer scale, SharedSessionContractImplementor session) {
        return (byte)(current + 1);
    }

    @Override
    public Byte seed(Long length, Integer precision, Integer scale, SharedSessionContractImplementor session) {
        return ZERO;
    }
}

