/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.model.ast;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.SelectableMapping;
import org.hibernate.metamodel.mapping.SqlTypedMapping;
import org.hibernate.sql.ast.SqlAstWalker;
import org.hibernate.sql.ast.tree.expression.SqlTypedExpression;
import org.hibernate.sql.model.ast.ColumnValueParameter;

public class ColumnWriteFragment
implements SqlTypedExpression {
    private final String fragment;
    private final List<ColumnValueParameter> parameters;
    private final SelectableMapping selectableMapping;

    public ColumnWriteFragment(String fragment, SelectableMapping selectableMapping) {
        this(fragment, Collections.emptyList(), selectableMapping);
    }

    public ColumnWriteFragment(String fragment, ColumnValueParameter parameter, SelectableMapping selectableMapping) {
        this(fragment, Collections.singletonList(parameter), selectableMapping);
        assert (!fragment.contains("?") || parameter != null);
    }

    public ColumnWriteFragment(String fragment, List<ColumnValueParameter> parameters, SelectableMapping selectableMapping) {
        this.fragment = fragment;
        this.parameters = parameters;
        this.selectableMapping = selectableMapping;
    }

    public String getFragment() {
        return this.fragment;
    }

    public Collection<ColumnValueParameter> getParameters() {
        return this.parameters;
    }

    @Override
    public SqlTypedMapping getSqlTypedMapping() {
        return this.selectableMapping;
    }

    @Override
    public JdbcMapping getExpressionType() {
        return this.selectableMapping.getJdbcMapping();
    }

    @Override
    public void accept(SqlAstWalker sqlTreeWalker) {
        sqlTreeWalker.visitColumnWriteFragment(this);
    }

    public String toString() {
        return switch (this.parameters.size()) {
            case 0 -> String.format(Locale.ROOT, "ColumnWriteFragment(%s)@%s", this.fragment, this.hashCode());
            case 1 -> String.format(Locale.ROOT, "ColumnWriteFragment(%s = %s (%s))@%s", new Object[]{this.parameters.get(0).getColumnReference().getColumnExpression(), this.fragment, this.parameters.get(0).getUsage(), this.hashCode()});
            default -> String.format(Locale.ROOT, "ColumnWriteFragment(%s = %s (%s))@%s", new Object[]{this.parameters, this.fragment, this.parameters.get(0).getUsage(), this.hashCode()});
        };
    }
}

