/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler.view.std;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.TableCellRenderer;
import net.sf.juife.InformationDialog;
import net.sf.juife.JuifeUtils;
import net.sf.juife.event.TaskEvent;
import net.sf.juife.event.TaskListener;
import org.jsampler.CC;
import org.jsampler.HF;
import org.jsampler.MidiInstrumentMap;
import org.jsampler.OrchestraInstrument;
import org.jsampler.OrchestraModel;
import org.jsampler.SamplerChannelModel;
import org.jsampler.event.ListEvent;
import org.jsampler.event.ListListener;
import org.jsampler.event.SamplerChannelListEvent;
import org.jsampler.event.SamplerChannelListListener;
import org.jsampler.task.EnhancedTask;
import org.jsampler.task.InstrumentsDb;
import org.jsampler.view.AbstractInstrumentsDbTable;
import org.jsampler.view.DbClipboard;
import org.jsampler.view.DbDirectoryTreeNode;
import org.jsampler.view.InstrumentsDbTableModel;
import org.jsampler.view.std.JSAddDbInstrumentsFromDirDlg;
import org.jsampler.view.std.JSAddDbInstrumentsFromFileDlg;
import org.jsampler.view.std.JSAddMidiInstrumentDlg;
import org.jsampler.view.std.JSDbDescriptionDlg;
import org.jsampler.view.std.JSDbDirectoryPropsPane;
import org.jsampler.view.std.JSDbInstrumentPropsPane;
import org.jsampler.view.std.JSInstrumentsDbTree;
import org.jsampler.view.std.StdA4n;
import org.jsampler.view.std.StdI18n;
import org.linuxsampler.lscp.DbDirectoryInfo;
import org.linuxsampler.lscp.DbInstrumentInfo;
import org.linuxsampler.lscp.Instrument;
import org.linuxsampler.lscp.Parser;

public class JSInstrumentsDbTable
extends AbstractInstrumentsDbTable {
    private JSInstrumentsDbTree instrumentsDbTree;
    private InstrumentsDbCellRenderer cellRenderer = new InstrumentsDbCellRenderer();
    public final Action reloadAction = new ReloadAction();
    public final Action createDirectoryAction = new CreateDirectoryAction();
    public final Action deleteAction = new DeleteAction();
    public final AddInstrumentsFromFileAction addInstrumentsFromFileAction = new AddInstrumentsFromFileAction();
    public final AddInstrumentsFromDirAction addInstrumentsFromDirAction = new AddInstrumentsFromDirAction();
    public final Action propertiesAction = new PropertiesAction();
    public final Action renameAction = new RenameAction();
    public final Action changeDescriptionAction = new ChangeDescriptionAction();
    public final Action cutAction = new CutAction();
    public final Action copyAction = new CopyAction();
    public final Action pasteAction;
    private static final DbClipboard dbClipboard = new DbClipboard();
    private final Vector<JMenu> loadInstrumentMenus = new Vector();
    private final Vector<JMenu> addToMidiMapMenus = new Vector();
    private final Vector<JMenu> addToOrchestraMenus = new Vector();
    private LoadInstrumentActionFactory loadInstrActionFactory = new LoadInstrumentActionFactory();
    private final EventHandler eventHandler = new EventHandler();

    public JSInstrumentsDbTable(JSInstrumentsDbTree jSInstrumentsDbTree) {
        this(jSInstrumentsDbTree, "");
    }

    public JSInstrumentsDbTable(JSInstrumentsDbTree jSInstrumentsDbTree, String string) {
        super(string);
        this.instrumentsDbTree = jSInstrumentsDbTree;
        this.setShowGrid(false);
        this.getColumnModel().setColumnMargin(0);
        this.getTableHeader().setReorderingAllowed(false);
        this.setFillsViewportHeight(true);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() != 1) {
                    return;
                }
                int n = JSInstrumentsDbTable.this.rowAtPoint(mouseEvent.getPoint());
                if (n == -1) {
                    JSInstrumentsDbTable.this.clearSelection();
                    return;
                }
                if (mouseEvent.getClickCount() < 2) {
                    return;
                }
                DbDirectoryTreeNode dbDirectoryTreeNode = JSInstrumentsDbTable.this.getSelectedDirectoryNode();
                if (dbDirectoryTreeNode == null) {
                    return;
                }
                if (!dbDirectoryTreeNode.isDetached()) {
                    JSInstrumentsDbTable.this.instrumentsDbTree.setSelectedDirectoryNode(dbDirectoryTreeNode);
                } else {
                    String string = dbDirectoryTreeNode.getInfo().getDirectoryPath();
                    JSInstrumentsDbTable.this.instrumentsDbTree.setSelectedDirectory(string);
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                int n = JSInstrumentsDbTable.this.rowAtPoint(mouseEvent.getPoint());
                if (mouseEvent.getButton() != 1) {
                    if (mouseEvent.getButton() != 3) {
                        return;
                    }
                }
                if (n == -1) {
                    JSInstrumentsDbTable.this.clearSelection();
                    return;
                }
                if (mouseEvent.getButton() != 3) {
                    return;
                }
                if (JSInstrumentsDbTable.this.getSelectionModel().isSelectedIndex(n)) {
                    JSInstrumentsDbTable.this.getSelectionModel().addSelectionInterval(n, n);
                } else {
                    JSInstrumentsDbTable.this.getSelectionModel().setSelectionInterval(n, n);
                }
            }
        });
        this.getSelectionModel().addListSelectionListener(this.getHandler());
        this.instrumentsDbTree.addTreeSelectionListener(this.getHandler());
        PasteAction pasteAction = new PasteAction();
        this.instrumentsDbTree.addTreeSelectionListener(pasteAction);
        this.pasteAction = pasteAction;
        ContextMenu contextMenu = new ContextMenu();
        this.addMouseListener(contextMenu);
        CC.getOrchestras().addOrchestraListListener(this.getHandler());
        CC.getSamplerModel().addSamplerChannelListListener(this.getHandler());
        CC.getMainFrame().addChannelsPaneSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                JSInstrumentsDbTable.this.updateLoadInstrumentMenus();
            }
        });
        ListListener<MidiInstrumentMap> listListener = new ListListener<MidiInstrumentMap>(){

            @Override
            public void entryAdded(ListEvent<MidiInstrumentMap> listEvent) {
                JSInstrumentsDbTable.this.updateAddToMidiMapMenus();
            }

            @Override
            public void entryRemoved(ListEvent<MidiInstrumentMap> listEvent) {
                JSInstrumentsDbTable.this.updateAddToMidiMapMenus();
            }
        };
        CC.getSamplerModel().addMidiInstrumentMapListListener(listListener);
        this.installKeyboardListeners();
    }

    public static DbClipboard getDbClipboard() {
        return dbClipboard;
    }

    @Override
    public TableCellRenderer getCellRenderer(int n, int n2) {
        return this.cellRenderer;
    }

    private void installKeyboardListeners() {
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
            }
        };
        abstractAction.setEnabled(false);
        this.getActionMap().put("none", abstractAction);
        int n = CC.getViewConfig().getDefaultModKey();
        this.getInputMap(1).put(KeyStroke.getKeyStroke(88, n), "none");
        this.getInputMap(1).put(KeyStroke.getKeyStroke(67, n), "none");
        this.getInputMap(1).put(KeyStroke.getKeyStroke(86, n), "none");
        this.getInputMap(0).put(KeyStroke.getKeyStroke(88, n), "none");
        this.getInputMap(0).put(KeyStroke.getKeyStroke(67, n), "none");
        this.getInputMap(0).put(KeyStroke.getKeyStroke(86, n), "none");
        this.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "OpenDirectory");
        this.getActionMap().put("OpenDirectory", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DbDirectoryTreeNode dbDirectoryTreeNode = JSInstrumentsDbTable.this.getSelectedDirectoryNode();
                if (dbDirectoryTreeNode == null) {
                    return;
                }
                JSInstrumentsDbTable.this.instrumentsDbTree.setSelectedDirectoryNode(dbDirectoryTreeNode);
            }
        });
    }

    public String getUniqueDirectoryName() {
        DbDirectoryTreeNode dbDirectoryTreeNode = this.getParentDirectoryNode();
        if (dbDirectoryTreeNode == null || dbDirectoryTreeNode.isDetached()) {
            return null;
        }
        if (dbDirectoryTreeNode != this.instrumentsDbTree.getSelectedDirectoryNode()) {
            return null;
        }
        boolean bl = false;
        int n = 2;
        String string = "New Folder";
        while (true) {
            for (int i = 0; i < dbDirectoryTreeNode.getChildCount(); ++i) {
                if (!string.equals(dbDirectoryTreeNode.getChildAt(i).getInfo().getName())) continue;
                bl = true;
                break;
            }
            if (!bl) break;
            bl = false;
            string = "New Folder[" + n++ + "]";
        }
        return string;
    }

    public void registerLoadInstrumentMenus(JMenu jMenu) {
        this.loadInstrumentMenus.add(jMenu);
        StdA4n.updateLoadInstrumentMenu(jMenu, this.loadInstrActionFactory);
        this.updateLoadInstrumentMenuState(jMenu);
    }

    public void registerAddToMidiMapMenu(JMenu jMenu) {
        this.addToMidiMapMenus.add(jMenu);
        this.updateAddToMidiMapMenu(jMenu);
    }

    public void registerAddToOrchestraMenu(JMenu jMenu) {
        this.addToOrchestraMenus.add(jMenu);
        this.updateAddToOrchestraMenu(jMenu);
    }

    private void updateLoadInstrumentMenus() {
        for (JMenu jMenu : this.loadInstrumentMenus) {
            StdA4n.updateLoadInstrumentMenu(jMenu, this.loadInstrActionFactory);
            this.updateLoadInstrumentMenuState(jMenu);
        }
    }

    private void updateLoadInstrumentMenuStates() {
        for (JMenu jMenu : this.loadInstrumentMenus) {
            this.updateLoadInstrumentMenuState(jMenu);
        }
    }

    private void updateLoadInstrumentMenuState(JMenu jMenu) {
        Object object = this.getLeadObject();
        boolean bl = object == null || !(object instanceof DbInstrumentInfo);
        bl = bl || CC.getSamplerModel().getChannelCount() == 0;
        jMenu.setEnabled(!bl);
    }

    private void updateAddToMidiMapMenus() {
        for (JMenu jMenu : this.addToMidiMapMenus) {
            this.updateAddToMidiMapMenu(jMenu);
        }
    }

    private void updateAddToMidiMapMenu(JMenu jMenu) {
        jMenu.removeAll();
        for (int i = 0; i < CC.getSamplerModel().getMidiInstrumentMapCount(); ++i) {
            MidiInstrumentMap midiInstrumentMap = CC.getSamplerModel().getMidiInstrumentMap(i);
            jMenu.add(new JMenuItem(new AddToMidiMapAction(midiInstrumentMap)));
        }
        this.updateAddToMidiMapMenuState(jMenu);
    }

    private void updateAddToMidiMapMenuStates() {
        for (JMenu jMenu : this.addToMidiMapMenus) {
            this.updateAddToMidiMapMenuState(jMenu);
        }
    }

    private void updateAddToMidiMapMenuState(JMenu jMenu) {
        Object object = this.getLeadObject();
        boolean bl = object == null || !(object instanceof DbInstrumentInfo);
        bl = bl || CC.getSamplerModel().getMidiInstrumentMapCount() == 0;
        jMenu.setEnabled(!bl);
    }

    private void updateAddToOrchestraMenus() {
        for (JMenu jMenu : this.addToOrchestraMenus) {
            this.updateAddToOrchestraMenu(jMenu);
        }
    }

    private void updateAddToOrchestraMenu(JMenu jMenu) {
        jMenu.removeAll();
        for (int i = 0; i < CC.getOrchestras().getOrchestraCount(); ++i) {
            OrchestraModel orchestraModel = CC.getOrchestras().getOrchestra(i);
            AddToOrchestraAction addToOrchestraAction = new AddToOrchestraAction(orchestraModel);
            jMenu.add(new JMenuItem(addToOrchestraAction));
        }
        this.updateAddToOrchestraMenuState(jMenu);
    }

    private void updateAddToOrchestraMenuStates() {
        for (JMenu jMenu : this.addToOrchestraMenus) {
            this.updateAddToOrchestraMenuState(jMenu);
        }
    }

    private void updateAddToOrchestraMenuState(JMenu jMenu) {
        Object object = this.getLeadObject();
        boolean bl = object == null || !(object instanceof DbInstrumentInfo);
        bl = bl || CC.getOrchestras().getOrchestraCount() == 0;
        jMenu.setEnabled(!bl);
    }

    private boolean showYesNoDialog(String string) {
        Window window = JuifeUtils.getWindow(this);
        if (window instanceof Dialog) {
            return HF.showYesNoDialog((Dialog)window, string);
        }
        if (window instanceof Frame) {
            return HF.showYesNoDialog((Frame)window, string);
        }
        return HF.showYesNoDialog(null, string);
    }

    private EventHandler getHandler() {
        return this.eventHandler;
    }

    class ContextMenu
    extends MouseAdapter {
        private final JPopupMenu instrumentMenu = new JPopupMenu();
        private final JPopupMenu directoryMenu = new JPopupMenu();
        private final JPopupMenu menu = new JPopupMenu();
        private JMenu loadInstrumentMenu;
        private JMenu addToMidiMapMenu;
        private JMenu addToOrchestraMenu;

        ContextMenu() {
            JMenuItem jMenuItem = new JMenuItem(JSInstrumentsDbTable.this.pasteAction);
            jMenuItem.setIcon(null);
            this.menu.add(jMenuItem);
            this.menu.addSeparator();
            jMenuItem = new MenuItem(JSInstrumentsDbTable.this.createDirectoryAction);
            jMenuItem.setIcon(null);
            this.menu.add(jMenuItem);
            String string = StdI18n.i18n.getMenuLabel("instrumentsdb.actions.addInstruments");
            JMenu jMenu = new JMenu(string);
            this.menu.add(jMenu);
            jMenuItem = new JMenuItem(JSInstrumentsDbTable.this.addInstrumentsFromFileAction);
            jMenuItem.setIcon(null);
            jMenu.add(jMenuItem);
            jMenuItem = new JMenuItem(JSInstrumentsDbTable.this.addInstrumentsFromDirAction);
            jMenuItem.setIcon(null);
            jMenu.add(jMenuItem);
            this.menu.addSeparator();
            jMenuItem = new MenuItem(JSInstrumentsDbTable.this.reloadAction);
            jMenuItem.setIcon(null);
            this.menu.add(jMenuItem);
            this.menu.addSeparator();
            jMenuItem = new JMenuItem(JSInstrumentsDbTable.this.propertiesAction);
            jMenuItem.setIcon(null);
            this.menu.add(jMenuItem);
            jMenuItem = new JMenuItem(JSInstrumentsDbTable.this.cutAction);
            jMenuItem.setIcon(null);
            this.instrumentMenu.add(jMenuItem);
            jMenuItem = new JMenuItem(JSInstrumentsDbTable.this.copyAction);
            jMenuItem.setIcon(null);
            this.instrumentMenu.add(jMenuItem);
            this.instrumentMenu.addSeparator();
            jMenuItem = new JMenuItem(JSInstrumentsDbTable.this.deleteAction);
            jMenuItem.setIcon(null);
            this.instrumentMenu.add(jMenuItem);
            jMenuItem = new JMenuItem(JSInstrumentsDbTable.this.renameAction);
            jMenuItem.setIcon(null);
            this.instrumentMenu.add(jMenuItem);
            jMenuItem = new JMenuItem(JSInstrumentsDbTable.this.changeDescriptionAction);
            jMenuItem.setIcon(null);
            this.instrumentMenu.add(jMenuItem);
            this.instrumentMenu.addSeparator();
            string = StdI18n.i18n.getMenuLabel("instrumentsdb.actions.loadInstrument");
            this.loadInstrumentMenu = new JMenu(string);
            this.instrumentMenu.add(this.loadInstrumentMenu);
            JSInstrumentsDbTable.this.registerLoadInstrumentMenus(this.loadInstrumentMenu);
            this.addToMidiMapMenu = new JMenu(StdI18n.i18n.getMenuLabel("instrumentsdb.actions.addToMidiMap"));
            this.instrumentMenu.add(this.addToMidiMapMenu);
            JSInstrumentsDbTable.this.registerAddToMidiMapMenu(this.addToMidiMapMenu);
            string = StdI18n.i18n.getMenuLabel("instrumentsdb.actions.addToOrchestra");
            this.addToOrchestraMenu = new JMenu(string);
            this.instrumentMenu.add(this.addToOrchestraMenu);
            JSInstrumentsDbTable.this.registerAddToOrchestraMenu(this.addToOrchestraMenu);
            this.instrumentMenu.addSeparator();
            jMenuItem = new JMenuItem(JSInstrumentsDbTable.this.propertiesAction);
            jMenuItem.setIcon(null);
            this.instrumentMenu.add(jMenuItem);
            jMenuItem = new JMenuItem(JSInstrumentsDbTable.this.cutAction);
            jMenuItem.setIcon(null);
            this.directoryMenu.add(jMenuItem);
            jMenuItem = new JMenuItem(JSInstrumentsDbTable.this.copyAction);
            jMenuItem.setIcon(null);
            this.directoryMenu.add(jMenuItem);
            this.directoryMenu.addSeparator();
            jMenuItem = new JMenuItem(JSInstrumentsDbTable.this.deleteAction);
            jMenuItem.setIcon(null);
            this.directoryMenu.add(jMenuItem);
            jMenuItem = new JMenuItem(JSInstrumentsDbTable.this.renameAction);
            jMenuItem.setIcon(null);
            this.directoryMenu.add(jMenuItem);
            jMenuItem = new JMenuItem(JSInstrumentsDbTable.this.changeDescriptionAction);
            jMenuItem.setIcon(null);
            this.directoryMenu.add(jMenuItem);
            this.directoryMenu.addSeparator();
            jMenuItem = new JMenuItem(JSInstrumentsDbTable.this.propertiesAction);
            jMenuItem.setIcon(null);
            this.directoryMenu.add(jMenuItem);
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.show(mouseEvent);
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.show(mouseEvent);
            }
        }

        void show(MouseEvent mouseEvent) {
            Object object = JSInstrumentsDbTable.this.getLeadObject();
            if (object == null) {
                this.menu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                return;
            }
            if (object instanceof DbInstrumentInfo) {
                this.instrumentMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                return;
            }
            if (object instanceof DbDirectoryInfo) {
                this.directoryMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                return;
            }
        }

        class MenuItem
        extends JMenuItem {
            MenuItem(Action action) {
                super(action);
            }

            @Override
            public Icon getIcon() {
                return null;
            }
        }
    }

    private class EventHandler
    implements ListSelectionListener,
    TreeSelectionListener,
    SamplerChannelListListener,
    ListListener<OrchestraModel> {
        private EventHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            boolean bl = !JSInstrumentsDbTable.this.getSelectionModel().isSelectionEmpty();
            JSInstrumentsDbTable.this.deleteAction.setEnabled(bl);
            JSInstrumentsDbTable.this.propertiesAction.setEnabled(bl || JSInstrumentsDbTable.this.instrumentsDbTree.getSelectionCount() > 0);
            JSInstrumentsDbTable.this.renameAction.setEnabled(bl);
            JSInstrumentsDbTable.this.changeDescriptionAction.setEnabled(bl);
            JSInstrumentsDbTable.this.cutAction.setEnabled(bl);
            JSInstrumentsDbTable.this.copyAction.setEnabled(bl);
            JSInstrumentsDbTable.this.updateLoadInstrumentMenuStates();
            JSInstrumentsDbTable.this.updateAddToMidiMapMenuStates();
            JSInstrumentsDbTable.this.updateAddToOrchestraMenuStates();
        }

        @Override
        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            DbDirectoryTreeNode dbDirectoryTreeNode = JSInstrumentsDbTable.this.instrumentsDbTree.getSelectedDirectoryNode();
            JSInstrumentsDbTable.this.setParentDirectoryNode(dbDirectoryTreeNode);
            JSInstrumentsDbTable.this.reloadAction.setEnabled(dbDirectoryTreeNode != null);
            JSInstrumentsDbTable.this.createDirectoryAction.setEnabled(dbDirectoryTreeNode != null);
            JSInstrumentsDbTable.this.propertiesAction.setEnabled(dbDirectoryTreeNode != null || JSInstrumentsDbTable.this.getLeadObject() != null);
        }

        @Override
        public void channelAdded(SamplerChannelListEvent samplerChannelListEvent) {
            if (CC.getSamplerModel().getChannelListIsAdjusting()) {
                return;
            }
            JSInstrumentsDbTable.this.updateLoadInstrumentMenus();
        }

        @Override
        public void channelRemoved(SamplerChannelListEvent samplerChannelListEvent) {
            JSInstrumentsDbTable.this.updateLoadInstrumentMenus();
        }

        @Override
        public void entryAdded(ListEvent<OrchestraModel> listEvent) {
            JSInstrumentsDbTable.this.updateAddToOrchestraMenus();
        }

        @Override
        public void entryRemoved(ListEvent<OrchestraModel> listEvent) {
            JSInstrumentsDbTable.this.updateAddToOrchestraMenus();
        }
    }

    class InstrumentsDbCellRenderer
    extends JLabel
    implements TableCellRenderer {
        InstrumentsDbCellRenderer() {
            this.setOpaque(true);
            this.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 3));
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Object object2;
            if (n2 == 0 && object != null) {
                if (object instanceof DbDirectoryInfo) {
                    this.setIcon(JSInstrumentsDbTable.this.getView().getFolderIcon());
                    object2 = ((DbDirectoryInfo)object).getDescription();
                    this.setToolTipText((String)(((String)object2).length() == 0 ? null : object2));
                } else if (object instanceof String) {
                    this.setIcon(JSInstrumentsDbTable.this.getView().getFolderIcon());
                    this.setToolTipText(null);
                } else if (object instanceof DbInstrumentInfo) {
                    DbInstrumentInfo dbInstrumentInfo = (DbInstrumentInfo)object;
                    if ("GIG".equals(dbInstrumentInfo.getFormatFamily())) {
                        this.setIcon(JSInstrumentsDbTable.this.getView().getGigInstrumentIcon());
                    } else {
                        this.setIcon(JSInstrumentsDbTable.this.getView().getInstrumentIcon());
                    }
                    object2 = dbInstrumentInfo.getDescription();
                    this.setToolTipText((String)(((String)object2).length() == 0 ? null : object2));
                } else {
                    this.setIcon(null);
                    this.setToolTipText(null);
                }
            } else {
                this.setIcon(null);
                this.setToolTipText(null);
            }
            if (object != null) {
                this.setText(object.toString());
            } else {
                this.setText("");
            }
            if (bl) {
                this.setBackground(jTable.getSelectionBackground());
                this.setForeground(jTable.getSelectionForeground());
            } else {
                this.setBackground(jTable.getBackground());
                this.setForeground(jTable.getForeground());
            }
            object2 = ((InstrumentsDbTableModel)jTable.getModel()).getColumnType(n2);
            if (object2 == InstrumentsDbTableModel.ColumnType.IS_DRUM || object2 == InstrumentsDbTableModel.ColumnType.FORMAT_FAMILY) {
                this.setHorizontalAlignment(0);
            } else if (object2 == InstrumentsDbTableModel.ColumnType.SIZE || object2 == InstrumentsDbTableModel.ColumnType.INSTRUMENT_NR || object2 == InstrumentsDbTableModel.ColumnType.FORMAT_VERSION) {
                this.setHorizontalAlignment(4);
            } else {
                this.setHorizontalAlignment(2);
            }
            return this;
        }
    }

    class PasteAction
    extends AbstractAction
    implements TreeSelectionListener,
    ChangeListener {
        PasteAction() {
            super(StdI18n.i18n.getMenuLabel("instrumentsdb.edit.paste"));
            String string = StdI18n.i18n.getMenuLabel("instrumentsdb.edit.paste.tt");
            this.putValue("ShortDescription", string);
            this.setEnabled(false);
            JSInstrumentsDbTable.getDbClipboard().addChangeListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            EnhancedTask enhancedTask;
            DbDirectoryInfo[] dbDirectoryInfoArray = JSInstrumentsDbTable.getDbClipboard().getDirectories();
            DbInstrumentInfo[] dbInstrumentInfoArray = JSInstrumentsDbTable.getDbClipboard().getInstruments();
            String string = JSInstrumentsDbTable.this.instrumentsDbTree.getSelectedDirectoryPath();
            if (JSInstrumentsDbTable.getDbClipboard().getOperation() == DbClipboard.Operation.CUT) {
                enhancedTask = new InstrumentsDb.Move(dbDirectoryInfoArray, dbInstrumentInfoArray, string);
                JSInstrumentsDbTable.getDbClipboard().setDirectories(new DbDirectoryInfo[0]);
                JSInstrumentsDbTable.getDbClipboard().setInstruments(new DbInstrumentInfo[0]);
            } else if (JSInstrumentsDbTable.getDbClipboard().getOperation() == DbClipboard.Operation.COPY) {
                enhancedTask = new InstrumentsDb.Copy(dbDirectoryInfoArray, dbInstrumentInfoArray, string);
            } else {
                return;
            }
            CC.getTaskQueue().add(enhancedTask);
        }

        @Override
        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            this.updateState();
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            this.updateState();
        }

        private void updateState() {
            DbDirectoryTreeNode dbDirectoryTreeNode = JSInstrumentsDbTable.this.instrumentsDbTree.getSelectedDirectoryNode();
            if (dbDirectoryTreeNode == null) {
                this.setEnabled(false);
                return;
            }
            int n = JSInstrumentsDbTable.getDbClipboard().getDirectories().length;
            this.setEnabled(n > 0 || JSInstrumentsDbTable.getDbClipboard().getInstruments().length > 0);
        }
    }

    class CopyAction
    extends AbstractAction {
        CopyAction() {
            super(StdI18n.i18n.getMenuLabel("instrumentsdb.edit.copy"));
            String string = StdI18n.i18n.getMenuLabel("instrumentsdb.edit.copy.tt");
            this.putValue("ShortDescription", string);
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JSInstrumentsDbTable.getDbClipboard().setDirectories(JSInstrumentsDbTable.this.getSelectedDirectories());
            JSInstrumentsDbTable.getDbClipboard().setInstruments(JSInstrumentsDbTable.this.getSelectedInstruments());
            JSInstrumentsDbTable.getDbClipboard().setOperation(DbClipboard.Operation.COPY);
        }
    }

    class CutAction
    extends AbstractAction {
        CutAction() {
            super(StdI18n.i18n.getMenuLabel("instrumentsdb.edit.cut"));
            String string = StdI18n.i18n.getMenuLabel("instrumentsdb.edit.cut.tt");
            this.putValue("ShortDescription", string);
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JSInstrumentsDbTable.getDbClipboard().setDirectories(JSInstrumentsDbTable.this.getSelectedDirectories());
            JSInstrumentsDbTable.getDbClipboard().setInstruments(JSInstrumentsDbTable.this.getSelectedInstruments());
            JSInstrumentsDbTable.getDbClipboard().setOperation(DbClipboard.Operation.CUT);
        }
    }

    class ChangeDescriptionAction
    extends AbstractAction {
        private String directoryPath;

        ChangeDescriptionAction() {
            super(StdI18n.i18n.getMenuLabel("instrumentsdb.edit.description"));
            this.directoryPath = null;
            String string = StdI18n.i18n.getMenuLabel("instrumentsdb.edit.description.tt");
            this.putValue("ShortDescription", string);
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = JSInstrumentsDbTable.this.getLeadObject();
            if (object == null) {
                return;
            }
            if (object instanceof DbDirectoryInfo) {
                DbDirectoryInfo dbDirectoryInfo = (DbDirectoryInfo)object;
                String string = this.editDescription(dbDirectoryInfo.getDescription());
                if (string == null) {
                    return;
                }
                String string2 = dbDirectoryInfo.getDirectoryPath();
                InstrumentsDb.SetDirectoryDescription setDirectoryDescription = new InstrumentsDb.SetDirectoryDescription(string2, string);
                CC.getTaskQueue().add(setDirectoryDescription);
            } else if (object instanceof DbInstrumentInfo) {
                DbInstrumentInfo dbInstrumentInfo = (DbInstrumentInfo)object;
                String string = this.editDescription(dbInstrumentInfo.getDescription());
                if (string == null) {
                    return;
                }
                String string3 = dbInstrumentInfo.getInstrumentPath();
                InstrumentsDb.SetInstrumentDescription setInstrumentDescription = new InstrumentsDb.SetInstrumentDescription(string3, string);
                CC.getTaskQueue().add(setInstrumentDescription);
            }
        }

        private String editDescription(String string) {
            Window window = JuifeUtils.getWindow(JSInstrumentsDbTable.this);
            JSDbDescriptionDlg jSDbDescriptionDlg = window instanceof Dialog ? new JSDbDescriptionDlg((Dialog)window) : (window instanceof Frame ? new JSDbDescriptionDlg((Frame)window) : new JSDbDescriptionDlg((Frame)null));
            jSDbDescriptionDlg.setDescription(string);
            jSDbDescriptionDlg.setVisible(true);
            if (jSDbDescriptionDlg.isCancelled()) {
                return null;
            }
            return jSDbDescriptionDlg.getDescription();
        }
    }

    class RenameAction
    extends AbstractAction {
        private String directoryPath;

        RenameAction() {
            super(StdI18n.i18n.getMenuLabel("instrumentsdb.edit.rename"));
            this.directoryPath = null;
            String string = StdI18n.i18n.getMenuLabel("instrumentsdb.edit.rename.tt");
            this.putValue("ShortDescription", string);
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = JSInstrumentsDbTable.this.getSelectionModel().getLeadSelectionIndex();
            if (n == -1) {
                return;
            }
            JSInstrumentsDbTable.this.editCellAt(n, 0);
        }
    }

    class PropertiesAction
    extends AbstractAction {
        PropertiesAction() {
            super(StdI18n.i18n.getMenuLabel("instrumentsdb.actions.properties"));
            String string = StdI18n.i18n.getMenuLabel("instrumentsdb.actions.properties.tt");
            this.putValue("ShortDescription", string);
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = JSInstrumentsDbTable.this.getLeadObject();
            if (object == null) {
                DbDirectoryTreeNode dbDirectoryTreeNode = JSInstrumentsDbTable.this.getParentDirectoryNode();
                if (dbDirectoryTreeNode == null || dbDirectoryTreeNode.getInfo() == null) {
                    return;
                }
                this.showDirectoryProperties(dbDirectoryTreeNode.getInfo());
                return;
            }
            if (object instanceof DbDirectoryInfo) {
                this.showDirectoryProperties((DbDirectoryInfo)object);
            } else if (object instanceof DbInstrumentInfo) {
                this.showInstrumentProperties((DbInstrumentInfo)object);
            }
        }

        private void showInstrumentProperties(DbInstrumentInfo dbInstrumentInfo) {
            JSDbInstrumentPropsPane jSDbInstrumentPropsPane = new JSDbInstrumentPropsPane(dbInstrumentInfo);
            String string = StdI18n.i18n.getLabel("JSInstrumentsDbTable.instrProps");
            this.showDialog(string, jSDbInstrumentPropsPane);
        }

        private void showDirectoryProperties(DbDirectoryInfo dbDirectoryInfo) {
            JSDbDirectoryPropsPane jSDbDirectoryPropsPane = new JSDbDirectoryPropsPane(dbDirectoryInfo);
            String string = StdI18n.i18n.getLabel("JSInstrumentsDbTable.dirProps");
            this.showDialog(string, jSDbDirectoryPropsPane);
        }

        private void showDialog(String string, JPanel jPanel) {
            Window window = JuifeUtils.getWindow(JSInstrumentsDbTable.this);
            InformationDialog informationDialog = window instanceof Dialog ? new InformationDialog((Dialog)window, string, (Container)jPanel) : (window instanceof Frame ? new InformationDialog((Frame)window, string, (Container)jPanel) : new InformationDialog((Frame)null, string, (Container)jPanel));
            informationDialog.setMinimumSize(informationDialog.getPreferredSize());
            informationDialog.setVisible(true);
        }
    }

    class AddToOrchestraAction
    extends AbstractAction {
        private final OrchestraModel orchestraModel;

        AddToOrchestraAction(OrchestraModel orchestraModel) {
            super(orchestraModel.getName());
            this.orchestraModel = orchestraModel;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DbInstrumentInfo[] dbInstrumentInfoArray = JSInstrumentsDbTable.this.getSelectedInstruments();
            int n = dbInstrumentInfoArray.length;
            if (n == 0) {
                return;
            }
            if (n > 1) {
                String string = "JSInstrumentsDbTable.confirmAddToOrchestra";
                string = StdI18n.i18n.getMessage(string, n, this.orchestraModel.getName());
                if (!HF.showYesNoDialog(JSInstrumentsDbTable.this, string)) {
                    return;
                }
            }
            for (DbInstrumentInfo dbInstrumentInfo : dbInstrumentInfoArray) {
                OrchestraInstrument orchestraInstrument = new OrchestraInstrument();
                orchestraInstrument.setFilePath(dbInstrumentInfo.getFilePath());
                orchestraInstrument.setInstrumentIndex(dbInstrumentInfo.getInstrumentIndex());
                orchestraInstrument.setName(dbInstrumentInfo.getName());
                orchestraInstrument.setDescription(dbInstrumentInfo.getDescription());
                orchestraInstrument.setEngine(dbInstrumentInfo.getFormatFamily());
                this.orchestraModel.addInstrument(orchestraInstrument);
            }
        }
    }

    class AddToMidiMapAction
    extends AbstractAction {
        private final MidiInstrumentMap midiMap;

        AddToMidiMapAction(MidiInstrumentMap midiInstrumentMap) {
            super(midiInstrumentMap.getName());
            this.midiMap = midiInstrumentMap;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object;
            DbInstrumentInfo[] dbInstrumentInfoArray = JSInstrumentsDbTable.this.getSelectedInstruments();
            int n = dbInstrumentInfoArray.length;
            if (n == 0) {
                return;
            }
            if (n > 4) {
                object = "JSInstrumentsDbTable.confirmAddToMidiMap";
                if (!HF.showYesNoDialog(JSInstrumentsDbTable.this, (String)(object = StdI18n.i18n.getMessage((String)object, n, this.midiMap.getName())))) {
                    return;
                }
            }
            Window window = JuifeUtils.getWindow(JSInstrumentsDbTable.this);
            for (DbInstrumentInfo dbInstrumentInfo : dbInstrumentInfoArray) {
                object = window instanceof Dialog ? new JSAddMidiInstrumentDlg((Dialog)window, this.midiMap, (Instrument)dbInstrumentInfo) : (window instanceof Frame ? new JSAddMidiInstrumentDlg((Frame)window, this.midiMap, (Instrument)dbInstrumentInfo) : new JSAddMidiInstrumentDlg((Frame)null, this.midiMap, (Instrument)dbInstrumentInfo));
                ((Dialog)object).setVisible(true);
            }
        }
    }

    class LoadInstrumentActionFactory
    implements StdA4n.LoadInstrumentActionFactory {
        LoadInstrumentActionFactory() {
        }

        @Override
        public StdA4n.LoadInstrumentAction createLoadInstrumentAction(SamplerChannelModel samplerChannelModel, boolean bl) {
            return new LoadInstrumentAction(samplerChannelModel, bl);
        }
    }

    class LoadInstrumentAction
    extends StdA4n.LoadInstrumentAction {
        LoadInstrumentAction(SamplerChannelModel samplerChannelModel, boolean bl) {
            super(samplerChannelModel, bl);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = JSInstrumentsDbTable.this.getLeadObject();
            if (object == null || !(object instanceof DbInstrumentInfo)) {
                return;
            }
            DbInstrumentInfo dbInstrumentInfo = (DbInstrumentInfo)object;
            int n = dbInstrumentInfo.getInstrumentIndex();
            this.channelModel.setBackendEngineType(dbInstrumentInfo.getFormatFamily());
            this.channelModel.loadBackendInstrument(dbInstrumentInfo.getFilePath(), n);
        }
    }

    class AddInstrumentsFromDirAction
    extends AbstractAction {
        AddInstrumentsFromDirAction() {
            super(StdI18n.i18n.getMenuLabel("instrumentsdb.actions.addInstruments.fromDir"));
            String string = "instrumentsdb.actions.addInstruments.fromDir.tt";
            this.putValue("ShortDescription", StdI18n.i18n.getMenuLabel(string));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DbDirectoryTreeNode dbDirectoryTreeNode = JSInstrumentsDbTable.this.getParentDirectoryNode();
            String string = dbDirectoryTreeNode == null || dbDirectoryTreeNode.getInfo() == null ? null : dbDirectoryTreeNode.getInfo().getDirectoryPath();
            Icon icon = JSInstrumentsDbTable.this.instrumentsDbTree.getView().getOpenIcon();
            Window window = JuifeUtils.getWindow(JSInstrumentsDbTable.this);
            JSAddDbInstrumentsFromDirDlg jSAddDbInstrumentsFromDirDlg = window instanceof Dialog ? new JSAddDbInstrumentsFromDirDlg((Dialog)window, string, icon) : (window instanceof Frame ? new JSAddDbInstrumentsFromDirDlg((Frame)window, string, icon) : new JSAddDbInstrumentsFromDirDlg((Frame)null, string, icon));
            jSAddDbInstrumentsFromDirDlg.setVisible(true);
            if (window != null) {
                window.toFront();
            }
        }
    }

    class AddInstrumentsFromFileAction
    extends AbstractAction {
        AddInstrumentsFromFileAction() {
            super(StdI18n.i18n.getMenuLabel("instrumentsdb.actions.addInstruments.fromFile"));
            String string = "instrumentsdb.actions.addInstruments.fromFile.tt";
            this.putValue("ShortDescription", StdI18n.i18n.getMenuLabel(string));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DbDirectoryTreeNode dbDirectoryTreeNode = JSInstrumentsDbTable.this.getParentDirectoryNode();
            String string = dbDirectoryTreeNode == null || dbDirectoryTreeNode.getInfo() == null ? null : dbDirectoryTreeNode.getInfo().getDirectoryPath();
            Icon icon = JSInstrumentsDbTable.this.instrumentsDbTree.getView().getOpenIcon();
            Window window = JuifeUtils.getWindow(JSInstrumentsDbTable.this);
            JSAddDbInstrumentsFromFileDlg jSAddDbInstrumentsFromFileDlg = window instanceof Dialog ? new JSAddDbInstrumentsFromFileDlg((Dialog)window, string, icon) : (window instanceof Frame ? new JSAddDbInstrumentsFromFileDlg((Frame)window, string, icon) : new JSAddDbInstrumentsFromFileDlg((Frame)null, string, icon));
            jSAddDbInstrumentsFromFileDlg.setVisible(true);
            if (window != null) {
                window.toFront();
            }
        }
    }

    class DeleteAction
    extends AbstractAction {
        DeleteAction() {
            super(StdI18n.i18n.getMenuLabel("instrumentsdb.actions.delete"));
            String string = StdI18n.i18n.getMenuLabel("instrumentsdb.actions.delete.tt");
            this.putValue("ShortDescription", string);
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            EnhancedTask enhancedTask;
            DbInstrumentInfo[] dbInstrumentInfoArray;
            final DbDirectoryInfo[] dbDirectoryInfoArray = JSInstrumentsDbTable.this.getSelectedDirectories();
            if (dbDirectoryInfoArray.length > 0) {
                dbInstrumentInfoArray = StdI18n.i18n.getMessage("JSInstrumentsDbTable.confirmDeletion");
                if (!JSInstrumentsDbTable.this.showYesNoDialog((String)dbInstrumentInfoArray)) {
                    return;
                }
                enhancedTask = new InstrumentsDb.RemoveDirectories(dbDirectoryInfoArray);
                enhancedTask.addTaskListener(new TaskListener(){

                    @Override
                    public void taskPerformed(TaskEvent taskEvent) {
                        if (JSInstrumentsDbTable.this.instrumentsDbTree.getSelectionCount() == 0) {
                            DeleteAction.this.deleteDirectories(dbDirectoryInfoArray);
                        }
                    }
                });
                CC.getTaskQueue().add(enhancedTask);
            }
            if ((dbInstrumentInfoArray = JSInstrumentsDbTable.this.getSelectedInstruments()).length > 0) {
                enhancedTask = new InstrumentsDb.RemoveInstruments(dbInstrumentInfoArray);
                enhancedTask.addTaskListener(new TaskListener(){

                    @Override
                    public void taskPerformed(TaskEvent taskEvent) {
                        if (JSInstrumentsDbTable.this.instrumentsDbTree.getSelectionCount() == 0) {
                            DeleteAction.this.deleteInstruments(dbInstrumentInfoArray);
                        }
                    }
                });
                CC.getTaskQueue().add(enhancedTask);
            }
        }

        private void deleteDirectories(DbDirectoryInfo[] dbDirectoryInfoArray) {
            for (DbDirectoryInfo dbDirectoryInfo : dbDirectoryInfoArray) {
                String string = dbDirectoryInfo.getDirectoryPath();
                JSInstrumentsDbTable.this.getParentDirectoryNode().removeDirectoryByPathName(string);
                JSInstrumentsDbTable.this.getModel().fireTableDataChanged();
            }
        }

        private void deleteInstruments(DbInstrumentInfo[] dbInstrumentInfoArray) {
            for (DbInstrumentInfo dbInstrumentInfo : dbInstrumentInfoArray) {
                String string = dbInstrumentInfo.getInstrumentPath();
                JSInstrumentsDbTable.this.getParentDirectoryNode().removeInstrumentByPathName(string);
                JSInstrumentsDbTable.this.getModel().fireTableDataChanged();
            }
        }
    }

    class CreateDirectoryAction
    extends AbstractAction {
        private String directoryName;

        CreateDirectoryAction() {
            super(StdI18n.i18n.getMenuLabel("instrumentsdb.actions.createFolder"));
            this.directoryName = null;
            String string = StdI18n.i18n.getMenuLabel("instrumentsdb.actions.createFolder.tt");
            this.putValue("ShortDescription", string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.setDirectoryName(JSInstrumentsDbTable.this.getUniqueDirectoryName());
            String string = JSInstrumentsDbTable.this.instrumentsDbTree.getSelectedDirectoryPath();
            if (string.length() > 1) {
                string = string + "/";
            }
            string = string + Parser.toEscapedFileName(this.getDirectoryName());
            final InstrumentsDb.CreateDirectory createDirectory = new InstrumentsDb.CreateDirectory(string);
            JSInstrumentsDbTable.this.setCreatedDirectoryName(this.directoryName);
            createDirectory.addTaskListener(new TaskListener(){

                @Override
                public void taskPerformed(TaskEvent taskEvent) {
                    if (createDirectory.doneWithErrors()) {
                        JSInstrumentsDbTable.this.setCreatedDirectoryName(null);
                        return;
                    }
                }
            });
            CC.getTaskQueue().add(createDirectory);
        }

        public String getDirectoryName() {
            return this.directoryName;
        }

        public void setDirectoryName(String string) {
            this.directoryName = string;
        }
    }

    private class ReloadAction
    extends AbstractAction
    implements TreeSelectionListener {
        ReloadAction() {
            super(StdI18n.i18n.getMenuLabel("instrumentsdb.actions.reload"));
            String string = StdI18n.i18n.getMenuLabel("instrumentsdb.actions.reload.tt");
            this.putValue("ShortDescription", string);
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DbDirectoryTreeNode dbDirectoryTreeNode = JSInstrumentsDbTable.this.instrumentsDbTree.getSelectedDirectoryNode();
            if (dbDirectoryTreeNode == null) {
                return;
            }
            final String string = dbDirectoryTreeNode.getInfo().getDirectoryPath();
            JSInstrumentsDbTable.this.instrumentsDbTree.refreshDirectoryContent(string);
            CC.scheduleInTaskQueue(new Runnable(){

                @Override
                public void run() {
                    JSInstrumentsDbTable.this.instrumentsDbTree.setSelectedDirectory(string);
                }
            });
        }

        @Override
        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            DbDirectoryTreeNode dbDirectoryTreeNode = JSInstrumentsDbTable.this.instrumentsDbTree.getSelectedDirectoryNode();
            this.setEnabled(dbDirectoryTreeNode != null);
        }
    }
}

