/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server.indexer;

import com.intellij.util.ExceptionUtilRt;
import java.io.File;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.model.MavenIndexId;
import org.jetbrains.idea.maven.model.MavenRepositoryInfo;
import org.jetbrains.idea.maven.model.RepositoryKind;
import org.jetbrains.idea.maven.server.AsyncMavenServerIndexer;
import org.jetbrains.idea.maven.server.MavenIndexUpdateState;
import org.jetbrains.idea.maven.server.MavenServerIndexerException;
import org.jetbrains.idea.maven.server.MavenServerProcessCanceledException;
import org.jetbrains.idea.maven.server.MavenServerProgressIndicator;
import org.jetbrains.idea.maven.server.MavenServerUtil;
import org.jetbrains.idea.maven.server.indexer.MavenIdeaIndexerImpl;
import org.jetbrains.idea.maven.server.security.MavenToken;

public class MavenIdeaAsyncIndexerImpl
extends MavenIdeaIndexerImpl
implements AsyncMavenServerIndexer {
    private final ExecutorService myExecutor = Executors.newSingleThreadExecutor(new MyThreadFactory());
    private final Map<String, IndexProcessData> states = new HashMap<String, IndexProcessData>();

    public MavenIdeaAsyncIndexerImpl(PlexusContainer container) throws ComponentLookupException {
        super(container);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MavenIndexUpdateState startIndexing(MavenRepositoryInfo repositoryInfo, File indexDir, MavenToken token) {
        IndexProcessData data;
        MavenServerUtil.checkToken((MavenToken)token);
        MavenIdeaAsyncIndexerImpl mavenIdeaAsyncIndexerImpl = this;
        synchronized (mavenIdeaAsyncIndexerImpl) {
            IndexProcessData existingData = this.states.get(repositoryInfo.getUrl());
            if (existingData != null && existingData.state.myState == MavenIndexUpdateState.State.INDEXING) {
                return existingData.state;
            }
            data = new IndexProcessData();
            data.state = new MavenIndexUpdateState(repositoryInfo.getUrl(), null, null, MavenIndexUpdateState.State.INDEXING);
            this.states.put(repositoryInfo.getUrl(), data);
        }
        MyMavenServerProgressIndicator indicator = new MyMavenServerProgressIndicator(data);
        this.myExecutor.execute(() -> {
            try {
                this.runIndexing(repositoryInfo, indexDir, indicator);
                data.state.myState = MavenIndexUpdateState.State.SUCCEED;
            }
            catch (Exception e) {
                data.state.myState = MavenIndexUpdateState.State.FAILED;
                data.state.myError = ExceptionUtilRt.getThrowableText((Throwable)e, (String)"com.jetbrains");
                throw new RuntimeException(this.wrapException(e));
            }
        });
        return data.state;
    }

    @NotNull
    private static File createNonExistentDir(MavenRepositoryInfo repositoryInfo, File parent) {
        File result;
        while (!(result = new File(parent, repositoryInfo.getId() + System.nanoTime())).mkdirs()) {
        }
        File file = result;
        if (file == null) {
            MavenIdeaAsyncIndexerImpl.$$$reportNull$$$0(0);
        }
        return file;
    }

    private void runIndexing(MavenRepositoryInfo repositoryInfo, File tempDirectory, MavenServerProgressIndicator indicator) throws IOException, MavenServerProcessCanceledException, MavenServerIndexerException {
        String path = repositoryInfo.getKind() == RepositoryKind.LOCAL ? repositoryInfo.getUrl() : null;
        String url = repositoryInfo.getKind() == RepositoryKind.REMOTE ? repositoryInfo.getUrl() : null;
        MavenIndexId id = new MavenIndexId(repositoryInfo.getId(), repositoryInfo.getId(), path, url, tempDirectory.getAbsolutePath());
        this.doUpdateIndex(id, true, indicator);
    }

    public ArrayList<MavenIndexUpdateState> status(MavenToken token) {
        MavenServerUtil.checkToken((MavenToken)token);
        ArrayList<MavenIndexUpdateState> result = new ArrayList<MavenIndexUpdateState>(this.states.size());
        this.states.values().forEach(d -> result.add(d.state));
        return result;
    }

    public void stopIndexing(MavenRepositoryInfo info, MavenToken token) {
        MavenServerUtil.checkToken((MavenToken)token);
        IndexProcessData data = this.states.get(info.getUrl());
        if (data != null) {
            data.isCanceled = true;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/server/indexer/MavenIdeaAsyncIndexerImpl", "createNonExistentDir"));
    }

    private static class MyThreadFactory
    implements ThreadFactory {
        private MyThreadFactory() {
        }

        @Override
        public Thread newThread(@NotNull Runnable r) {
            if (r == null) {
                MyThreadFactory.$$$reportNull$$$0(0);
            }
            Thread t = new Thread(r, "Maven Async Index thread");
            t.setDaemon(true);
            return t;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "r", "org/jetbrains/idea/maven/server/indexer/MavenIdeaAsyncIndexerImpl$MyThreadFactory", "newThread"));
        }
    }

    static class IndexProcessData {
        public MavenIndexUpdateState state;
        public boolean isCanceled;

        IndexProcessData() {
        }
    }

    private static class MyMavenServerProgressIndicator
    implements MavenServerProgressIndicator {
        private final IndexProcessData myData;

        private MyMavenServerProgressIndicator(IndexProcessData data) {
            this.myData = data;
        }

        public void setText(String text) throws RemoteException {
            this.myData.state.myProgressInfo = text;
            this.myData.state.updateTimestamp();
        }

        public void setText2(String text) throws RemoteException {
        }

        public boolean isCanceled() throws RemoteException {
            return this.myData.isCanceled;
        }

        public void setIndeterminate(boolean value) throws RemoteException {
        }

        public void setFraction(double fraction) throws RemoteException {
            this.myData.state.fraction = fraction;
            this.myData.state.updateTimestamp();
        }
    }
}

