/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.DocFieldConsumerPerField;
import org.apache.lucene.index.DocumentsWriter;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.StoredFieldsWriter;
import org.apache.lucene.index.StoredFieldsWriterPerThread;

final class StoredFieldsWriterPerField
extends DocFieldConsumerPerField {
    final StoredFieldsWriterPerThread perThread;
    final FieldInfo fieldInfo;
    final DocumentsWriter.DocState docState;
    static final /* synthetic */ boolean $assertionsDisabled;

    public StoredFieldsWriterPerField(StoredFieldsWriterPerThread perThread, FieldInfo fieldInfo) {
        this.perThread = perThread;
        this.fieldInfo = fieldInfo;
        this.docState = perThread.docState;
    }

    public void processFields(Fieldable[] fields, int count) throws IOException {
        StoredFieldsWriter.PerDoc doc;
        if (this.perThread.doc == null) {
            doc = this.perThread.doc = this.perThread.storedFieldsWriter.getPerDoc();
            doc.docID = this.docState.docID;
            this.perThread.localFieldsWriter.setFieldsStream(doc.fdt);
            if (!$assertionsDisabled && doc.numStoredFields != 0) {
                throw new AssertionError((Object)("doc.numStoredFields=" + doc.numStoredFields));
            }
            if (!$assertionsDisabled && 0L != doc.fdt.length()) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && 0L != doc.fdt.getFilePointer()) {
                throw new AssertionError();
            }
        } else {
            doc = this.perThread.doc;
            if (!$assertionsDisabled && doc.docID != this.docState.docID) {
                throw new AssertionError((Object)("doc.docID=" + doc.docID + " docState.docID=" + this.docState.docID));
            }
        }
        for (int i = 0; i < count; ++i) {
            Fieldable field = fields[i];
            if (!field.isStored()) continue;
            this.perThread.localFieldsWriter.writeField(this.fieldInfo, field);
            if (!$assertionsDisabled && !this.docState.testPoint("StoredFieldsWriterPerField.processFields.writeField")) {
                throw new AssertionError();
            }
            ++doc.numStoredFields;
        }
    }

    void abort() {
    }

    static {
        $assertionsDisabled = !StoredFieldsWriterPerField.class.desiredAssertionStatus();
    }
}

