//
// Copyright (C) 2013 Intel Corporation. All Rights Reserved.
//
// The source code contained or described herein and all documents related
// to the source code ("Material") are owned by Intel Corporation or its
// suppliers or licensors.  Title to the Material remains with Intel
// Corporation or its suppliers and licensors.  The Material is protected
// by worldwide copyright laws and treaty provisions.  No part of the
// Material may be used, copied, reproduced, modified, published, uploaded,
// posted, transmitted, distributed, or disclosed in any way without
// Intel's prior express written permission.
//
// No license under any patent, copyright, trade secret or other intellectual
// property right is granted to or conferred upon you by disclosure or
// delivery of the Materials, either expressly, by implication, inducement,
// estoppel or otherwise. Any license under such intellectual property rights
// must be express and approved by Intel in writing.
//
// Unless otherwise agreed by Intel in writing, you may not remove or alter
// this notice or any other notice embedded in Materials by Intel or Intel's
// suppliers or licensors in any way.
//

#ifndef SDLT_EMIT_FOR_EACH_H
#define SDLT_EMIT_FOR_EACH_H

#include "../common.h"

// C99 standard states macros can take up to 127 arguments,
// therefore our FOR_EACH_# should go up to 126 variable arguments + the 1st
// argument which is the macro we are going to emit
// Tested up to 126 on icc, other preprocessors might require fewer
// Visual Studio 2015 fatal error C1112 : compiler limit : '128' too many macro arguments, only '127' allowed
// So we reduced down to 125 additional arguments

#define __SDLT_EMIT_FOR_EACH_1(MACRO, FINAL_ARGUMENT) MACRO(FINAL_ARGUMENT)
#define __SDLT_EMIT_FOR_EACH_2(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_1(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_3(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_2(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_4(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_3(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_5(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_4(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_6(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_5(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_7(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_6(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_8(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_7(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_9(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_8(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_10(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_9(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_11(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_10(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_12(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_11(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_13(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_12(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_14(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_13(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_15(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_14(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_16(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_15(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_17(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_16(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_18(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_17(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_19(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_18(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_20(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_19(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_21(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_20(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_22(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_21(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_23(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_22(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_24(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_23(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_25(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_24(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_26(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_25(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_27(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_26(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_28(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_27(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_29(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_28(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_30(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_29(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_31(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_30(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_32(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_31(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_33(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_32(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_34(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_33(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_35(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_34(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_36(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_35(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_37(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_36(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_38(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_37(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_39(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_38(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_40(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_39(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_41(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_40(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_42(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_41(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_43(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_42(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_44(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_43(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_45(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_44(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_46(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_45(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_47(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_46(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_48(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_47(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_49(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_48(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_50(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_49(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_51(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_50(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_52(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_51(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_53(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_52(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_54(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_53(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_55(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_54(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_56(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_55(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_57(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_56(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_58(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_57(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_59(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_58(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_60(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_59(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_61(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_60(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_62(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_61(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_63(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_62(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_64(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_63(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_65(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_64(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_66(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_65(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_67(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_66(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_68(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_67(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_69(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_68(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_70(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_69(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_71(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_70(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_72(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_71(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_73(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_72(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_74(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_73(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_75(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_74(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_76(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_75(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_77(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_76(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_78(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_77(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_79(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_78(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_80(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_79(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_81(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_80(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_82(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_81(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_83(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_82(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_84(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_83(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_85(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_84(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_86(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_85(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_87(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_86(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_88(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_87(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_89(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_88(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_90(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_89(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_91(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_90(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_92(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_91(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_93(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_92(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_94(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_93(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_95(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_94(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_96(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_95(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_97(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_96(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_98(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_97(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_99(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_98(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_100(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_99(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_101(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_100(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_102(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_101(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_103(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_102(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_104(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_103(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_105(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_104(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_106(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_105(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_107(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_106(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_108(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_107(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_109(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_108(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_110(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_109(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_111(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_110(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_112(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_111(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_113(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_112(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_114(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_113(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_115(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_114(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_116(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_115(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_117(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_116(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_118(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_117(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_119(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_118(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_120(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_119(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_121(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_120(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_122(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_121(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_123(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_122(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_124(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_123(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_125(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_124(MACRO, __VA_ARGS__))

#define __SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_1(MACRO, FINAL_ARGUMENT) MACRO(FINAL_ARGUMENT)
#define __SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_2(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) , __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_1(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_3(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) , __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_2(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_4(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) , __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_3(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_5(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) , __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_4(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_6(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) , __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_5(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_7(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) , __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_6(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_8(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) , __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_7(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_9(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) , __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_8(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_10(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) , __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_9(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_11(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) , __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_10(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_12(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) , __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_11(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_13(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) , __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_12(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_14(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) , __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_13(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_15(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) , __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_14(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_16(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) , __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_15(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_17(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) , __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_16(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_18(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) , __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_17(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_19(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) , __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_18(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_20(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) , __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_19(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_21(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) , __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_20(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_22(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) , __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_21(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_23(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) , __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_22(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_24(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) , __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_23(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_25(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) , __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_24(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_26(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) , __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_25(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_27(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) , __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_26(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_28(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) , __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_27(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_29(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) , __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_28(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_30(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) , __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_29(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_31(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) , __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_30(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_32(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) , __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_31(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_33(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) , __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_32(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_34(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) , __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_33(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_35(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) , __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_34(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_36(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) , __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_35(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_37(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) , __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_36(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_38(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) , __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_37(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_39(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) , __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_38(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_40(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) , __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_39(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_41(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) , __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_40(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_42(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) , __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_41(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_43(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) , __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_42(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_44(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) , __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_43(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_45(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) , __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_44(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_46(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) , __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_45(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_47(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) , __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_46(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_48(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) , __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_47(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_49(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) , __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_48(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_50(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) , __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_49(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_51(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) , __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_50(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_52(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) , __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_51(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_53(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) , __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_52(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_54(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) , __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_53(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_55(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) , __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_54(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_56(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) , __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_55(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_57(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) , __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_56(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_58(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) , __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_57(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_59(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) , __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_58(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_60(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) , __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_59(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_61(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) , __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_60(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_62(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) , __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_61(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_63(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) , __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_62(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_64(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) , __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_63(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_65(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) , __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_64(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_66(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) , __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_65(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_67(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) , __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_66(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_68(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) , __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_67(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_69(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) , __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_68(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_70(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) , __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_69(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_71(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) , __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_70(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_72(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) , __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_71(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_73(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) , __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_72(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_74(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) , __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_73(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_75(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) , __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_74(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_76(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) , __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_75(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_77(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) , __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_76(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_78(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) , __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_77(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_79(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) , __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_78(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_80(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) , __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_79(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_81(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) , __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_80(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_82(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) , __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_81(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_83(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) , __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_82(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_84(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) , __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_83(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_85(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) , __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_84(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_86(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) , __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_85(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_87(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) , __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_86(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_88(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) , __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_87(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_89(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) , __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_88(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_90(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) , __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_89(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_91(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) , __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_90(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_92(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) , __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_91(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_93(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) , __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_92(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_94(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) , __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_93(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_95(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) , __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_94(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_96(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) , __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_95(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_97(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) , __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_96(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_98(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) , __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_97(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_99(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) , __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_98(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_100(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) , __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_99(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_101(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) , __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_100(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_102(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) , __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_101(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_103(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) , __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_102(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_104(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) , __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_103(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_105(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) , __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_104(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_106(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) , __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_105(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_107(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) , __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_106(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_108(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) , __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_107(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_109(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) , __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_108(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_110(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) , __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_109(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_111(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) , __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_110(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_112(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) , __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_111(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_113(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) , __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_112(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_114(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) , __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_113(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_115(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) , __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_114(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_116(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) , __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_115(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_117(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) , __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_116(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_118(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) , __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_117(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_119(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) , __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_118(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_120(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) , __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_119(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_121(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) , __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_120(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_122(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) , __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_121(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_123(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) , __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_122(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_124(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) , __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_123(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_125(MACRO, FIRST_ARGUMENT, ...) MACRO(FIRST_ARGUMENT) , __SDLT_EXPAND_TOKEN(__SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_124(MACRO, __VA_ARGS__))

// To avoid gcc error:  ISO C99 requiers rest arguments to be used
// Need to pass a parameter to fill the ... argument
// for SDLT_NUM_VARIABLE_ARGUMENTS_INDIRECT, so we will pass 0
#define __SDLT_NUM_VARIABLE_ARGUMENTS(...)    \
    __SDLT_EXPAND_TOKEN(__SDLT_NUM_VARIABLE_ARGUMENTS_INDIRECT(__VA_ARGS__, \
                   125, 124, 123, 122, 121, 120, \
    119, 118, 117, 116, 115, 114, 113, 112, 111, 110, \
    109, 108, 107, 106, 105, 104, 103, 102, 101, 100, \
     99,  98,  97,  96,  95,  94,  93,  92,  91,  90, \
     89,  88,  87,  86,  85,  84,  83,  82,  81,  80, \
     79,  78,  77,  76,  75,  74,  73,  72,  71,  70, \
     69,  68,  67,  66,  65,  64,  63,  62,  61,  60, \
     59,  58,  57,  56,  55,  54,  53,  52,  51,  50, \
     49,  48,  47,  46,  45,  44,  43,  42,  41,  40, \
     39,  38,  37,  36,  35,  34,  33,  32,  31,  30, \
     29,  28,  27,  26,  25,  24,  23,  22,  21,  20, \
     19,  18,  17,  16,  15,  14,  13,  12,  11,  10, \
      9,   8,   7,   6,   5,   4,   3,   2,   1,   0))

#define __SDLT_NUM_VARIABLE_ARGUMENTS_INDIRECT( \
      _1,   _2,   _3,   _4,   _5,   _6,   _7,   _8,   _9,  _10, \
     _11,  _12,  _13,  _14,  _15,  _16,  _17,  _18,  _19,  _20, \
     _21,  _22,  _23,  _24,  _25,  _26,  _27,  _28,  _29,  _30, \
     _31,  _32,  _33,  _34,  _35,  _36,  _37,  _38,  _39,  _40, \
     _41,  _42,  _43,  _44,  _45,  _46,  _47,  _48,  _49,  _50, \
     _51,  _52,  _53,  _54,  _55,  _56,  _57,  _58,  _59,  _60, \
     _61,  _62,  _63,  _64,  _65,  _66,  _67,  _68,  _69,  _70, \
     _71,  _72,  _73,  _74,  _75,  _76,  _77,  _78,  _79,  _80, \
     _81,  _82,  _83,  _84,  _85,  _86,  _87,  _88,  _89,  _90, \
     _91,  _92,  _93,  _94,  _95,  _96,  _97,  _98,  _99, _100, \
    _101, _102, _103, _104, _105, _106, _107, _108, _109, _110, \
    _111, _112, _113, _114, _115, _116, _117, _118, _119, _120, \
    _121, _122, _123, _124, _125, N, ...) N

#define __SDLT_SUFFIXED_BY_NUM_ARGUMENTS(MACRO, ...)  __SDLT_EXPAND_TOKEN(__SDLT_SUFFIXED_BY_NUM_ARGUMENTS_INDIRECT_1(MACRO, __SDLT_NUM_VARIABLE_ARGUMENTS(__VA_ARGS__)))
#define __SDLT_SUFFIXED_BY_NUM_ARGUMENTS_INDIRECT_1(MACRO, NUM_ARGUMENTS) __SDLT_SUFFIXED_BY_NUM_ARGUMENTS_INDIRECT_2(MACRO, NUM_ARGUMENTS)
#define __SDLT_SUFFIXED_BY_NUM_ARGUMENTS_INDIRECT_2(MACRO, NUM_ARGUMENTS) MACRO ## NUM_ARGUMENTS


// Will emit the MACRO(ARGUMENT) passing each of the remaining variable
// arguments one at a time in order as the ARGUMENT to MACRO
// Can be used from inside other macros, useful for generating code
#define __SDLT_EMIT_FOR_EACH(MACRO, ...) __SDLT_EXPAND_TOKEN(__SDLT_SUFFIXED_BY_NUM_ARGUMENTS(__SDLT_EMIT_FOR_EACH_, __VA_ARGS__)(MACRO, __VA_ARGS__))
#define __SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA(MACRO, ...) __SDLT_EXPAND_TOKEN(__SDLT_SUFFIXED_BY_NUM_ARGUMENTS(__SDLT_EMIT_FOR_EACH_SEPARATED_BY_COMMA_, __VA_ARGS__)(MACRO, __VA_ARGS__))


#endif // SDLT_EMIT_FOR_EACH_H
