/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.reflect.annotations.impl;

import com.google.common.collect.ImmutableMap;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.gradle.internal.reflect.annotations.AnnotationCategory;
import org.gradle.internal.reflect.annotations.FunctionAnnotationMetadata;
import org.gradle.internal.reflect.annotations.impl.AbstractHasAnnotationMetadata;
import org.jspecify.annotations.NonNull;

public class DefaultFunctionAnnotationMetadata
extends AbstractHasAnnotationMetadata
implements FunctionAnnotationMetadata {
    public DefaultFunctionAnnotationMetadata(Method method, ImmutableMap<AnnotationCategory, Annotation> annotationsByCategory) {
        super(method, annotationsByCategory);
    }

    public String toString() {
        return this.getMethod().getName() + "(" + this.getParameterTypeString() + ")";
    }

    private String getParameterTypeString() {
        return Arrays.stream(this.getMethod().getParameterTypes()).map(Class::getSimpleName).collect(Collectors.joining(", "));
    }

    @Override
    public int compareTo(@NonNull FunctionAnnotationMetadata o) {
        int result = this.getMethod().getName().compareTo(o.getMethod().getName());
        if (result == 0) {
            if (this.getMethod().getParameterCount() != o.getMethod().getParameterCount()) {
                return this.getMethod().getParameterCount() - o.getMethod().getParameterCount();
            }
            for (int i = 0; i < this.getMethod().getParameterCount(); ++i) {
                if (this.getMethod().getParameterTypes()[i] == o.getMethod().getParameterTypes()[i]) continue;
                return this.getMethod().getParameterTypes()[i].getName().compareTo(o.getMethod().getParameterTypes()[i].getName());
            }
            return 0;
        }
        return result;
    }
}

