/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.script.proxy;

import groovy.lang.Closure;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.filechooser.FileFilter;
import org.freeplane.api.AttributeValueSerializer;
import org.freeplane.api.MindMap;
import org.freeplane.api.Node;
import org.freeplane.api.NodeCondition;
import org.freeplane.api.Script;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.IEditHandler;
import org.freeplane.core.undo.IUndoHandler;
import org.freeplane.core.util.FreeplaneVersion;
import org.freeplane.core.util.LogUtils;
import org.freeplane.features.export.mindmapmode.ExportController;
import org.freeplane.features.export.mindmapmode.IExportEngine;
import org.freeplane.features.filter.condition.ICondition;
import org.freeplane.features.icon.factory.IconStoreFactory;
import org.freeplane.features.map.IMapSelection;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.map.mindmapmode.MMapModel;
import org.freeplane.features.mapio.mindmapmode.MMapIO;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.mindmapmode.MModeController;
import org.freeplane.features.text.TextController;
import org.freeplane.features.text.mindmapmode.MTextController;
import org.freeplane.features.ui.IMapViewManager;
import org.freeplane.features.ui.ViewController;
import org.freeplane.plugin.script.ScriptContext;
import org.freeplane.plugin.script.proxy.FileScriptProxy;
import org.freeplane.plugin.script.proxy.LoaderProxy;
import org.freeplane.plugin.script.proxy.MapProxy;
import org.freeplane.plugin.script.proxy.NodeProxy;
import org.freeplane.plugin.script.proxy.Proxy;
import org.freeplane.plugin.script.proxy.ProxyUtils;
import org.freeplane.plugin.script.proxy.StaticAttributeValueSerializer;
import org.freeplane.plugin.script.proxy.StringScriptProxy;

class ControllerProxy
implements Proxy.Controller {
    private final ScriptContext scriptContext;

    public ControllerProxy(ScriptContext scriptContext) {
        this.scriptContext = scriptContext;
    }

    public void centerOnNode(Node center) {
        NodeModel nodeModel = (NodeModel)((NodeProxy)center).getDelegate();
        Controller.getCurrentController().getSelection().scrollNodeToCenter(nodeModel, false);
    }

    public void edit(Node node) {
        this.editImpl(node, true);
    }

    public void editInPopup(Node node) {
        this.editImpl(node, false);
    }

    private void editImpl(Node node, boolean editInline) {
        NodeModel nodeModel = (NodeModel)((NodeProxy)node).getDelegate();
        Controller.getCurrentController().getSelection().selectAsTheOnlyOneSelected(nodeModel);
        ((MTextController)TextController.getController()).edit(IEditHandler.FirstAction.EDIT_CURRENT, !editInline);
    }

    @Override
    public Node getSelected() {
        this.reportArbitraryNodeAccess();
        IMapSelection selection = Controller.getCurrentController().getSelection();
        return selection != null ? new NodeProxy(selection.getSelected(), this.scriptContext) : null;
    }

    public Node getViewRoot() {
        this.reportArbitraryNodeAccess();
        IMapSelection selection = Controller.getCurrentController().getSelection();
        return selection != null ? new NodeProxy(selection.getSelectionRoot(), this.scriptContext) : null;
    }

    private void reportArbitraryNodeAccess() {
        if (this.scriptContext != null) {
            this.scriptContext.accessAll();
        }
    }

    @Override
    public List<? extends Node> getSelecteds() {
        this.reportArbitraryNodeAccess();
        return ProxyUtils.createNodeList(Controller.getCurrentController().getSelection().getOrderedSelection(), this.scriptContext);
    }

    @Override
    public List<? extends Node> getSortedSelection(boolean differentSubtrees) {
        this.reportArbitraryNodeAccess();
        return ProxyUtils.createNodeList(Controller.getCurrentController().getSelection().getSortedSelection(differentSubtrees), this.scriptContext);
    }

    public void select(Node toSelect) {
        if (toSelect != null) {
            NodeModel nodeModel = (NodeModel)((NodeProxy)toSelect).getDelegate();
            Controller.getCurrentModeController().getMapController().displayNode(nodeModel);
            Controller.getCurrentController().getSelection().selectAsTheOnlyOneSelected(nodeModel);
        }
    }

    public void selectBranch(Node branchRoot) {
        if (branchRoot != null) {
            NodeModel nodeModel = (NodeModel)((NodeProxy)branchRoot).getDelegate();
            Controller.getCurrentModeController().getMapController().displayNode(nodeModel);
            Controller.getCurrentController().getSelection().selectBranch(nodeModel, false);
        }
    }

    public void select(Collection<? extends Node> toSelect) {
        Iterator<? extends Node> it = toSelect.iterator();
        if (!it.hasNext()) {
            return;
        }
        Node firstNode = it.next();
        this.select(firstNode);
        while (it.hasNext()) {
            Node nextNode = it.next();
            NodeModel nodeModel = (NodeModel)((NodeProxy)nextNode).getDelegate();
            Controller.getCurrentModeController().getMapController().displayNode(nodeModel);
            Controller.getCurrentController().getSelection().toggleSelected(nodeModel);
        }
    }

    public void selectMultipleNodes(Collection<? extends Node> toSelect) {
        this.select(toSelect);
    }

    public void deactivateUndo() {
        MapModel map = Controller.getCurrentController().getMap();
        if (map instanceof MapModel) {
            MModeController modeController = (MModeController)Controller.getCurrentModeController();
            modeController.deactivateUndo((MMapModel)map);
        }
    }

    public void undo() {
        MapModel map = Controller.getCurrentController().getMap();
        IUndoHandler undoHandler = (IUndoHandler)map.getExtension(IUndoHandler.class);
        undoHandler.undo();
    }

    public void redo() {
        MapModel map = Controller.getCurrentController().getMap();
        IUndoHandler undoHandler = (IUndoHandler)map.getExtension(IUndoHandler.class);
        undoHandler.redo();
    }

    public void setStatusInfo(String info) {
        ViewController viewController = this.getViewController();
        viewController.out(info);
    }

    private ViewController getViewController() {
        return Controller.getCurrentController().getViewController();
    }

    private IMapViewManager getMapViewManager() {
        return Controller.getCurrentController().getMapViewManager();
    }

    public void setStatusInfo(String infoPanelKey, String info) {
        ViewController viewController = this.getViewController();
        viewController.addStatusInfo(infoPanelKey, info, null);
    }

    public void setStatusInfo(String infoPanelKey, String info, String iconKey) {
        ViewController viewController = this.getViewController();
        viewController.addStatusInfo(infoPanelKey, info, IconStoreFactory.ICON_STORE.getUIIcon(iconKey).getIcon());
    }

    @Deprecated
    public void setStatusInfo(String infoPanelKey, Icon icon) {
        ViewController viewController = this.getViewController();
        viewController.addStatusInfo(infoPanelKey, null, icon);
    }

    public FreeplaneVersion getFreeplaneVersion() {
        return FreeplaneVersion.getVersion();
    }

    @Override
    public File getUserDirectory() {
        return new File(ResourceController.getResourceController().getFreeplaneUserDirectory());
    }

    @Override
    @Deprecated
    public List<? extends Node> find(ICondition condition) {
        this.reportArbitraryNodeAccess();
        return ProxyUtils.find(condition, this.currentMapRootNode(), this.scriptContext);
    }

    @Override
    public List<? extends Node> find(NodeCondition condition) {
        this.reportArbitraryNodeAccess();
        return ProxyUtils.find(condition, this.currentMapRootNode(), this.scriptContext);
    }

    @Override
    public List<? extends Node> find(boolean withAncestors, boolean withDescendants, NodeCondition condition) {
        this.reportArbitraryNodeAccess();
        return ProxyUtils.find(withAncestors, withDescendants, condition, this.currentMapRootNode(), this.scriptContext);
    }

    private NodeModel currentMapRootNode() {
        return Controller.getCurrentController().getMap().getRootNode();
    }

    @Override
    public List<? extends Node> find(Closure<Boolean> closure) {
        this.reportArbitraryNodeAccess();
        return ProxyUtils.find(closure, this.currentMapRootNode(), this.scriptContext);
    }

    @Override
    public List<? extends Node> find(boolean withAncestors, boolean withDescendants, Closure<Boolean> closure) {
        this.reportArbitraryNodeAccess();
        return ProxyUtils.find(withAncestors, withDescendants, closure, this.currentMapRootNode(), this.scriptContext);
    }

    @Override
    public List<? extends Node> findAll() {
        this.reportArbitraryNodeAccess();
        return ProxyUtils.findAll(this.currentMapRootNode(), this.scriptContext, false);
    }

    @Override
    public List<? extends Node> findAllDepthFirst() {
        this.reportArbitraryNodeAccess();
        return ProxyUtils.findAll(this.currentMapRootNode(), this.scriptContext, true);
    }

    public MindMap newMindMap() {
        MMapIO mapIO = MMapIO.getInstance();
        MapModel newMap = mapIO.newMapFromDefaultTemplate();
        return newMap != null ? new MapProxy(newMap, this.scriptContext) : null;
    }

    @Override
    public float getZoom() {
        return this.getMapViewManager().getZoom();
    }

    public void setZoom(float ratio) {
        this.getMapViewManager().setZoom(ratio);
    }

    @Override
    public boolean isInteractive() {
        return !GraphicsEnvironment.isHeadless();
    }

    @Override
    public List<String> getExportTypeDescriptions() {
        ArrayList<String> list = new ArrayList<String>();
        for (FileFilter fileFilter : ExportController.getContoller().getMapExportFileFilters()) {
            list.add(fileFilter.getDescription());
        }
        return list;
    }

    @Override
    public void export(MindMap map, File destFile, String exportTypeDescription, boolean overwriteExisting) {
        String destinationName = destFile.getName();
        String destinationExtension = destinationName.substring(destinationName.lastIndexOf(46));
        List fileFilters = ExportController.getContoller().getMapExportFileFilters();
        FileFilter filter = this.findExportFileFilterByDescription(fileFilters, exportTypeDescription, destinationExtension);
        if (filter == null) {
            throw new IllegalArgumentException("no export defined for '" + exportTypeDescription + "'");
        }
        if (!overwriteExisting && destFile.exists()) {
            throw new RuntimeException("destination file " + destFile.getAbsolutePath() + " already exists - set overwriteExisting to true?");
        }
        HashMap exportEngines = ExportController.getContoller().getMapExportEngines();
        IExportEngine exportEngine = (IExportEngine)exportEngines.get(filter);
        MapModel mapDelegate = (MapModel)((MapProxy)map).getDelegate();
        exportEngine.export(Collections.singletonList(mapDelegate.getRootNode()), destFile);
        LogUtils.info((String)("exported " + map.getFile() + " to " + destFile.getAbsolutePath()));
    }

    private FileFilter findExportFileFilterByDescription(List<FileFilter> fileFilters, String exportTypeDescription, String destinationExtension) {
        String exportTypeDescriptionLowerCase = exportTypeDescription.toLowerCase();
        String destinationExtensionLowerCase = destinationExtension.toLowerCase();
        for (FileFilter fileFilter : fileFilters) {
            String filterDescriptionLowerCase = fileFilter.getDescription().toLowerCase();
            if (!filterDescriptionLowerCase.equals(exportTypeDescriptionLowerCase) && (!filterDescriptionLowerCase.contains(destinationExtensionLowerCase) || !filterDescriptionLowerCase.contains(exportTypeDescriptionLowerCase))) continue;
            return fileFilter;
        }
        return null;
    }

    public List<MindMap> getOpenMindMaps() {
        return this.getMapViewManager().getMaps().values().stream().distinct().map(m -> new MapProxy((MapModel)m, this.scriptContext)).collect(Collectors.toList());
    }

    @Override
    public Proxy.Loader mapLoader(File file) {
        return LoaderProxy.of(file, this.scriptContext);
    }

    public Proxy.Loader load(File file) {
        return this.mapLoader(file);
    }

    @Override
    public Proxy.Loader mapLoader(URL url) {
        return LoaderProxy.of(url, this.scriptContext);
    }

    public Proxy.Loader load(URL url) {
        return this.mapLoader(url);
    }

    public Proxy.Loader load(String file) {
        return this.mapLoader(file);
    }

    @Override
    public Proxy.Loader mapLoader(String fileOrContent) {
        return LoaderProxy.of(fileOrContent, this.scriptContext);
    }

    public Proxy.Loader mapLoader(InputStream inputStream) {
        return LoaderProxy.of(inputStream, this.scriptContext);
    }

    public Script script(File file) {
        return new FileScriptProxy(file, this.scriptContext);
    }

    public Script script(String script, String type) {
        return new StringScriptProxy(script, type, this.scriptContext);
    }

    public AttributeValueSerializer getAttributeValueSerializer() {
        return StaticAttributeValueSerializer.INSTANCE;
    }

    public ExecutorService getMainThreadExecutorService() {
        return Controller.getCurrentController().getMainThreadExecutorService();
    }
}

