﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/ivs/IVSRequest.h>
#include <aws/ivs/IVS_EXPORTS.h>

#include <utility>

namespace Aws {
namespace IVS {
namespace Model {

/**
 */
class BatchGetStreamKeyRequest : public IVSRequest {
 public:
  AWS_IVS_API BatchGetStreamKeyRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "BatchGetStreamKey"; }

  AWS_IVS_API Aws::String SerializePayload() const override;

  ///@{
  /**
   * <p>Array of ARNs, one per stream key.</p>
   */
  inline const Aws::Vector<Aws::String>& GetArns() const { return m_arns; }
  inline bool ArnsHasBeenSet() const { return m_arnsHasBeenSet; }
  template <typename ArnsT = Aws::Vector<Aws::String>>
  void SetArns(ArnsT&& value) {
    m_arnsHasBeenSet = true;
    m_arns = std::forward<ArnsT>(value);
  }
  template <typename ArnsT = Aws::Vector<Aws::String>>
  BatchGetStreamKeyRequest& WithArns(ArnsT&& value) {
    SetArns(std::forward<ArnsT>(value));
    return *this;
  }
  template <typename ArnsT = Aws::String>
  BatchGetStreamKeyRequest& AddArns(ArnsT&& value) {
    m_arnsHasBeenSet = true;
    m_arns.emplace_back(std::forward<ArnsT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Vector<Aws::String> m_arns;
  bool m_arnsHasBeenSet = false;
};

}  // namespace Model
}  // namespace IVS
}  // namespace Aws
