/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.observability.model;

import java.io.IOException;
import java.time.Instant;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.commons.utils.HelpersKt;
import org.opensearch.commons.utils.XContentHelpersKt;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.observability.model.BaseModel;
import org.opensearch.observability.model.BaseObjectData;
import org.opensearch.observability.model.ObservabilityObjectDataProperties;
import org.opensearch.observability.model.ObservabilityObjectType;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 72\u00020\u0001:\u00017BG\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0004\b\u000e\u0010\u000fB\u0011\b\u0016\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0004\b\u000e\u0010\u0012J\u0010\u0010\u001f\u001a\u00020 2\b\b\u0002\u0010!\u001a\u00020\"J\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0016J\u001c\u0010\u001f\u001a\u00020 2\b\u0010'\u001a\u0004\u0018\u00010 2\b\u0010!\u001a\u0004\u0018\u00010\"H\u0016J\t\u0010(\u001a\u00020\u0003H\u00c6\u0003J\t\u0010)\u001a\u00020\u0005H\u00c6\u0003J\t\u0010*\u001a\u00020\u0005H\u00c6\u0003J\t\u0010+\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00030\tH\u00c6\u0003J\t\u0010-\u001a\u00020\u000bH\u00c6\u0003J\u000b\u0010.\u001a\u0004\u0018\u00010\rH\u00c6\u0003JW\u0010/\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u00032\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\t2\b\b\u0002\u0010\n\u001a\u00020\u000b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\rH\u00c6\u0001J\u0013\u00100\u001a\u0002012\b\u00102\u001a\u0004\u0018\u000103H\u00d6\u0003J\t\u00104\u001a\u000205H\u00d6\u0001J\t\u00106\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0016R\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0014R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0013\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001e\u00a8\u00068"}, d2={"Lorg/opensearch/observability/model/ObservabilityObjectDoc;", "Lorg/opensearch/observability/model/BaseModel;", "objectId", "", "updatedTime", "Ljava/time/Instant;", "createdTime", "tenant", "access", "", "type", "Lorg/opensearch/observability/model/ObservabilityObjectType;", "objectData", "Lorg/opensearch/observability/model/BaseObjectData;", "<init>", "(Ljava/lang/String;Ljava/time/Instant;Ljava/time/Instant;Ljava/lang/String;Ljava/util/List;Lorg/opensearch/observability/model/ObservabilityObjectType;Lorg/opensearch/observability/model/BaseObjectData;)V", "input", "Lorg/opensearch/core/common/io/stream/StreamInput;", "(Lorg/opensearch/core/common/io/stream/StreamInput;)V", "getObjectId", "()Ljava/lang/String;", "getUpdatedTime", "()Ljava/time/Instant;", "getCreatedTime", "getTenant", "getAccess", "()Ljava/util/List;", "getType", "()Lorg/opensearch/observability/model/ObservabilityObjectType;", "getObjectData", "()Lorg/opensearch/observability/model/BaseObjectData;", "toXContent", "Lorg/opensearch/core/xcontent/XContentBuilder;", "params", "Lorg/opensearch/core/xcontent/ToXContent$Params;", "writeTo", "", "output", "Lorg/opensearch/core/common/io/stream/StreamOutput;", "builder", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "equals", "", "other", "", "hashCode", "", "toString", "Companion", "opensearch-observability"})
public final class ObservabilityObjectDoc
implements BaseModel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String objectId;
    @NotNull
    private final Instant updatedTime;
    @NotNull
    private final Instant createdTime;
    @NotNull
    private final String tenant;
    @NotNull
    private final List<String> access;
    @NotNull
    private final ObservabilityObjectType type;
    @Nullable
    private final BaseObjectData objectData;
    @NotNull
    private static final Lazy<Logger> log$delegate = HelpersKt.logger(ObservabilityObjectDoc.class);
    @NotNull
    private static final Writeable.Reader<ObservabilityObjectDoc> reader = ObservabilityObjectDoc::reader$lambda$0;

    public ObservabilityObjectDoc(@NotNull String objectId, @NotNull Instant updatedTime, @NotNull Instant createdTime, @NotNull String tenant, @NotNull List<String> access, @NotNull ObservabilityObjectType type, @Nullable BaseObjectData objectData) {
        Intrinsics.checkNotNullParameter((Object)objectId, (String)"objectId");
        Intrinsics.checkNotNullParameter((Object)updatedTime, (String)"updatedTime");
        Intrinsics.checkNotNullParameter((Object)createdTime, (String)"createdTime");
        Intrinsics.checkNotNullParameter((Object)tenant, (String)"tenant");
        Intrinsics.checkNotNullParameter(access, (String)"access");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        this.objectId = objectId;
        this.updatedTime = updatedTime;
        this.createdTime = createdTime;
        this.tenant = tenant;
        this.access = access;
        this.type = type;
        this.objectData = objectData;
    }

    @NotNull
    public final String getObjectId() {
        return this.objectId;
    }

    @NotNull
    public final Instant getUpdatedTime() {
        return this.updatedTime;
    }

    @NotNull
    public final Instant getCreatedTime() {
        return this.createdTime;
    }

    @NotNull
    public final String getTenant() {
        return this.tenant;
    }

    @NotNull
    public final List<String> getAccess() {
        return this.access;
    }

    @NotNull
    public final ObservabilityObjectType getType() {
        return this.type;
    }

    @Nullable
    public final BaseObjectData getObjectData() {
        return this.objectData;
    }

    @NotNull
    public final XContentBuilder toXContent(@NotNull ToXContent.Params params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        return this.toXContent(XContentFactory.jsonBuilder(), params);
    }

    public static /* synthetic */ XContentBuilder toXContent$default(ObservabilityObjectDoc observabilityObjectDoc, ToXContent.Params params, int n, Object object) {
        if ((n & 1) != 0) {
            ToXContent.Params params2 = ToXContent.EMPTY_PARAMS;
            Intrinsics.checkNotNullExpressionValue((Object)params2, (String)"EMPTY_PARAMS");
            params = params2;
        }
        return observabilityObjectDoc.toXContent(params);
    }

    public ObservabilityObjectDoc(@NotNull StreamInput input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        String string = input.readString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"readString(...)");
        Instant instant = input.readInstant();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"readInstant(...)");
        Instant instant2 = input.readInstant();
        Intrinsics.checkNotNullExpressionValue((Object)instant2, (String)"readInstant(...)");
        String string2 = input.readString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"readString(...)");
        List list = input.readStringList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"readStringList(...)");
        Enum enum_ = input.readEnum(ObservabilityObjectType.class);
        Intrinsics.checkNotNullExpressionValue((Object)enum_, (String)"readEnum(...)");
        ObservabilityObjectType observabilityObjectType = (ObservabilityObjectType)enum_;
        Enum enum_2 = input.readEnum(ObservabilityObjectType.class);
        Intrinsics.checkNotNullExpressionValue((Object)enum_2, (String)"readEnum(...)");
        this(string, instant, instant2, string2, list, observabilityObjectType, (BaseObjectData)input.readOptionalWriteable(ObservabilityObjectDataProperties.INSTANCE.getReaderForObjectType((ObservabilityObjectType)enum_2)));
    }

    public void writeTo(@NotNull StreamOutput output) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        output.writeString(this.objectId);
        output.writeInstant(this.updatedTime);
        output.writeInstant(this.createdTime);
        output.writeString(this.tenant);
        output.writeStringCollection((Collection)this.access);
        output.writeEnum((Enum)this.type);
        output.writeEnum((Enum)this.type);
        output.writeOptionalWriteable((Writeable)this.objectData);
    }

    @NotNull
    public XContentBuilder toXContent(@Nullable XContentBuilder builder, @Nullable ToXContent.Params params) {
        Intrinsics.checkNotNull((Object)builder);
        builder.startObject();
        ToXContent.Params params2 = params;
        boolean bl = params2 != null ? params2.paramAsBoolean("objectId", false) : false;
        if (bl) {
            builder.field("objectId", this.objectId);
        }
        builder.field("lastUpdatedTimeMs", this.updatedTime.toEpochMilli()).field("createdTimeMs", this.createdTime.toEpochMilli()).field("tenant", this.tenant);
        ToXContent.Params params3 = params;
        boolean bl2 = params3 != null ? params3.paramAsBoolean("access", true) : false;
        if (bl2 && !((Collection)this.access).isEmpty()) {
            builder.field("access", (Iterable)this.access);
        }
        builder.field(this.type.getTag(), (ToXContent)this.objectData).endObject();
        return builder;
    }

    @NotNull
    public final String component1() {
        return this.objectId;
    }

    @NotNull
    public final Instant component2() {
        return this.updatedTime;
    }

    @NotNull
    public final Instant component3() {
        return this.createdTime;
    }

    @NotNull
    public final String component4() {
        return this.tenant;
    }

    @NotNull
    public final List<String> component5() {
        return this.access;
    }

    @NotNull
    public final ObservabilityObjectType component6() {
        return this.type;
    }

    @Nullable
    public final BaseObjectData component7() {
        return this.objectData;
    }

    @NotNull
    public final ObservabilityObjectDoc copy(@NotNull String objectId, @NotNull Instant updatedTime, @NotNull Instant createdTime, @NotNull String tenant, @NotNull List<String> access, @NotNull ObservabilityObjectType type, @Nullable BaseObjectData objectData) {
        Intrinsics.checkNotNullParameter((Object)objectId, (String)"objectId");
        Intrinsics.checkNotNullParameter((Object)updatedTime, (String)"updatedTime");
        Intrinsics.checkNotNullParameter((Object)createdTime, (String)"createdTime");
        Intrinsics.checkNotNullParameter((Object)tenant, (String)"tenant");
        Intrinsics.checkNotNullParameter(access, (String)"access");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        return new ObservabilityObjectDoc(objectId, updatedTime, createdTime, tenant, access, type, objectData);
    }

    public static /* synthetic */ ObservabilityObjectDoc copy$default(ObservabilityObjectDoc observabilityObjectDoc, String string, Instant instant, Instant instant2, String string2, List list, ObservabilityObjectType observabilityObjectType, BaseObjectData baseObjectData, int n, Object object) {
        if ((n & 1) != 0) {
            string = observabilityObjectDoc.objectId;
        }
        if ((n & 2) != 0) {
            instant = observabilityObjectDoc.updatedTime;
        }
        if ((n & 4) != 0) {
            instant2 = observabilityObjectDoc.createdTime;
        }
        if ((n & 8) != 0) {
            string2 = observabilityObjectDoc.tenant;
        }
        if ((n & 0x10) != 0) {
            list = observabilityObjectDoc.access;
        }
        if ((n & 0x20) != 0) {
            observabilityObjectType = observabilityObjectDoc.type;
        }
        if ((n & 0x40) != 0) {
            baseObjectData = observabilityObjectDoc.objectData;
        }
        return observabilityObjectDoc.copy(string, instant, instant2, string2, list, observabilityObjectType, baseObjectData);
    }

    @NotNull
    public String toString() {
        return "ObservabilityObjectDoc(objectId=" + this.objectId + ", updatedTime=" + this.updatedTime + ", createdTime=" + this.createdTime + ", tenant=" + this.tenant + ", access=" + this.access + ", type=" + this.type + ", objectData=" + this.objectData + ")";
    }

    public int hashCode() {
        int result = this.objectId.hashCode();
        result = result * 31 + this.updatedTime.hashCode();
        result = result * 31 + this.createdTime.hashCode();
        result = result * 31 + this.tenant.hashCode();
        result = result * 31 + ((Object)this.access).hashCode();
        result = result * 31 + this.type.hashCode();
        result = result * 31 + (this.objectData == null ? 0 : this.objectData.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ObservabilityObjectDoc)) {
            return false;
        }
        ObservabilityObjectDoc observabilityObjectDoc = (ObservabilityObjectDoc)other;
        if (!Intrinsics.areEqual((Object)this.objectId, (Object)observabilityObjectDoc.objectId)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.updatedTime, (Object)observabilityObjectDoc.updatedTime)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.createdTime, (Object)observabilityObjectDoc.createdTime)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.tenant, (Object)observabilityObjectDoc.tenant)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.access, observabilityObjectDoc.access)) {
            return false;
        }
        if (this.type != observabilityObjectDoc.type) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.objectData, (Object)observabilityObjectDoc.objectData);
    }

    private static final ObservabilityObjectDoc reader$lambda$0(StreamInput it) {
        Intrinsics.checkNotNull((Object)it);
        return new ObservabilityObjectDoc(it);
    }

    @JvmStatic
    @NotNull
    public static final ObservabilityObjectDoc parse(@NotNull XContentParser parser, @Nullable String useId) throws IOException {
        return Companion.parse(parser, useId);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00122\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0007R\u001b\u0010\u0004\u001a\u00020\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007R\u001f\u0010\n\u001a\u0010\u0012\f\u0012\n \r*\u0004\u0018\u00010\f0\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0015"}, d2={"Lorg/opensearch/observability/model/ObservabilityObjectDoc$Companion;", "", "<init>", "()V", "log", "Lorg/apache/logging/log4j/Logger;", "getLog", "()Lorg/apache/logging/log4j/Logger;", "log$delegate", "Lkotlin/Lazy;", "reader", "Lorg/opensearch/core/common/io/stream/Writeable$Reader;", "Lorg/opensearch/observability/model/ObservabilityObjectDoc;", "kotlin.jvm.PlatformType", "getReader", "()Lorg/opensearch/core/common/io/stream/Writeable$Reader;", "parse", "parser", "Lorg/opensearch/core/xcontent/XContentParser;", "useId", "", "opensearch-observability"})
    public static final class Companion {
        private Companion() {
        }

        private final Logger getLog() {
            Lazy lazy = log$delegate;
            return (Logger)lazy.getValue();
        }

        @NotNull
        public final Writeable.Reader<ObservabilityObjectDoc> getReader() {
            return reader;
        }

        @JvmStatic
        @NotNull
        public final ObservabilityObjectDoc parse(@NotNull XContentParser parser, @Nullable String useId) throws IOException {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            String objectId = useId;
            Instant updatedTime = null;
            Instant createdTime = null;
            String tenant = null;
            List access = CollectionsKt.emptyList();
            ObservabilityObjectType type = null;
            BaseObjectData objectData = null;
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
            block14: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                String fieldName;
                block27: {
                    fieldName = parser.currentName();
                    parser.nextToken();
                    String string = fieldName;
                    if (string == null) break block27;
                    int n = -1;
                    switch (string.hashCode()) {
                        case -394530056: {
                            if (string.equals("lastUpdatedTimeMs")) {
                                n = 1;
                            }
                            break;
                        }
                        case -1423461020: {
                            if (string.equals("access")) {
                                n = 2;
                            }
                            break;
                        }
                        case 1643084379: {
                            if (string.equals("createdTimeMs")) {
                                n = 3;
                            }
                            break;
                        }
                        case 90495162: {
                            if (string.equals("objectId")) {
                                n = 4;
                            }
                            break;
                        }
                        case -877336406: {
                            if (string.equals("tenant")) {
                                n = 5;
                            }
                            break;
                        }
                    }
                    switch (n) {
                        case 4: {
                            objectId = parser.text();
                            continue block14;
                        }
                        case 1: {
                            updatedTime = Instant.ofEpochMilli(parser.longValue());
                            continue block14;
                        }
                        case 3: {
                            createdTime = Instant.ofEpochMilli(parser.longValue());
                            continue block14;
                        }
                        case 5: {
                            tenant = parser.text();
                            continue block14;
                        }
                        case 2: {
                            access = XContentHelpersKt.stringList((XContentParser)parser);
                            continue block14;
                        }
                    }
                }
                Intrinsics.checkNotNull((Object)fieldName);
                ObservabilityObjectType objectTypeForTag = ObservabilityObjectType.Companion.fromTagOrDefault(fieldName);
                if (objectTypeForTag != ObservabilityObjectType.NONE && objectData == null) {
                    objectData = ObservabilityObjectDataProperties.INSTANCE.createObjectData(objectTypeForTag, parser);
                    type = objectTypeForTag;
                    continue;
                }
                parser.skipChildren();
                this.getLog().info("Unexpected field: " + fieldName + ", while parsing ObservabilityObjectDoc");
            }
            if (objectId == null) {
                throw new IllegalArgumentException("objectId field absent");
            }
            if (updatedTime == null) {
                throw new IllegalArgumentException("lastUpdatedTimeMs field absent");
            }
            if (createdTime == null) {
                throw new IllegalArgumentException("createdTimeMs field absent");
            }
            String string = tenant;
            if (string == null) {
                string = tenant = "";
            }
            if (type == null) {
                throw new IllegalArgumentException("Object type field absent");
            }
            if (objectData == null) {
                throw new IllegalArgumentException("Object data field absent");
            }
            return new ObservabilityObjectDoc(objectId, updatedTime, createdTime, tenant, access, type, objectData);
        }

        public static /* synthetic */ ObservabilityObjectDoc parse$default(Companion companion, XContentParser xContentParser, String string, int n, Object object) throws IOException {
            if ((n & 2) != 0) {
                string = null;
            }
            return companion.parse(xContentParser, string);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

