/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.refresh;

import java.io.IOException;
import java.util.Objects;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentFragment;
import org.opensearch.core.xcontent.XContentBuilder;

@PublicApi(since="1.0.0")
public class RefreshStats
implements Writeable,
ToXContentFragment {
    private long total;
    private long totalTimeInMillis;
    private long externalTotal;
    private long externalTotalTimeInMillis;
    private int listeners;

    public RefreshStats() {
    }

    public RefreshStats(StreamInput in) throws IOException {
        this.total = in.readVLong();
        this.totalTimeInMillis = in.readVLong();
        this.externalTotal = in.readVLong();
        this.externalTotalTimeInMillis = in.readVLong();
        this.listeners = in.readVInt();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.total);
        out.writeVLong(this.totalTimeInMillis);
        out.writeVLong(this.externalTotal);
        out.writeVLong(this.externalTotalTimeInMillis);
        out.writeVInt(this.listeners);
    }

    @Deprecated
    public RefreshStats(long total, long totalTimeInMillis, long externalTotal, long externalTotalTimeInMillis, int listeners) {
        this.total = total;
        this.totalTimeInMillis = totalTimeInMillis;
        this.externalTotal = externalTotal;
        this.externalTotalTimeInMillis = externalTotalTimeInMillis;
        this.listeners = listeners;
    }

    public void add(RefreshStats refreshStats) {
        this.addTotals(refreshStats);
    }

    public void addTotals(RefreshStats refreshStats) {
        if (refreshStats == null) {
            return;
        }
        this.total += refreshStats.total;
        this.totalTimeInMillis += refreshStats.totalTimeInMillis;
        this.externalTotal += refreshStats.externalTotal;
        this.externalTotalTimeInMillis += refreshStats.externalTotalTimeInMillis;
        this.listeners += refreshStats.listeners;
    }

    public long getTotal() {
        return this.total;
    }

    public long getExternalTotal() {
        return this.externalTotal;
    }

    public long getTotalTimeInMillis() {
        return this.totalTimeInMillis;
    }

    public long getExternalTotalTimeInMillis() {
        return this.externalTotalTimeInMillis;
    }

    public TimeValue getTotalTime() {
        return new TimeValue(this.totalTimeInMillis);
    }

    public TimeValue getExternalTotalTime() {
        return new TimeValue(this.externalTotalTimeInMillis);
    }

    public int getListeners() {
        return this.listeners;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("refresh");
        builder.field("total", this.total);
        builder.humanReadableField("total_time_in_millis", "total_time", (Object)this.getTotalTime());
        builder.field("external_total", this.externalTotal);
        builder.humanReadableField("external_total_time_in_millis", "external_total_time", (Object)this.getExternalTotalTime());
        builder.field("listeners", this.listeners);
        builder.endObject();
        return builder;
    }

    private RefreshStats(Builder builder) {
        this.total = builder.total;
        this.totalTimeInMillis = builder.totalTimeInMillis;
        this.externalTotal = builder.externalTotal;
        this.externalTotalTimeInMillis = builder.externalTotalTimeInMillis;
        this.listeners = builder.listeners;
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != RefreshStats.class) {
            return false;
        }
        RefreshStats rhs = (RefreshStats)obj;
        return this.total == rhs.total && this.totalTimeInMillis == rhs.totalTimeInMillis && this.externalTotal == rhs.externalTotal && this.externalTotalTimeInMillis == rhs.externalTotalTimeInMillis && this.listeners == rhs.listeners;
    }

    public int hashCode() {
        return Objects.hash(this.total, this.totalTimeInMillis, this.externalTotal, this.externalTotalTimeInMillis, this.listeners);
    }

    public static class Builder {
        private long total = 0L;
        private long totalTimeInMillis = 0L;
        private long externalTotal = 0L;
        private long externalTotalTimeInMillis = 0L;
        private int listeners = 0;

        public Builder total(long total) {
            this.total = total;
            return this;
        }

        public Builder totalTimeInMillis(long time) {
            this.totalTimeInMillis = time;
            return this;
        }

        public Builder externalTotal(long total) {
            this.externalTotal = total;
            return this;
        }

        public Builder externalTotalTimeInMillis(long time) {
            this.externalTotalTimeInMillis = time;
            return this;
        }

        public Builder listeners(int listeners) {
            this.listeners = listeners;
            return this;
        }

        public RefreshStats build() {
            return new RefreshStats(this);
        }
    }
}

