/*
 * Copyright (C) 2023, KylinSoft Co., Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
**/
#ifndef THEMEICONLABEL_H
#define THEMEICONLABEL_H

#include <QObject>
#include <QWidget>
#include <QLabel>

#include "drawiconlabel.h"

class ThemeIconLabel : public QLabel
{
    Q_OBJECT
public:
    ThemeIconLabel(QWidget *parent = nullptr);
    ThemeIconLabel(const QPixmap &pixmap, QWidget *parent = nullptr);
    ThemeIconLabel(QStringList iStringList, QWidget *parent = nullptr);
    ThemeIconLabel(QList<QPixmap> iconList, QWidget *parent = nullptr);

    QPixmap pixmapToRound(const QString &filePath, const QSize &scaledSize);
    QPixmap pixmapToRound(const QPixmap &pixmap, const QSize &scaledSize);
    void setRadius(int radius);
    void setIcon(const QPixmap &pixmap);

protected:
    void leaveEvent(QEvent * event);
    void enterEvent(QEvent * event);

private:
    DrawIconLabel *mPictrueLabel = nullptr;
    QStringList mIconList;
    int mRadius = 10;

Q_SIGNALS:
    void enterWidget();
    void leaveWidget();
};

#endif // THEMEICONLABEL_H
