// Copyright (C) 2016 The Qt Company Ltd.
// SPDX-License-Identifier: LicenseRef-Qt-Commercial OR GPL-3.0-only

import QtQuick 2.0
import QtCharts 2.0

ChartView {
    id: chartView
    title: "chart axes"

    ValueAxis {
        id: valueAxisX
        min: 0
        max: 10
    }
    ValueAxis {
        id: valueAxisY
        min: 0
        max: 5
    }

    LineSeries {
        name: "line series"
        XYPoint { x: 0; y: 0 }
        XYPoint { x: 1; y: 1 }
        XYPoint { x: 2; y: 2 }
        XYPoint { x: 3; y: 3 }
        XYPoint { x: 4; y: 4 }
        axisX: valueAxisX
        axisY: valueAxisY
    }

    ScatterSeries {
        name: "scatter series"
        XYPoint { x: 0; y: 0 }
        XYPoint { x: 0.5; y: 1 }
        XYPoint { x: 1; y: 2 }
        XYPoint { x: 1.5; y: 3 }
        XYPoint { x: 2; y: 4 }
        XYPoint { x: 1; y: 1 }
        XYPoint { x: 2; y: 2 }
        XYPoint { x: 3; y: 3 }
        XYPoint { x: 4; y: 4 }
        axisX: valueAxisX
        axisY: valueAxisY
    }

//    Component.onCompleted: {
//        // You can also set the axes dynamically
//        chartView.setAxisX(axisX, scatter);
//    }
}
