## RabbitMQ 3.8.24

RabbitMQ `3.8.24` is a maintenance release.
All users are recommended to upgrade to this release.

### Obtaining Packages

RabbitMQ releases are distributed via [GitHub](https://github.com/rabbitmq/rabbitmq-server/releases), [Cloudsmith](https://cloudsmith.io/~rabbitmq/repos/),
and [PackageCloud](https://packagecloud.io/rabbitmq).

### Erlang/OTP Compatibility Notes

This release [requires Erlang 23.2](https://www.rabbitmq.com/which-erlang.html) and [supports Erlang 24](https://blog.rabbitmq.com/posts/2021/03/erlang-24-support-roadmap/).

[Provisioning Latest Erlang Releases](https://www.rabbitmq.com/which-erlang.html#erlang-repositories) explains
what package repositories and tools can be used to provision modern Erlang versions.


## Upgrade and Compatibility Notes

See the [Upgrading guide](https://www.rabbitmq.com/upgrade.html) for general documentation on upgrades and
[RabbitMQ change log](https://www.rabbitmq.com/changelog.html) for release notes of other releases.

If upgrading from a`3.7.x` release, see [3.8.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.8.0)
upgrade and compatibility notes first.

If upgrading from a `3.6.x` or older [release series](https://www.rabbitmq.com/versions.html), first upgrade
to [`3.7.27`](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.7.27) and then to this version.


## Getting Help

Any questions about this release, upgrades or RabbitMQ in general are welcome on the [RabbitMQ mailing list](https://groups.google.com/forum/#!forum/rabbitmq-users)
and [RabbitMQ community Slack](https://rabbitmq-slack.herokuapp.com/).


## Changes Worth Mentioning

Release notes are kept under [rabbitmq-server/release-notes](https://github.com/rabbitmq/rabbitmq-server/tree/v3.8.x/release-notes).
Contributors are encouraged to update them together with their changes.  This helps with release automation and more
consistent release schedule.


### Core Server

#### Bug Fixes

 * Fixed an issue where node monitor could produce a false network partition when
   one of the cluster members was restarted

   GitHub issue: [#3631](https://github.com/rabbitmq/rabbitmq-server/pull/3631)

* `rabbitmq-diagnostics memory_breakdown` failed to read memory of connection
  reader, writer and channel processes.

   GitHub issue: [#3570](https://github.com/rabbitmq/rabbitmq-server/issues/3570)

 * Queue leader rebalancing now logs less

   GitHub issue: [#3643](https://github.com/rabbitmq/rabbitmq-server/pull/3643)

 * Removed some redundant code

   Contributed by @Ayanda-D

   GitHub issue: [#https://github.com/rabbitmq/rabbitmq-server/pull/3506](https://github.com/rabbitmq/rabbitmq-server/pull/3506)

 * Info message grammar

   Contributed by @tuxiqae

   GitHub issue: [#3680](https://github.com/rabbitmq/rabbitmq-server/pull/3680)

#### Enhancements

 * `cluster_formation.target_cluster_size_hint` is a new configuration setting that can be used to specify expected initial cluster size.
   This can be used by features, plugins or tools that expect a certain minimum number of clusters nodes
   to join during initial cluster formation

   GitHub issue: [#3635](https://github.com/rabbitmq/rabbitmq-server/pull/3635)


### Prometheus Plugin

#### Bug Fixes

 * TLS-enabled Prometheus endpoint listener port was not correctly stored internally

   GitHub issue: [#2975](https://github.com/rabbitmq/rabbitmq-server/issues/2975)


### Management Plugin

#### Bug Fixes

 * Persistent message count is now displayed correctly on individual queue pages

   GitHub issue: [#3598](https://github.com/rabbitmq/rabbitmq-server/pull/3598)

 * When setting topic permissions, the list of exchanges in the UI now honors the
   currently selected virtual host.

   Contributed by @LuisCusihuaman.

   GitHub issues: [#3545](https://github.com/rabbitmq/rabbitmq-server/pull/3545), [#3689](https://github.com/rabbitmq/rabbitmq-server/pull/3689)


### AWS Peer Discovery Plugin

#### Enhancements

 * The plugin now logs more details for failed AWS API requests.

   Contributed by @tvhong-amazon (AWS)

   GitHub issue: [#3579](https://github.com/rabbitmq/rabbitmq-server/pull/3579)


### Consistent Hashing Exchange Plugin

#### Bug Fixes

 * Corrected deletion of duplicate bindings between an exchange and a queue

   Contributed by @FalconerTC

   GitHub issue: [#3594](https://github.com/rabbitmq/rabbitmq-server/pull/3594)


## Dependency Upgrades

 None in this release.


## Source Code Archives

To obtain source code of the entire distribution, please download the archive named `rabbitmq-server-3.8.24.tar.xz`
instead of the source tarball produced by GitHub.

