// Copyright John Maddock 2019.

// Use, modification and distribution are subject to the
// Boost Software License, Version 1.0.
// (See accompanying file LICENSE_1_0.txt
// or copy at http://www.boost.org/LICENSE_1_0.txt)

#ifndef SC_
#  define SC_(x) static_cast<T>(BOOST_JOIN(x, L))
#endif
   static const std::array<std::array<T, 4>, 1280> hypergeometric_2F0_integer_a2 = {{
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(-1.0672900060657104357920671728509291419998e+23) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(-7.3767594514781772314601935827275945493626e+22) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(-9.5092070569484559766150370105508596918823e+20) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(2.5177888870239257812500000000000000000000e+00), SC_(5.2174486913739279808251116901253159504247e+22) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(2.6800680160522460937500000000000000000000e+00), SC_(1.2652476435582852324450311941587499913699e+23) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(3.2463350296020507812500000000000000000000e+00), SC_(1.9492297788193122811816725603041387758467e+24) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+00), SC_(2.5416706034685042902352447049436372084120e+24) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(3.7509422302246093750000000000000000000000e+00), SC_(1.5538774675693139736174911420140527243183e+25) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(1.8884900991760422589670576028653106986274e+19) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(1.4164454455294844877096811983049115847036e+19) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(4.8945496364852070534701282070132162437227e+17) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(2.5177888870239257812500000000000000000000e+00), SC_(6.5014699496890839951235223735579618515875e+18) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(2.6800680160522460937500000000000000000000e+00), SC_(1.3357189592912487554315796346218304264309e+19) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(3.2463350296020507812500000000000000000000e+00), SC_(1.2293923093065599369879451350041333365521e+20) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+00), SC_(1.5245120015742543962437164119932506535222e+20) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(3.7509422302246093750000000000000000000000e+00), SC_(6.6088879563133865210670390979260896485479e+20) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(-8.8425953060420154833993411272730660678487e+14) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(-7.1436549989491750035605952961778943138806e+14) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(-5.9174606417364359388105484910213013262885e+13) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(2.5177888870239257812500000000000000000000e+00), SC_(3.3128850525298189096012340253923946489170e+14) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(2.6800680160522460937500000000000000000000e+00), SC_(5.7133634218586130111595810716488098772144e+14) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(3.2463350296020507812500000000000000000000e+00), SC_(3.0608106964521241025041805687473523741140e+15) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(3.3070068359375000000000000000000000000000e+00), SC_(3.6011666793537281532382569594050661142388e+15) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(3.7509422302246093750000000000000000000000e+00), SC_(1.0903317443468622432096318575132408931104e+16) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(1.7199394384674321435196867758494034592216e+10) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(1.4932067012711910484527732333733778684455e+10) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(2.8717530740687748540092889759692870664006e+09) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(2.5177888870239257812500000000000000000000e+00), SC_(8.3111645382990916866665153024848740352576e+09) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(2.6800680160522460937500000000000000000000e+00), SC_(1.1977838588295361834821965872277174858023e+10) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(3.2463350296020507812500000000000000000000e+00), SC_(3.6887766872259548183263337516867350074741e+10) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(3.3070068359375000000000000000000000000000e+00), SC_(4.1131688580795421950193615488102514486353e+10) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(3.7509422302246093750000000000000000000000e+00), SC_(8.6365715048400112779561671093235137461263e+10) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(-1.7178670442609116002846691984018434595782e+05) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(-1.6010863537374455557187741261415681037761e+05) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(-7.0484076398515507758446574371191672980785e+04) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(2.5177888870239257812500000000000000000000e+00), SC_(1.1655152160343470960626038879226484823448e+05) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(2.6800680160522460937500000000000000000000e+00), SC_(1.4002219122542500406231741338913820982270e+05) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(3.2463350296020507812500000000000000000000e+00), SC_(2.4622080358103474464361720697169744198618e+05) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(3.3070068359375000000000000000000000000000e+00), SC_(2.6004496991143650666344910860061645507812e+05) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(3.7509422302246093750000000000000000000000e+00), SC_(3.7724044924527436003858227309137873817235e+05) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.5177888870239257812500000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.6800680160522460937500000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(3.2463350296020507812500000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(3.3070068359375000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(3.7509422302246093750000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(3.0000000000000000000000000000000000000000e+00), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(2.3890772190925794881275415673736197596685e+30) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(3.0000000000000000000000000000000000000000e+00), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(1.5181748075490782073023158911807338590051e+30) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(3.0000000000000000000000000000000000000000e+00), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(7.9304127413141013812334302076852562622405e+27) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(3.0000000000000000000000000000000000000000e+00), SC_(2.5177888870239257812500000000000000000000e+00), SC_(4.1037415454609171633490749025646517305767e+28) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(3.0000000000000000000000000000000000000000e+00), SC_(2.6800680160522460937500000000000000000000e+00), SC_(1.4629198425814948400624644474656627330173e+29) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(3.0000000000000000000000000000000000000000e+00), SC_(3.2463350296020507812500000000000000000000e+00), SC_(7.1763700168118797942488815220389096914382e+30) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(3.0000000000000000000000000000000000000000e+00), SC_(3.3070068359375000000000000000000000000000e+00), SC_(1.0446578848646069490260635802626980236262e+31) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(3.0000000000000000000000000000000000000000e+00), SC_(3.7509422302246093750000000000000000000000e+00), SC_(1.3403763034125768365592135033817556878579e+32) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(6.0000000000000000000000000000000000000000e+00), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(5.2968139152702595033102024008381258529992e+32) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(6.0000000000000000000000000000000000000000e+00), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(3.3630504236487760687190688247647087194233e+32) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(6.0000000000000000000000000000000000000000e+00), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(1.7365020171692787237588845002800405027759e+30) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(6.0000000000000000000000000000000000000000e+00), SC_(2.5177888870239257812500000000000000000000e+00), SC_(9.8544308186795481890112118685617949895685e+30) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(6.0000000000000000000000000000000000000000e+00), SC_(2.6800680160522460937500000000000000000000e+00), SC_(3.5038350639778647491966806094814596903981e+31) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(6.0000000000000000000000000000000000000000e+00), SC_(3.2463350296020507812500000000000000000000e+00), SC_(1.7067527667648541479543799963908396732607e+33) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(6.0000000000000000000000000000000000000000e+00), SC_(3.3070068359375000000000000000000000000000e+00), SC_(2.4829854276027542127234667935294446548330e+33) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(6.0000000000000000000000000000000000000000e+00), SC_(3.7509422302246093750000000000000000000000e+00), SC_(3.1735351232990849332774892567600079206781e+34) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(-2.1197212666819179394135452446098611321245e+22) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(-1.4539416516868942855041278321479563736256e+22) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(-1.6595551368709076890003455433369158176035e+20) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(2.5177888870239257812500000000000000000000e+00), SC_(1.5234419320772491884534550273853392557685e+22) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(2.6800680160522460937500000000000000000000e+00), SC_(3.6665983480316798461433551643497113958719e+22) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(3.2463350296020507812500000000000000000000e+00), SC_(5.5292305178196846684518487746503856720986e+23) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+00), SC_(7.1958910964877519929923344518453912849664e+23) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(3.7509422302246093750000000000000000000000e+00), SC_(4.3447644405363319664135149995199093894148e+24) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(7.0948380541487757594304538642184031914390e+18) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(5.3126457032598771369599709627106538952776e+18) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(1.7935584841924073684603596233049220671104e+17) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(2.5177888870239257812500000000000000000000e+00), SC_(2.7586171173003250174330933925786585778011e+18) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(2.6800680160522460937500000000000000000000e+00), SC_(5.6493592629630533176119027509082648572253e+18) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(3.2463350296020507812500000000000000000000e+00), SC_(5.1535583068451148725024850986312292979275e+19) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+00), SC_(6.3856533589456825155959479453192585863800e+19) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(3.7509422302246093750000000000000000000000e+00), SC_(2.7542995663582155967363045264169994320292e+20) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(-4.7469713620338047222388136199304351460919e+14) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(-3.8326282378548304135457487385581083457463e+14) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(-3.1486452769458411066850420058427817788565e+13) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(2.5177888870239257812500000000000000000000e+00), SC_(1.8689639686905973193424107859624134883897e+14) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(2.6800680160522460937500000000000000000000e+00), SC_(3.2185256010145044439729609822476460665912e+14) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(3.2463350296020507812500000000000000000000e+00), SC_(1.7174125500013067516626409618345216126687e+15) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(3.3070068359375000000000000000000000000000e+00), SC_(2.0198996106525987574835232232247522180940e+15) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(3.7509422302246093750000000000000000000000e+00), SC_(6.1020949847703382322270127398387185522291e+15) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(1.1920797779650723709901618608277208089137e+10) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(1.0346849604378560080326162261308875253305e+10) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(1.9834318661050857131524598328360620150452e+09) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(2.5177888870239257812500000000000000000000e+00), SC_(5.8816325347061498465302240573572304328418e+09) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(2.6800680160522460937500000000000000000000e+00), SC_(8.4710637615618822497196099916233443812619e+09) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(3.2463350296020507812500000000000000000000e+00), SC_(2.6042762110610740763271040449728150406821e+10) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(3.3070068359375000000000000000000000000000e+00), SC_(2.9034558461735384872364911492023928620758e+10) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(3.7509422302246093750000000000000000000000e+00), SC_(6.0906053618290840545790191669300172421503e+10) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(-1.4552887472554553965954637906321522677899e+05) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(-1.3562495167288239232663248079457929406999e+05) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(-5.9640810643719621807257169621152570471168e+04) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(2.5177888870239257812500000000000000000000e+00), SC_(9.9445387966380053917382284001114101101848e+04) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(2.6800680160522460937500000000000000000000e+00), SC_(1.1944451053023554160779397259606326997528e+05) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(3.2463350296020507812500000000000000000000e+00), SC_(2.0990801644814916208332637725941793860329e+05) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(3.3070068359375000000000000000000000000000e+00), SC_(2.2168158523587408490129746496677398681641e+05) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(3.7509422302246093750000000000000000000000e+00), SC_(3.2147900286589004857840112805433818721212e+05) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.5177888870239257812500000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.6800680160522460937500000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(3.2463350296020507812500000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(3.3070068359375000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(3.7509422302246093750000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(3.0000000000000000000000000000000000000000e+00), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(3.6337413187553893186818377242390636750560e+28) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(3.0000000000000000000000000000000000000000e+00), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(2.3628152109116313320195195350680208032410e+28) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(3.0000000000000000000000000000000000000000e+00), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(1.6120293427488784952904349587630016684180e+26) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(3.0000000000000000000000000000000000000000e+00), SC_(2.5177888870239257812500000000000000000000e+00), SC_(-7.4211660117922750457771894702978187388289e+26) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(3.0000000000000000000000000000000000000000e+00), SC_(2.6800680160522460937500000000000000000000e+00), SC_(-2.4850917354729490995628959409046908403374e+27) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(3.0000000000000000000000000000000000000000e+00), SC_(3.2463350296020507812500000000000000000000e+00), SC_(-1.0061444787579566243530561665986000685701e+29) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(3.0000000000000000000000000000000000000000e+00), SC_(3.3070068359375000000000000000000000000000e+00), SC_(-1.4377305680701183308035968315165540893677e+29) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(3.0000000000000000000000000000000000000000e+00), SC_(3.7509422302246093750000000000000000000000e+00), SC_(-1.6261447999295862862174117892440503252622e+30) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(6.0000000000000000000000000000000000000000e+00), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(7.0800327863510271685009860890737358795844e+30) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(6.0000000000000000000000000000000000000000e+00), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(4.5996455652437892702652993087838328500082e+30) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(6.0000000000000000000000000000000000000000e+00), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(3.1006320792939224099868570482967482543462e+28) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(6.0000000000000000000000000000000000000000e+00), SC_(2.5177888870239257812500000000000000000000e+00), SC_(-1.5706973790668019185627492882159974068484e+29) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(6.0000000000000000000000000000000000000000e+00), SC_(2.6800680160522460937500000000000000000000e+00), SC_(-5.2455748915629972067026323802104095972936e+29) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(6.0000000000000000000000000000000000000000e+00), SC_(3.2463350296020507812500000000000000000000e+00), SC_(-2.1083454967908188478909260277139372689909e+31) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(6.0000000000000000000000000000000000000000e+00), SC_(3.3070068359375000000000000000000000000000e+00), SC_(-3.0108110553918489381466357714413941130376e+31) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(6.0000000000000000000000000000000000000000e+00), SC_(3.7509422302246093750000000000000000000000e+00), SC_(-3.3917204022895913202545253805545432040527e+32) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(-2.9540211390731046003691198967977852992525e+21) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(-1.9919739001454179993734628997615881652883e+21) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(-1.6425906032269556059972105430678025647491e+19) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(2.5177888870239257812500000000000000000000e+00), SC_(3.9794372384790110021755198598264298962383e+21) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(2.6800680160522460937500000000000000000000e+00), SC_(9.4838146760652890773833267573315896184535e+21) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(3.2463350296020507812500000000000000000000e+00), SC_(1.3904263594308235731939212778260923987698e+23) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+00), SC_(1.8049118249671399204204530402196870506825e+23) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(3.7509422302246093750000000000000000000000e+00), SC_(1.0717567007315120352253376575666430859918e+24) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(2.4059428070888683984095411519870385896157e+18) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(1.7975322205806643076710517369050553753277e+18) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(5.8765299246310131558450722948683102787145e+16) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(2.5177888870239257812500000000000000000000e+00), SC_(1.0945728016125955883400326407522991192498e+18) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(2.6800680160522460937500000000000000000000e+00), SC_(2.2327104181091771267766408215506901626124e+18) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(3.2463350296020507812500000000000000000000e+00), SC_(2.0144433591382697183810850194949102207591e+19) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+00), SC_(2.4936090581312929409118041210208478009637e+19) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(3.7509422302246093750000000000000000000000e+00), SC_(1.0688278419775017500680510619019153314274e+20) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(-2.4261702248750223601679589424045720583961e+14) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(-1.9574150251015815853330581065909939850979e+14) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(-1.5918838252441348319666765095264478667163e+13) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(2.5177888870239257812500000000000000000000e+00), SC_(1.0138488124696733092431506455613334566825e+14) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(2.6800680160522460937500000000000000000000e+00), SC_(1.7429548431429961796296742129044011779147e+14) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(3.2463350296020507812500000000000000000000e+00), SC_(9.2568133861214699683089623535405090068922e+14) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(3.3070068359375000000000000000000000000000e+00), SC_(1.0882711938684146053552142101389405975592e+15) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(3.7509422302246093750000000000000000000000e+00), SC_(3.2789975905793376654986669078233554052745e+15) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(8.0632351220531174286428855417299010610552e+09) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(6.9966689656486472114452158413733206195331e+09) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(1.3361353846527284127498210897564432167025e+09) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(2.5177888870239257812500000000000000000000e+00), SC_(4.0750615590365665358448097814823081763601e+09) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(2.6800680160522460937500000000000000000000e+00), SC_(5.8648575664362734138725088802305816709482e+09) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(3.2463350296020507812500000000000000000000e+00), SC_(1.7994557853788660752716447079144529719068e+10) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(3.3070068359375000000000000000000000000000e+00), SC_(2.0058278419643526737847808006021302527845e+10) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(3.7509422302246093750000000000000000000000e+00), SC_(4.2029801823139769682341981176091440979034e+10) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(-1.2208751408345982403313989550497353775427e+05) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(-1.1376860172454009278311670705363667366328e+05) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(-4.9968120176567392562105851538944989442825e+04) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(2.5177888870239257812500000000000000000000e+00), SC_(8.4101069318825943145784274079801434709225e+04) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(2.6800680160522460937500000000000000000000e+00), SC_(1.0098895856247906136779479702170192467747e+05) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(3.2463350296020507812500000000000000000000e+00), SC_(1.7735337065565355421528637158701258158544e+05) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(3.3070068359375000000000000000000000000000e+00), SC_(1.8728978949556610314175486564636230468750e+05) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(3.7509422302246093750000000000000000000000e+00), SC_(2.7150158050741817319639892502891598269343e+05) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.5177888870239257812500000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.6800680160522460937500000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(3.2463350296020507812500000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(3.3070068359375000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(3.7509422302246093750000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(3.0000000000000000000000000000000000000000e+00), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(5.7891770625719724622950757267801971310079e+26) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(3.0000000000000000000000000000000000000000e+00), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(3.8519018109109840159603715012497309287247e+26) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(3.0000000000000000000000000000000000000000e+00), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(3.4321539437434988029596090305909016090113e+24) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(3.0000000000000000000000000000000000000000e+00), SC_(2.5177888870239257812500000000000000000000e+00), SC_(1.4061786098460810785453379592103861089430e+25) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(3.0000000000000000000000000000000000000000e+00), SC_(2.6800680160522460937500000000000000000000e+00), SC_(4.4231962570823453779674054822129189268373e+25) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(3.0000000000000000000000000000000000000000e+00), SC_(3.2463350296020507812500000000000000000000e+00), SC_(1.4780054908001147677197175795780444595343e+27) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(3.0000000000000000000000000000000000000000e+00), SC_(3.3070068359375000000000000000000000000000e+00), SC_(2.0731946449082442629983994329941700746241e+27) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(3.0000000000000000000000000000000000000000e+00), SC_(3.7509422302246093750000000000000000000000e+00), SC_(2.0670184427462884994978955220771563796926e+28) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(6.0000000000000000000000000000000000000000e+00), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(9.8554781630809154174957628456332915193117e+28) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(6.0000000000000000000000000000000000000000e+00), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(6.5514089622693984415352684255105428690425e+28) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(6.0000000000000000000000000000000000000000e+00), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(5.7651468376475906145712626127046909756491e+26) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(6.0000000000000000000000000000000000000000e+00), SC_(2.5177888870239257812500000000000000000000e+00), SC_(2.6085867079091395790801128400839110805955e+27) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(6.0000000000000000000000000000000000000000e+00), SC_(2.6800680160522460937500000000000000000000e+00), SC_(8.1825181247864736873543169500154977783356e+27) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(6.0000000000000000000000000000000000000000e+00), SC_(3.2463350296020507812500000000000000000000e+00), SC_(2.7135477223908285857802554749125775322010e+29) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(6.0000000000000000000000000000000000000000e+00), SC_(3.3070068359375000000000000000000000000000e+00), SC_(3.8037819740935109506358676888224218774648e+29) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(6.0000000000000000000000000000000000000000e+00), SC_(3.7509422302246093750000000000000000000000e+00), SC_(3.7766657793609874944603325218388812348282e+30) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(-1.5270059066002726763505540439783111511998e+20) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(-9.2957220454093964459995581431588053257490e+19) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(9.8466726720318720685712933110038822849852e+17) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(2.5177888870239257812500000000000000000000e+00), SC_(9.1158315011517211685346410430080709597556e+20) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(2.6800680160522460937500000000000000000000e+00), SC_(2.1440992735839987548060682397447633755703e+21) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(3.2463350296020507812500000000000000000000e+00), SC_(3.0256638789550068173998727428293642931247e+22) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+00), SC_(3.9138356925188606476697946522176777600879e+22) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(3.7509422302246093750000000000000000000000e+00), SC_(2.2710293998711315209898835510194053110363e+23) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(7.1468706114252561860737728659352735901683e+17) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(5.3221179224640588811434969457315031041018e+17) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(1.6586509839428713966908211650458136373918e+16) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(2.5177888870239257812500000000000000000000e+00), SC_(4.0157509774452369925952305549331100010144e+17) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(2.6800680160522460937500000000000000000000e+00), SC_(8.1506106257660547370532029862532555745875e+17) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(3.2463350296020507812500000000000000000000e+00), SC_(7.2520178417972029373092036192565867250939e+18) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+00), SC_(8.9658682234624992672692164856739488680041e+18) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(3.7509422302246093750000000000000000000000e+00), SC_(3.8123962638935916136025759537076119459117e+19) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(-1.1698784053867612291386019371478604996687e+14) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(-9.4298325899745854428002312218437881567130e+13) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(-7.5718864035309652524310670842324397425755e+12) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(2.5177888870239257812500000000000000000000e+00), SC_(5.2579270683488520541155468674375445322502e+13) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(2.6800680160522460937500000000000000000000e+00), SC_(9.0206476216288915673446670644403332601003e+13) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(3.2463350296020507812500000000000000000000e+00), SC_(4.7638981531174304763169306934253688558934e+14) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(3.3070068359375000000000000000000000000000e+00), SC_(5.5978634603558175785590557121689721955983e+14) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(3.7509422302246093750000000000000000000000e+00), SC_(1.6813119543561923995978751021332851702883e+15) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(5.3036732518230737291962472272260196519066e+09) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(4.6006224599792875528103088233746128036630e+09) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(8.7464343522154695458719746263835268261820e+08) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(2.5177888870239257812500000000000000000000e+00), SC_(2.7565700847651541411062843797298781975362e+09) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(2.6800680160522460937500000000000000000000e+00), SC_(3.9639295064296155197281357665156225853766e+09) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(3.2463350296020507812500000000000000000000e+00), SC_(1.2134103361119912809367479094636130415966e+10) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(3.3070068359375000000000000000000000000000e+00), SC_(1.3522981256800269659252116758847363811548e+10) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(3.7509422302246093750000000000000000000000e+00), SC_(2.8299445809696552869221056146254394495575e+10) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(-1.0130318370025281959334595427435488090850e+05) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(-9.4390787831932327648351566118378741521155e+04) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(-4.1399312833940493213447098241886124014854e+04) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(2.5177888870239257812500000000000000000000e+00), SC_(7.0422800137204442966806783310573791823117e+04) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(2.6800680160522460937500000000000000000000e+00), SC_(8.4540033536599508626765975272121522721136e+04) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(3.2463350296020507812500000000000000000000e+00), SC_(1.4835159347056772956145731523491804182413e+05) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(3.3070068359375000000000000000000000000000e+00), SC_(1.5665258429218051605857908725738525390625e+05) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(3.7509422302246093750000000000000000000000e+00), SC_(2.2699153735790175934372570054620155133307e+05) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.5177888870239257812500000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.6800680160522460937500000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(3.2463350296020507812500000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(3.3070068359375000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(3.7509422302246093750000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(3.0000000000000000000000000000000000000000e+00), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(9.6826523857727701129033647423030889685823e+24) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(3.0000000000000000000000000000000000000000e+00), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(6.5922483770689155744990888338073380853132e+24) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(3.0000000000000000000000000000000000000000e+00), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(7.6709531950964576015674651043591630312394e+22) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(3.0000000000000000000000000000000000000000e+00), SC_(2.5177888870239257812500000000000000000000e+00), SC_(-2.7982231120839007189128965707918914631676e+23) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(3.0000000000000000000000000000000000000000e+00), SC_(2.6800680160522460937500000000000000000000e+00), SC_(-8.2679631358261640076913831310741233305862e+23) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(3.0000000000000000000000000000000000000000e+00), SC_(3.2463350296020507812500000000000000000000e+00), SC_(-2.2800624587188239956397748878201894853811e+25) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(3.0000000000000000000000000000000000000000e+00), SC_(3.3070068359375000000000000000000000000000e+00), SC_(-3.1394709322766317822046257078617868043121e+25) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(3.0000000000000000000000000000000000000000e+00), SC_(3.7509422302246093750000000000000000000000e+00), SC_(-2.7591531271211559793753267987222039787485e+26) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(6.0000000000000000000000000000000000000000e+00), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(1.4311397576938669613751622759572764392267e+27) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(6.0000000000000000000000000000000000000000e+00), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(9.7342859520620909966726315225795759521022e+26) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(6.0000000000000000000000000000000000000000e+00), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(1.1181259299624590025999636983495445453098e+25) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(6.0000000000000000000000000000000000000000e+00), SC_(2.5177888870239257812500000000000000000000e+00), SC_(-4.5221107581616040485071965391326986451045e+25) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(6.0000000000000000000000000000000000000000e+00), SC_(2.6800680160522460937500000000000000000000e+00), SC_(-1.3322805479393543845252955084841511951029e+26) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(6.0000000000000000000000000000000000000000e+00), SC_(3.2463350296020507812500000000000000000000e+00), SC_(-3.6452333775174714355175846559905046028441e+27) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(6.0000000000000000000000000000000000000000e+00), SC_(3.3070068359375000000000000000000000000000e+00), SC_(-5.0157738865226598232914692214933601243218e+27) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(6.0000000000000000000000000000000000000000e+00), SC_(3.7509422302246093750000000000000000000000e+00), SC_(-4.3890929508905332616126201595071583866125e+28) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(3.7255635078106633741575532889277472799908e+19) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(2.7369685959374133319723626020575434235173e+19) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(5.7474839441396786186711225024564782266553e+17) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(2.5177888870239257812500000000000000000000e+00), SC_(1.7891987262289692785143832502107483402332e+20) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(2.6800680160522460937500000000000000000000e+00), SC_(4.1334287177506128180877506781632782359994e+20) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(3.2463350296020507812500000000000000000000e+00), SC_(5.5308047768855658925740032391709387263669e+21) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+00), SC_(7.1188321756574356898900083837325563596843e+21) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(3.7509422302246093750000000000000000000000e+00), SC_(3.9964135452212639299087390916837253043240e+22) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(1.7686357275011103984254240442730146292597e+17) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(1.3100959259301476741735460760166987688995e+17) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(3.7666432676636962579212161818859337467833e+15) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(2.5177888870239257812500000000000000000000e+00), SC_(1.3430094592655573748416626476694388989947e+17) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(2.6800680160522460937500000000000000000000e+00), SC_(2.7083914873295492090532788091584233435368e+17) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(3.2463350296020507812500000000000000000000e+00), SC_(2.3665567538973723370063959673880785763809e+18) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+00), SC_(2.9210910976830237998944240027844098575037e+18) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(3.7509422302246093750000000000000000000000e+00), SC_(1.2291229003001918470793153392573559450727e+19) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(-5.2576664024176002862344158589796535881831e+13) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(-4.2329431643848954286418066672258348501505e+13) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(-3.3432330002485440610036561359280221226978e+12) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(2.5177888870239257812500000000000000000000e+00), SC_(2.5883439973179118319490975027880887543946e+13) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(2.6800680160522460937500000000000000000000e+00), SC_(4.4295735823618177498252806615177797194601e+13) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(3.2463350296020507812500000000000000000000e+00), SC_(2.3232459641454259693489546852605512393115e+14) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(3.3070068359375000000000000000000000000000e+00), SC_(2.7282931617629933514561823008019828584994e+14) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(3.7509422302246093750000000000000000000000e+00), SC_(8.1626106558478791577585980919827610462951e+14) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(3.3773913229478200649888047062032932589025e+09) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(2.9285417383082111250867859864532665222271e+09) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(5.5378181908620493239920781636035447427836e+08) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(2.5177888870239257812500000000000000000000e+00), SC_(1.8144671362825300546707165714136514607033e+09) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(2.6800680160522460937500000000000000000000e+00), SC_(2.6066181226270233189920873654423394354617e+09) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(3.2463350296020507812500000000000000000000e+00), SC_(7.9576699701312567018046791524139108915222e+09) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(3.3070068359375000000000000000000000000000e+00), SC_(8.8664112280956104821324337124118106711560e+09) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(3.7509422302246093750000000000000000000000e+00), SC_(1.8526730143084793615732333474938655365801e+10) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(-8.3016444776343332784263040480254858266562e+04) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(-7.7342712298273767629358532715855290007312e+04) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(-3.3867696452720596951735387847293168306351e+04) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(2.5177888870239257812500000000000000000000e+00), SC_(5.8314814897947619055790235975678115210030e+04) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(2.6800680160522460937500000000000000000000e+00), SC_(6.9982233667040828669153595953389412898105e+04) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(3.2463350296020507812500000000000000000000e+00), SC_(1.2269741215991149664379933348357099021086e+05) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(3.3070068359375000000000000000000000000000e+00), SC_(1.2955297122738527832552790641784667968750e+05) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(3.7509422302246093750000000000000000000000e+00), SC_(1.8763222860538383247153149113728431984782e+05) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.5177888870239257812500000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.6800680160522460937500000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(3.2463350296020507812500000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(3.3070068359375000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(3.7509422302246093750000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(3.0000000000000000000000000000000000000000e+00), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(1.7043590891447229105697023590655016852353e+23) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(3.0000000000000000000000000000000000000000e+00), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(1.1873509096873203425933279716213204928016e+23) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(3.0000000000000000000000000000000000000000e+00), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(1.8042255988611323451581539032403838075160e+21) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(3.0000000000000000000000000000000000000000e+00), SC_(2.5177888870239257812500000000000000000000e+00), SC_(5.8627141159632624527472017995090651254408e+21) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(3.0000000000000000000000000000000000000000e+00), SC_(2.6800680160522460937500000000000000000000e+00), SC_(1.6271574924751257734072193426458659027476e+22) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(3.0000000000000000000000000000000000000000e+00), SC_(3.2463350296020507812500000000000000000000e+00), SC_(3.7031423974218048440032561983258521268952e+23) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(3.0000000000000000000000000000000000000000e+00), SC_(3.3070068359375000000000000000000000000000e+00), SC_(5.0052347447533553739355176070964649255392e+23) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(3.0000000000000000000000000000000000000000e+00), SC_(3.7509422302246093750000000000000000000000e+00), SC_(3.8774849036221880073100481497888682167742e+24) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(6.0000000000000000000000000000000000000000e+00), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(2.1719642697382298749100349405015507861641e+25) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(6.0000000000000000000000000000000000000000e+00), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(1.5115986377351560057832562086702432503538e+25) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(6.0000000000000000000000000000000000000000e+00), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(2.2661552684348303843016358948347606851782e+23) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(6.0000000000000000000000000000000000000000e+00), SC_(2.5177888870239257812500000000000000000000e+00), SC_(8.1986424745579950886792323761180707203647e+23) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(6.0000000000000000000000000000000000000000e+00), SC_(2.6800680160522460937500000000000000000000e+00), SC_(2.2686093302249683008362318249135901555796e+24) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(6.0000000000000000000000000000000000000000e+00), SC_(3.2463350296020507812500000000000000000000e+00), SC_(5.1208572619501770355256619844219153287912e+25) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(6.0000000000000000000000000000000000000000e+00), SC_(3.3070068359375000000000000000000000000000e+00), SC_(6.9165176585091473311421190275562251439245e+25) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(6.0000000000000000000000000000000000000000e+00), SC_(3.7509422302246093750000000000000000000000e+00), SC_(5.3340112102152905285655960276857834095873e+26) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(6.3069765669464202322969307932847671738549e+18) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(4.2894654697363941442259395597200399615738e+18) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(2.4441910554463945485059533993604138748626e+16) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(2.5177888870239257812500000000000000000000e+00), SC_(2.9369662170336939066281839914206835187481e+19) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(2.6800680160522460937500000000000000000000e+00), SC_(6.6195694360997339703050276203898880734438e+19) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(3.2463350296020507812500000000000000000000e+00), SC_(8.2170892161025745381392173920164421458573e+20) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+00), SC_(1.0500725084412141978893840351819648239915e+21) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(3.7509422302246093750000000000000000000000e+00), SC_(5.6159550589246050165096114936295218077855e+21) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(3.2951558976417439412838140130454242268228e+16) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(2.4153786462268501490942298061299300000746e+16) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(5.8263776199638425970990961752868529531776e+14) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(2.5177888870239257812500000000000000000000e+00), SC_(4.0209881099666537316433937838129942283581e+16) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(2.6800680160522460937500000000000000000000e+00), SC_(8.0401207479851486943533897843005818810638e+16) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(3.2463350296020507812500000000000000000000e+00), SC_(6.8569643001270932561483203195121809541102e+17) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+00), SC_(8.4451462183868409730282580621230503989459e+17) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(3.7509422302246093750000000000000000000000e+00), SC_(3.5032446590464731757817075523752468313771e+18) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(-2.1653243778983226546726061294685126333289e+13) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(-1.7405323025452021614393997881600229426937e+13) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(-1.3442401112287683346706071282986638606867e+12) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(2.5177888870239257812500000000000000000000e+00), SC_(1.1986685417110922747186445591827840669039e+13) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(2.6800680160522460937500000000000000000000e+00), SC_(2.0450036830665718542228800601472654576722e+13) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(3.2463350296020507812500000000000000000000e+00), SC_(1.0634087165953095603220683947046087632358e+14) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(3.3070068359375000000000000000000000000000e+00), SC_(1.2478610290394438795599156130336274039044e+14) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(3.7509422302246093750000000000000000000000e+00), SC_(3.7152810935132472413849691305801181579983e+14) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(2.0705249583941852921047107940633440181636e+09) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(1.7945023601066531809777798860735154304445e+09) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(3.3712784000295336095294601451921348083216e+08) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(2.5177888870239257812500000000000000000000e+00), SC_(1.1574281283273840218487573923036236087428e+09) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(2.6800680160522460937500000000000000000000e+00), SC_(1.6607892402916781816200862439510701665471e+09) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(3.2463350296020507812500000000000000000000e+00), SC_(5.0539504313665629255163251439936934446217e+09) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(3.3070068359375000000000000000000000000000e+00), SC_(5.6295127705661714307645114164895253041807e+09) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(3.7509422302246093750000000000000000000000e+00), SC_(1.1742044019049273483865375620982826561902e+10) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(-6.7067858512150170049989639231569071853301e+04) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(-6.2475577426779083433159081573116111485433e+04) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(-2.7306578869789376967425198472483316436410e+04) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(2.5177888870239257812500000000000000000000e+00), SC_(4.7681348077487537088075056357361347636470e+04) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(2.6800680160522460937500000000000000000000e+00), SC_(5.7200057168246966779403747671572944000218e+04) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(3.2463350296020507812500000000000000000000e+00), SC_(1.0018555399070466398427255161340809763715e+05) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(3.3070068359375000000000000000000000000000e+00), SC_(1.0577395190284834461635909974575042724609e+05) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(3.7509422302246093750000000000000000000000e+00), SC_(1.5310700943790741803096633333325371495448e+05) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.5177888870239257812500000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.6800680160522460937500000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(3.2463350296020507812500000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(3.3070068359375000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(3.7509422302246093750000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(3.0000000000000000000000000000000000000000e+00), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(3.1659665487777752395605623961540814024410e+21) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(3.0000000000000000000000000000000000000000e+00), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(2.2568392468261524056068953236263339459784e+21) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(3.0000000000000000000000000000000000000000e+00), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(4.4779067617495860322218043692559123134877e+19) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(3.0000000000000000000000000000000000000000e+00), SC_(2.5177888870239257812500000000000000000000e+00), SC_(-1.2969149292157914036028150255112737863381e+20) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(3.0000000000000000000000000000000000000000e+00), SC_(2.6800680160522460937500000000000000000000e+00), SC_(-3.3810395423461304260704262788166268981281e+20) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(3.0000000000000000000000000000000000000000e+00), SC_(3.2463350296020507812500000000000000000000e+00), SC_(-6.3498750061329822984747889402196999469439e+21) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(3.0000000000000000000000000000000000000000e+00), SC_(3.3070068359375000000000000000000000000000e+00), SC_(-8.4248449249488725348949138400561293659902e+21) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(3.0000000000000000000000000000000000000000e+00), SC_(3.7509422302246093750000000000000000000000e+00), SC_(-5.7528579400578681185606358344137232265702e+22) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(6.0000000000000000000000000000000000000000e+00), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(3.4519696103193243590807154273753630012168e+23) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(6.0000000000000000000000000000000000000000e+00), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(2.4581521911676112411017401909140122288920e+23) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(6.0000000000000000000000000000000000000000e+00), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(4.8092505860530242429862116579332290486827e+21) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(6.0000000000000000000000000000000000000000e+00), SC_(2.5177888870239257812500000000000000000000e+00), SC_(-1.5578644913211950597985261493160843578969e+22) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(6.0000000000000000000000000000000000000000e+00), SC_(2.6800680160522460937500000000000000000000e+00), SC_(-4.0485525063684617631534688484061419868904e+22) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(6.0000000000000000000000000000000000000000e+00), SC_(3.2463350296020507812500000000000000000000e+00), SC_(-7.5388710165672420511429274383985003625323e+23) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(6.0000000000000000000000000000000000000000e+00), SC_(3.3070068359375000000000000000000000000000e+00), SC_(-9.9949528882057312672387971696171957463101e+23) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(6.0000000000000000000000000000000000000000e+00), SC_(3.7509422302246093750000000000000000000000e+00), SC_(-6.7929805058079427622684593003781879295871e+24) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(-6.9141104793275284074919404966318228475593e+17) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(-5.2763513603535701591823909044274279152804e+17) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(-1.6438878527272579560168791016040747429689e+16) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(2.5177888870239257812500000000000000000000e+00), SC_(3.9598292301446336120327136588854816540500e+18) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(2.6800680160522460937500000000000000000000e+00), SC_(8.6352827698110316716799122995314017457285e+18) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(3.2463350296020507812500000000000000000000e+00), SC_(9.6705891666241421983210507683920102952226e+19) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+00), SC_(1.2234143982339838928664898468944531605920e+20) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(3.7509422302246093750000000000000000000000e+00), SC_(6.1048092781443589775735666250832615482472e+20) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(3.3752336290521052133805558057400240159832e+15) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(2.3879349706618784094756125656322204764422e+15) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(2.1414226874304304881001450803083134897208e+13) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(2.5177888870239257812500000000000000000000e+00), SC_(1.0533343819279748919580943176076347691164e+16) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(2.6800680160522460937500000000000000000000e+00), SC_(2.0817383491682766811586484734018124669520e+16) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(3.2463350296020507812500000000000000000000e+00), SC_(1.7165739762806335552611163116485906087571e+17) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+00), SC_(2.1076507905654326402057985843911594299019e+17) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(3.7509422302246093750000000000000000000000e+00), SC_(8.5684051967474702436488255416035836648166e+17) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(-7.9704503012147328566960299892193772078104e+12) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(-6.3923410902045643593803739588681215502448e+12) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(-4.7798168123521794578665547929709983649966e+11) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(2.5177888870239257812500000000000000000000e+00), SC_(5.1626360354953033460248312583213797345416e+12) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(2.6800680160522460937500000000000000000000e+00), SC_(8.7731762702105692846051103627150345894050e+12) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(3.2463350296020507812500000000000000000000e+00), SC_(4.5123547738178103863770837934211872499806e+13) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(3.3070068359375000000000000000000000000000e+00), SC_(5.2898876344546592871118393548254000191720e+13) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(3.7509422302246093750000000000000000000000e+00), SC_(1.5651562134197382039712421323894468435395e+14) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(1.2131188196587825964190342759209172765174e+09) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(1.0507762295236174674302649841459278533513e+09) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(1.9580476781882653534672098990739658336900e+08) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(2.5177888870239257812500000000000000000000e+00), SC_(7.1185412612883029969184372720369905256084e+08) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(2.6800680160522460937500000000000000000000e+00), SC_(1.0200010287181928918043328845109847417863e+09) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(3.2463350296020507812500000000000000000000e+00), SC_(3.0920009811018714587959744950270520149901e+09) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(3.3070068359375000000000000000000000000000e+00), SC_(3.4429609990298242141581544387564257056250e+09) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(3.7509422302246093750000000000000000000000e+00), SC_(7.1658127549419646671225480918410367146197e+09) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(-5.3297986108092137834624235637193123693578e+04) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(-4.9640585520662945766774687417210998319206e+04) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(-2.1649267922028506450971008234773762524128e+04) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(2.5177888870239257812500000000000000000000e+00), SC_(3.8426634152256262739001668737870431868942e+04) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(2.6800680160522460937500000000000000000000e+00), SC_(4.6078002254661868241962519032739464819315e+04) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(3.2463350296020507812500000000000000000000e+00), SC_(8.0610746229967040104837094904866034994484e+04) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(3.3070068359375000000000000000000000000000e+00), SC_(8.5098527920237669604830443859100341796875e+04) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(3.7509422302246093750000000000000000000000e+00), SC_(1.2309923504351554147318026366519916336983e+05) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.5177888870239257812500000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.6800680160522460937500000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(3.2463350296020507812500000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(3.3070068359375000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(3.7509422302246093750000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(3.0000000000000000000000000000000000000000e+00), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(6.2251969714455437911663389922969316982588e+19) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(3.0000000000000000000000000000000000000000e+00), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(4.5406789754059254996986610554281886957302e+19) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(3.0000000000000000000000000000000000000000e+00), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(1.1763003307251058888476712533040767694645e+18) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(3.0000000000000000000000000000000000000000e+00), SC_(2.5177888870239257812500000000000000000000e+00), SC_(3.0386772119881177148616178413973748965718e+18) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(3.0000000000000000000000000000000000000000e+00), SC_(2.6800680160522460937500000000000000000000e+00), SC_(7.4408606543966974906173800598043357287132e+18) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(3.0000000000000000000000000000000000000000e+00), SC_(3.2463350296020507812500000000000000000000e+00), SC_(1.1531618905703112102852758000170649231985e+20) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(3.0000000000000000000000000000000000000000e+00), SC_(3.3070068359375000000000000000000000000000e+00), SC_(1.5018543185291937288582718190265664364596e+20) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(3.0000000000000000000000000000000000000000e+00), SC_(3.7509422302246093750000000000000000000000e+00), SC_(9.0392719782373314701140890310754166260111e+20) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(6.0000000000000000000000000000000000000000e+00), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(5.7581845390341748825072680816898846761379e+21) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(6.0000000000000000000000000000000000000000e+00), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(4.1954736867465743746838482135718808723271e+21) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(6.0000000000000000000000000000000000000000e+00), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(1.0710406248207922335131244111560252097143e+20) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(6.0000000000000000000000000000000000000000e+00), SC_(2.5177888870239257812500000000000000000000e+00), SC_(3.1097054098075373428394903666796399315761e+20) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(6.0000000000000000000000000000000000000000e+00), SC_(2.6800680160522460937500000000000000000000e+00), SC_(7.5897769619741992739633719718576814820649e+20) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(6.0000000000000000000000000000000000000000e+00), SC_(3.2463350296020507812500000000000000000000e+00), SC_(1.1658018042723442695003928834678337727477e+22) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(6.0000000000000000000000000000000000000000e+00), SC_(3.3070068359375000000000000000000000000000e+00), SC_(1.5171404360332229211854563563169873445721e+22) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(6.0000000000000000000000000000000000000000e+00), SC_(3.7509422302246093750000000000000000000000e+00), SC_(9.0865615422581773647372954935451368032682e+22) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(-1.1812926811368912095843187812221162593065e+17) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(-8.0301095090766599505685270230918832407937e+16) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(-1.3422305525568395671418188003358613230141e+14) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(2.5177888870239257812500000000000000000000e+00), SC_(4.3802092127043713712526817130175489181050e+17) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(2.6800680160522460937500000000000000000000e+00), SC_(9.1728126258914667173836483984718250619155e+17) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(3.2463350296020507812500000000000000000000e+00), SC_(9.0445577751673601479900473199582489277066e+18) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+00), SC_(1.1299537980092126905374473044324042121585e+19) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(3.7509422302246093750000000000000000000000e+00), SC_(5.1712634006280606553620163059616093299501e+19) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(-2.2577268815156737037554153653784502610562e+14) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(-1.9199584133323218499713121596235976838998e+14) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(-1.4903319511671731688752362734455772199122e+13) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(2.5177888870239257812500000000000000000000e+00), SC_(2.3466738082729422615768499647515494993482e+15) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(2.6800680160522460937500000000000000000000e+00), SC_(4.5619266353067581709861825950356332752214e+15) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(3.2463350296020507812500000000000000000000e+00), SC_(3.5832800979634936902882239638883495731177e+16) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+00), SC_(4.3797755100304594666154855576986941116278e+16) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(3.7509422302246093750000000000000000000000e+00), SC_(1.7280082409091051129893602611862023687219e+17) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(-2.5190734235634763040050714158445146333705e+12) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(-2.0132286802618261588493096159627830690650e+12) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(-1.4298231563423092935418605552346793143368e+11) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(2.5177888870239257812500000000000000000000e+00), SC_(2.0373938856015269487199372756876422458921e+12) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(2.6800680160522460937500000000000000000000e+00), SC_(3.4444863070443997713603948682759141528352e+12) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(3.2463350296020507812500000000000000000000e+00), SC_(1.7462507392319300198630376305730238367151e+13) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(3.3070068359375000000000000000000000000000e+00), SC_(2.0445159581793493555299395656777412624322e+13) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(3.7509422302246093750000000000000000000000e+00), SC_(5.9992883379140601370310120641770230383795e+13) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(6.7268759093443026085995889720227304946119e+08) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(5.8222684662151186374930716264193600538323e+08) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(1.0736525897326592052385603572051620605067e+08) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(2.5177888870239257812500000000000000000000e+00), SC_(4.1941452625884462747007987309459450410062e+08) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(2.6800680160522460937500000000000000000000e+00), SC_(5.9993587433530918095420744679548872709272e+08) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(3.2463350296020507812500000000000000000000e+00), SC_(1.8100261519585536584424384943495397397780e+09) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(3.3070068359375000000000000000000000000000e+00), SC_(2.0146339678178875923066378701529558636766e+09) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(3.7509422302246093750000000000000000000000e+00), SC_(4.1818945594468279247915892122512207307728e+09) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(-4.1547388764588042582265314806022615812253e+04) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(-3.8688938883140025337226824975189742872317e+04) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(-1.6829071446319658592827295251481700688601e+04) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(2.5177888870239257812500000000000000000000e+00), SC_(3.0454907598685861683910497399452310673951e+04) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(2.6800680160522460937500000000000000000000e+00), SC_(3.6500567140729478341275998642956324147235e+04) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(3.2463350296020507812500000000000000000000e+00), SC_(6.3767716144718433527453088638381473174377e+04) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(3.3070068359375000000000000000000000000000e+00), SC_(6.7309700881221207964699715375900268554688e+04) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(3.7509422302246093750000000000000000000000e+00), SC_(9.7292260610251228249323318664210091810673e+04) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.5177888870239257812500000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.6800680160522460937500000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(3.2463350296020507812500000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(3.3070068359375000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(3.7509422302246093750000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(3.0000000000000000000000000000000000000000e+00), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(1.3001162315737231096474112010858914130371e+18) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(3.0000000000000000000000000000000000000000e+00), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(9.7033068885138381279829794822859591788018e+17) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(3.0000000000000000000000000000000000000000e+00), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(3.2816513109751438818989476970249147214740e+16) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(3.0000000000000000000000000000000000000000e+00), SC_(2.5177888870239257812500000000000000000000e+00), SC_(-7.5674646290234714845939887858674495557956e+16) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(3.0000000000000000000000000000000000000000e+00), SC_(2.6800680160522460937500000000000000000000e+00), SC_(-1.7405208082518257550674401656533350222698e+17) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(3.0000000000000000000000000000000000000000e+00), SC_(3.2463350296020507812500000000000000000000e+00), SC_(-2.2257289702895657584335788953952872482970e+18) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(3.0000000000000000000000000000000000000000e+00), SC_(3.3070068359375000000000000000000000000000e+00), SC_(-2.8454325879280437997088630071229921632426e+18) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(3.0000000000000000000000000000000000000000e+00), SC_(3.7509422302246093750000000000000000000000e+00), SC_(-1.5094658898529399647583573796964641275493e+19) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(6.0000000000000000000000000000000000000000e+00), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(1.0105662202944477954956881882186755664606e+20) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(6.0000000000000000000000000000000000000000e+00), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(7.5337068844925416931921217018017788079528e+19) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(6.0000000000000000000000000000000000000000e+00), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(2.5091171169823238423582992269397061415841e+18) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(6.0000000000000000000000000000000000000000e+00), SC_(2.5177888870239257812500000000000000000000e+00), SC_(-6.5378228695933862333973629838329417346060e+18) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(6.0000000000000000000000000000000000000000e+00), SC_(2.6800680160522460937500000000000000000000e+00), SC_(-1.4985381687540318636305433980536948616234e+19) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(6.0000000000000000000000000000000000000000e+00), SC_(3.2463350296020507812500000000000000000000e+00), SC_(-1.8985085520068925207348809523615604484853e+20) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(6.0000000000000000000000000000000000000000e+00), SC_(3.3070068359375000000000000000000000000000e+00), SC_(-2.4251396094319210981637443184397962497768e+20) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(6.0000000000000000000000000000000000000000e+00), SC_(3.7509422302246093750000000000000000000000e+00), SC_(-1.2799191286377320336957074983219747104936e+21) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(3.2951558976417439412838140130454242268228e+16) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(2.4153786462268501490942298061299300000746e+16) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(5.8263776199638425970990961752868529531776e+14) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(2.5177888870239257812500000000000000000000e+00), SC_(4.0209881099666537316433937838129942283581e+16) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(2.6800680160522460937500000000000000000000e+00), SC_(8.0401207479851486943533897843005818810638e+16) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(3.2463350296020507812500000000000000000000e+00), SC_(6.8569643001270932561483203195121809541102e+17) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+00), SC_(8.4451462183868409730282580621230503989459e+17) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(3.7509422302246093750000000000000000000000e+00), SC_(3.5032446590464731757817075523752468313771e+18) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(-1.1019241153765957491086579935453109840175e+14) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(-8.2822294115278296643176182101103781074962e+13) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(-2.3982005920230095775287081902635241310895e+12) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(2.5177888870239257812500000000000000000000e+00), SC_(4.3063118166863557319372142738762274257776e+14) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(2.6800680160522460937500000000000000000000e+00), SC_(8.1748012916800250182965539766368227154107e+14) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(3.2463350296020507812500000000000000000000e+00), SC_(5.9747820086846004253478340782564132382605e+15) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+00), SC_(7.2528239616104665854179526436049269985551e+15) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(3.7509422302246093750000000000000000000000e+00), SC_(2.7320429873476048491105413621007368229973e+16) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(-6.3457613074484570706828171906287066446107e+11) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(-5.0394280522544386463540441510390707207949e+11) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(-3.2447817034555189515548770814733869388772e+10) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(2.5177888870239257812500000000000000000000e+00), SC_(7.2237231663501669845277996939624742940828e+11) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(2.6800680160522460937500000000000000000000e+00), SC_(1.2127855321650709244802371949132979490419e+12) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(3.2463350296020507812500000000000000000000e+00), SC_(6.0285175041868675541508780329477250071123e+12) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(3.3070068359375000000000000000000000000000e+00), SC_(7.0457123729479944381803009846528757690581e+12) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(3.7509422302246093750000000000000000000000e+00), SC_(2.0438804970348593689955430015051634752786e+13) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(3.4828537789281027279931714909273846529044e+08) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(3.0114737370315639562050862070027869840907e+08) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(5.4763733892172071001547317494716254098417e+07) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(2.5177888870239257812500000000000000000000e+00), SC_(2.3477315819478600884179713284202195289239e+08) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(2.6800680160522460937500000000000000000000e+00), SC_(3.3509906705792799767132122748066407766158e+08) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(3.2463350296020507812500000000000000000000e+00), SC_(1.0050063214145772952621866532462563307614e+09) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(3.3070068359375000000000000000000000000000e+00), SC_(1.1180266986048984026726489055752143518150e+09) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(3.7509422302246093750000000000000000000000e+00), SC_(2.3129825810433958716625921766451359472530e+09) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(-3.1656627682056690737011361846953150234185e+04) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(-2.9471839817424992851536968974102137508453e+04) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(-1.2779297279544506583448537639924325048923e+04) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(2.5177888870239257812500000000000000000000e+00), SC_(2.3670402893208399598141966624353926818003e+04) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(2.6800680160522460937500000000000000000000e+00), SC_(2.8352250040893742361790275108290870775818e+04) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(3.2463350296020507812500000000000000000000e+00), SC_(4.9451191001978652774080658094391083068331e+04) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(3.3070068359375000000000000000000000000000e+00), SC_(5.2190472387466914369724690914154052734375e+04) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(3.7509422302246093750000000000000000000000e+00), SC_(7.5369441326157503810545534861375926993787e+04) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.5177888870239257812500000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.6800680160522460937500000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(3.2463350296020507812500000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(3.3070068359375000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(3.7509422302246093750000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(3.0000000000000000000000000000000000000000e+00), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(2.8950873484730664049925841595240167489661e+16) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(3.0000000000000000000000000000000000000000e+00), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(2.2108784548632151733197956983463214658604e+16) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(3.0000000000000000000000000000000000000000e+00), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(9.7601073092736690124522403060189338883902e+14) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(3.0000000000000000000000000000000000000000e+00), SC_(2.5177888870239257812500000000000000000000e+00), SC_(2.0111456730119108853315870023356941588038e+15) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(3.0000000000000000000000000000000000000000e+00), SC_(2.6800680160522460937500000000000000000000e+00), SC_(4.3446112091947520372813424442436023856067e+15) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(3.0000000000000000000000000000000000000000e+00), SC_(3.2463350296020507812500000000000000000000e+00), SC_(4.5839319802475077044702706303686410063834e+16) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(3.0000000000000000000000000000000000000000e+00), SC_(3.3070068359375000000000000000000000000000e+00), SC_(5.7524110097545549448174262486863606245964e+16) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(3.0000000000000000000000000000000000000000e+00), SC_(3.7509422302246093750000000000000000000000e+00), SC_(2.6895315084611796735758355676258546860901e+17) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(6.0000000000000000000000000000000000000000e+00), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(1.8709887714229327538646695346923664235539e+18) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(6.0000000000000000000000000000000000000000e+00), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(1.4271106386206828576172790099488886196057e+18) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(6.0000000000000000000000000000000000000000e+00), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(6.1997749391572306269561295382150292266813e+16) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(6.0000000000000000000000000000000000000000e+00), SC_(2.5177888870239257812500000000000000000000e+00), SC_(1.4518435702328426900436048018675078100140e+17) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(6.0000000000000000000000000000000000000000e+00), SC_(2.6800680160522460937500000000000000000000e+00), SC_(3.1250862080942641279019600518967810802895e+17) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(6.0000000000000000000000000000000000000000e+00), SC_(3.2463350296020507812500000000000000000000e+00), SC_(3.2651909010153496083575577254961183939587e+18) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(6.0000000000000000000000000000000000000000e+00), SC_(3.3070068359375000000000000000000000000000e+00), SC_(4.0940371498905965746663783502715803148623e+18) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(6.0000000000000000000000000000000000000000e+00), SC_(3.7509422302246093750000000000000000000000e+00), SC_(1.9038971000759020208091041412919333441540e+19) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(-4.0188477077892283364838402754385305470781e+15) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(-3.0535279022397773608910588082845494046338e+15) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(-1.1889165690621568382622559087831740520793e+14) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(2.5177888870239257812500000000000000000000e+00), SC_(3.1142094991830518203676945105629490430602e+15) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(2.6800680160522460937500000000000000000000e+00), SC_(5.9214274946405867785996314567712011342405e+15) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(3.2463350296020507812500000000000000000000e+00), SC_(4.3147639531901863003931530968269302241880e+16) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+00), SC_(5.2327693361008055700018371495818668764085e+16) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(3.7509422302246093750000000000000000000000e+00), SC_(1.9523948483181548651067630460663625025780e+17) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(3.2276633309147432611106199928479787514599e+12) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(3.1197600269714595045610272516376848391517e+12) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(4.6694464111948972326460423622569125292239e+11) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(2.5177888870239257812500000000000000000000e+00), SC_(6.3416841541637532278788013313511962864796e+13) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(2.6800680160522460937500000000000000000000e+00), SC_(1.1642883948315935340806779285484445645309e+14) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(3.2463350296020507812500000000000000000000e+00), SC_(7.6645454794116080342507650113880012117241e+14) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+00), SC_(9.2089647203924518978442012977946384301178e+14) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(3.7509422302246093750000000000000000000000e+00), SC_(3.2320855509577518922328838615255284772186e+15) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(-1.0601807445670078330017866920263440808823e+11) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(-8.2856116693607785059898175334640850580762e+10) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(-3.9845651381042932383500996511591152068756e+09) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(2.5177888870239257812500000000000000000000e+00), SC_(2.2411743154269883906832765685500304992525e+11) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(2.6800680160522460937500000000000000000000e+00), SC_(3.7258830274605926323328414287069705512675e+11) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(3.2463350296020507812500000000000000000000e+00), SC_(1.8006395904852139776395293141287434917496e+12) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(3.3070068359375000000000000000000000000000e+00), SC_(2.0990810392795414244019146133394158524263e+12) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(3.7509422302246093750000000000000000000000e+00), SC_(5.9884599646417106596043436249437473389919e+12) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(1.6508352108336477157145884883342119539179e+08) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(1.4254151673016362504064815522535753821660e+08) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(2.5417711274384580814781605774000438635007e+07) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(2.5177888870239257812500000000000000000000e+00), SC_(1.2349780659200330571479143947015108613980e+08) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(2.6800680160522460937500000000000000000000e+00), SC_(1.7578429988847251471891781816674712606196e+08) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(3.2463350296020507812500000000000000000000e+00), SC_(5.2316799821387472937418109493475527215851e+08) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(3.3070068359375000000000000000000000000000e+00), SC_(5.8160697433595604691075149989372131733570e+08) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(3.7509422302246093750000000000000000000000e+00), SC_(1.1980122352091416231893993853001138215064e+09) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(-2.3466264060916888742960861868880328984233e+04) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(-2.1840490626732519016726594140997974591301e+04) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(-9.4332532585847236132892135174188297241926e+03) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(2.5177888870239257812500000000000000000000e+00), SC_(1.7977354512255942157036500694822223067604e+04) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(2.6800680160522460937500000000000000000000e+00), SC_(2.1517549169598605587951437034810453496902e+04) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(3.2463350296020507812500000000000000000000e+00), SC_(3.7455898068767506366679928553331535567850e+04) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(3.3070068359375000000000000000000000000000e+00), SC_(3.9523844040642743493663147091865539550781e+04) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(3.7509422302246093750000000000000000000000e+00), SC_(5.7014132379277393607996948787786095635965e+04) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.5177888870239257812500000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.6800680160522460937500000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(3.2463350296020507812500000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(3.3070068359375000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(3.7509422302246093750000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(3.0000000000000000000000000000000000000000e+00), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(6.9037421849985645501237000076518442352973e+14) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(3.0000000000000000000000000000000000000000e+00), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(5.3944613940702461221573002226614102373587e+14) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(3.0000000000000000000000000000000000000000e+00), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(3.1080141462712709395426375529218778417699e+13) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(3.0000000000000000000000000000000000000000e+00), SC_(2.5177888870239257812500000000000000000000e+00), SC_(-5.7298574777724722449102966180133102333305e+13) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(3.0000000000000000000000000000000000000000e+00), SC_(2.6800680160522460937500000000000000000000e+00), SC_(-1.1625603196166873079882874475534692622203e+14) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(3.0000000000000000000000000000000000000000e+00), SC_(3.2463350296020507812500000000000000000000e+00), SC_(-1.0119474631644907779731992892254247672783e+15) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(3.0000000000000000000000000000000000000000e+00), SC_(3.3070068359375000000000000000000000000000e+00), SC_(-1.2465279688104621054566557687350322724314e+15) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(3.0000000000000000000000000000000000000000e+00), SC_(3.7509422302246093750000000000000000000000e+00), SC_(-5.1364000313145028794654063072195997136498e+15) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(6.0000000000000000000000000000000000000000e+00), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(3.6652172130918960444241662549223114508916e+16) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(6.0000000000000000000000000000000000000000e+00), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(2.8603658198026591955175756095866798891150e+16) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(6.0000000000000000000000000000000000000000e+00), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(1.6205018594608826999045205857825546585008e+15) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(6.0000000000000000000000000000000000000000e+00), SC_(2.5177888870239257812500000000000000000000e+00), SC_(-3.4164611277164746271206565163197964759736e+15) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(6.0000000000000000000000000000000000000000e+00), SC_(2.6800680160522460937500000000000000000000e+00), SC_(-6.9056655255436202538464292906854839803996e+15) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(6.0000000000000000000000000000000000000000e+00), SC_(3.2463350296020507812500000000000000000000e+00), SC_(-5.9497383847155170078436165844124308667700e+16) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(6.0000000000000000000000000000000000000000e+00), SC_(3.3070068359375000000000000000000000000000e+00), SC_(-7.3224295523060543717602743658942675235667e+16) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(6.0000000000000000000000000000000000000000e+00), SC_(3.7509422302246093750000000000000000000000e+00), SC_(-3.0002802335538642110589950849635263001823e+17) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(3.3511679235220193917381769981743401740964e+14) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(2.6221335990662274385685523088330458914590e+14) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(1.4656633544076969868112035332053251827642e+13) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(2.5177888870239257812500000000000000000000e+00), SC_(2.0696309998590090883379440006449553076740e+14) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(2.6800680160522460937500000000000000000000e+00), SC_(3.7314067364536398626304161372667873687378e+14) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(3.2463350296020507812500000000000000000000e+00), SC_(2.3036331768950504517667265359305740126195e+15) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+00), SC_(2.7488402881763658005624400469279033639144e+15) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(3.7509422302246093750000000000000000000000e+00), SC_(9.1777439160731309796789866589466570934533e+15) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(3.1618540156132597585707220385573719454179e+12) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(2.3955417993411110411645844806570507966575e+12) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(7.4261750882576177537898748074863686425097e+10) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(2.5177888870239257812500000000000000000000e+00), SC_(7.4937368589536477500780512161456931586980e+12) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(2.6800680160522460937500000000000000000000e+00), SC_(1.3195529452303927142409920066805358259275e+13) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(3.2463350296020507812500000000000000000000e+00), SC_(7.6174270043552168126626036705025124216824e+13) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+00), SC_(9.0345816525958819724028350969972379955702e+13) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(3.7509422302246093750000000000000000000000e+00), SC_(2.8998721347495615667901684190805986639869e+14) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(-3.1737935219990783530360597292798974644896e+09) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(-1.9377981790847647430661092954327439430514e+09) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(4.3497993172297516397339829120602730290121e+08) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(2.5177888870239257812500000000000000000000e+00), SC_(5.8738972066455066131339388602592925209054e+10) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(2.6800680160522460937500000000000000000000e+00), SC_(9.6243188914837172534132405692230251517078e+10) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(3.2463350296020507812500000000000000000000e+00), SC_(4.4578484870714860651690801633948897616236e+11) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(3.3070068359375000000000000000000000000000e+00), SC_(5.1763320510889587801992972753029719146316e+11) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(3.7509422302246093750000000000000000000000e+00), SC_(1.4390342991213360386511685851572390283936e+12) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(6.9456823948430336120454514867083870701476e+07) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(5.9847221832691416156516824977506609449995e+07) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(1.0358099270590063675313229507502988381580e+07) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(2.5177888870239257812500000000000000000000e+00), SC_(6.0153154266526643799239011000351152343233e+07) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(2.6800680160522460937500000000000000000000e+00), SC_(8.5305981767583872985623961422643771899599e+07) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(3.2463350296020507812500000000000000000000e+00), SC_(2.5129684667381422531714097426529083906368e+08) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(3.3070068359375000000000000000000000000000e+00), SC_(2.7911289925164043782637409929982386628958e+08) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(3.7509422302246093750000000000000000000000e+00), SC_(5.7157381036063279609540906423254715849348e+08) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(-1.6816859101587443044212299980699754087254e+04) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(-1.5646093614277274539817175202927046484547e+04) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(-6.7242472203219828728038010012824088335037e+03) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(2.5177888870239257812500000000000000000000e+00), SC_(1.3279996932260555035934523893104142189259e+04) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(2.6800680160522460937500000000000000000000e+00), SC_(1.5880962741288013304205573028582421102328e+04) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(3.2463350296020507812500000000000000000000e+00), SC_(2.7576564612104802827211025295639501564438e+04) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(3.3070068359375000000000000000000000000000e+00), SC_(2.9092817442416650010272860527038574218750e+04) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(3.7509422302246093750000000000000000000000e+00), SC_(4.1909688957653923092827596974530024453998e+04) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.5177888870239257812500000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.6800680160522460937500000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(3.2463350296020507812500000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(3.3070068359375000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(3.7509422302246093750000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(3.0000000000000000000000000000000000000000e+00), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(1.7718088791149623027628279657904253550952e+13) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(3.0000000000000000000000000000000000000000e+00), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(1.4165571585120195630065368467023343193201e+13) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(3.0000000000000000000000000000000000000000e+00), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(1.0649370622952190082411499390218020437027e+12) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(3.0000000000000000000000000000000000000000e+00), SC_(2.5177888870239257812500000000000000000000e+00), SC_(1.7592723590074153984441389115929590578081e+12) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(3.0000000000000000000000000000000000000000e+00), SC_(2.6800680160522460937500000000000000000000e+00), SC_(3.3523647193026979051418642656865854618820e+12) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(3.0000000000000000000000000000000000000000e+00), SC_(3.2463350296020507812500000000000000000000e+00), SC_(2.4071348956787227746979934038988715163881e+13) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(3.0000000000000000000000000000000000000000e+00), SC_(3.3070068359375000000000000000000000000000e+00), SC_(2.9105332522270871783573955519120461503702e+13) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(3.0000000000000000000000000000000000000000e+00), SC_(3.7509422302246093750000000000000000000000e+00), SC_(1.0568965843761764719653660468061255208099e+14) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(6.0000000000000000000000000000000000000000e+00), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(7.6224671715954830858798783303062976614173e+14) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(6.0000000000000000000000000000000000000000e+00), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(6.0861728885403807578931536748307861421150e+14) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(6.0000000000000000000000000000000000000000e+00), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(4.4953792173606354581240572232020110686664e+13) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(6.0000000000000000000000000000000000000000e+00), SC_(2.5177888870239257812500000000000000000000e+00), SC_(8.5502313625296696420212958378710226874170e+13) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(6.0000000000000000000000000000000000000000e+00), SC_(2.6800680160522460937500000000000000000000e+00), SC_(1.6228150414385126969699088421969609480787e+14) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(6.0000000000000000000000000000000000000000e+00), SC_(3.2463350296020507812500000000000000000000e+00), SC_(1.1527623806050199752733656742011968459770e+15) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(6.0000000000000000000000000000000000000000e+00), SC_(3.3070068359375000000000000000000000000000e+00), SC_(1.3925326779766339250230111227270112621162e+15) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(6.0000000000000000000000000000000000000000e+00), SC_(3.7509422302246093750000000000000000000000e+00), SC_(5.0267784722090847936971061643327759412211e+15) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(-2.1653243778983226546726061294685126333289e+13) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(-1.7405323025452021614393997881600229426937e+13) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(-1.3442401112287683346706071282986638606867e+12) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(2.5177888870239257812500000000000000000000e+00), SC_(1.1986685417110922747186445591827840669039e+13) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(2.6800680160522460937500000000000000000000e+00), SC_(2.0450036830665718542228800601472654576722e+13) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(3.2463350296020507812500000000000000000000e+00), SC_(1.0634087165953095603220683947046087632358e+14) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+00), SC_(1.2478610290394438795599156130336274039044e+14) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(3.7509422302246093750000000000000000000000e+00), SC_(3.7152810935132472413849691305801181579983e+14) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(-6.3457613074484570706828171906287066446107e+11) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(-5.0394280522544386463540441510390707207949e+11) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(-3.2447817034555189515548770814733869388772e+10) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(2.5177888870239257812500000000000000000000e+00), SC_(7.2237231663501669845277996939624742940828e+11) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(2.6800680160522460937500000000000000000000e+00), SC_(1.2127855321650709244802371949132979490419e+12) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(3.2463350296020507812500000000000000000000e+00), SC_(6.0285175041868675541508780329477250071123e+12) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+00), SC_(7.0457123729479944381803009846528757690581e+12) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(3.7509422302246093750000000000000000000000e+00), SC_(2.0438804970348593689955430015051634752786e+13) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(3.1290223082780812542911354822151866857150e+09) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(2.5810213164436527093802616213555028680098e+09) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(2.4153045330022161107537410483848714693649e+08) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(2.5177888870239257812500000000000000000000e+00), SC_(1.2442297771465071319800537740338107885910e+10) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(2.6800680160522460937500000000000000000000e+00), SC_(1.9935442048659401843493277148239805019080e+10) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(3.2463350296020507812500000000000000000000e+00), SC_(8.6313386827034171520965821028632824895833e+10) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(3.3070068359375000000000000000000000000000e+00), SC_(9.9584444343623441539253392023445355596098e+10) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(3.7509422302246093750000000000000000000000e+00), SC_(2.6519097278234068324632998526608208255428e+11) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(2.4578195454610112775633536833179484328694e+07) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(2.1103186910568077011948998155175648998962e+07) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(3.4684435546581633457002501767017482095200e+06) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(2.5177888870239257812500000000000000000000e+00), SC_(2.6577145887843629852290035855212268460008e+07) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(2.6800680160522460937500000000000000000000e+00), SC_(3.7498363674149662443550104953481873050416e+07) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(3.2463350296020507812500000000000000000000e+00), SC_(1.0889344889077440695923692763840493649805e+08) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(3.3070068359375000000000000000000000000000e+00), SC_(1.2079222501050340657132044797973984483989e+08) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(3.7509422302246093750000000000000000000000e+00), SC_(2.4533035253347086442379416883311287412965e+08) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(-1.1548974004487160084864161291307027568109e+04) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(-1.0739851083273930127830186886939145551878e+04) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(-4.5855870016379575524467782088322564959526e+03) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(2.5177888870239257812500000000000000000000e+00), SC_(9.4825646296543039101764605014466269494733e+03) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(2.6800680160522460937500000000000000000000e+00), SC_(1.1326988970405910794998771695674122383934e+04) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(3.2463350296020507812500000000000000000000e+00), SC_(1.9607917899010350677634073601751651949598e+04) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(3.3070068359375000000000000000000000000000e+00), SC_(2.0680394194456588593311607837677001953125e+04) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(3.7509422302246093750000000000000000000000e+00), SC_(2.9739466249330117716187515952697140164673e+04) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.5177888870239257812500000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.6800680160522460937500000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(3.2463350296020507812500000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(3.3070068359375000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(3.7509422302246093750000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(3.0000000000000000000000000000000000000000e+00), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(4.9222114076748582916424363231499347103970e+11) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(3.0000000000000000000000000000000000000000e+00), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(4.0264539176433856788241811459003352559663e+11) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(3.0000000000000000000000000000000000000000e+00), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(3.9486819329070181291566660641476564486501e+10) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(3.0000000000000000000000000000000000000000e+00), SC_(2.5177888870239257812500000000000000000000e+00), SC_(-5.8569406374302031625779351668569091989338e+10) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(3.0000000000000000000000000000000000000000e+00), SC_(2.6800680160522460937500000000000000000000e+00), SC_(-1.0481247690954215565159882000983959085952e+11) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(3.0000000000000000000000000000000000000000e+00), SC_(3.2463350296020507812500000000000000000000e+00), SC_(-6.2073657435280648554480577824819675706774e+11) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(3.0000000000000000000000000000000000000000e+00), SC_(3.3070068359375000000000000000000000000000e+00), SC_(-7.3671950399330446346585775534169171546922e+11) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(3.0000000000000000000000000000000000000000e+00), SC_(3.7509422302246093750000000000000000000000e+00), SC_(-2.3573876539030027219964072962988502556183e+12) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(6.0000000000000000000000000000000000000000e+00), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(1.6892006804622581895659291428855168584345e+13) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(6.0000000000000000000000000000000000000000e+00), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(1.3798963722803456514687905901958460594742e+13) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(6.0000000000000000000000000000000000000000e+00), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(1.3283804115559352907485778759544105924089e+12) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(6.0000000000000000000000000000000000000000e+00), SC_(2.5177888870239257812500000000000000000000e+00), SC_(-2.2851415648305688125047909866309202161738e+12) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(6.0000000000000000000000000000000000000000e+00), SC_(2.6800680160522460937500000000000000000000e+00), SC_(-4.0722670987903283336918349401111756731030e+12) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(6.0000000000000000000000000000000000000000e+00), SC_(3.2463350296020507812500000000000000000000e+00), SC_(-2.3845347730687969556117494885997472256535e+13) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(6.0000000000000000000000000000000000000000e+00), SC_(3.3070068359375000000000000000000000000000e+00), SC_(-2.8272903022615350646398707905498793540311e+13) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(6.0000000000000000000000000000000000000000e+00), SC_(3.7509422302246093750000000000000000000000e+00), SC_(-8.9905713453378977440270448961310273519993e+13) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(1.1514120172975962699906575477577888758418e+12) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(9.4964686662707381062870865628661703421663e+11) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(9.9523938760482313469312286703942846291677e+10) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(2.5177888870239257812500000000000000000000e+00), SC_(6.1326978108489041191708836931707244487653e+11) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(2.6800680160522460937500000000000000000000e+00), SC_(9.8860256324046977952265020354328793119348e+11) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(3.2463350296020507812500000000000000000000e+00), SC_(4.3119984572762024181468369100458699506234e+12) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+00), SC_(4.9740586382813961478696150448481733925751e+12) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(3.7509422302246093750000000000000000000000e+00), SC_(1.3173962669073217902875746692899930056701e+13) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(7.0167944306014191289189014084111010702717e+10) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(5.7506112817004241465270571255114556585480e+10) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(5.5031854940460055207161240700324695204232e+09) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(2.5177888870239257812500000000000000000000e+00), SC_(5.8032469845259552606843552674588256764244e+10) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(2.6800680160522460937500000000000000000000e+00), SC_(9.2522559606388709484299792189830090488380e+10) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(3.2463350296020507812500000000000000000000e+00), SC_(3.9134695258466278546907974118908298662869e+11) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+00), SC_(4.5020392805672375314245248956826254688242e+11) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(3.7509422302246093750000000000000000000000e+00), SC_(1.1716782960727496494873148282411182010605e+12) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(2.3468095806520018929395600364470848373819e+08) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(1.7217397181516144737474017453789391811468e+08) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(-9.6312769042586142896347624071862958478034e+06) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(2.5177888870239257812500000000000000000000e+00), SC_(2.0430922338949351321043177932553347059884e+09) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(2.6800680160522460937500000000000000000000e+00), SC_(3.1635908081077348686510107071004559462510e+09) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(3.2463350296020507812500000000000000000000e+00), SC_(1.2303497075325310545901965105672532939658e+10) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(3.3070068359375000000000000000000000000000e+00), SC_(1.4045892437378185455808204202593441197868e+10) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(3.7509422302246093750000000000000000000000e+00), SC_(3.4771806190168463129533449195274788248225e+10) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(6.5217073403837831554571404120477803441242e+06) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(5.5581883257898772030487834690267078397254e+06) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(8.1313228740559422839985665257366454720018e+05) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(2.5177888870239257812500000000000000000000e+00), SC_(1.0340772381760380614340388827846170601351e+07) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(2.6800680160522460937500000000000000000000e+00), SC_(1.4481477974665140100740653891200838464662e+07) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(3.2463350296020507812500000000000000000000e+00), SC_(4.1171804843821852210215553139853759077069e+07) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(3.3070068359375000000000000000000000000000e+00), SC_(4.5583442909133570075803470116240017034719e+07) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(3.7509422302246093750000000000000000000000e+00), SC_(9.1440828801015871032133571243730295205235e+07) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(-7.5031699700348463090149309095977514516562e+03) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(-6.9729653369371564877871039200840641569812e+03) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(-2.9505804394143208426726232573855668306351e+03) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(2.5177888870239257812500000000000000000000e+00), SC_(6.4892920808692544551027348020966201147530e+03) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(2.6800680160522460937500000000000000000000e+00), SC_(7.7401260713962433447771216421529061335605e+03) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(3.2463350296020507812500000000000000000000e+00), SC_(1.3344685196503958439909198752104657614836e+04) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(3.3070068359375000000000000000000000000000e+00), SC_(1.4069575898430513916537165641784667968750e+04) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(3.7509422302246093750000000000000000000000e+00), SC_(2.0186819442349002929226742253376869484782e+04) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.5177888870239257812500000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.6800680160522460937500000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(3.2463350296020507812500000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(3.3070068359375000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(3.7509422302246093750000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(3.0000000000000000000000000000000000000000e+00), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(1.4901668746423370038663807728873992986698e+10) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(3.0000000000000000000000000000000000000000e+00), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(1.2471869773200203607350782989992770618545e+10) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(3.0000000000000000000000000000000000000000e+00), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(1.5949602587657422396520464286358974596886e+09) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(3.0000000000000000000000000000000000000000e+00), SC_(2.5177888870239257812500000000000000000000e+00), SC_(2.1296004674203039640821736288578211227606e+09) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(3.0000000000000000000000000000000000000000e+00), SC_(2.6800680160522460937500000000000000000000e+00), SC_(3.5787811318166716946153065756268256072657e+09) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(3.0000000000000000000000000000000000000000e+00), SC_(3.2463350296020507812500000000000000000000e+00), SC_(1.7478133914885319628680064982663538779962e+10) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(3.0000000000000000000000000000000000000000e+00), SC_(3.3070068359375000000000000000000000000000e+00), SC_(2.0361305751253172142890918857237196470052e+10) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(3.0000000000000000000000000000000000000000e+00), SC_(3.7509422302246093750000000000000000000000e+00), SC_(5.7406235084266366245702401774837503481591e+10) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(6.0000000000000000000000000000000000000000e+00), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(4.0058111046848265574641550427443582505904e+11) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(6.0000000000000000000000000000000000000000e+00), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(3.3477997288886693964921102875357592909772e+11) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(6.0000000000000000000000000000000000000000e+00), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(4.1987235777423114407846242505222452841583e+10) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(6.0000000000000000000000000000000000000000e+00), SC_(2.5177888870239257812500000000000000000000e+00), SC_(6.5529041492495556868601872253118354257484e+10) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(6.0000000000000000000000000000000000000000e+00), SC_(2.6800680160522460937500000000000000000000e+00), SC_(1.0963565777083273880974221324644871426702e+11) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(6.0000000000000000000000000000000000000000e+00), SC_(3.2463350296020507812500000000000000000000e+00), SC_(5.2907231375763247203710477330988684020528e+11) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(6.0000000000000000000000000000000000000000e+00), SC_(3.3070068359375000000000000000000000000000e+00), SC_(6.1570707270870236060353948840535454139949e+11) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(6.0000000000000000000000000000000000000000e+00), SC_(3.7509422302246093750000000000000000000000e+00), SC_(1.7245185676896961095645208026261251967793e+12) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(-5.2230603430189230531585745064381688889714e+10) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(-4.4169356765928006589383580321280574874211e+10) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(-6.2176157285768747075914552082524608329821e+09) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(2.5177888870239257812500000000000000000000e+00), SC_(2.8041904247566837896498836851747604437588e+10) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(2.6800680160522460937500000000000000000000e+00), SC_(4.2665871241411937921842809876211642011535e+10) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(3.2463350296020507812500000000000000000000e+00), SC_(1.5561901687909027203215908061902517676392e+11) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+00), SC_(1.7641794616543366615566422192738490272927e+11) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(3.7509422302246093750000000000000000000000e+00), SC_(4.1492028916495875138385139164168695108935e+11) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(-5.5632354577718115251010601448571813401794e+09) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(-4.6869808389549277416237608909703586614138e+09) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(-6.2594115949611721362346528408547963593420e+08) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(2.5177888870239257812500000000000000000000e+00), SC_(3.9660700183048985812578838157918845260591e+09) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(2.6800680160522460937500000000000000000000e+00), SC_(5.9884656253207071593314667172747308282023e+09) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(3.2463350296020507812500000000000000000000e+00), SC_(2.1385549509036393333281721318273799066782e+10) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+00), SC_(2.4198565578100091664673384574941626765792e+10) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(3.7509422302246093750000000000000000000000e+00), SC_(5.6237078805504359582037117019796671860684e+10) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(-1.5057500233481445119667679282154031178748e+08) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(-1.2477513314910789789881670297226659261825e+08) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(-1.2863764360344277009063298223933137129684e+07) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(2.5177888870239257812500000000000000000000e+00), SC_(2.6090008196220559964303657349776170763552e+08) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(2.6800680160522460937500000000000000000000e+00), SC_(3.8680047717973557099406273990712329789285e+08) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(3.2463350296020507812500000000000000000000e+00), SC_(1.3118106995587188399956506470559094997497e+09) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(3.3070068359375000000000000000000000000000e+00), SC_(1.4774950407651467076348368396144474514546e+09) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(3.7509422302246093750000000000000000000000e+00), SC_(3.3322337493816933490740692306609802944529e+09) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(8.7406597995537219972614701827262873350573e+05) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(7.2322268639094144161184470794430132770474e+05) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(5.4557972788212169922980782692657641658061e+04) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(2.5177888870239257812500000000000000000000e+00), SC_(3.3912760433473634369813776164664082662573e+06) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(2.6800680160522460937500000000000000000000e+00), SC_(4.6938910219271849479739212081784225417626e+06) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(3.2463350296020507812500000000000000000000e+00), SC_(1.2900570396491827535953920892874271294769e+07) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(3.3070068359375000000000000000000000000000e+00), SC_(1.4238642199794658717002227217968638996138e+07) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(3.7509422302246093750000000000000000000000e+00), SC_(2.7988569431896494531455531476254995786136e+07) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(-4.5200081986493081607630939444675277627539e+03) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(-4.1966386784816243267094010294115946635429e+03) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(-1.7525353705327459339358142642595339566469e+03) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(2.5177888870239257812500000000000000000000e+00), SC_(4.2044137623374723460537710773010644516035e+03) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(2.6800680160522460937500000000000000000000e+00), SC_(5.0048722587029562379867114740861211430456e+03) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(3.2463350296020507812500000000000000000000e+00), SC_(8.5815937716054346359965260271351894516556e+03) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(3.3070068359375000000000000000000000000000e+00), SC_(9.0433641560063806537073105573654174804688e+03) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(3.7509422302246093750000000000000000000000e+00), SC_(1.2935103724753604183095312407658639131114e+04) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.5177888870239257812500000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.6800680160522460937500000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(3.2463350296020507812500000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(3.3070068359375000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(3.7509422302246093750000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(3.0000000000000000000000000000000000000000e+00), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(4.9555413200798853454613462404109597594612e+08) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(3.0000000000000000000000000000000000000000e+00), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(4.2433334235230103240584530875227758812965e+08) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(3.0000000000000000000000000000000000000000e+00), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(7.0731418209976434902382597726244577594990e+07) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(3.0000000000000000000000000000000000000000e+00), SC_(2.5177888870239257812500000000000000000000e+00), SC_(-8.5306921143594263325811841884986432649152e+07) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(3.0000000000000000000000000000000000000000e+00), SC_(2.6800680160522460937500000000000000000000e+00), SC_(-1.3461004990862955046433961557368549947708e+08) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(3.0000000000000000000000000000000000000000e+00), SC_(3.2463350296020507812500000000000000000000e+00), SC_(-5.4199758957761691029715042821534238666224e+08) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(3.0000000000000000000000000000000000000000e+00), SC_(3.3070068359375000000000000000000000000000e+00), SC_(-6.1974695585351038699767648232846637875368e+08) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(3.0000000000000000000000000000000000000000e+00), SC_(3.7509422302246093750000000000000000000000e+00), SC_(-1.5393366565846773036664081567878601029697e+09) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(6.0000000000000000000000000000000000000000e+00), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(1.0214348617609250630931157780290048944040e+10) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(6.0000000000000000000000000000000000000000e+00), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(8.7330832173778870540762626262452034519783e+09) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(6.0000000000000000000000000000000000000000e+00), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(1.4262406693549145109630610379696733440680e+09) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(6.0000000000000000000000000000000000000000e+00), SC_(2.5177888870239257812500000000000000000000e+00), SC_(-2.0273002372054002028293450403196826103617e+09) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(6.0000000000000000000000000000000000000000e+00), SC_(2.6800680160522460937500000000000000000000e+00), SC_(-3.1840833332328478690814675333084590382626e+09) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(6.0000000000000000000000000000000000000000e+00), SC_(3.2463350296020507812500000000000000000000e+00), SC_(-1.2659516294201404647636864689017863146257e+10) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(6.0000000000000000000000000000000000000000e+00), SC_(3.3070068359375000000000000000000000000000e+00), SC_(-1.4459643453426705907015128296345385693695e+10) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(6.0000000000000000000000000000000000000000e+00), SC_(3.7509422302246093750000000000000000000000e+00), SC_(-3.5666328699104546822643437708377179817898e+10) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(2.0705249583941852921047107940633440181636e+09) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(1.7945023601066531809777798860735154304445e+09) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(3.3712784000295336095294601451921348083216e+08) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(2.5177888870239257812500000000000000000000e+00), SC_(1.1574281283273840218487573923036236087428e+09) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(2.6800680160522460937500000000000000000000e+00), SC_(1.6607892402916781816200862439510701665471e+09) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(3.2463350296020507812500000000000000000000e+00), SC_(5.0539504313665629255163251439936934446217e+09) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+00), SC_(5.6295127705661714307645114164895253041807e+09) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(3.7509422302246093750000000000000000000000e+00), SC_(1.1742044019049273483865375620982826561902e+10) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(3.4828537789281027279931714909273846529044e+08) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(3.0114737370315639562050862070027869840907e+08) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(5.4763733892172071001547317494716254098417e+07) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(2.5177888870239257812500000000000000000000e+00), SC_(2.3477315819478600884179713284202195289239e+08) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(2.6800680160522460937500000000000000000000e+00), SC_(3.3509906705792799767132122748066407766158e+08) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(3.2463350296020507812500000000000000000000e+00), SC_(1.0050063214145772952621866532462563307614e+09) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+00), SC_(1.1180266986048984026726489055752143518150e+09) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(3.7509422302246093750000000000000000000000e+00), SC_(2.3129825810433958716625921766451359472530e+09) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(2.4578195454610112775633536833179484328694e+07) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(2.1103186910568077011948998155175648998962e+07) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(3.4684435546581633457002501767017482095200e+06) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(2.5177888870239257812500000000000000000000e+00), SC_(2.6577145887843629852290035855212268460008e+07) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(2.6800680160522460937500000000000000000000e+00), SC_(3.7498363674149662443550104953481873050416e+07) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(3.2463350296020507812500000000000000000000e+00), SC_(1.0889344889077440695923692763840493649805e+08) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(3.3070068359375000000000000000000000000000e+00), SC_(1.2079222501050340657132044797973984483989e+08) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(3.7509422302246093750000000000000000000000e+00), SC_(2.4533035253347086442379416883311287412965e+08) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(-1.4550113666110366987647165679961348367270e+05) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(-1.3353627831448097325740120304095205802949e+05) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(-4.0763793478884519951866291730119324814980e+04) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(2.5177888870239257812500000000000000000000e+00), SC_(8.7877635997004860262751992424798211216539e+05) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(2.6800680160522460937500000000000000000000e+00), SC_(1.1922690030609898999117762538947210758389e+06) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(3.2463350296020507812500000000000000000000e+00), SC_(3.0870331966721622754441136277905084249146e+06) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(3.3070068359375000000000000000000000000000e+00), SC_(3.3881345056373042241419507764024295255485e+06) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(3.7509422302246093750000000000000000000000e+00), SC_(6.4149887863054716696934522729081700942833e+06) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(-2.4400498907493520842071355048119585262612e+03) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(-2.2620734111220043516185529419715294352500e+03) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(-9.2475963187490601669082934677135199308395e+02) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(2.5177888870239257812500000000000000000000e+00), SC_(2.5321641504910232583699936093069027265301e+03) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(2.6800680160522460937500000000000000000000e+00), SC_(3.0057257467699947590736297975411162042292e+03) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(3.2463350296020507812500000000000000000000e+00), SC_(5.1133708913345877878561807072799183515599e+03) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(3.3070068359375000000000000000000000000000e+00), SC_(5.3847605688521434785798192024230957031250e+03) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(3.7509422302246093750000000000000000000000e+00), SC_(7.6676742845869469289432629466318758204579e+03) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.5177888870239257812500000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.6800680160522460937500000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(3.2463350296020507812500000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(3.3070068359375000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(3.7509422302246093750000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(3.0000000000000000000000000000000000000000e+00), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(1.8275216396049273496488166930333332705398e+07) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(3.0000000000000000000000000000000000000000e+00), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(1.6009491599103285240597685638765638135742e+07) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(3.0000000000000000000000000000000000000000e+00), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(3.4760861351410748402190865321570216342768e+06) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(3.0000000000000000000000000000000000000000e+00), SC_(2.5177888870239257812500000000000000000000e+00), SC_(3.8048809126489133546339975898584587686524e+06) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(3.0000000000000000000000000000000000000000e+00), SC_(2.6800680160522460937500000000000000000000e+00), SC_(5.6368658822283847123688989557374534610979e+06) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(3.0000000000000000000000000000000000000000e+00), SC_(3.2463350296020507812500000000000000000000e+00), SC_(1.8705660846546884331797319193700691860808e+07) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(3.0000000000000000000000000000000000000000e+00), SC_(3.3070068359375000000000000000000000000000e+00), SC_(2.0993455740933701457557529354066365684210e+07) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(3.0000000000000000000000000000000000000000e+00), SC_(3.7509422302246093750000000000000000000000e+00), SC_(4.5929146395403527919754650630466027405086e+07) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(6.0000000000000000000000000000000000000000e+00), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(2.8160304950063306639594145066859531435102e+08) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(6.0000000000000000000000000000000000000000e+00), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(2.4629868667182858948103469465507695601018e+08) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(6.0000000000000000000000000000000000000000e+00), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(5.2345965536203154571084792675452745031866e+07) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(6.0000000000000000000000000000000000000000e+00), SC_(2.5177888870239257812500000000000000000000e+00), SC_(6.8101683143456065058785950925583155206490e+07) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(6.0000000000000000000000000000000000000000e+00), SC_(2.6800680160522460937500000000000000000000e+00), SC_(1.0039523351292610554162755645630183261526e+08) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(6.0000000000000000000000000000000000000000e+00), SC_(3.2463350296020507812500000000000000000000e+00), SC_(3.2874101919428362607960627538439464104685e+08) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(6.0000000000000000000000000000000000000000e+00), SC_(3.3070068359375000000000000000000000000000e+00), SC_(3.6852053366159423743338320701402591785803e+08) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(6.0000000000000000000000000000000000000000e+00), SC_(3.7509422302246093750000000000000000000000e+00), SC_(8.0035111979548426526843266902685364204264e+08) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(-7.2990388444321447109480501292722835951957e+07) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(-6.4812966350936102891007368745453512288413e+07) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(-1.6179840457363703062616547010328762825739e+07) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(2.5177888870239257812500000000000000000000e+00), SC_(4.3493122830999716456473229553812218287847e+07) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(2.6800680160522460937500000000000000000000e+00), SC_(5.8818711357964957080702845350856604645090e+07) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(3.2463350296020507812500000000000000000000e+00), SC_(1.4907680570483425871544852157708987054268e+08) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+00), SC_(1.6313334172530338924861897215677630779140e+08) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(3.7509422302246093750000000000000000000000e+00), SC_(3.0146585878100144200830679812835194369658e+08) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(-1.8118335726080729656399451425896074506856e+07) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(-1.6064340242829145539212310249563621975861e+07) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(-3.9283113434029093719841059467153768284037e+06) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(2.5177888870239257812500000000000000000000e+00), SC_(1.2222454989220602587785746098280219387203e+07) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(2.6800680160522460937500000000000000000000e+00), SC_(1.6469532719017031766514408852830174462336e+07) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(3.2463350296020507812500000000000000000000e+00), SC_(4.1329675013172163486175536623254213555613e+07) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+00), SC_(4.5187250067013691148854094212228282856358e+07) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(3.7509422302246093750000000000000000000000e+00), SC_(8.3041889374887374716206593955091695759735e+07) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(-2.5065367167293816546310577985180716481609e+06) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(-2.2143109665992227014013238740477627398930e+06) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(-5.1452334622069033025034010949037728395972e+05) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(2.5177888870239257812500000000000000000000e+00), SC_(2.2225856287187559953655653141631216720229e+06) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(2.6800680160522460937500000000000000000000e+00), SC_(2.9730351249228789293359283600603211717846e+06) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(3.2463350296020507812500000000000000000000e+00), SC_(7.3109828203455748357048658905781703665790e+06) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(3.3070068359375000000000000000000000000000e+00), SC_(7.9790518584486518280449811844901031321342e+06) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(3.7509422302246093750000000000000000000000e+00), SC_(1.4496066934788374336303272449039005743029e+07) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(-5.6944307318148260908244253380754970399015e+04) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(-4.8965751117370775333202652915203518550052e+04) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(-7.1186828732238339055370888636342631650779e+03) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(2.5177888870239257812500000000000000000000e+00), SC_(1.6631654440437333582235112446642526247832e+05) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(2.6800680160522460937500000000000000000000e+00), SC_(2.1775703687949073059899141463336877189273e+05) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(3.2463350296020507812500000000000000000000e+00), SC_(5.0382647459026276020779746895969803895231e+05) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(3.3070068359375000000000000000000000000000e+00), SC_(5.4684433348428782009715025044793712538649e+05) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(3.7509422302246093750000000000000000000000e+00), SC_(9.5858495108037515955391770844154186827195e+05) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(-1.1038562467537845234455406995266457670368e+03) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(-1.0204718380729672695360343848136608357891e+03) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(-4.0056106032247428139214662223821505904198e+02) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(2.5177888870239257812500000000000000000000e+00), SC_(1.3767777217619728673918266803610777060385e+03) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(2.6800680160522460937500000000000000000000e+00), SC_(1.6271847500413041924839652185852401089505e+03) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(3.2463350296020507812500000000000000000000e+00), SC_(2.7347438227112264174482880729755152060534e+03) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(3.3070068359375000000000000000000000000000e+00), SC_(2.8767667386357570649124681949615478515625e+03) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(3.7509422302246093750000000000000000000000e+00), SC_(4.0678863098920566179206304013860062696040e+03) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.5177888870239257812500000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.6800680160522460937500000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(3.2463350296020507812500000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(3.3070068359375000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(3.7509422302246093750000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(3.0000000000000000000000000000000000000000e+00), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(7.5610253611613554023645775799526391176040e+05) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(3.0000000000000000000000000000000000000000e+00), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(6.7758744817324917913235281625635607317454e+05) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(3.0000000000000000000000000000000000000000e+00), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(1.9146334869696222057715339445304907729639e+05) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(3.0000000000000000000000000000000000000000e+00), SC_(2.5177888870239257812500000000000000000000e+00), SC_(-1.9149210419640373680608758745463796099516e+05) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(3.0000000000000000000000000000000000000000e+00), SC_(2.6800680160522460937500000000000000000000e+00), SC_(-2.6630295136675537256274882039177861162354e+05) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(3.0000000000000000000000000000000000000000e+00), SC_(3.2463350296020507812500000000000000000000e+00), SC_(-7.2798359652031352607406513813781665672729e+05) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(3.0000000000000000000000000000000000000000e+00), SC_(3.3070068359375000000000000000000000000000e+00), SC_(-8.0187803134479973019980666472383834531001e+05) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(3.0000000000000000000000000000000000000000e+00), SC_(3.7509422302246093750000000000000000000000e+00), SC_(-1.5448398265436864138067764205768080122059e+06) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(6.0000000000000000000000000000000000000000e+00), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(8.4478031272384011931866041694800197290975e+06) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(6.0000000000000000000000000000000000000000e+00), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(7.5580609622724066902058030088469615370858e+06) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(6.0000000000000000000000000000000000000000e+00), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(2.0887053801524487369001990570011572347191e+06) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(6.0000000000000000000000000000000000000000e+00), SC_(2.5177888870239257812500000000000000000000e+00), SC_(-2.5031214537168496164163100714184745040908e+06) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(6.0000000000000000000000000000000000000000e+00), SC_(2.6800680160522460937500000000000000000000e+00), SC_(-3.4629665358718253010105235299477458775816e+06) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(6.0000000000000000000000000000000000000000e+00), SC_(3.2463350296020507812500000000000000000000e+00), SC_(-9.3343969126203125031587283815480515766662e+06) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(6.0000000000000000000000000000000000000000e+00), SC_(3.3070068359375000000000000000000000000000e+00), SC_(-1.0269351771882180721942051486450520059179e+07) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(6.0000000000000000000000000000000000000000e+00), SC_(3.7509422302246093750000000000000000000000e+00), SC_(-1.9631958265427033442177970802913917273484e+07) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(2.3186347945243345625361793176879120627169e+06) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(2.1089409579853823061049394007476488542118e+06) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(6.9742245228270840534138443468463453012163e+05) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(2.5177888870239257812500000000000000000000e+00), SC_(1.4989336345917606102377437397408818852633e+06) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(2.6800680160522460937500000000000000000000e+00), SC_(1.9095827584627853007148988227689132136488e+06) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(3.2463350296020507812500000000000000000000e+00), SC_(4.0255278927212564822744371843903774003330e+06) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+00), SC_(4.3270951553095110166093917314356076531112e+06) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(3.7509422302246093750000000000000000000000e+00), SC_(7.0791787979339210343185221376943695378858e+06) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(8.0865322287695730604139974458114461250760e+05) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(7.3481894347578476227495379970307591297797e+05) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(2.3985012259119166259274661041379916870397e+05) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(2.5177888870239257812500000000000000000000e+00), SC_(5.6682860380177766416872492365059088854765e+05) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(2.6800680160522460937500000000000000000000e+00), SC_(7.2037419380016722578962153217609998704708e+05) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(3.2463350296020507812500000000000000000000e+00), SC_(1.5085839185921037664123456252132485852903e+06) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+00), SC_(1.6206579414866650061473052346627810038626e+06) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(3.7509422302246093750000000000000000000000e+00), SC_(2.6416500436587318383118804858514802949565e+06) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(1.8996332104612870977331483544009807246794e+05) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(1.7227022514371129916021631688850867457049e+05) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(5.4678439224904934975511974510481438827014e+04) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(2.5177888870239257812500000000000000000000e+00), SC_(1.5653057200243908385862073148118014058851e+05) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(2.6800680160522460937500000000000000000000e+00), SC_(1.9802356788785667122427587685945408400552e+05) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(3.2463350296020507812500000000000000000000e+00), SC_(4.0949978901081489159618554652345936794135e+05) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(3.3070068359375000000000000000000000000000e+00), SC_(4.3943404726811741288727830578864086419344e+05) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(3.7509422302246093750000000000000000000000e+00), SC_(7.1121580811136478717051483754260816916304e+05) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(1.7324094826542807044944497599563376730863e+04) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(1.5593231073082556739491697069241712888263e+04) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(4.4388994112013822540299906680566488503814e+03) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(2.5177888870239257812500000000000000000000e+00), SC_(2.3330778037017506222262490916328150919326e+04) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(2.6800680160522460937500000000000000000000e+00), SC_(2.9171520575532003312286896219938332671393e+04) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(3.2463350296020507812500000000000000000000e+00), SC_(5.8380738903266236140822939058202140782819e+04) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(3.3070068359375000000000000000000000000000e+00), SC_(6.2465684189248599517796378677303437143564e+04) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(3.7509422302246093750000000000000000000000e+00), SC_(9.9218113569746950797015534037810204071040e+04) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(-3.5198846708141192257679463750719150993973e+02) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(-3.2303626254918378748332008498778122884687e+02) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(-1.1324749275712391849424420797731727361679e+02) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(2.5177888870239257812500000000000000000000e+00), SC_(6.4248895258238684845969457271053215663414e+02) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(2.6800680160522460937500000000000000000000e+00), SC_(7.5374748296082982266380634328584164904896e+02) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(3.2463350296020507812500000000000000000000e+00), SC_(1.2404398327551590467329734046586509066401e+03) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(3.3070068359375000000000000000000000000000e+00), SC_(1.3023842670251760864630341529846191406250e+03) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(3.7509422302246093750000000000000000000000e+00), SC_(1.8190949887119587011774513030104571953416e+03) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.5177888870239257812500000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.6800680160522460937500000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(3.2463350296020507812500000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(3.3070068359375000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(3.7509422302246093750000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(3.0000000000000000000000000000000000000000e+00), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(3.5602450582555946850038489751359932575930e+04) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(3.0000000000000000000000000000000000000000e+00), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(3.2635491113545671743622386802827481296638e+04) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(3.0000000000000000000000000000000000000000e+00), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(1.1984395506252049440429086621731635808885e+04) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(3.0000000000000000000000000000000000000000e+00), SC_(2.5177888870239257812500000000000000000000e+00), SC_(1.1063634633933438613649229680866373232021e+04) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(3.0000000000000000000000000000000000000000e+00), SC_(2.6800680160522460937500000000000000000000e+00), SC_(1.4439085286595604564473046645354477242893e+04) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(3.0000000000000000000000000000000000000000e+00), SC_(3.2463350296020507812500000000000000000000e+00), SC_(3.2492964243140079372317549131386644345335e+04) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(3.0000000000000000000000000000000000000000e+00), SC_(3.3070068359375000000000000000000000000000e+00), SC_(3.5125704368312176024247150962764862924814e+04) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(3.0000000000000000000000000000000000000000e+00), SC_(3.7509422302246093750000000000000000000000e+00), SC_(5.9566188912257823417687125486436917898292e+04) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(6.0000000000000000000000000000000000000000e+00), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(2.7782521515538028957301684982400893659388e+05) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(6.0000000000000000000000000000000000000000e+00), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(2.5424116272053503630603656470655970432389e+05) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(6.0000000000000000000000000000000000000000e+00), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(9.1263444772587031722565012199083200883365e+04) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(6.0000000000000000000000000000000000000000e+00), SC_(2.5177888870239257812500000000000000000000e+00), SC_(1.0160974451284261430015137103097657371832e+05) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(6.0000000000000000000000000000000000000000e+00), SC_(2.6800680160522460937500000000000000000000e+00), SC_(1.3188886627278297571184469241939322335351e+05) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(6.0000000000000000000000000000000000000000e+00), SC_(3.2463350296020507812500000000000000000000e+00), SC_(2.9245531403773569822098833093596839482033e+05) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(6.0000000000000000000000000000000000000000e+00), SC_(3.3070068359375000000000000000000000000000e+00), SC_(3.1574799083368705628416250874579418450594e+05) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(6.0000000000000000000000000000000000000000e+00), SC_(3.7509422302246093750000000000000000000000e+00), SC_(5.3113713471103873728564730781584631025272e+05) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(-6.7067858512150170049989639231569071853301e+04) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(-6.2475577426779083433159081573116111485433e+04) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(-2.7306578869789376967425198472483316436410e+04) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(2.5177888870239257812500000000000000000000e+00), SC_(4.7681348077487537088075056357361347636470e+04) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(2.6800680160522460937500000000000000000000e+00), SC_(5.7200057168246966779403747671572944000218e+04) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(3.2463350296020507812500000000000000000000e+00), SC_(1.0018555399070466398427255161340809763715e+05) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+00), SC_(1.0577395190284834461635909974575042724609e+05) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(3.7509422302246093750000000000000000000000e+00), SC_(1.5310700943790741803096633333325371495448e+05) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(-3.1656627682056690737011361846953150234185e+04) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(-2.9471839817424992851536968974102137508453e+04) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(-1.2779297279544506583448537639924325048923e+04) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(2.5177888870239257812500000000000000000000e+00), SC_(2.3670402893208399598141966624353926818003e+04) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(2.6800680160522460937500000000000000000000e+00), SC_(2.8352250040893742361790275108290870775818e+04) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(3.2463350296020507812500000000000000000000e+00), SC_(4.9451191001978652774080658094391083068331e+04) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+00), SC_(5.2190472387466914369724690914154052734375e+04) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(3.7509422302246093750000000000000000000000e+00), SC_(7.5369441326157503810545534861375926993787e+04) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(-1.1548974004487160084864161291307027568109e+04) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(-1.0739851083273930127830186886939145551878e+04) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(-4.5855870016379575524467782088322564959526e+03) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(2.5177888870239257812500000000000000000000e+00), SC_(9.4825646296543039101764605014466269494733e+03) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(2.6800680160522460937500000000000000000000e+00), SC_(1.1326988970405910794998771695674122383934e+04) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(3.2463350296020507812500000000000000000000e+00), SC_(1.9607917899010350677634073601751651949598e+04) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(3.3070068359375000000000000000000000000000e+00), SC_(2.0680394194456588593311607837677001953125e+04) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(3.7509422302246093750000000000000000000000e+00), SC_(2.9739466249330117716187515952697140164673e+04) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(-2.4400498907493520842071355048119585262612e+03) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(-2.2620734111220043516185529419715294352500e+03) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(-9.2475963187490601669082934677135199308395e+02) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(2.5177888870239257812500000000000000000000e+00), SC_(2.5321641504910232583699936093069027265301e+03) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(2.6800680160522460937500000000000000000000e+00), SC_(3.0057257467699947590736297975411162042292e+03) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(3.2463350296020507812500000000000000000000e+00), SC_(5.1133708913345877878561807072799183515599e+03) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(3.3070068359375000000000000000000000000000e+00), SC_(5.3847605688521434785798192024230957031250e+03) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(3.7509422302246093750000000000000000000000e+00), SC_(7.6676742845869469289432629466318758204579e+03) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(-2.5007752151040725699382427649197779828683e+01) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(-2.0968987765324612481884769543682978110155e+01) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(3.8732339394718815483997786941472440958023e+00) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(2.5177888870239257812500000000000000000000e+00), SC_(2.3353231938433087691402156860220884482260e+02) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(2.6800680160522460937500000000000000000000e+00), SC_(2.6991215997251693405924177771026961636380e+02) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(3.2463350296020507812500000000000000000000e+00), SC_(4.2518618848619419767036198276599634482409e+02) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(3.3070068359375000000000000000000000000000e+00), SC_(4.4461475568835521698929369449615478515625e+02) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(3.7509422302246093750000000000000000000000e+00), SC_(6.0465550908967862986376218259465531446040e+02) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.5177888870239257812500000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.6800680160522460937500000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(3.2463350296020507812500000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(3.3070068359375000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(3.7509422302246093750000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(3.0000000000000000000000000000000000000000e+00), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(1.9428209543959961022319138379543801420368e+03) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(3.0000000000000000000000000000000000000000e+00), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(1.8213713653778603962472837363151256795391e+03) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(3.0000000000000000000000000000000000000000e+00), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(8.6730907050150219639306214958196505904198e+02) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(3.0000000000000000000000000000000000000000e+00), SC_(2.5177888870239257812500000000000000000000e+00), SC_(-7.5110194399619613818061547583226911228849e+02) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(3.0000000000000000000000000000000000000000e+00), SC_(2.6800680160522460937500000000000000000000e+00), SC_(-9.1955894316103336305970317177127526520053e+02) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(3.0000000000000000000000000000000000000000e+00), SC_(3.2463350296020507812500000000000000000000e+00), SC_(-1.7015514645891647122315226692279566123034e+03) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(3.0000000000000000000000000000000000000000e+00), SC_(3.3070068359375000000000000000000000000000e+00), SC_(-1.8050404531781459809280931949615478515625e+03) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(3.0000000000000000000000000000000000000000e+00), SC_(3.7509422302246093750000000000000000000000e+00), SC_(-2.6927021655204017795970372617375687696040e+03) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(6.0000000000000000000000000000000000000000e+00), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(1.0105302699729173590337261146032687975094e+04) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(6.0000000000000000000000000000000000000000e+00), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(9.4576829215721474866801488090573002409656e+03) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(6.0000000000000000000000000000000000000000e+00), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(4.4034888496388023284566770598758012056351e+03) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(6.0000000000000000000000000000000000000000e+00), SC_(2.5177888870239257812500000000000000000000e+00), SC_(-4.6084426489384843034363692382271437963936e+03) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(6.0000000000000000000000000000000000000000e+00), SC_(2.6800680160522460937500000000000000000000e+00), SC_(-5.6103128795240604750754753737851387995761e+03) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(6.0000000000000000000000000000000000000000e+00), SC_(3.2463350296020507812500000000000000000000e+00), SC_(-1.0224831995746469846100823453127759421477e+04) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(6.0000000000000000000000000000000000000000e+00), SC_(3.3070068359375000000000000000000000000000e+00), SC_(-1.0832463358811306534335017204284667968750e+04) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(6.0000000000000000000000000000000000000000e+00), SC_(3.7509422302246093750000000000000000000000e+00), SC_(-1.6025860910309839527876363263203529641032e+04) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(1.7815035081399910268373787403106689453125e+03) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(1.6993821038016048987628892064094543457031e+03) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(9.7997586901497561484575271606445312500000e+02) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(2.5177888870239257812500000000000000000000e+00), SC_(1.4077784513311653427081182599067687988281e+03) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(2.6800680160522460937500000000000000000000e+00), SC_(1.5897826003214740921976044774055480957031e+03) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(3.2463350296020507812500000000000000000000e+00), SC_(2.3115151870165445870952680706977844238281e+03) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+00), SC_(2.3968319897949695587158203125000000000000e+03) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(3.7509422302246093750000000000000000000000e+00), SC_(3.0681374659480352420359849929809570312500e+03) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(1.1048268025025172391906380653381347656250e+03) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(1.0535569453449024877045303583145141601562e+03) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(6.0487880429462529718875885009765625000000e+02) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(2.5177888870239257812500000000000000000000e+00), SC_(8.9820936939856983372010290622711181640625e+02) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(2.6800680160522460937500000000000000000000e+00), SC_(1.0134465557131952664349228143692016601562e+03) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(3.2463350296020507812500000000000000000000e+00), SC_(1.4700192691340671444777399301528930664062e+03) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+00), SC_(1.5239590001702308654785156250000000000000e+03) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(3.7509422302246093750000000000000000000000e+00), SC_(1.9482055386370630003511905670166015625000e+03) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(5.8843809886978124268352985382080078125000e+02) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(5.6080615573639079229906201362609863281250e+02) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(3.1943268503295257687568664550781250000000e+02) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(2.5177888870239257812500000000000000000000e+00), SC_(5.0274698329915554495528340339660644531250e+02) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(2.6800680160522460937500000000000000000000e+00), SC_(5.6640027337690844433382153511047363281250e+02) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(3.2463350296020507812500000000000000000000e+00), SC_(8.1821979149117396445944905281066894531250e+02) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(3.3070068359375000000000000000000000000000e+00), SC_(8.4793930637836456298828125000000000000000e+02) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(3.7509422302246093750000000000000000000000e+00), SC_(1.0815258283867733553051948547363281250000e+03) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(2.3233739724178303731605410575866699218750e+02) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(2.2112973497606981254648417234420776367188e+02) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(1.2363751122995745390653610229492187500000e+02) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(2.5177888870239257812500000000000000000000e+00), SC_(2.2139129303292247641365975141525268554688e+02) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(2.6800680160522460937500000000000000000000e+00), SC_(2.4864375331261362589430063962936401367188e+02) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(3.2463350296020507812500000000000000000000e+00), SC_(3.5611675408786504704039543867111206054688e+02) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(3.3070068359375000000000000000000000000000e+00), SC_(3.6877290841937065124511718750000000000000e+02) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(3.7509422302246093750000000000000000000000e+00), SC_(4.6809833519716630689799785614013671875000e+02) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(3.6524697618522623088210821151733398437500e+01) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(3.4527683063939548446796834468841552734375e+01) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(1.7493282885639928281307220458984375000000e+01) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(2.5177888870239257812500000000000000000000e+00), SC_(5.4142298599870628095231950283050537109375e+01) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(2.6800680160522460937500000000000000000000e+00), SC_(6.0176995520310811116360127925872802734375e+01) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(3.2463350296020507812500000000000000000000e+00), SC_(8.3710156924140392220579087734222412109375e+01) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(3.3070068359375000000000000000000000000000e+00), SC_(8.6459806293249130249023437500000000000000e+01) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(3.7509422302246093750000000000000000000000e+00), SC_(1.0792305906824185512959957122802734375000e+02) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.5177888870239257812500000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.6800680160522460937500000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(3.2463350296020507812500000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(3.3070068359375000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(3.7509422302246093750000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(3.0000000000000000000000000000000000000000e+00), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(1.2576330438621516805142164230346679687500e+02) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(3.0000000000000000000000000000000000000000e+00), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(1.2054668578425116720609366893768310546875e+02) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(3.0000000000000000000000000000000000000000e+00), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(7.4157662573037669062614440917968750000000e+01) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(3.0000000000000000000000000000000000000000e+00), SC_(2.5177888870239257812500000000000000000000e+00), SC_(6.1964397233310592127963900566101074218750e+01) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(3.0000000000000000000000000000000000000000e+00), SC_(2.6800680160522460937500000000000000000000e+00), SC_(7.1112766751681192545220255851745605468750e+01) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(3.0000000000000000000000000000000000000000e+00), SC_(3.2463350296020507812500000000000000000000e+00), SC_(1.0798628331544387037865817546844482421875e+02) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(3.0000000000000000000000000000000000000000e+00), SC_(3.3070068359375000000000000000000000000000e+00), SC_(1.1239348953962326049804687500000000000000e+02) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(3.0000000000000000000000000000000000000000e+00), SC_(3.7509422302246093750000000000000000000000e+00), SC_(1.4732915799244074150919914245605468750000e+02) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(6.0000000000000000000000000000000000000000e+00), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(4.1081461077716812724247574806213378906250e+02) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(6.0000000000000000000000000000000000000000e+00), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(3.9316774041669305006507784128189086914062e+02) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(6.0000000000000000000000000000000000000000e+00), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(2.3696627060475293546915054321289062500000e+02) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(6.0000000000000000000000000000000000000000e+00), SC_(2.5177888870239257812500000000000000000000e+00), SC_(2.3703549029980240447912365198135375976562e+02) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(6.0000000000000000000000000000000000000000e+00), SC_(2.6800680160522460937500000000000000000000e+00), SC_(2.7051529577535438875202089548110961914062e+02) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(6.0000000000000000000000000000000000000000e+00), SC_(3.2463350296020507812500000000000000000000e+00), SC_(4.0466900687047200335655361413955688476562e+02) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(6.0000000000000000000000000000000000000000e+00), SC_(3.3070068359375000000000000000000000000000e+00), SC_(4.2064027491211891174316406250000000000000e+02) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(6.0000000000000000000000000000000000000000e+00), SC_(3.7509422302246093750000000000000000000000e+00), SC_(5.4691053304556407965719699859619140625000e+02) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(-4.3761590957641601562500000000000000000000e+01) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(-4.2742766380310058593750000000000000000000e+01) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(-3.2475914001464843750000000000000000000000e+01) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(2.5177888870239257812500000000000000000000e+00), SC_(3.8766833305358886718750000000000000000000e+01) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(2.6800680160522460937500000000000000000000e+00), SC_(4.1201020240783691406250000000000000000000e+01) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(3.2463350296020507812500000000000000000000e+00), SC_(4.9695025444030761718750000000000000000000e+01) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+00), SC_(5.0605102539062500000000000000000000000000e+01) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(-1.5000000000000000000000000000000000000000e+01), SC_(3.7509422302246093750000000000000000000000e+00), SC_(5.7264133453369140625000000000000000000000e+01) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(-3.4809272766113281250000000000000000000000e+01) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(-3.3994213104248046875000000000000000000000e+01) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(-2.5780731201171875000000000000000000000000e+01) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(2.5177888870239257812500000000000000000000e+00), SC_(3.1213466644287109375000000000000000000000e+01) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(2.6800680160522460937500000000000000000000e+00), SC_(3.3160816192626953125000000000000000000000e+01) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(3.2463350296020507812500000000000000000000e+00), SC_(3.9956020355224609375000000000000000000000e+01) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+00), SC_(4.0684082031250000000000000000000000000000e+01) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(-1.2000000000000000000000000000000000000000e+01), SC_(3.7509422302246093750000000000000000000000e+00), SC_(4.6011306762695312500000000000000000000000e+01) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(-2.5856954574584960937500000000000000000000e+01) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(-2.5245659828186035156250000000000000000000e+01) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(-1.9085548400878906250000000000000000000000e+01) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(2.5177888870239257812500000000000000000000e+00), SC_(2.3660099983215332031250000000000000000000e+01) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(2.6800680160522460937500000000000000000000e+00), SC_(2.5120612144470214843750000000000000000000e+01) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(3.2463350296020507812500000000000000000000e+00), SC_(3.0217015266418457031250000000000000000000e+01) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(3.3070068359375000000000000000000000000000e+00), SC_(3.0763061523437500000000000000000000000000e+01) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(-9.0000000000000000000000000000000000000000e+00), SC_(3.7509422302246093750000000000000000000000e+00), SC_(3.4758480072021484375000000000000000000000e+01) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(-1.6904636383056640625000000000000000000000e+01) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(-1.6497106552124023437500000000000000000000e+01) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(-1.2390365600585937500000000000000000000000e+01) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(2.5177888870239257812500000000000000000000e+00), SC_(1.6106733322143554687500000000000000000000e+01) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(2.6800680160522460937500000000000000000000e+00), SC_(1.7080408096313476562500000000000000000000e+01) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(3.2463350296020507812500000000000000000000e+00), SC_(2.0478010177612304687500000000000000000000e+01) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(3.3070068359375000000000000000000000000000e+00), SC_(2.0842041015625000000000000000000000000000e+01) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(-6.0000000000000000000000000000000000000000e+00), SC_(3.7509422302246093750000000000000000000000e+00), SC_(2.3505653381347656250000000000000000000000e+01) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(-7.9523181915283203125000000000000000000000e+00) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(-7.7485532760620117187500000000000000000000e+00) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(-5.6951828002929687500000000000000000000000e+00) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(2.5177888870239257812500000000000000000000e+00), SC_(8.5533666610717773437500000000000000000000e+00) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(2.6800680160522460937500000000000000000000e+00), SC_(9.0402040481567382812500000000000000000000e+00) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(3.2463350296020507812500000000000000000000e+00), SC_(1.0739005088806152343750000000000000000000e+01) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(3.3070068359375000000000000000000000000000e+00), SC_(1.0921020507812500000000000000000000000000e+01) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(-3.0000000000000000000000000000000000000000e+00), SC_(3.7509422302246093750000000000000000000000e+00), SC_(1.2252826690673828125000000000000000000000e+01) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.5177888870239257812500000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.6800680160522460937500000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(3.2463350296020507812500000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(3.3070068359375000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(3.7509422302246093750000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(3.0000000000000000000000000000000000000000e+00), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(9.9523181915283203125000000000000000000000e+00) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(3.0000000000000000000000000000000000000000e+00), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(9.7485532760620117187500000000000000000000e+00) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(3.0000000000000000000000000000000000000000e+00), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(7.6951828002929687500000000000000000000000e+00) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(3.0000000000000000000000000000000000000000e+00), SC_(2.5177888870239257812500000000000000000000e+00), SC_(-6.5533666610717773437500000000000000000000e+00) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(3.0000000000000000000000000000000000000000e+00), SC_(2.6800680160522460937500000000000000000000e+00), SC_(-7.0402040481567382812500000000000000000000e+00) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(3.0000000000000000000000000000000000000000e+00), SC_(3.2463350296020507812500000000000000000000e+00), SC_(-8.7390050888061523437500000000000000000000e+00) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(3.0000000000000000000000000000000000000000e+00), SC_(3.3070068359375000000000000000000000000000e+00), SC_(-8.9210205078125000000000000000000000000000e+00) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(3.0000000000000000000000000000000000000000e+00), SC_(3.7509422302246093750000000000000000000000e+00), SC_(-1.0252826690673828125000000000000000000000e+01) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(6.0000000000000000000000000000000000000000e+00), SC_(-2.9841060638427734375000000000000000000000e+00), SC_(1.8904636383056640625000000000000000000000e+01) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(6.0000000000000000000000000000000000000000e+00), SC_(-2.9161844253540039062500000000000000000000e+00), SC_(1.8497106552124023437500000000000000000000e+01) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(6.0000000000000000000000000000000000000000e+00), SC_(-2.2317276000976562500000000000000000000000e+00), SC_(1.4390365600585937500000000000000000000000e+01) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(6.0000000000000000000000000000000000000000e+00), SC_(2.5177888870239257812500000000000000000000e+00), SC_(-1.4106733322143554687500000000000000000000e+01) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(6.0000000000000000000000000000000000000000e+00), SC_(2.6800680160522460937500000000000000000000e+00), SC_(-1.5080408096313476562500000000000000000000e+01) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(6.0000000000000000000000000000000000000000e+00), SC_(3.2463350296020507812500000000000000000000e+00), SC_(-1.8478010177612304687500000000000000000000e+01) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(6.0000000000000000000000000000000000000000e+00), SC_(3.3070068359375000000000000000000000000000e+00), SC_(-1.8842041015625000000000000000000000000000e+01) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(6.0000000000000000000000000000000000000000e+00), SC_(3.7509422302246093750000000000000000000000e+00), SC_(-2.1505653381347656250000000000000000000000e+01) }
   }};
//#undef SC_
