/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.dialogs;

import java.awt.BorderLayout;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.TextField;
import rene.gui.ButtonAction;
import rene.gui.CheckboxAction;
import rene.gui.DoActionListener;
import rene.gui.Global;
import rene.gui.IconBar;
import rene.gui.MyChoice;
import rene.gui.MyLabel;
import rene.gui.MyPanel;
import rene.gui.Panel3D;
import rene.gui.TextFieldAction;
import rene.util.FileName;
import rene.zirkel.Zirkel;
import rene.zirkel.ZirkelFrame;
import rene.zirkel.construction.Construction;
import rene.zirkel.dialogs.HelpCloseDialog;

public class ExportTemplateDialog
extends HelpCloseDialog {
    ZirkelFrame ZF;
    Construction C;
    TextField PageTitle;
    TextField CFile;
    TextField Codebase;
    Checkbox Job;
    Panel CP;
    Choice Style;
    boolean OK = false;
    IconBar IBa;
    IconBar IBb;
    boolean SaveDimensions = true;
    boolean Restrict;
    static String[] ISb = new String[]{"back", "delete", "undo", "showcolor", "showname", "showvalue", "color", "hidden", "macro0", "replay", "arrow", "obtuse", "solid", "grid", "thickness0", "type0", "partial", "plines", "twolines", "macrobar", "qintersection", "qpointon", "qchoice", "indicate", "draw", "rename", "function"};
    static String[] ISb0 = new String[]{"back", "delete", "undo", "showcolor", "showname", "showvalue", "color", "hidden", "macro", "replay", "arrow", "obtuse", "solid", "grid", "thickness", "type", "partial", "plines", "twolines", "macrobar", "qintersection", "qpointon", "qchoice", "indicate", "draw", "rename", "function"};
    static String[] ST = new String[]{"plain", "3D", "icons", "full", "nonvisual", "breaks"};

    public ExportTemplateDialog(ZirkelFrame zirkelFrame, Construction construction, boolean bl) {
        super(zirkelFrame, Zirkel.name("export.title"), true);
        int n;
        this.ZF = zirkelFrame;
        this.C = construction;
        this.Restrict = bl;
        this.setLayout(new BorderLayout());
        MyPanel myPanel = new MyPanel();
        myPanel.setLayout(new GridLayout(0, 2));
        myPanel.add(new MyLabel(Zirkel.name("export.pagetitle")));
        this.PageTitle = new TextFieldAction((DoActionListener)this, "export.pagetitle", 32);
        myPanel.add(this.PageTitle);
        this.PageTitle.setText(FileName.purefilename(zirkelFrame.Filename));
        myPanel.add(new MyLabel(Zirkel.name("export.codebase")));
        this.Codebase = new TextFieldAction((DoActionListener)this, "export.codebase", 32);
        myPanel.add(this.Codebase);
        this.Codebase.setText(Global.getParameter("export.codebase", "."));
        myPanel.add(new MyLabel(Zirkel.name("export.file")));
        this.CFile = new TextFieldAction((DoActionListener)this, "export.file", 32);
        myPanel.add(this.CFile);
        this.CFile.setText(Global.getParameter("export.path", "") + FileName.filename(zirkelFrame.Filename));
        if (zirkelFrame.ZC.isJob()) {
            myPanel.add(new MyLabel(""));
            this.Job = new CheckboxAction(this, Zirkel.name("export.job"));
            myPanel.add(this.Job);
            this.Job.setState(true);
        }
        this.Style = new MyChoice();
        for (n = 0; n < ST.length; ++n) {
            this.Style.add(Global.name("export." + ST[n]));
        }
        n = Global.getParameter("export.style", 0);
        if (n <= 1 && this.ZF.ZC.isJob()) {
            n = 3;
        }
        this.Style.select(n);
        myPanel.add(new MyLabel(Zirkel.name("export.style")));
        myPanel.add(this.Style);
        this.add("North", new Panel3D(myPanel));
        MyPanel myPanel2 = new MyPanel();
        myPanel2.setLayout(new GridLayout(0, 1));
        this.IBa = new IconBar(this.ZF);
        String string = bl ? Global.getParameter("restrictedicons", "point line segment ray circle circle3 fixedcircle fixedangle intersection") : Global.getParameter("export.icons", "point line segment ray circle circle3 fixedcircle fixedangle intersection");
        for (int i = 0; i < 26; ++i) {
            String string2 = ZirkelFrame.ObjectStrings[i];
            this.IBa.addToggleLeft(string2);
            if (!string.equals("full") && string.indexOf(string2) < 0) continue;
            this.IBa.setState(string2, true);
        }
        myPanel2.add(new Panel3D(this.IBa));
        this.IBb = new IconBar(this.ZF);
        String string3 = bl ? Global.getParameter("restrictedicons", "back hidden color twolines ") : Global.getParameter("export.tools", "back hidden color twolines ");
        for (int i = 0; i < ISb.length; ++i) {
            String string4 = ISb[i];
            if (string4.equals("qintersection")) {
                this.IBb.addSeparatorLeft();
            }
            if (string4.equals("twolines")) {
                this.IBb.addSeparatorLeft();
            }
            if (string4.equals("draw")) {
                this.IBb.addSeparatorLeft();
            }
            this.IBb.addToggleLeft(string4);
            if (!string3.equals("full") && string3.indexOf(ISb0[i]) < 0) continue;
            this.IBb.setState(string4, true);
        }
        myPanel2.add(new Panel3D(this.IBb));
        this.IBb.setState("qchoice", Global.getParameter("options.choice", false));
        this.IBb.setState("qintersection", Global.getParameter("options.intersection", false));
        this.IBb.setState("qpointon", Global.getParameter("options.pointon", false));
        this.IBb.setState("indicate", !Global.getParameter("options.indicate.simple", false));
        this.add("Center", myPanel2);
        MyPanel myPanel3 = new MyPanel();
        myPanel3.add(new ButtonAction(this, Zirkel.name("ok"), "OK"));
        myPanel3.add(new ButtonAction(this, Zirkel.name("abort"), "Close"));
        this.addHelp(myPanel3, "htmlexporttemplate");
        this.add("South", myPanel3);
        this.pack();
        if (this.getSize().width > 750) {
            this.setSize(750, this.getSize().height);
        }
    }

    public void doAction(String string) {
        this.OK = false;
        if (string.equals("OK")) {
            this.OK = true;
            int n = this.Style.getSelectedIndex();
            if (n >= 0) {
                Global.setParameter("export.style", n);
            }
            this.getIcons();
            this.getTools();
            this.doclose();
        } else {
            super.doAction(string);
        }
    }

    public boolean isAborted() {
        return !this.OK;
    }

    public String getPageTitle() {
        return this.PageTitle.getText();
    }

    public String getIcons() {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        for (int i = 0; i < 26; ++i) {
            String string = ZirkelFrame.ObjectStrings[i];
            if (!this.IBa.getState(string)) continue;
            if (!bl) {
                stringBuffer.append(' ');
            }
            stringBuffer.append(string);
            bl = false;
        }
        if (!this.Restrict) {
            Global.setParameter("export.icons", stringBuffer.toString());
        }
        return stringBuffer.toString();
    }

    public String getTools() {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        for (int i = 0; i < ISb.length; ++i) {
            String string = ISb[i];
            if (string.equals("indicate") && !this.IBb.getState(string)) {
                if (!bl) {
                    stringBuffer.append(' ');
                }
                stringBuffer.append("noindicate");
                bl = false;
                continue;
            }
            if (!this.IBb.getState(string)) continue;
            if (!bl) {
                stringBuffer.append(' ');
            }
            stringBuffer.append(ISb0[i]);
            bl = false;
        }
        if (!this.Restrict) {
            Global.setParameter("export.tools", stringBuffer.toString());
        }
        return stringBuffer.toString();
    }

    public String getStyle() {
        int n = this.Style.getSelectedIndex();
        if (n >= 0) {
            Global.setParameter("export.style", n);
        }
        if (n < 0) {
            return ST[0];
        }
        return ST[n];
    }

    public String getFile() {
        String string = FileName.pathAndSeparator(this.CFile.getText());
        Global.setParameter("export.path", string);
        return this.CFile.getText();
    }

    public String getCodebase() {
        Global.setParameter("export.codebase", this.Codebase.getText());
        return this.Codebase.getText();
    }

    public boolean isJob() {
        if (this.Job == null) {
            return false;
        }
        return this.Job.getState();
    }
}

