#[test]
fn random_colors() {
    // The color string is randomly generated, then parsed using Mozilla Firefox 84.0.2
    let test_data = [
        ("#30758CE9", [48, 117, 140, 233]),
        ("#91F76A89", [145, 247, 106, 137]),
        ("#CF0206", [207, 2, 6, 255]),
        ("#5BD6AC", [91, 214, 172, 255]),
        ("#86AFB7FB", [134, 175, 183, 251]),
        ("#562", [85, 102, 34, 255]),
        ("#67030D", [103, 3, 13, 255]),
        ("#52DE306C", [82, 222, 48, 108]),
        ("#3425", [51, 68, 34, 85]),
        ("#3CF775", [60, 247, 117, 255]),
        ("#46D6DAC3", [70, 214, 218, 195]),
        ("#5AE", [85, 170, 238, 255]),
        ("#6900", [102, 153, 0, 0]),
        ("#266A6B69", [38, 106, 107, 105]),
        ("#D49C7F", [212, 156, 127, 255]),
        ("#29CEDDF2", [41, 206, 221, 242]),
        ("#E99", [238, 153, 153, 255]),
        ("#462FCA15", [70, 47, 202, 21]),
        ("#5ECAB8", [94, 202, 184, 255]),
        ("#663A77D6", [102, 58, 119, 214]),
        ("#4952", [68, 153, 85, 34]),
        ("#427273", [66, 114, 115, 255]),
        ("#9866", [153, 136, 102, 102]),
        ("#7206AC1C", [114, 6, 172, 28]),
        ("#03E9", [0, 51, 238, 153]),
        ("#8AB779", [138, 183, 121, 255]),
        ("#B6EFB9", [182, 239, 185, 255]),
        ("#735E8A", [115, 94, 138, 255]),
        ("#F45", [255, 68, 85, 255]),
        ("#E8E9", [238, 136, 238, 153]),
        ("#67B9FB", [103, 185, 251, 255]),
        ("#846A1C", [132, 106, 28, 255]),
        ("#DFF17C", [223, 241, 124, 255]),
        ("#5CB7", [85, 204, 187, 119]),
        ("#895191", [137, 81, 145, 255]),
        ("#B05ACA00", [176, 90, 202, 0]),
        ("#303B", [51, 0, 51, 187]),
        ("#E02D", [238, 0, 34, 221]),
        ("#BD202974", [189, 32, 41, 116]),
        ("#54F5D0", [84, 245, 208, 255]),
        ("#52F24795", [82, 242, 71, 149]),
        ("#2BC5", [34, 187, 204, 85]),
        ("#8AA7", [136, 170, 170, 119]),
        ("#53F55F", [83, 245, 95, 255]),
        ("#A4DA", [170, 68, 221, 170]),
        ("#CE3E", [204, 238, 51, 238]),
        ("#9F7", [153, 255, 119, 255]),
        ("#85418C", [133, 65, 140, 255]),
        ("#D467", [221, 68, 102, 119]),
        ("#D83", [221, 136, 51, 255]),
        ("rgb(144.894,221.944,15.338,1.042)", [145, 222, 15, 255]),
        ("rgb(172.519,104.262,195.385)", [173, 104, 195, 255]),
        ("rgb(197.660,22.336,220.613)", [198, 22, 221, 255]),
        ("rgb(172.049,149.391,83.459)", [172, 149, 83, 255]),
        ("rgb(15.808,118.246,48.177)", [16, 118, 48, 255]),
        ("rgb(110.224,15.299,118.110)", [110, 15, 118, 255]),
        ("rgb(61.657,132.868,241.810)", [62, 133, 242, 255]),
        ("rgb(109.629,130.088,177.988,0.263)", [110, 130, 178, 67]),
        ("rgb(230.646,136.749,248.448,0.049)", [231, 137, 248, 12]),
        ("rgb(-7.621,134.924,115.641)", [0, 135, 116, 255]),
        ("rgb(26.009,108.413,240.710)", [26, 108, 241, 255]),
        ("rgb(21.680,232.551,168.863)", [22, 233, 169, 255]),
        ("rgb(111.999,67.957,205.788,1.105)", [112, 68, 206, 255]),
        ("rgb(63.877,198.919,221.669,-0.010)", [64, 199, 222, 0]),
        ("rgb(142.226,135.238,260.621)", [142, 135, 255, 255]),
        ("rgb(59.970,110.510,182.595,-0.069)", [60, 111, 183, 0]),
        ("rgb(-2.286,254.610,235.853)", [0, 255, 236, 255]),
        ("rgb(-7.958,193.044,235.101)", [0, 193, 235, 255]),
        ("rgb(256.609,159.324,257.998)", [255, 159, 255, 255]),
        ("rgb(109.388,91.292,241.384)", [109, 91, 241, 255]),
        ("rgb(30.402,200.071,253.355)", [30, 200, 253, 255]),
        ("rgb(254.429,18.713,262.391)", [254, 19, 255, 255]),
        ("rgb(58.353,74.252,20.484,0.240)", [58, 74, 20, 61]),
        ("rgb(175.711,57.423,190.797)", [176, 57, 191, 255]),
        ("rgb(258.310,48.529,209.761)", [255, 49, 210, 255]),
        ("rgb(42.267,221.449,78.031)", [42, 221, 78, 255]),
        ("rgb(35.229,195.388,257.837)", [35, 195, 255, 255]),
        ("rgb(-1.089,245.407,-3.070,0.320)", [0, 245, 0, 82]),
        ("rgb(62.510,251.003,18.592)", [63, 251, 19, 255]),
        ("rgb(30.376,73.291,147.311)", [30, 73, 147, 255]),
        ("rgb(129.732,260.759,31.529)", [130, 255, 32, 255]),
        ("rgb(197.675,25.346,77.167,-0.005)", [198, 25, 77, 0]),
        ("rgb(132.191,40.666,142.643)", [132, 41, 143, 255]),
        ("rgb(72.049,262.173,213.300)", [72, 255, 213, 255]),
        ("rgb(168.366,214.806,197.234)", [168, 215, 197, 255]),
        ("rgb(233.079,33.094,211.204)", [233, 33, 211, 255]),
        ("rgb(241.575,256.514,243.212,0.915)", [242, 255, 243, 233]),
        ("rgb(192.030,70.554,5.442)", [192, 71, 5, 255]),
        ("rgb(214.761,181.138,1.594)", [215, 181, 2, 255]),
        ("rgb(137.246,159.092,175.243,0.412)", [137, 159, 175, 105]),
        ("rgb(-6.852,94.340,165.562,1.115)", [0, 94, 166, 255]),
        ("rgb(27.688,165.299,256.621)", [28, 165, 255, 255]),
        ("rgb(240.314,99.632,-3.909,0.214)", [240, 100, 0, 55]),
        ("rgb(62.626,96.898,45.764,0.580)", [63, 97, 46, 148]),
        ("rgb(101.295,61.291,109.920)", [101, 61, 110, 255]),
        ("rgb(250.755,243.673,73.583)", [251, 244, 74, 255]),
        ("rgb(87.908,173.653,236.399,0.100)", [88, 174, 236, 26]),
        ("rgb(1.276,63.625,76.657)", [1, 64, 77, 255]),
        ("rgb(182.622,81.426,107.665)", [183, 81, 108, 255]),
        ("rgb(97.666,126.808,202.343)", [98, 127, 202, 255]),
        ("rgb(19.077%,96.844%,107.049%)", [49, 247, 255, 255]),
        ("rgb(60.527%,20.266%,24.231%)", [154, 52, 62, 255]),
        ("rgb(-8.659%,45.149%,39.844%)", [0, 115, 102, 255]),
        ("rgb(72.862%,88.329%,41.681%)", [186, 225, 106, 255]),
        ("rgb(71.619%,55.033%,109.121%)", [183, 140, 255, 255]),
        ("rgb(8.320%,59.542%,86.342%,0.535)", [21, 152, 220, 136]),
        ("rgb(71.371%,30.476%,87.487%)", [182, 78, 223, 255]),
        ("rgb(72.932%,55.921%,36.855%)", [186, 143, 94, 255]),
        ("rgb(102.716%,16.386%,95.450%)", [255, 42, 243, 255]),
        ("rgb(31.319%,7.413%,83.436%,1.067)", [80, 19, 213, 255]),
        ("rgb(30.471%,106.110%,14.952%)", [78, 255, 38, 255]),
        ("rgb(73.746%,53.000%,70.974%)", [188, 135, 181, 255]),
        ("rgb(53.236%,76.453%,51.996%)", [136, 195, 133, 255]),
        ("rgb(74.430%,-9.053%,40.591%,0.372)", [190, 0, 104, 95]),
        ("rgb(63.771%,56.927%,61.386%,0.867)", [163, 145, 157, 221]),
        ("rgb(82.193%,76.039%,85.366%)", [210, 194, 218, 255]),
        ("rgb(-8.062%,84.997%,52.049%)", [0, 217, 133, 255]),
        ("rgb(87.040%,18.561%,51.447%)", [222, 47, 131, 255]),
        ("rgb(-0.383%,-7.852%,59.846%,0.606)", [0, 0, 153, 155]),
        ("rgb(-5.271%,29.630%,24.221%)", [0, 76, 62, 255]),
        ("rgb(37.412%,-9.639%,28.126%)", [95, 0, 72, 255]),
        ("rgb(49.021%,98.510%,38.101%,0.498)", [125, 251, 97, 127]),
        ("rgb(32.297%,10.427%,9.294%,1.078)", [82, 27, 24, 255]),
        ("rgb(66.507%,95.944%,5.022%,0.846)", [170, 245, 13, 216]),
        ("rgb(61.872%,37.070%,49.019%)", [158, 95, 125, 255]),
        ("rgb(71.738%,44.537%,91.829%)", [183, 114, 234, 255]),
        ("rgb(103.206%,32.133%,45.463%)", [255, 82, 116, 255]),
        ("rgb(72.780%,94.460%,32.319%)", [186, 241, 82, 255]),
        ("rgb(1.399%,0.124%,59.130%,0.668)", [4, 0, 151, 170]),
        ("rgb(14.442%,4.097%,14.401%,-0.092)", [37, 10, 37, 0]),
        ("rgb(104.800%,58.989%,13.037%)", [255, 150, 33, 255]),
        ("rgb(98.126%,78.825%,105.629%,0.673)", [250, 201, 255, 172]),
        ("rgb(53.607%,90.566%,100.766%,1.127)", [137, 231, 255, 255]),
        ("rgb(35.961%,2.549%,12.719%)", [92, 6, 32, 255]),
        ("rgb(47.649%,104.780%,20.425%,0.936)", [122, 255, 52, 239]),
        ("rgb(19.942%,54.172%,31.089%,1.077)", [51, 138, 79, 255]),
        ("rgb(70.314%,108.126%,96.525%,0.513)", [179, 255, 246, 131]),
        ("rgb(49.348%,-1.456%,15.051%)", [126, 0, 38, 255]),
        ("rgb(13.047%,34.342%,99.376%)", [33, 88, 253, 255]),
        ("rgb(21.879%,37.037%,34.846%)", [56, 94, 89, 255]),
        ("rgb(18.765%,3.997%,17.193%,0.598)", [48, 10, 44, 152]),
        ("rgb(54.629%,55.177%,51.436%,-0.123)", [139, 141, 131, 0]),
        ("rgb(8.356%,-0.583%,74.565%)", [21, 0, 190, 255]),
        ("rgb(2.435%,74.014%,16.351%,0.580)", [6, 189, 42, 148]),
        ("rgb(25.820%,80.885%,85.077%)", [66, 206, 217, 255]),
        ("rgb(-4.774%,54.466%,34.484%,1.139)", [0, 139, 88, 255]),
        ("rgb(24.928%,80.365%,48.506%)", [64, 205, 124, 255]),
        ("rgb(43.466%,12.333%,73.637%,0.170)", [111, 31, 188, 43]),
        ("rgb(26.659%,24.469%,51.155%,0.592)", [68, 62, 130, 151]),
        ("rgb(102.749%,16.226%,13.440%,0.542)", [255, 41, 34, 138]),
        (
            "hsl(157.572grad,22.057%,82.352%,0.748)",
            [200, 220, 207, 191],
        ),
        ("hsl(359.534grad,99.302%,24.820%)", [126, 0, 77, 255]),
        ("hsl(89.381deg,0.820%,2.238%,1.184)", [6, 6, 6, 255]),
        ("hsl(3.435rad,9.931%,1.830%,0.688)", [4, 5, 5, 175]),
        ("hsl(269.781deg,72.977%,16.749%,0.919)", [42, 12, 74, 234]),
        ("hsl(0.231turn,25.156%,-8.804%)", [0, 0, 0, 255]),
        ("hsl(362.732grad,71.384%,89.611%)", [247, 210, 231, 255]),
        ("hsl(8.019deg,22.561%,21.216%)", [66, 45, 42, 255]),
        ("hsl(80.737grad,88.920%,-0.182%)", [0, 0, 0, 255]),
        ("hsl(3.901rad,104.403%,100.043%)", [255, 255, 255, 255]),
        ("hsl(127.668deg,38.344%,95.249%)", [238, 248, 239, 255]),
        ("hsl(276.662grad,32.442%,77.971%)", [186, 181, 217, 255]),
        ("hsl(5.491rad,65.601%,107.670%)", [255, 255, 255, 255]),
        ("hsl(92.909grad,102.247%,91.380%)", [238, 255, 211, 255]),
        ("hsl(236.020,98.201%,19.861%,-0.065)", [1, 8, 100, 0]),
        ("hsl(356.944grad,18.231%,70.131%)", [193, 165, 183, 255]),
        ("hsl(347.581grad,91.415%,35.258%,0.479)", [172, 8, 137, 122]),
        ("hsl(200.437deg,81.639%,56.948%,0.017)", [56, 174, 235, 4]),
        ("hsl(96.598,-1.219%,80.187%)", [204, 204, 204, 255]),
        ("hsl(162.463,35.025%,9.764%,1.000)", [16, 34, 29, 255]),
        ("hsl(97.785grad,42.878%,49.733%,0.540)", [130, 181, 72, 138]),
        ("hsl(0.243turn,61.733%,36.754%)", [99, 152, 36, 255]),
        ("hsl(81.865grad,93.755%,100.434%)", [255, 255, 255, 255]),
        ("hsl(0.846turn,12.520%,78.873%,-0.121)", [208, 194, 207, 0]),
        ("hsl(1.003turn,-3.924%,48.828%)", [125, 125, 125, 255]),
        ("hsl(262.728deg,25.894%,50.198%)", [120, 95, 161, 255]),
        ("hsl(187.679,4.225%,90.298%,0.974)", [229, 231, 231, 248]),
        ("hsl(0.301turn,-6.189%,34.167%)", [87, 87, 87, 255]),
        ("hsl(0.268turn,91.972%,89.764%)", [224, 253, 205, 255]),
        ("hsl(247.074grad,78.542%,14.539%)", [8, 25, 66, 255]),
        ("hsl(46.282grad,37.538%,92.244%)", [243, 238, 228, 255]),
        ("hsl(0.391turn,4.084%,67.843%)", [170, 176, 172, 255]),
        ("hsl(-0.088turn,61.468%,95.887%)", [251, 238, 245, 255]),
        ("hsl(0.386turn,59.601%,19.961%,-0.102)", [21, 81, 40, 0]),
        ("hsl(310.087,43.917%,93.640%)", [246, 232, 244, 255]),
        ("hsl(59.767grad,17.209%,-3.545%)", [0, 0, 0, 255]),
        ("hsl(-7.789grad,91.197%,40.446%)", [197, 9, 31, 255]),
        ("hsl(99.724deg,44.247%,91.630%,0.575)", [231, 243, 224, 147]),
        ("hsl(0.129rad,100.953%,88.130%,0.208)", [255, 202, 194, 53]),
        ("hsl(28.333grad,92.866%,94.350%,0.225)", [254, 239, 227, 57]),
        ("hsl(6.278rad,13.724%,109.460%,0.388)", [255, 255, 255, 99]),
        ("hsl(0.526turn,79.719%,57.535%)", [60, 206, 233, 255]),
        ("hsl(299.379,49.286%,95.788%)", [249, 239, 250, 255]),
        ("hsl(198.214,22.384%,26.807%,0.047)", [53, 74, 84, 12]),
        ("hsl(140.760,-9.660%,9.079%)", [23, 23, 23, 255]),
        ("hsl(0.342turn,38.150%,26.553%,0.570)", [42, 94, 45, 145]),
        ("hsl(235.559deg,-1.789%,81.781%)", [209, 209, 209, 255]),
        ("hsl(-0.400grad,100.928%,31.366%,-0.121)", [160, 0, 1, 0]),
        ("hsl(41.989grad,-8.040%,83.940%)", [214, 214, 214, 255]),
        ("hsl(327.089grad,41.748%,17.920%)", [61, 27, 65, 255]),
        ("hwb(5.093rad 16.228% 7.107% / 0.995)", [210, 41, 237, 254]),
        ("hwb(0.913turn 23.380% 28.693%)", [182, 60, 123, 255]),
        (
            "hwb(0.083turn 48.957% 19.454% / -0.055)",
            [205, 165, 125, 0],
        ),
        ("hwb(223.305 46.995% 33.460% / -0.095)", [120, 134, 170, 0]),
        ("hwb(93.679grad 14.835% 5.257%)", [159, 242, 38, 255]),
        (
            "hwb(208.953grad 43.974% 17.786% / 49%)",
            [112, 197, 210, 125],
        ),
        ("hwb(168.267 8.049% 1.527%)", [21, 251, 206, 255]),
        ("hwb(260.943 27.267% 43.541%)", [96, 70, 144, 255]),
        ("hwb(0.485turn 46.539% 10.643%)", [119, 228, 218, 255]),
        ("hwb(212.179deg 31.054% 9.752%)", [79, 149, 230, 255]),
        ("hwb(-0.070turn 14.978% 9.707%)", [230, 38, 119, 255]),
        ("hwb(0.073turn 36.215% 43.333% / -40%)", [145, 115, 92, 0]),
        ("hwb(0.162turn 49.627% 28.784%)", [182, 180, 127, 255]),
        ("hwb(0.243turn 20.723% 13.575%)", [144, 220, 53, 255]),
        ("hwb(24.098deg 10.817% 49.419%)", [129, 68, 28, 255]),
        ("hwb(231.600deg 9.597% 14.013% / 3%)", [24, 52, 219, 8]),
        ("hwb(203.254deg 18.262% 3.646%)", [47, 169, 246, 255]),
        ("hwb(153.756deg 48.303% 33.045%)", [123, 171, 150, 255]),
        ("hwb(298.912grad 22.529% 13.786%)", [136, 57, 220, 255]),
        ("hwb(185.717deg 5.163% 31.175%)", [13, 160, 176, 255]),
        ("hwb(211.980 1.733% 4.655% / -52%)", [4, 116, 243, 0]),
        ("hwb(204.276 30.754% 10.146%)", [78, 168, 229, 255]),
        (
            "hwb(0.953turn 48.769% 4.335% / 0.684)",
            [244, 124, 158, 174],
        ),
        ("hwb(2.465rad 16.911% 11.363%)", [43, 226, 108, 255]),
        ("hwb(58.908deg 29.545% 12.057% / 7%)", [224, 222, 75, 18]),
        ("hwb(6.344rad 49.227% 42.409%)", [147, 127, 126, 255]),
        ("hwb(0.255turn 29.724% 27.689% / 45%)", [127, 184, 76, 115]),
        ("hwb(328.563deg 20.347% 38.896%)", [156, 52, 106, 255]),
        ("hwb(2.157deg 15.367% 13.797% / 0.761)", [220, 46, 39, 194]),
        ("hwb(290.068grad 13.739% 49.438%)", [68, 35, 129, 255]),
        ("hwb(3.523 0.171% 7.495%)", [236, 14, 0, 255]),
        ("hwb(0.228turn 7.261% 38.296% / -28%)", [106, 157, 19, 0]),
        ("hwb(114.298deg 2.263% 48.814% / 115%)", [18, 131, 6, 255]),
        ("hwb(6.000rad 29.569% 37.733% / -90%)", [159, 75, 98, 0]),
        ("hwb(293.975 48.728% 30.547%)", [172, 124, 177, 255]),
        ("hwb(3.861rad 5.194% 22.537%)", [13, 71, 198, 255]),
        ("hwb(363.051grad 39.733% 20.035%)", [204, 101, 158, 255]),
        ("hwb(0.046turn 4.758% 4.128%)", [244, 76, 12, 255]),
        ("hwb(198.156 40.979% 25.203% / 47%)", [104, 165, 191, 120]),
        ("hwb(169.283 15.477% 3.858% / -79%)", [39, 245, 208, 0]),
        ("hwb(6.282rad 36.718% 12.765% / 27%)", [222, 94, 94, 69]),
        ("hwb(4.590rad 20.571% 19.423%)", [111, 52, 205, 255]),
        ("hwb(252.979grad 3.471% 13.610% / 0.626)", [9, 52, 220, 160]),
        (
            "hwb(0.738turn 12.619% 22.873% / 0.498)",
            [103, 32, 197, 127],
        ),
        ("hwb(210.399grad 1.847% 38.094%)", [5, 134, 158, 255]),
        ("hwb(143.863 35.042% 31.195% / 0.378)", [89, 175, 124, 96]),
        (
            "hwb(21.631grad 41.743% 24.160% / 47%)",
            [193, 135, 106, 120],
        ),
        ("hwb(84.952grad 41.859% 39.539%)", [141, 154, 107, 255]),
        ("hwb(37.442 2.103% 9.857%)", [230, 145, 5, 255]),
        ("hwb(135.379grad 5.905% 8.483% / 76%)", [15, 233, 22, 194]),
    ];
    for (s, expected) in test_data {
        let rgba = csscolorparser::parse(s).unwrap().to_rgba8();
        assert_eq!(expected, rgba);
    }
}
