/*
 * Copyright © 2016 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 3,
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by: Alexandros Frantzis <alexandros.frantzis@canonical.com>
 */

#include "src/adapters/real_chrono.h"
#include "duration_of.h"

#include <gtest/gtest.h>
#include <gmock/gmock.h>

namespace rt = repowerd::test;

using namespace testing;
using namespace std::chrono_literals;

namespace
{

struct ARealChrono : Test
{
    repowerd::RealChrono real_chrono;
};

MATCHER_P(IsAbout, a, "")
{
    return arg >= a - 10ms && arg <= a + 10ms;
}

}

TEST_F(ARealChrono, sleeps_for_right_amount_of_time)
{
    EXPECT_THAT(rt::duration_of([&]{real_chrono.sleep_for(50ms);}), IsAbout(50ms));
}
