
// std lib related includes
#include <tuple>

// pybind 11 related includes
#include <pybind11/pybind11.h>
#include <pybind11/stl.h>

namespace py = pybind11;

// Standard Handle
#include <Standard_Handle.hxx>


// includes to resolve forward declarations
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Message_ProgressRange.hxx>

// module includes
#include <RWStl.hxx>
#include <RWStl_ConfigurationNode.hxx>
#include <RWStl_Provider.hxx>
#include <RWStl_Reader.hxx>

// template related includes


// user-defined pre
#include "OCP_specific.inc"

// user-defined inclusion per module
        #include <DE_ConfigurationContext.hxx>
        #include <NCollection_Buffer.hxx>
        #include <TDocStd_Document.hxx>
        #include <XSControl_WorkSession.hxx>
        #include <TopoDS_Shape.hxx>

// Module definiiton
void register_RWStl(py::module &main_module) {


py::module m = static_cast<py::module>(main_module.attr("RWStl"));
py::object klass;

//Python trampoline classes
    class Py_RWStl_Reader : public RWStl_Reader{
    public:
        using RWStl_Reader::RWStl_Reader;


        // public pure virtual
        Standard_Integer AddNode(const gp_XYZ & thePnt) override { PYBIND11_OVERLOAD_PURE(Standard_Integer,RWStl_Reader,AddNode,thePnt) };
        void AddTriangle(Standard_Integer theN1,Standard_Integer theN2,Standard_Integer theN3) override { PYBIND11_OVERLOAD_PURE(void,RWStl_Reader,AddTriangle,theN1,theN2,theN3) };


        // protected pure virtual


        // private pure virtual

    };

// classes

    // Class RWStl from ./opencascade/RWStl.hxx
    klass = m.attr("RWStl");

    // default constructor
    register_default_constructor<RWStl , shared_ptr<RWStl>>(m,"RWStl");

    // nested enums

    static_cast<py::class_<RWStl , shared_ptr<RWStl>  >>(klass)
    // constructors
    // custom constructors
    // methods
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("WriteBinary_s",
                    (Standard_Boolean (*)( const opencascade::handle<Poly_Triangulation> & ,  const OSD_Path & ,  const Message_ProgressRange &  ) ) static_cast<Standard_Boolean (*)( const opencascade::handle<Poly_Triangulation> & ,  const OSD_Path & ,  const Message_ProgressRange &  ) >(&RWStl::WriteBinary),
                    R"#(Write triangulation to binary STL file. binary format of an STL file. Returns false if the cannot be opened;)#"  , py::arg("theMesh"),  py::arg("thePath"),  py::arg("theProgress")=static_cast<const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
        .def_static("WriteAscii_s",
                    (Standard_Boolean (*)( const opencascade::handle<Poly_Triangulation> & ,  const OSD_Path & ,  const Message_ProgressRange &  ) ) static_cast<Standard_Boolean (*)( const opencascade::handle<Poly_Triangulation> & ,  const OSD_Path & ,  const Message_ProgressRange &  ) >(&RWStl::WriteAscii),
                    R"#(write the meshing in a file following the Ascii format of an STL file. Returns false if the cannot be opened;)#"  , py::arg("theMesh"),  py::arg("thePath"),  py::arg("theProgress")=static_cast<const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
        .def_static("ReadFile_s",
                    (opencascade::handle<Poly_Triangulation> (*)( const OSD_Path & ,  const Message_ProgressRange &  ) ) static_cast<opencascade::handle<Poly_Triangulation> (*)( const OSD_Path & ,  const Message_ProgressRange &  ) >(&RWStl::ReadFile),
                    R"#(Read specified STL file and returns its content as triangulation. In case of error, returns Null handle.)#"  , py::arg("theFile"),  py::arg("theProgress")=static_cast<const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
        .def_static("ReadFile_s",
                    (opencascade::handle<Poly_Triangulation> (*)( const Standard_CString ,  const Message_ProgressRange &  ) ) static_cast<opencascade::handle<Poly_Triangulation> (*)( const Standard_CString ,  const Message_ProgressRange &  ) >(&RWStl::ReadFile),
                    R"#(Read specified STL file and returns its content as triangulation. In case of error, returns Null handle.)#"  , py::arg("theFile"),  py::arg("theProgress")=static_cast<const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
        .def_static("ReadFile_s",
                    (opencascade::handle<Poly_Triangulation> (*)( const Standard_CString ,  const Standard_Real ,  const Message_ProgressRange &  ) ) static_cast<opencascade::handle<Poly_Triangulation> (*)( const Standard_CString ,  const Standard_Real ,  const Message_ProgressRange &  ) >(&RWStl::ReadFile),
                    R"#(Read specified STL file and returns its content as triangulation.)#"  , py::arg("theFile"),  py::arg("theMergeAngle"),  py::arg("theProgress")=static_cast<const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
        .def_static("ReadFile_s",
                    (void (*)( const Standard_CString ,  const Standard_Real ,  NCollection_Sequence<opencascade::handle<Poly_Triangulation>> & ,  const Message_ProgressRange &  ) ) static_cast<void (*)( const Standard_CString ,  const Standard_Real ,  NCollection_Sequence<opencascade::handle<Poly_Triangulation>> & ,  const Message_ProgressRange &  ) >(&RWStl::ReadFile),
                    R"#(Read specified STL file and fills triangulation list for multi-domain case.)#"  , py::arg("theFile"),  py::arg("theMergeAngle"),  py::arg("theTriangList"),  py::arg("theProgress")=static_cast<const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
        .def_static("ReadBinary_s",
                    (opencascade::handle<Poly_Triangulation> (*)( const OSD_Path & ,  const Message_ProgressRange &  ) ) static_cast<opencascade::handle<Poly_Triangulation> (*)( const OSD_Path & ,  const Message_ProgressRange &  ) >(&RWStl::ReadBinary),
                    R"#(Read triangulation from a binary STL file In case of error, returns Null handle.)#"  , py::arg("thePath"),  py::arg("theProgress")=static_cast<const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
        .def_static("ReadAscii_s",
                    (opencascade::handle<Poly_Triangulation> (*)( const OSD_Path & ,  const Message_ProgressRange &  ) ) static_cast<opencascade::handle<Poly_Triangulation> (*)( const OSD_Path & ,  const Message_ProgressRange &  ) >(&RWStl::ReadAscii),
                    R"#(Read triangulation from an Ascii STL file In case of error, returns Null handle.)#"  , py::arg("thePath"),  py::arg("theProgress")=static_cast<const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class RWStl_ConfigurationNode from ./opencascade/RWStl_ConfigurationNode.hxx
    klass = m.attr("RWStl_ConfigurationNode");


    // nested enums

    static_cast<py::class_<RWStl_ConfigurationNode ,opencascade::handle<RWStl_ConfigurationNode>  , DE_ConfigurationNode >>(klass)
    // constructors
        .def(py::init<  >()  )
        .def(py::init< const opencascade::handle<RWStl_ConfigurationNode> & >()  , py::arg("theNode") )
    // custom constructors
    // methods
        .def("Load",
             (bool (RWStl_ConfigurationNode::*)( const opencascade::handle<DE_ConfigurationContext> &  ) ) static_cast<bool (RWStl_ConfigurationNode::*)( const opencascade::handle<DE_ConfigurationContext> &  ) >(&RWStl_ConfigurationNode::Load),
             R"#(Updates values according the resource)#"  , py::arg("theResource")
          )
        .def("Save",
             (TCollection_AsciiString (RWStl_ConfigurationNode::*)() const) static_cast<TCollection_AsciiString (RWStl_ConfigurationNode::*)() const>(&RWStl_ConfigurationNode::Save),
             R"#(Writes configuration to the string)#" 
          )
        .def("Copy",
             (opencascade::handle<DE_ConfigurationNode> (RWStl_ConfigurationNode::*)() const) static_cast<opencascade::handle<DE_ConfigurationNode> (RWStl_ConfigurationNode::*)() const>(&RWStl_ConfigurationNode::Copy),
             R"#(Copies values of all fields)#" 
          )
        .def("BuildProvider",
             (opencascade::handle<DE_Provider> (RWStl_ConfigurationNode::*)() ) static_cast<opencascade::handle<DE_Provider> (RWStl_ConfigurationNode::*)() >(&RWStl_ConfigurationNode::BuildProvider),
             R"#(Creates new provider for the own format)#" 
          )
        .def("IsImportSupported",
             (bool (RWStl_ConfigurationNode::*)() const) static_cast<bool (RWStl_ConfigurationNode::*)() const>(&RWStl_ConfigurationNode::IsImportSupported),
             R"#(Checks the import supporting)#" 
          )
        .def("IsExportSupported",
             (bool (RWStl_ConfigurationNode::*)() const) static_cast<bool (RWStl_ConfigurationNode::*)() const>(&RWStl_ConfigurationNode::IsExportSupported),
             R"#(Checks the export supporting)#" 
          )
        .def("GetFormat",
             (TCollection_AsciiString (RWStl_ConfigurationNode::*)() const) static_cast<TCollection_AsciiString (RWStl_ConfigurationNode::*)() const>(&RWStl_ConfigurationNode::GetFormat),
             R"#(Gets CAD format name of associated provider)#" 
          )
        .def("GetVendor",
             (TCollection_AsciiString (RWStl_ConfigurationNode::*)() const) static_cast<TCollection_AsciiString (RWStl_ConfigurationNode::*)() const>(&RWStl_ConfigurationNode::GetVendor),
             R"#(Gets provider's vendor name of associated provider)#" 
          )
        .def("GetExtensions",
             (TColStd_ListOfAsciiString (RWStl_ConfigurationNode::*)() const) static_cast<TColStd_ListOfAsciiString (RWStl_ConfigurationNode::*)() const>(&RWStl_ConfigurationNode::GetExtensions),
             R"#(Gets list of supported file extensions)#" 
          )
        .def("CheckContent",
             (bool (RWStl_ConfigurationNode::*)( const opencascade::handle<NCollection_Buffer> &  ) const) static_cast<bool (RWStl_ConfigurationNode::*)( const opencascade::handle<NCollection_Buffer> &  ) const>(&RWStl_ConfigurationNode::CheckContent),
             R"#(Checks the file content to verify a format)#"  , py::arg("theBuffer")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    (const char * (*)() ) static_cast<const char * (*)() >(&RWStl_ConfigurationNode::get_type_name),
                    R"#(None)#" 
          )
        .def_static("get_type_descriptor_s",
                    (const opencascade::handle<Standard_Type> & (*)() ) static_cast<const opencascade::handle<Standard_Type> & (*)() >(&RWStl_ConfigurationNode::get_type_descriptor),
                    R"#(None)#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             (const opencascade::handle<Standard_Type> & (RWStl_ConfigurationNode::*)() const) static_cast<const opencascade::handle<Standard_Type> & (RWStl_ConfigurationNode::*)() const>(&RWStl_ConfigurationNode::DynamicType),
             R"#(None)#"
             
         )
;

    // Class RWStl_Provider from ./opencascade/RWStl_Provider.hxx
    klass = m.attr("RWStl_Provider");


    // nested enums

    static_cast<py::class_<RWStl_Provider ,opencascade::handle<RWStl_Provider>  , DE_Provider >>(klass)
    // constructors
        .def(py::init<  >()  )
        .def(py::init< const opencascade::handle<DE_ConfigurationNode> & >()  , py::arg("theNode") )
    // custom constructors
    // methods
        .def("Read",
             (Standard_Boolean (RWStl_Provider::*)( const TCollection_AsciiString & ,  const opencascade::handle<TDocStd_Document> & ,  opencascade::handle<XSControl_WorkSession> & ,  const Message_ProgressRange &  ) ) static_cast<Standard_Boolean (RWStl_Provider::*)( const TCollection_AsciiString & ,  const opencascade::handle<TDocStd_Document> & ,  opencascade::handle<XSControl_WorkSession> & ,  const Message_ProgressRange &  ) >(&RWStl_Provider::Read),
             R"#(Reads a CAD file, according internal configuration)#"  , py::arg("thePath"),  py::arg("theDocument"),  py::arg("theWS"),  py::arg("theProgress")=static_cast<const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
        .def("Write",
             (Standard_Boolean (RWStl_Provider::*)( const TCollection_AsciiString & ,  const opencascade::handle<TDocStd_Document> & ,  opencascade::handle<XSControl_WorkSession> & ,  const Message_ProgressRange &  ) ) static_cast<Standard_Boolean (RWStl_Provider::*)( const TCollection_AsciiString & ,  const opencascade::handle<TDocStd_Document> & ,  opencascade::handle<XSControl_WorkSession> & ,  const Message_ProgressRange &  ) >(&RWStl_Provider::Write),
             R"#(Writes a CAD file, according internal configuration)#"  , py::arg("thePath"),  py::arg("theDocument"),  py::arg("theWS"),  py::arg("theProgress")=static_cast<const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
        .def("Read",
             (Standard_Boolean (RWStl_Provider::*)( const TCollection_AsciiString & ,  const opencascade::handle<TDocStd_Document> & ,  const Message_ProgressRange &  ) ) static_cast<Standard_Boolean (RWStl_Provider::*)( const TCollection_AsciiString & ,  const opencascade::handle<TDocStd_Document> & ,  const Message_ProgressRange &  ) >(&RWStl_Provider::Read),
             R"#(Reads a CAD file, according internal configuration)#"  , py::arg("thePath"),  py::arg("theDocument"),  py::arg("theProgress")=static_cast<const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
        .def("Write",
             (Standard_Boolean (RWStl_Provider::*)( const TCollection_AsciiString & ,  const opencascade::handle<TDocStd_Document> & ,  const Message_ProgressRange &  ) ) static_cast<Standard_Boolean (RWStl_Provider::*)( const TCollection_AsciiString & ,  const opencascade::handle<TDocStd_Document> & ,  const Message_ProgressRange &  ) >(&RWStl_Provider::Write),
             R"#(Writes a CAD file, according internal configuration)#"  , py::arg("thePath"),  py::arg("theDocument"),  py::arg("theProgress")=static_cast<const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
        .def("Read",
             (Standard_Boolean (RWStl_Provider::*)( const TCollection_AsciiString & ,  TopoDS_Shape & ,  opencascade::handle<XSControl_WorkSession> & ,  const Message_ProgressRange &  ) ) static_cast<Standard_Boolean (RWStl_Provider::*)( const TCollection_AsciiString & ,  TopoDS_Shape & ,  opencascade::handle<XSControl_WorkSession> & ,  const Message_ProgressRange &  ) >(&RWStl_Provider::Read),
             R"#(Reads a CAD file, according internal configuration)#"  , py::arg("thePath"),  py::arg("theShape"),  py::arg("theWS"),  py::arg("theProgress")=static_cast<const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
        .def("Write",
             (Standard_Boolean (RWStl_Provider::*)( const TCollection_AsciiString & ,  const TopoDS_Shape & ,  opencascade::handle<XSControl_WorkSession> & ,  const Message_ProgressRange &  ) ) static_cast<Standard_Boolean (RWStl_Provider::*)( const TCollection_AsciiString & ,  const TopoDS_Shape & ,  opencascade::handle<XSControl_WorkSession> & ,  const Message_ProgressRange &  ) >(&RWStl_Provider::Write),
             R"#(Writes a CAD file, according internal configuration)#"  , py::arg("thePath"),  py::arg("theShape"),  py::arg("theWS"),  py::arg("theProgress")=static_cast<const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
        .def("Read",
             (Standard_Boolean (RWStl_Provider::*)( const TCollection_AsciiString & ,  TopoDS_Shape & ,  const Message_ProgressRange &  ) ) static_cast<Standard_Boolean (RWStl_Provider::*)( const TCollection_AsciiString & ,  TopoDS_Shape & ,  const Message_ProgressRange &  ) >(&RWStl_Provider::Read),
             R"#(Reads a CAD file, according internal configuration)#"  , py::arg("thePath"),  py::arg("theShape"),  py::arg("theProgress")=static_cast<const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
        .def("Write",
             (Standard_Boolean (RWStl_Provider::*)( const TCollection_AsciiString & ,  const TopoDS_Shape & ,  const Message_ProgressRange &  ) ) static_cast<Standard_Boolean (RWStl_Provider::*)( const TCollection_AsciiString & ,  const TopoDS_Shape & ,  const Message_ProgressRange &  ) >(&RWStl_Provider::Write),
             R"#(Writes a CAD file, according internal configuration)#"  , py::arg("thePath"),  py::arg("theShape"),  py::arg("theProgress")=static_cast<const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
        .def("GetFormat",
             (TCollection_AsciiString (RWStl_Provider::*)() const) static_cast<TCollection_AsciiString (RWStl_Provider::*)() const>(&RWStl_Provider::GetFormat),
             R"#(Gets CAD format name of associated provider)#" 
          )
        .def("GetVendor",
             (TCollection_AsciiString (RWStl_Provider::*)() const) static_cast<TCollection_AsciiString (RWStl_Provider::*)() const>(&RWStl_Provider::GetVendor),
             R"#(Gets provider's vendor name of associated provider)#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    (const char * (*)() ) static_cast<const char * (*)() >(&RWStl_Provider::get_type_name),
                    R"#(None)#" 
          )
        .def_static("get_type_descriptor_s",
                    (const opencascade::handle<Standard_Type> & (*)() ) static_cast<const opencascade::handle<Standard_Type> & (*)() >(&RWStl_Provider::get_type_descriptor),
                    R"#(None)#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             (const opencascade::handle<Standard_Type> & (RWStl_Provider::*)() const) static_cast<const opencascade::handle<Standard_Type> & (RWStl_Provider::*)() const>(&RWStl_Provider::DynamicType),
             R"#(None)#"
             
         )
;

    // Class RWStl_Reader from ./opencascade/RWStl_Reader.hxx
    klass = m.attr("RWStl_Reader");


    // nested enums

    static_cast<py::class_<RWStl_Reader ,opencascade::handle<RWStl_Reader> ,Py_RWStl_Reader , Standard_Transient >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("Read",
             (Standard_Boolean (RWStl_Reader::*)( const char * ,  const Message_ProgressRange &  ) ) static_cast<Standard_Boolean (RWStl_Reader::*)( const char * ,  const Message_ProgressRange &  ) >(&RWStl_Reader::Read),
             R"#(Reads data from STL file (either binary or Ascii). This function supports reading multi-domain STL files formed by concatenation of several "plain" files. The mesh nodes are not merged between domains. Unicode paths can be given in UTF-8 encoding. Format is recognized automatically by analysis of the file header. Returns true if success, false on error or user break.)#"  , py::arg("theFile"),  py::arg("theProgress")
          )
        .def("IsAscii",
             (Standard_Boolean (RWStl_Reader::*)( std::istream & ,  const bool  ) ) static_cast<Standard_Boolean (RWStl_Reader::*)( std::istream & ,  const bool  ) >(&RWStl_Reader::IsAscii),
             R"#(Guess whether the stream is an Ascii STL file, by analysis of the first bytes (~200). If the stream does not support seekg() then the parameter isSeekgAvailable should be passed as 'false', in this case the function attempts to put back the read symbols to the stream which thus must support ungetc(). Returns true if the stream seems to contain Ascii STL.)#"  , py::arg("theStream"),  py::arg("isSeekgAvailable")
          )
        .def("ReadBinary",
             (Standard_Boolean (RWStl_Reader::*)( std::istream & ,  const Message_ProgressRange &  ) ) static_cast<Standard_Boolean (RWStl_Reader::*)( std::istream & ,  const Message_ProgressRange &  ) >(&RWStl_Reader::ReadBinary),
             R"#(Reads STL data from binary stream. The stream must be opened in binary mode. Stops after reading the number of triangles recorded in the file header. Returns true if success, false on error or user break.)#"  , py::arg("theStream"),  py::arg("theProgress")
          )
        .def("AddNode",
             (Standard_Integer (RWStl_Reader::*)( const gp_XYZ &  ) ) static_cast<Standard_Integer (RWStl_Reader::*)( const gp_XYZ &  ) >(&RWStl_Reader::AddNode),
             R"#(Callback function to be implemented in descendant. Should create new node with specified coordinates in the target model, and return its ID as integer.)#"  , py::arg("thePnt")
          )
        .def("AddTriangle",
             (void (RWStl_Reader::*)( Standard_Integer ,  Standard_Integer ,  Standard_Integer  ) ) static_cast<void (RWStl_Reader::*)( Standard_Integer ,  Standard_Integer ,  Standard_Integer  ) >(&RWStl_Reader::AddTriangle),
             R"#(Callback function to be implemented in descendant. Should create new triangle built on specified nodes in the target model.)#"  , py::arg("theN1"),  py::arg("theN2"),  py::arg("theN3")
          )
        .def("AddSolid",
             (void (RWStl_Reader::*)() ) static_cast<void (RWStl_Reader::*)() >(&RWStl_Reader::AddSolid),
             R"#(Callback function to be implemented in descendant. Should create a new triangulation for a solid in multi-domain case.)#" 
          )
        .def("MergeAngle",
             (Standard_Real (RWStl_Reader::*)() const) static_cast<Standard_Real (RWStl_Reader::*)() const>(&RWStl_Reader::MergeAngle),
             R"#(Return merge tolerance; M_PI/2 by default - all nodes are merged regardless angle between triangles.)#" 
          )
        .def("SetMergeAngle",
             (void (RWStl_Reader::*)( Standard_Real  ) ) static_cast<void (RWStl_Reader::*)( Standard_Real  ) >(&RWStl_Reader::SetMergeAngle),
             R"#(Set merge angle in radians. Specify something like M_PI/4 (45 degrees) to avoid merge nodes between triangles at sharp corners.)#"  , py::arg("theAngleRad")
          )
        .def("MergeTolerance",
             (double (RWStl_Reader::*)() const) static_cast<double (RWStl_Reader::*)() const>(&RWStl_Reader::MergeTolerance),
             R"#(Return linear merge tolerance; 0.0 by default (only 3D points with exactly matching coordinates are merged).)#" 
          )
        .def("SetMergeTolerance",
             (void (RWStl_Reader::*)( double  ) ) static_cast<void (RWStl_Reader::*)( double  ) >(&RWStl_Reader::SetMergeTolerance),
             R"#(Set linear merge tolerance.)#"  , py::arg("theTolerance")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    (const char * (*)() ) static_cast<const char * (*)() >(&RWStl_Reader::get_type_name),
                    R"#(None)#" 
          )
        .def_static("get_type_descriptor_s",
                    (const opencascade::handle<Standard_Type> & (*)() ) static_cast<const opencascade::handle<Standard_Type> & (*)() >(&RWStl_Reader::get_type_descriptor),
                    R"#(None)#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             (const opencascade::handle<Standard_Type> & (RWStl_Reader::*)() const) static_cast<const opencascade::handle<Standard_Type> & (RWStl_Reader::*)() const>(&RWStl_Reader::DynamicType),
             R"#(None)#"
             
         )
;

// functions
// ./opencascade/RWStl.hxx
// ./opencascade/RWStl_ConfigurationNode.hxx
// ./opencascade/RWStl_Provider.hxx
// ./opencascade/RWStl_Reader.hxx

// Additional functions

// operators

// register typdefs


// exceptions

// user-defined post-inclusion per module in the body

};

// user-defined post-inclusion per module

// user-defined post
