# Copyright(c) 1986 Association of Universities for Research in Astronomy Inc.

include	<ctype.h>
include	<chars.h>
include	"tty.h"

# TTYWRITE -- Put a counted control string to the output file.  The control
# string consists of an optional prefix specifying the delay required, followed
# by the chars to be sent to the terminal.  If the delay is given as a simple
# integer number (i.e., ":cl=50\E"), it specifies the delay in milliseconds.
# If the delay number is followed by an asterisk (i.e., ":cd=3.5*\E^C:") it
# specifies the delay in milliseconds per line affected by the operation.
# In the latter case, the AFFLNCNT argument is used to compute the total
# delay.  Delays are generated by writing a sequence of pad characters
# (usually NUL); the number of pad chars sent to achieve a particular delay
# depends on the baud rate.

procedure ttywrite (fd, tty, ctrlstr, nchars, afflncnt)

int	fd			# output file
pointer	tty			# terminal descriptor
char	ctrlstr[ARB]		# control sequence to be output
int	nchars			# nchars in control string
int	afflncnt		# number of lines affected

double	dval
int	ip, delay, junk, ch
int	ctod(), and()
errchk	putci

begin
	# Determine number of milliseconds of delay req'd, and position ip
	# to start of control string.  Do not use CTOD to test whether or not
	# the string begins with a number, because it is not permissable to
	# skip whitespace (blank and tab are legal output chars).

	ip = 1
	if (IS_DIGIT (ctrlstr[ip])) {
	    junk = ctod (ctrlstr, ip, dval)
	    if (ctrlstr[ip] == '*') {
		delay = dval * afflncnt + 0.5
		ip = ip + 1
	    } else
		delay = dval
	} else
	    delay = 0

	# Output the control sequence, passing only the first seven bits of
	# each character.  This is where the \200 escapes get turned into NULs.
	# Do not use MOD to do the masking because 200B is a negative integer
	# if CHAR is implemented as 8 bits.

	for (;  ip <= nchars;  ip=ip+1) {
	    ch = ctrlstr[ip]
	    call putci (fd, and (ch, 177B))
	}

	# Add padding if needed to generate delay.
	call ttydelay (fd, tty, delay)
end
