// Copyright 2014 The Go Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

package testdata

var PEMBytes = []struct {
	Name     string
	PEMBytes []byte
}{
	{
		Name: "dsa",
		PEMBytes: []byte(`-----BEGIN DSA PRIVATE KEY-----
MIIBuwIBAAKBgQD6PDSEyXiI9jfNs97WuM46MSDCYlOqWw80ajN16AohtBncs1YB
lHk//dQOvCYOsYaE+gNix2jtoRjwXhDsc25/IqQbU1ahb7mB8/rsaILRGIbA5WH3
EgFtJmXFovDz3if6F6TzvhFpHgJRmLYVR8cqsezL3hEZOvvs2iH7MorkxwIVAJHD
nD82+lxh2fb4PMsIiaXudAsBAoGAQRf7Q/iaPRn43ZquUhd6WwvirqUj+tkIu6eV
2nZWYmXLlqFQKEy4Tejl7Wkyzr2OSYvbXLzo7TNxLKoWor6ips0phYPPMyXld14r
juhT24CrhOzuLMhDduMDi032wDIZG4Y+K7ElU8Oufn8Sj5Wge8r6ANmmVgmFfynr
FhdYCngCgYEA3ucGJ93/Mx4q4eKRDxcWD3QzWyqpbRVRRV1Vmih9Ha/qC994nJFz
DQIdjxDIT2Rk2AGzMqFEB68Zc3O+Wcsmz5eWWzEwFxaTwOGWTyDqsDRLm3fD+QYj
nOwuxb0Kce+gWI8voWcqC9cyRm09jGzu2Ab3Bhtpg8JJ8L7gS3MRZK4CFEx4UAfY
Fmsr0W6fHB9nhS4/UXM8
-----END DSA PRIVATE KEY-----
`),
	},
	{
		Name: "ecdsa",
		PEMBytes: []byte(`-----BEGIN EC PRIVATE KEY-----
MHcCAQEEINGWx0zo6fhJ/0EAfrPzVFyFC9s18lBt3cRoEDhS3ARooAoGCCqGSM49
AwEHoUQDQgAEi9Hdw6KvZcWxfg2IDhA7UkpDtzzt6ZqJXSsFdLd+Kx4S3Sx4cVO+
6/ZOXRnPmNAlLUqjShUsUBBngG0u2fqEqA==
-----END EC PRIVATE KEY-----
`),
	},
	{
		Name: "rsa",
		PEMBytes: []byte(`-----BEGIN RSA PRIVATE KEY-----
MIICXAIBAAKBgQC8A6FGHDiWCSREAXCq6yBfNVr0xCVG2CzvktFNRpue+RXrGs/2
a6ySEJQb3IYquw7HlJgu6fg3WIWhOmHCjfpG0PrL4CRwbqQ2LaPPXhJErWYejcD8
Di00cF3677+G10KMZk9RXbmHtuBFZT98wxg8j+ZsBMqGM1+7yrWUvynswQIDAQAB
AoGAJMCk5vqfSRzyXOTXLGIYCuR4Kj6pdsbNSeuuRGfYBeR1F2c/XdFAg7D/8s5R
38p/Ih52/Ty5S8BfJtwtvgVY9ecf/JlU/rl/QzhG8/8KC0NG7KsyXklbQ7gJT8UT
Ojmw5QpMk+rKv17ipDVkQQmPaj+gJXYNAHqImke5mm/K/h0CQQDciPmviQ+DOhOq
2ZBqUfH8oXHgFmp7/6pXw80DpMIxgV3CwkxxIVx6a8lVH9bT/AFySJ6vXq4zTuV9
6QmZcZzDAkEA2j/UXJPIs1fQ8z/6sONOkU/BjtoePFIWJlRxdN35cZjXnBraX5UR
fFHkePv4YwqmXNqrBOvSu+w2WdSDci+IKwJAcsPRc/jWmsrJW1q3Ha0hSf/WG/Bu
X7MPuXaKpP/DkzGoUmb8ks7yqj6XWnYkPNLjCc8izU5vRwIiyWBRf4mxMwJBAILa
NDvRS0rjwt6lJGv7zPZoqDc65VfrK2aNyHx2PgFyzwrEOtuF57bu7pnvEIxpLTeM
z26i6XVMeYXAWZMTloMCQBbpGgEERQpeUknLBqUHhg/wXF6+lFA+vEGnkY+Dwab2
KCXFGd+SQ5GdUcEMe9isUH6DYj/6/yCDoFrXXmpQb+M=
-----END RSA PRIVATE KEY-----
`),
	},
	{
		Name: "user",
		PEMBytes: []byte(`-----BEGIN EC PRIVATE KEY-----
MHcCAQEEILYCAeq8f7V4vSSypRw7pxy8yz3V5W4qg8kSC3zJhqpQoAoGCCqGSM49
AwEHoUQDQgAEYcO2xNKiRUYOLEHM7VYAp57HNyKbOdYtHD83Z4hzNPVC4tM5mdGD
PLL8IEwvYu2wq+lpXfGQnNMbzYf9gspG0w==
-----END EC PRIVATE KEY-----
`),
	},
	{
		Name: "rsa-openssh-format",
		PEMBytes: []byte(`-----BEGIN OPENSSH PRIVATE KEY-----
b3BlbnNzaC1rZXktdjEAAAAABG5vbmUAAAAEbm9uZQAAAAAAAAABAAAAlwAAAAdzc2gtcn
NhAAAAAwEAAQAAAIEAwa48yfWFi3uIdqzuf9X7C2Zxfea/Iaaw0zIwHudpF8U92WVIiC5l
oEuW1+OaVi3UWfIEjWMV1tHGysrHOwtwc34BPCJqJknUQO/KtDTBTJ4Pryhw1bWPC999Lz
a+yrCTdNQYBzoROXKExZgPFh9pTMi5wqpHDuOQ2qZFIEI3lT0AAAIQWL0H31i9B98AAAAH
c3NoLXJzYQAAAIEAwa48yfWFi3uIdqzuf9X7C2Zxfea/Iaaw0zIwHudpF8U92WVIiC5loE
uW1+OaVi3UWfIEjWMV1tHGysrHOwtwc34BPCJqJknUQO/KtDTBTJ4Pryhw1bWPC999Lza+
yrCTdNQYBzoROXKExZgPFh9pTMi5wqpHDuOQ2qZFIEI3lT0AAAADAQABAAAAgCThyTGsT4
IARDxVMhWl6eiB2ZrgFgWSeJm/NOqtppWgOebsIqPMMg4UVuVFsl422/lE3RkPhVkjGXgE
pWvZAdCnmLmApK8wK12vF334lZhZT7t3Z9EzJps88PWEHo7kguf285HcnUM7FlFeissJdk
kXly34y7/3X/a6Tclm+iABAAAAQE0xR/KxZ39slwfMv64Rz7WKk1PPskaryI29aHE3mKHk
pY2QA+P3QlrKxT/VWUMjHUbNNdYfJm48xu0SGNMRdKMAAABBAORh2NP/06JUV3J9W/2Hju
X1ViJuqqcQnJPVzpgSL826EC2xwOECTqoY8uvFpUdD7CtpksIxNVqRIhuNOlz0lqEAAABB
ANkaHTTaPojClO0dKJ/Zjs7pWOCGliebBYprQ/Y4r9QLBkC/XaWMS26gFIrjgC7D2Rv+rZ
wSD0v0RcmkITP1ZR0AAAAYcHF1ZXJuYUBMdWNreUh5ZHJvLmxvY2FsAQID
-----END OPENSSH PRIVATE KEY-----`),
	},
	{
		Name: "ed25519-openssh-format",
		PEMBytes: []byte(`-----BEGIN OPENSSH PRIVATE KEY-----
b3BlbnNzaC1rZXktdjEAAAAABG5vbmUAAAAEbm9uZQAAAAAAAAABAAAAMwAAAAtzc2gtZW
QyNTUxOQAAACA+3f7hS7g5UWwXOGVTrMfhmxyrjqz7Sxxbx7I1j8DvvwAAAJhAFfkOQBX5
DgAAAAtzc2gtZWQyNTUxOQAAACA+3f7hS7g5UWwXOGVTrMfhmxyrjqz7Sxxbx7I1j8Dvvw
AAAEAaYmXltfW6nhRo3iWGglRB48lYq0z0Q3I3KyrdutEr6j7d/uFLuDlRbBc4ZVOsx+Gb
HKuOrPtLHFvHsjWPwO+/AAAAE2dhcnRvbm1AZ2FydG9ubS14cHMBAg==
-----END OPENSSH PRIVATE KEY-----
`),
	},
}

var PEMEncryptedKeys = []struct {
	Name          string
	EncryptionKey string
	PEMBytes      []byte
}{
	{
		Name:          "rsa-encrypted-aes256-cbc",
		EncryptionKey: "r54-G0pher_t3st$",
		PEMBytes: []byte(`-----BEGIN RSA PRIVATE KEY-----
Proc-Type: 4,ENCRYPTED
DEK-Info: AES-128-CBC,3E1714DE130BC5E81327F36564B05462

MqW88sud4fnWk/Jk3fkjh7ydu51ZkHLN5qlQgA4SkAXORPPMj2XvqZOv1v2LOgUV
dUevUn8PZK7a9zbZg4QShUSzwE5k6wdB7XKPyBgI39mJ79GBd2U4W3h6KT6jIdWA
goQpluxkrzr2/X602IaxLEre97FT9mpKC6zxKCLvyFWVIP9n3OSFS47cTTXyFr+l
7PdRhe60nn6jSBgUNk/Q1lAvEQ9fufdPwDYY93F1wyJ6lOr0F1+mzRrMbH67NyKs
rG8J1Fa7cIIre7ueKIAXTIne7OAWqpU9UDgQatDtZTbvA7ciqGsSFgiwwW13N+Rr
hN8MkODKs9cjtONxSKi05s206A3NDU6STtZ3KuPDjFE1gMJODotOuqSM+cxKfyFq
wxpk/CHYCDdMAVBSwxb/vraOHamylL4uCHpJdBHypzf2HABt+lS8Su23uAmL87DR
yvyCS/lmpuNTndef6qHPRkoW2EV3xqD3ovosGf7kgwGJUk2ZpCLVteqmYehKlZDK
r/Jy+J26ooI2jIg9bjvD1PZq+Mv+2dQ1RlDrPG3PB+rEixw6vBaL9x3jatCd4ej7
XG7lb3qO9xFpLsx89tkEcvpGR+broSpUJ6Mu5LBCVmrvqHjvnDhrZVz1brMiQtU9
iMZbgXqDLXHd6ERWygk7OTU03u+l1gs+KGMfmS0h0ZYw6KGVLgMnsoxqd6cFSKNB
8Ohk9ZTZGCiovlXBUepyu8wKat1k8YlHSfIHoRUJRhhcd7DrmojC+bcbMIZBU22T
Pl2ftVRGtcQY23lYd0NNKfebF7ncjuLWQGy+vZW+7cgfI6wPIbfYfP6g7QAutk6W
KQx0AoX5woZ6cNxtpIrymaVjSMRRBkKQrJKmRp3pC/lul5E5P2cueMs1fj4OHTbJ
lAUv88ywr+R+mRgYQlFW/XQ653f6DT4t6+njfO9oBcPrQDASZel3LjXLpjjYG/N5
+BWnVexuJX9ika8HJiFl55oqaKb+WknfNhk5cPY+x7SDV9ywQeMiDZpr0ffeYAEP
LlwwiWRDYpO+uwXHSFF3+JjWwjhs8m8g99iFb7U93yKgBB12dCEPPa2ZeH9wUHMJ
sreYhNuq6f4iWWSXpzN45inQqtTi8jrJhuNLTT543ErW7DtntBO2rWMhff3aiXbn
Uy3qzZM1nPbuCGuBmP9L2dJ3Z5ifDWB4JmOyWY4swTZGt9AVmUxMIKdZpRONx8vz
I9u9nbVPGZBcou50Pa0qTLbkWsSL94MNXrARBxzhHC9Zs6XNEtwN7mOuii7uMkVc
adrxgknBH1J1N+NX/eTKzUwJuPvDtA+Z5ILWNN9wpZT/7ed8zEnKHPNUexyeT5g3
uw9z9jH7ffGxFYlx87oiVPHGOrCXYZYW5uoZE31SCBkbtNuffNRJRKIFeipmpJ3P
7bpAG+kGHMelQH6b+5K1Qgsv4tpuSyKeTKpPFH9Av5nN4P1ZBm9N80tzbNWqjSJm
S7rYdHnuNEVnUGnRmEUMmVuYZnNBEVN/fP2m2SEwXcP3Uh7TiYlcWw10ygaGmOr7
MvMLGkYgQ4Utwnd98mtqa0jr0hK2TcOSFir3AqVvXN3XJj4cVULkrXe4Im1laWgp
-----END RSA PRIVATE KEY-----
`),
	},
	{
		Name:          "rsa-encrypted-aes256-ctr",
		EncryptionKey: "Password-Test_1234",
		PEMBytes: []byte(`-----BEGIN OPENSSH PRIVATE KEY-----
b3BlbnNzaC1rZXktdjEAAAAACmFlczI1Ni1jdHIAAAAGYmNyeXB0AAAAGAAAABBb5bVJRJ
OyqhVNPrtqeQR7AAAAEAAAAAEAAAEXAAAAB3NzaC1yc2EAAAADAQABAAABAQDGl3Dz88NH
mWH65wsj94ffJHmXf09tYTIbJKwSADexk8ETQMBG0CjgM5B5Xu9J9JzTG3QkXFkery9tWb
uPCh4y2hz1svJe3gg37YV3Pp98Fmc4rTAKozlJLUdZA8kmURXmGhUe8p6IBT/EF8/ggGqC
vphqBwEzQz8jphAzkDBNFfQCpqEblnwG2Kw/Tegso1BPI9EsN3o5wrURCLN8fjPxxEcmWR
dGcCDuUqAbwnaJRGup0iJPal7YIVSi3uB7VCK8iWeDtsGLpOAnLojJRzGccn6pnFb1Pjes
35VWkhyv1KH5tDjmq0fA+P40ffSV0T1OZ7J0ZyR/BC0yV0gypHCPAAAD0LaQ/bL0QaRXRv
qHn1A+xJIWtkHskTX0APDZ+yyUHye9oaR5LBkvv6x8wPH3j8jb/k6eZ1zfv3g3Xkm5qUOW
dI0Lu1KPrwxh+f3Mco7LCDqHsI+j72uTo3sNJjsxhrRuX31rmKUwP4MWNecwVT9uN6Y+lr
BjFKfZX3RTEfYzgTh2skPVco90x0Zfbj/Q8IWaPpZFdLzogB+kERZrA7HT8SIGmzLOKDCX
KjVP92RkxvleC5T7XcTsXVkVelnfcMQ7sK6tKu6gk3+TUm0FUpOPoPxM1oRfVdyV2Fc3iI
tq17lkexQ3PqAjlSkM9VSz8f0ZEKqkQ2oK7m+TPoasMSkn/Blxs6ZnNiToH9Y9xawva/M5
JW822Zbhu8vVGBtpB9DVaHAj3JPAc+l2EwSlHPbyWoNfmQcHilonp+mHru2B/fH+vXOYO5
+T1Fp0gfQMifrDISgcNbTmhKYhnWnnpV6a3JGIe+cUWGzeYn9/GGZAJOHyAyA7Uy70e/2M
9ps4AY2rsS4Fu21BHuskbs9X1ujszIk0prXEN5NAyvKDsTT9chQRjo/VbwWpeAN9adF1Gs
yHnOkVT4Vc1reCLi0hNGcqUVH+LAQwTcaEnNaY1mAdgSBY+/8CnSDkhffixzT5ob5HbfLG
M2Hax9/pDX9hlLoh+eHz5pLoKzW+YDo1/NypS7goAsHPkiMTpn+oM1bqtjxDLeNmh3gCdW
UlJYt8rUT4G0t8JFIhTlVUNULaRYVIypGPgKdkVqUYo3lRW959cxgAC92XepjBISRACQCT
jYBWu2RHzbgePTwQLui0udXXFrhL7Tjw+epudZV3CDenBpkaDIGHOb3vOHN/q/lhgyuaTE
KN02DGQ1ThBdpAbUJksMj3S8X4aYtZK5Q71o7szjuamf+UseausaLs47BaNKqLugfDNFFl
oK2A5VCwJrt+o1wdet86JSnwr5lcJlSF4X9N8Ju6W0qJ/RWoE6znRpuCsVq90i0cgFaVIA
OE8CeHdjpXHijVqW/cFbH2IDyUYzSdr5Ke1fow0M61n22D9lm16mXBs5OmkZ5yrb7vJCB7
U2VYIrZIsGQh2VMC/HOt3Ms3HE08jI97MDX/4LlmQEzZwDLYArK7JVVpTCvjdTiY2XrSd6
ZRE5Mw1J5QYHHdw18Ia+tvKVlcQL+RwbTDYzBQrkmHIJ7xYAO5QAtRMZnwSGRyq+f8uhEU
nGz9lcHnccxsF6BxuT0XHe1gcUnU71Uffm+D9NLf9xGxEgWkoJK4+/K5DxRYXxYj2iWSMg
xQGBlJ2l92yvGabNDbfgqgsvVsTWg=
-----END OPENSSH PRIVATE KEY-----
`),
	},
	{
		Name:          "dsa-encrypted-aes256-cbc",
		EncryptionKey: "qG0pher-dsa_t3st$",
		PEMBytes: []byte(`-----BEGIN DSA PRIVATE KEY-----
Proc-Type: 4,ENCRYPTED
DEK-Info: AES-128-CBC,7CE7A6E4A647DC01AF860210B15ADE3E

hvnBpI99Hceq/55pYRdOzBLntIEis02JFNXuLEydWL+RJBFDn7tA+vXec0ERJd6J
G8JXlSOAhmC2H4uK3q2xR8/Y3yL95n6OIcjvCBiLsV+o3jj1MYJmErxP6zRtq4w3
JjIjGHWmaYFSxPKQ6e8fs74HEqaeMV9ONUoTtB+aISmgaBL15Fcoayg245dkBvVl
h5Kqspe7yvOBmzA3zjRuxmSCqKJmasXM7mqs3vIrMxZE3XPo1/fWKcPuExgpVQoT
HkJZEoIEIIPnPMwT2uYbFJSGgPJVMDT84xz7yvjCdhLmqrsXgs5Qw7Pw0i0c0BUJ
b7fDJ2UhdiwSckWGmIhTLlJZzr8K+JpjCDlP+REYBI5meB7kosBnlvCEHdw2EJkH
0QDc/2F4xlVrHOLbPRFyu1Oi2Gvbeoo9EsM/DThpd1hKAlb0sF5Y0y0d+owv0PnE
R/4X3HWfIdOHsDUvJ8xVWZ4BZk9Zk9qol045DcFCehpr/3hslCrKSZHakLt9GI58
vVQJ4L0aYp5nloLfzhViZtKJXRLkySMKdzYkIlNmW1oVGl7tce5UCNI8Nok4j6yn
IiHM7GBn+0nJoKTXsOGMIBe3ulKlKVxLjEuk9yivh/8=
-----END DSA PRIVATE KEY-----
`),
	},
	{
		Name:          "rsa-openssh-encrypted-aes256-cbc",
		EncryptionKey: "12345",
		PEMBytes: []byte(`-----BEGIN OPENSSH PRIVATE KEY-----
b3BlbnNzaC1rZXktdjEAAAAACmFlczI1Ni1jYmMAAAAGYmNyeXB0AAAAGAAAABAr17kxS0
ml6jFNMeKz3kmAAAAAEAAAAAEAAACXAAAAB3NzaC1yc2EAAAADAQABAAAAgQDWgUqHjwHx
hEg9L0aUk4z8H/3TOY2/AzWFoXa/50JjZkHpmC5Nuc0dW5tZEavJ4hp556HQzNJpFmnvJt
4xH4hFtOYjxdVkUJFxthj4gX65VchAC4qHkXSIFo9eR2wf+nI6MhnTe2M9K2v1qdhr/tDB
QgBDl8EhcXdho7f9wUSt5QAAAhCfga24LXLNKwXb21L7Xl5Qd8MPkNNp9cR7/1E39SEx8Q
//hL1DSyQ+kAfuhBkh4oO15ukE8IMxBpsAYkv69PtjIWqFAHKe/AYZe8eQCK3csiMHu8np
TCwq6rCaTXl3TkwqnrR908mG9D00fMjsD6FE6ycsofvtxv05VVNdruGm/81dC2FYkW8uU8
k/z+fTj0a9KqxLyxUAX7+Zronnx5m5Z/FPBYfc2boSvTLaKsewcgTY7O7Ut6bvnGR4VRlQ
P1ONKhaRdc8jjBHKZhfKHqLQBYMe5YT0QJXwG2wr+VknkzPTTeKPNJvKeiboCB/apBZEB9
Lu+OwZjizwYpXYZ7euT0KMryXXOvdNBHLA5kpjZiYpp7gVHPP1A39SeA2YFdhJ32NRZaXb
Gkhhx8egwoNCGhsmnHnc9J0z1J8WIB1dohm7p7nWYEbjd22hwl+huzLSJ1Nwwae51xGCry
9QUplm6ot3EYJIkU8Xh40mR74rL2nMDa70xFYZKwN4F9AoZrcWATMX9L+ARw3m8s3DW4xp
Z+R8/30TIeqFzzuVRfLeWyc1AKT0dbwFyz5l8sRlWhUM+jgWx2EU/s+gP8Ch4+3Pjqnu97
1e+V+l6fR0o1r6TmDuOlMe3egsroRTKx+Re4UZGrbWINrFU3KOJmjXf8vOj+IcG23+MMgN
uxJ4W16r7KrATcy4l5F45EyinbHR020=
-----END OPENSSH PRIVATE KEY-----
`),
	},
	{
		Name:          "ed25519-openssh-encrypted-aes256-cbc",
		EncryptionKey: "quohwan1Ae",
		PEMBytes: []byte(`-----BEGIN OPENSSH PRIVATE KEY-----
b3BlbnNzaC1rZXktdjEAAAAACmFlczI1Ni1jYmMAAAAGYmNyeXB0AAAAGAAAABBkYM/1no
eyaYdoda4+kT2wAAAAEAAAAAEAAAAzAAAAC3NzaC1lZDI1NTE5AAAAID+XSBBldjetRI5l
PsElCyrgFXmGikfg9chCGrY6MW2fAAAAkF2mStmLKKdTDi67NQeZiWv1FaCd9NyKyUYY9s
KkgIWxvVVzi8SxJmR2znR4PU26HpX3QUDdOf6ET3BATO9VVWkbBUUqt0VnwB1CI498OYuQ
uFv91uY8u4KfYYFN7qZw4sjjPa5m+u1cIGwqVDoNDXR7OddStXwDCcn/9Wq+t2/LoavtsC
MgjCX2e9GImZ7kbA==
-----END OPENSSH PRIVATE KEY-----
	`),
	},
	{
		Name:          "ed25519-openssh-encrypted-aes256-ctr",
		EncryptionKey: "1234",
		PEMBytes: []byte(`-----BEGIN OPENSSH PRIVATE KEY-----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-----END OPENSSH PRIVATE KEY-----
`),
	},
}
