/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.internal;

import jakarta.persistence.EntityGraph;
import jakarta.persistence.PessimisticLockScope;
import jakarta.persistence.Timeout;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.HibernateException;
import org.hibernate.IdentifierLoadAccess;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.UnknownProfileException;
import org.hibernate.engine.spi.EffectiveEntityGraph;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.NaturalIdResolutions;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.Status;
import org.hibernate.graph.GraphSemantic;
import org.hibernate.graph.spi.RootGraphImplementor;
import org.hibernate.internal.NaturalIdHelper;
import org.hibernate.loader.ast.spi.NaturalIdLoadOptions;
import org.hibernate.loader.internal.IdentifierLoadAccessImpl;
import org.hibernate.loader.internal.LoadAccessContext;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;

public abstract class BaseNaturalIdLoadAccessImpl<T>
implements NaturalIdLoadOptions {
    private final LoadAccessContext context;
    private final EntityMappingType entityDescriptor;
    private LockOptions lockOptions;
    private boolean synchronizationEnabled = true;
    private Set<String> enabledFetchProfiles;
    private Set<String> disabledFetchProfiles;
    private RootGraphImplementor<T> rootGraph;
    private GraphSemantic graphSemantic;

    protected BaseNaturalIdLoadAccessImpl(LoadAccessContext context, EntityMappingType entityDescriptor) {
        this.context = context;
        this.entityDescriptor = entityDescriptor;
        if (entityDescriptor.getNaturalIdMapping() == null) {
            throw new HibernateException(String.format("Entity [%s] did not define a natural id", entityDescriptor.getEntityName()));
        }
    }

    @Override
    public LockOptions getLockOptions() {
        return this.lockOptions;
    }

    protected Object with(LockMode lockMode, PessimisticLockScope lockScope) {
        if (this.lockOptions == null) {
            this.lockOptions = new LockOptions();
        }
        this.lockOptions.setLockMode(lockMode);
        this.lockOptions.setLockScope(lockScope);
        return this;
    }

    protected Object with(Timeout timeout) {
        if (this.lockOptions == null) {
            this.lockOptions = new LockOptions();
        }
        this.lockOptions.setTimeOut(timeout.milliseconds());
        return this;
    }

    public Object with(EntityGraph<T> graph, GraphSemantic semantic) {
        this.rootGraph = (RootGraphImplementor)graph;
        this.graphSemantic = semantic;
        return this;
    }

    public Object enableFetchProfile(String profileName) {
        if (!this.context.getSession().getFactory().containsFetchProfileDefinition(profileName)) {
            throw new UnknownProfileException(profileName);
        }
        if (this.enabledFetchProfiles == null) {
            this.enabledFetchProfiles = new HashSet<String>();
        }
        this.enabledFetchProfiles.add(profileName);
        if (this.disabledFetchProfiles != null) {
            this.disabledFetchProfiles.remove(profileName);
        }
        return this;
    }

    public Object disableFetchProfile(String profileName) {
        if (this.disabledFetchProfiles == null) {
            this.disabledFetchProfiles = new HashSet<String>();
        }
        this.disabledFetchProfiles.add(profileName);
        if (this.enabledFetchProfiles != null) {
            this.enabledFetchProfiles.remove(profileName);
        }
        return this;
    }

    @Override
    public boolean isSynchronizationEnabled() {
        return this.synchronizationEnabled;
    }

    public BaseNaturalIdLoadAccessImpl<T> with(LockOptions lockOptions) {
        this.lockOptions = lockOptions;
        return this;
    }

    protected void synchronizationEnabled(boolean synchronizationEnabled) {
        this.synchronizationEnabled = synchronizationEnabled;
    }

    private Object getCachedResolution(Object normalizedNaturalIdValue) {
        SessionImplementor session = this.context.getSession();
        NaturalIdHelper.performAnyNeededCrossReferenceSynchronizations(this.synchronizationEnabled, this.entityDescriptor, session);
        this.context.checkOpenOrWaitingForAutoClose();
        this.context.pulseTransactionCoordinator();
        return session.getPersistenceContextInternal().getNaturalIdResolutions().findCachedIdByNaturalId(normalizedNaturalIdValue, this.entityPersister());
    }

    protected final T doGetReference(Object normalizedNaturalIdValue) {
        Object cachedResolution = this.getCachedResolution(normalizedNaturalIdValue);
        if (cachedResolution == NaturalIdResolutions.INVALID_NATURAL_ID_REFERENCE) {
            return null;
        }
        if (cachedResolution != null) {
            return this.identifierLoadAccess().getReference(cachedResolution);
        }
        Object idFromDatabase = this.entityPersister().getNaturalIdLoader().resolveNaturalIdToId(normalizedNaturalIdValue, this.context.getSession());
        return idFromDatabase == null ? null : (T)this.identifierLoadAccess().getReference(idFromDatabase);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final T doLoad(Object normalizedNaturalIdValue) {
        Object cachedResolution = this.getCachedResolution(normalizedNaturalIdValue);
        if (cachedResolution == NaturalIdResolutions.INVALID_NATURAL_ID_REFERENCE) {
            return null;
        }
        SessionImplementor session = this.context.getSession();
        LoadQueryInfluencers influencers = session.getLoadQueryInfluencers();
        HashSet<String> fetchProfiles = influencers.adjustFetchProfiles(this.disabledFetchProfiles, this.enabledFetchProfiles);
        EffectiveEntityGraph effectiveEntityGraph = session.getLoadQueryInfluencers().applyEntityGraph(this.rootGraph, this.graphSemantic);
        try {
            T loaded;
            Object object = loaded = cachedResolution != null ? this.identifierLoadAccess().load(cachedResolution) : this.entityPersister().getNaturalIdLoader().load(normalizedNaturalIdValue, this, session);
            if (loaded != null) {
                EntityEntry entry;
                PersistenceContext persistenceContext = session.getPersistenceContextInternal();
                LazyInitializer lazyInitializer = HibernateProxy.extractLazyInitializer(loaded);
                EntityEntry entityEntry = entry = lazyInitializer != null ? persistenceContext.getEntry(lazyInitializer.getImplementation()) : persistenceContext.getEntry(loaded);
                assert (entry != null);
                if (entry.getStatus() == Status.DELETED) {
                    T t = null;
                    return t;
                }
            }
            T t = loaded;
            return t;
        }
        finally {
            this.context.delayedAfterCompletion();
            effectiveEntityGraph.clear();
            influencers.setEnabledFetchProfileNames(fetchProfiles);
        }
    }

    protected final IdentifierLoadAccess<T> identifierLoadAccess() {
        IdentifierLoadAccessImpl loadAccess = new IdentifierLoadAccessImpl(this.context, this.entityPersister());
        if (this.lockOptions != null) {
            loadAccess.with(this.lockOptions);
        }
        return loadAccess;
    }

    protected LoadAccessContext getContext() {
        return this.context;
    }

    public EntityMappingType getEntityDescriptor() {
        return this.entityDescriptor;
    }

    protected EntityPersister entityPersister() {
        return this.entityDescriptor.getEntityPersister();
    }
}

