/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.id.enhanced;

import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.id.IntegralDataTypeHolder;
import org.hibernate.id.enhanced.AbstractOptimizer;
import org.hibernate.id.enhanced.AccessCallback;
import org.hibernate.query.sqm.BinaryArithmeticOperator;
import org.hibernate.sql.ast.tree.expression.BinaryArithmeticExpression;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.QueryLiteral;
import org.hibernate.type.BasicType;
import org.jboss.logging.Logger;

public class LegacyHiLoAlgorithmOptimizer
extends AbstractOptimizer {
    private static final Logger log = Logger.getLogger(LegacyHiLoAlgorithmOptimizer.class);
    private final long initialMaxLo;
    private final Lock lock = new ReentrantLock();
    private GenerationState noTenantState;
    private Map<String, GenerationState> tenantSpecificState;

    public LegacyHiLoAlgorithmOptimizer(Class<?> returnClass, int incrementSize) {
        super(returnClass, incrementSize);
        if (incrementSize < 1) {
            throw new HibernateException("increment size cannot be less than 1");
        }
        if (log.isTraceEnabled()) {
            log.tracev("Creating hilo optimizer (legacy) with [incrementSize={0}; returnClass={1}]", (Object)incrementSize, (Object)returnClass.getName());
        }
        this.initialMaxLo = incrementSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Serializable generate(AccessCallback callback) {
        this.lock.lock();
        try {
            GenerationState generationState = this.locateGenerationState(callback.getTenantIdentifier());
            if (generationState.lo > generationState.maxLo) {
                generationState.lastSourceValue = callback.getNextValue();
                generationState.lo = generationState.lastSourceValue.eq(0L) ? 1L : 0L;
                generationState.hi = generationState.lastSourceValue.copy().multiplyBy(generationState.maxLo + 1L);
            }
            generationState.value = generationState.hi.copy().add(generationState.lo++);
            Number number = generationState.value.makeValue();
            return number;
        }
        finally {
            this.lock.unlock();
        }
    }

    private GenerationState locateGenerationState(String tenantIdentifier) {
        GenerationState state;
        if (tenantIdentifier == null) {
            if (this.noTenantState == null) {
                this.noTenantState = this.createGenerationState();
            }
            return this.noTenantState;
        }
        if (this.tenantSpecificState == null) {
            this.tenantSpecificState = new ConcurrentHashMap<String, GenerationState>();
            state = this.createGenerationState();
            this.tenantSpecificState.put(tenantIdentifier, state);
        } else {
            state = this.tenantSpecificState.get(tenantIdentifier);
            if (state == null) {
                state = this.createGenerationState();
                this.tenantSpecificState.put(tenantIdentifier, state);
            }
        }
        return state;
    }

    private GenerationState createGenerationState() {
        GenerationState state = new GenerationState();
        state.maxLo = this.initialMaxLo;
        state.lo = this.initialMaxLo + 1L;
        return state;
    }

    private GenerationState noTenantGenerationState() {
        if (this.noTenantState == null) {
            throw new IllegalStateException("Could not locate previous generation state for no-tenant");
        }
        return this.noTenantState;
    }

    @Override
    public IntegralDataTypeHolder getLastSourceValue() {
        this.lock.lock();
        try {
            IntegralDataTypeHolder integralDataTypeHolder = this.noTenantGenerationState().lastSourceValue.copy();
            return integralDataTypeHolder;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean applyIncrementSizeToSourceValues() {
        return false;
    }

    public IntegralDataTypeHolder getLastValue() {
        this.lock.lock();
        try {
            IntegralDataTypeHolder integralDataTypeHolder = this.noTenantGenerationState().value;
            return integralDataTypeHolder;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public Expression createLowValueExpression(Expression databaseValue, SessionFactoryImplementor sessionFactory) {
        BasicType<Integer> integerType = sessionFactory.getTypeConfiguration().getBasicTypeForJavaType(Integer.class);
        return new BinaryArithmeticExpression(databaseValue, BinaryArithmeticOperator.MULTIPLY, new QueryLiteral<Integer>(this.getIncrementSize() + 1, integerType), integerType);
    }

    private static class GenerationState {
        private long maxLo;
        private long lo;
        private IntegralDataTypeHolder hi;
        private IntegralDataTypeHolder lastSourceValue;
        private IntegralDataTypeHolder value;

        private GenerationState() {
        }
    }
}

