/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.micrometer.v1_5;

import io.micrometer.core.instrument.AbstractMeter;
import io.micrometer.core.instrument.FunctionCounter;
import io.micrometer.core.instrument.Measurement;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.config.NamingConvention;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.metrics.ObservableDoubleCounter;
import io.opentelemetry.instrumentation.micrometer.v1_5.Bridging;
import io.opentelemetry.instrumentation.micrometer.v1_5.DoubleMeasurementRecorder;
import io.opentelemetry.instrumentation.micrometer.v1_5.RemovableMeter;
import io.opentelemetry.instrumentation.micrometer.v1_5.UnsupportedReadLogger;
import java.util.Collections;
import java.util.function.ToDoubleFunction;

final class OpenTelemetryFunctionCounter<T>
extends AbstractMeter
implements FunctionCounter,
RemovableMeter {
    private final ObservableDoubleCounter observableCount;

    OpenTelemetryFunctionCounter(Meter.Id id, NamingConvention namingConvention, T obj, ToDoubleFunction<T> countFunction, Meter otelMeter) {
        super(id);
        String name = Bridging.name(id, namingConvention);
        this.observableCount = otelMeter.counterBuilder(name).ofDoubles().setDescription(Bridging.description(id)).setUnit(Bridging.baseUnit(id)).buildWithCallback(new DoubleMeasurementRecorder<T>(obj, countFunction, Bridging.tagsAsAttributes(id, namingConvention)));
    }

    public double count() {
        UnsupportedReadLogger.logWarning();
        return Double.NaN;
    }

    public Iterable<Measurement> measure() {
        UnsupportedReadLogger.logWarning();
        return Collections.emptyList();
    }

    @Override
    public void onRemove() {
        this.observableCount.close();
    }
}

