/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.events;

import org.jboss.logging.Logger;
import org.keycloak.cluster.ClusterEvent;
import org.keycloak.cluster.ClusterListener;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.sessions.infinispan.InfinispanAuthenticationSessionProvider;
import org.keycloak.models.sessions.infinispan.events.SessionClusterEvent;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.sessions.AuthenticationSessionProvider;

public abstract class AbstractAuthSessionClusterListener<SE extends SessionClusterEvent>
implements ClusterListener {
    private static final Logger log = Logger.getLogger(AbstractAuthSessionClusterListener.class);
    private final KeycloakSessionFactory sessionFactory;

    public AbstractAuthSessionClusterListener(KeycloakSessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public void eventReceived(ClusterEvent event) {
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)this.sessionFactory, session -> {
            InfinispanAuthenticationSessionProvider provider = (InfinispanAuthenticationSessionProvider)session.getProvider(AuthenticationSessionProvider.class, "infinispan");
            SessionClusterEvent sessionEvent = (SessionClusterEvent)event;
            if (!provider.getCache().getStatus().allowInvocations()) {
                log.debugf("Cache in state '%s' doesn't allow invocations", (Object)provider.getCache().getStatus());
                return;
            }
            log.debugf("Received authentication session event '%s'", (Object)sessionEvent.toString());
            this.eventReceived(provider, sessionEvent);
        });
    }

    protected abstract void eventReceived(InfinispanAuthenticationSessionProvider var1, SE var2);
}

