/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.openapi.runtime;

import io.quarkus.smallrye.openapi.runtime.OpenAPIRuntimeBuilder;
import io.quarkus.smallrye.openapi.runtime.OpenApiConstants;
import io.quarkus.smallrye.openapi.runtime.OpenApiDocumentHolder;
import io.quarkus.smallrye.openapi.runtime.OpenApiDocumentService;
import io.quarkus.smallrye.openapi.runtime.OpenApiRecorder;
import io.quarkus.smallrye.openapi.runtime.filter.DisabledRestEndpointsFilter;
import io.smallrye.openapi.api.SmallRyeOpenAPI;
import io.smallrye.openapi.runtime.io.Format;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.LinkedHashSet;
import java.util.Optional;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.openapi.OASFilter;
import org.jboss.jandex.IndexView;

@ApplicationScoped
public class OpenApiDocumentService {
    private final OpenApiDocumentHolder documentHolder;

    @Inject
    public OpenApiDocumentService(OASFilter autoSecurityFilter, OpenApiRecorder.UserDefinedRuntimeFilters runtimeFilters, Config config) {
        ClassLoader loader = Optional.ofNullable(OpenApiConstants.classLoader).orElseGet(Thread.currentThread()::getContextClassLoader);
        try (InputStream source = loader.getResourceAsStream("META-INF/quarkus-generated-openapi-doc.JSON");){
            if (source != null) {
                LinkedHashSet userFilters = new LinkedHashSet(runtimeFilters.filters());
                boolean dynamic = config.getOptionalValue("quarkus.smallrye-openapi.always-run-filter", Boolean.class).orElse(Boolean.FALSE);
                SmallRyeOpenAPI.Builder builder = new OpenAPIRuntimeBuilder().withConfig(config).withApplicationClassLoader(loader).enableModelReader(false).enableStandardStaticFiles(false).enableAnnotationScan(false).enableStandardFilter(false).withCustomStaticFile(() -> source);
                Optional.ofNullable(autoSecurityFilter).ifPresent(arg_0 -> ((SmallRyeOpenAPI.Builder)builder).addFilter(arg_0));
                DisabledRestEndpointsFilter.maybeGetInstance().ifPresent(arg_0 -> ((SmallRyeOpenAPI.Builder)builder).addFilter(arg_0));
                if (dynamic && !userFilters.isEmpty()) {
                    this.documentHolder = new DynamicDocument(builder, loader, userFilters);
                } else {
                    userFilters.forEach(name -> builder.addFilter(name, loader, (IndexView)null));
                    this.documentHolder = new StaticDocument(builder.build());
                }
            } else {
                this.documentHolder = new EmptyDocument();
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public byte[] getDocument(Format format) {
        if (format.equals((Object)Format.JSON)) {
            return this.documentHolder.getJsonDocument();
        }
        return this.documentHolder.getYamlDocument();
    }

    public OpenApiDocumentService() {
    }
}

