/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.docking.action;

import net.infonode.docking.DockingWindow;
import net.infonode.docking.TabWindow;
import net.infonode.docking.action.DockingWindowAction;
import net.infonode.docking.action.MaximizeWindowAction;
import net.infonode.docking.action.MaximizeWithAbortWindowAction;
import net.infonode.docking.action.RestoreParentWindowAction;
import net.infonode.docking.action.RestoreParentWithAbortWindowAction;
import net.infonode.docking.util.DockingUtil;

public class StateDependentWindowAction
extends DockingWindowAction {
    private static final long serialVersionUID = 1L;
    public static final StateDependentWindowAction MAXIMIZE_RESTORE = new StateDependentWindowAction(MaximizeWindowAction.INSTANCE, RestoreParentWindowAction.INSTANCE, RestoreParentWindowAction.INSTANCE);
    public static final StateDependentWindowAction MAXIMIZE_RESTORE_WITH_ABORT = new StateDependentWindowAction(MaximizeWithAbortWindowAction.INSTANCE, RestoreParentWithAbortWindowAction.INSTANCE, RestoreParentWithAbortWindowAction.INSTANCE);
    private DockingWindowAction normalAction;
    private DockingWindowAction minimizedAction;
    private DockingWindowAction maximizedAction;

    public StateDependentWindowAction(DockingWindowAction normalAction, DockingWindowAction minimizedAction, DockingWindowAction maximizedAction) {
        this.normalAction = normalAction;
        this.minimizedAction = minimizedAction;
        this.maximizedAction = maximizedAction;
    }

    @Override
    public String getName() {
        return "State Dependent";
    }

    @Override
    public boolean isPerformable(DockingWindow window) {
        return this.getActionProvider(window).isPerformable(window);
    }

    @Override
    public void perform(DockingWindow window) {
        this.getActionProvider(window).perform(window);
    }

    private DockingWindowAction getActionProvider(DockingWindow window) {
        if (window.isMinimized()) {
            return this.minimizedAction;
        }
        TabWindow tabWindow = DockingUtil.getTabWindowFor(window);
        return tabWindow != null && tabWindow.isMaximized() ? this.maximizedAction : this.normalAction;
    }
}

