/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.util;

import java.net.URL;
import java.util.Properties;
import java.util.StringTokenizer;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.util.FileUtils;

public class FreeplaneVersion
implements org.freeplane.api.FreeplaneVersion {
    private static final FreeplaneVersion VERSION = FreeplaneVersion.loadVersion();
    public static final String VERSION_KEY = "freeplane_version";
    public static final String VERSION_PROPERTIES = "/version.properties";
    public static final String XML_VERSION = "freeplane 1.12.15";
    private final int mMaj;
    private final int mMid;
    private final int mMin;
    private final int mNum;
    private String mType;
    private String revision = null;

    public static FreeplaneVersion getVersion() {
        return VERSION;
    }

    public static FreeplaneVersion getVersion(String pString) throws IllegalArgumentException {
        if (pString == null) {
            return null;
        }
        StringTokenizer t = new StringTokenizer(pString, "v. ", false);
        String[] info = new String[t.countTokens()];
        int i = 0;
        while (t.hasMoreTokens()) {
            info[i++] = t.nextToken();
        }
        if (info.length < 2 | info.length > 5) {
            throw new IllegalArgumentException("Wrong number of tokens for version information: " + pString);
        }
        try {
            int maj = Integer.parseInt(info[0]);
            int mid = Integer.parseInt(info[1]);
            int min = info.length < 3 ? 0 : Integer.parseInt(info[2]);
            String type = info.length < 4 ? "" : info[3];
            int num = info.length < 5 ? 0 : Integer.parseInt(info[4]);
            return new FreeplaneVersion(maj, mid, min, type, num);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Wrong version token: " + pString, e);
        }
    }

    private static FreeplaneVersion loadVersion() {
        Properties versionProperties = FileUtils.loadProperties(VERSION_PROPERTIES);
        String versionString = versionProperties.getProperty(VERSION_KEY);
        String versionStatus = versionProperties.getProperty("freeplane_version_status");
        FreeplaneVersion version = FreeplaneVersion.getVersion(versionString);
        version.mType = versionStatus;
        return version;
    }

    public int getMaj() {
        return this.mMaj;
    }

    public int getMid() {
        return this.mMid;
    }

    public int getMin() {
        return this.mMin;
    }

    public int getNum() {
        return this.mNum;
    }

    public String getType() {
        return this.mType;
    }

    public String getRevision() {
        if (this.revision == null) {
            this.revision = FreeplaneVersion.loadRevision();
        }
        return this.revision;
    }

    public FreeplaneVersion(int pMaj, int pMid, int pMin, String pType, int pNum) {
        this.mMaj = pMaj;
        this.mMid = pMid;
        this.mMin = pMin;
        this.mType = pType;
        this.mNum = pNum;
    }

    public FreeplaneVersion(int pMaj, int pMid, int pMin) {
        this(pMaj, pMid, pMin, "", 0);
    }

    public int compareTo(org.freeplane.api.FreeplaneVersion o) {
        if (this.mMaj < o.getMaj()) {
            return -1;
        }
        if (this.mMaj > o.getMaj()) {
            return 1;
        }
        if (this.mMid < o.getMid()) {
            return -1;
        }
        if (this.mMid > o.getMid()) {
            return 1;
        }
        if (this.mMin < o.getMin()) {
            return -1;
        }
        if (this.mMin > o.getMin()) {
            return 1;
        }
        if (this.mNum < o.getNum()) {
            return -1;
        }
        if (this.mNum > o.getNum()) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.mMaj);
        buf.append('.');
        buf.append(this.mMid);
        buf.append('.');
        buf.append(this.mMin);
        if (!this.mType.equals("")) {
            buf.append(' ');
            buf.append(this.mType);
        }
        if (this.mNum != 0) {
            buf.append(' ');
            buf.append(this.mNum);
        }
        return buf.toString();
    }

    public String numberToString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.mMaj);
        buf.append('.');
        buf.append(this.mMid);
        buf.append('.');
        buf.append(this.mMin);
        return buf.toString();
    }

    public boolean isOlderThan(org.freeplane.api.FreeplaneVersion freeplaneVersion) {
        return this.compareTo(freeplaneVersion) < 0;
    }

    public boolean isNewerThan(org.freeplane.api.FreeplaneVersion freeplaneVersion) {
        return this.compareTo(freeplaneVersion) > 0;
    }

    public boolean isFinal() {
        return "".equals(this.mType);
    }

    private static String loadRevision() {
        try {
            URL gitInfo = ResourceController.getResourceController().getResource("/gitinfo.properties");
            if (gitInfo != null) {
                Properties gitProps = new Properties();
                gitProps.load(gitInfo.openStream());
                return gitProps.getProperty("git-revision", "");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }
}

