﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/chime-sdk-voice/ChimeSDKVoiceRequest.h>
#include <aws/chime-sdk-voice/ChimeSDKVoice_EXPORTS.h>
#include <aws/chime-sdk-voice/model/EmergencyCallingConfiguration.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
namespace ChimeSDKVoice {
namespace Model {

/**
 */
class PutVoiceConnectorEmergencyCallingConfigurationRequest : public ChimeSDKVoiceRequest {
 public:
  AWS_CHIMESDKVOICE_API PutVoiceConnectorEmergencyCallingConfigurationRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "PutVoiceConnectorEmergencyCallingConfiguration"; }

  AWS_CHIMESDKVOICE_API Aws::String SerializePayload() const override;

  ///@{
  /**
   * <p>The Voice Connector ID.</p>
   */
  inline const Aws::String& GetVoiceConnectorId() const { return m_voiceConnectorId; }
  inline bool VoiceConnectorIdHasBeenSet() const { return m_voiceConnectorIdHasBeenSet; }
  template <typename VoiceConnectorIdT = Aws::String>
  void SetVoiceConnectorId(VoiceConnectorIdT&& value) {
    m_voiceConnectorIdHasBeenSet = true;
    m_voiceConnectorId = std::forward<VoiceConnectorIdT>(value);
  }
  template <typename VoiceConnectorIdT = Aws::String>
  PutVoiceConnectorEmergencyCallingConfigurationRequest& WithVoiceConnectorId(VoiceConnectorIdT&& value) {
    SetVoiceConnectorId(std::forward<VoiceConnectorIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The configuration being updated.</p>
   */
  inline const EmergencyCallingConfiguration& GetEmergencyCallingConfiguration() const { return m_emergencyCallingConfiguration; }
  inline bool EmergencyCallingConfigurationHasBeenSet() const { return m_emergencyCallingConfigurationHasBeenSet; }
  template <typename EmergencyCallingConfigurationT = EmergencyCallingConfiguration>
  void SetEmergencyCallingConfiguration(EmergencyCallingConfigurationT&& value) {
    m_emergencyCallingConfigurationHasBeenSet = true;
    m_emergencyCallingConfiguration = std::forward<EmergencyCallingConfigurationT>(value);
  }
  template <typename EmergencyCallingConfigurationT = EmergencyCallingConfiguration>
  PutVoiceConnectorEmergencyCallingConfigurationRequest& WithEmergencyCallingConfiguration(EmergencyCallingConfigurationT&& value) {
    SetEmergencyCallingConfiguration(std::forward<EmergencyCallingConfigurationT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_voiceConnectorId;

  EmergencyCallingConfiguration m_emergencyCallingConfiguration;
  bool m_voiceConnectorIdHasBeenSet = false;
  bool m_emergencyCallingConfigurationHasBeenSet = false;
};

}  // namespace Model
}  // namespace ChimeSDKVoice
}  // namespace Aws
