/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.decompiler.psi.text;

import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.decompiler.psi.DeserializerForClassfileDecompilerKt;
import org.jetbrains.kotlin.analysis.decompiler.psi.ResolverForDecompiler;
import org.jetbrains.kotlin.analysis.decompiler.psi.text.BuildDecompiledTextKt;
import org.jetbrains.kotlin.analysis.decompiler.psi.text.DecompiledText;
import org.jetbrains.kotlin.analysis.decompiler.psi.text.IncompatibleAbiVersionKt;
import org.jetbrains.kotlin.analysis.decompiler.stub.file.ClsClassFinder;
import org.jetbrains.kotlin.analysis.decompiler.stub.file.ClsKotlinBinaryClassCache;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinaryClass;
import org.jetbrains.kotlin.load.kotlin.header.KotlinClassHeader;
import org.jetbrains.kotlin.metadata.deserialization.BinaryVersion;
import org.jetbrains.kotlin.metadata.deserialization.MetadataVersion;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.renderer.DescriptorRendererOptions;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.error.ErrorType;
import org.jetbrains.kotlin.types.error.ErrorTypeKind;
import org.jetbrains.kotlin.types.error.ErrorUtils;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005\"\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"buildDecompiledTextForClassFile", "Lorg/jetbrains/kotlin/analysis/decompiler/psi/text/DecompiledText;", "classFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "resolver", "Lorg/jetbrains/kotlin/analysis/decompiler/psi/ResolverForDecompiler;", "decompilerRendererForClassFiles", "Lorg/jetbrains/kotlin/renderer/DescriptorRenderer;", "decompiler-to-psi"})
@SourceDebugExtension(value={"SMAP\nbuildDecompiledTextForClassFile.kt\nKotlin\n*S Kotlin\n*F\n+ 1 buildDecompiledTextForClassFile.kt\norg/jetbrains/kotlin/analysis/decompiler/psi/text/BuildDecompiledTextForClassFileKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,69:1\n1374#2:70\n1460#2,5:71\n*S KotlinDebug\n*F\n+ 1 buildDecompiledTextForClassFile.kt\norg/jetbrains/kotlin/analysis/decompiler/psi/text/BuildDecompiledTextForClassFileKt\n*L\n50#1:70\n50#1:71,5\n*E\n"})
public final class BuildDecompiledTextForClassFileKt {
    @NotNull
    private static final DescriptorRenderer decompilerRendererForClassFiles = DescriptorRenderer.Companion.withOptions(BuildDecompiledTextForClassFileKt::decompilerRendererForClassFiles$lambda$0);

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final DecompiledText buildDecompiledTextForClassFile(@NotNull VirtualFile classFile, @NotNull ResolverForDecompiler resolver) {
        DecompiledText decompiledText;
        Intrinsics.checkNotNullParameter(classFile, "classFile");
        Intrinsics.checkNotNullParameter(resolver, "resolver");
        ClsKotlinBinaryClassCache.KotlinBinaryClassHeaderData kotlinBinaryClassHeaderData = ClsKotlinBinaryClassCache.getKotlinBinaryClassHeaderData$default(ClsKotlinBinaryClassCache.Companion.getInstance(), classFile, null, 2, null);
        if (kotlinBinaryClassHeaderData == null) {
            throw new IllegalStateException(("Decompiled data factory shouldn't be called on an unsupported file: " + classFile).toString());
        }
        ClsKotlinBinaryClassCache.KotlinBinaryClassHeaderData classHeader = kotlinBinaryClassHeaderData;
        ClassId classId = classHeader.getClassId();
        if (!classHeader.getMetadataVersion().isCompatibleWithCurrentCompilerVersion()) {
            return IncompatibleAbiVersionKt.createIncompatibleMetadataVersionDecompiledText((BinaryVersion)MetadataVersion.INSTANCE_NEXT, (BinaryVersion)classHeader.getMetadataVersion());
        }
        switch (WhenMappings.$EnumSwitchMapping$0[classHeader.getKind().ordinal()]) {
            case 1: 
            case 2: {
                decompiledText = BuildDecompiledTextForClassFileKt.buildDecompiledTextForClassFile$buildText(classHeader, resolver.resolveDeclarationsInFacade(classId.asSingleFqName()));
                break;
            }
            case 3: {
                decompiledText = BuildDecompiledTextForClassFileKt.buildDecompiledTextForClassFile$buildText(classHeader, CollectionsKt.listOfNotNull(resolver.resolveTopLevelClass(classId)));
                break;
            }
            case 4: {
                void $this$flatMapTo$iv$iv;
                List<KotlinJvmBinaryClass> partClasses = ClsClassFinder.INSTANCE.findMultifileClassParts(classFile, classId, classHeader.getPartNamesIfMultifileFacade());
                Iterable $this$flatMap$iv = partClasses;
                boolean $i$f$flatMap = false;
                Iterable iterable = $this$flatMap$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$flatMapTo = false;
                for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                    KotlinJvmBinaryClass partClass = (KotlinJvmBinaryClass)element$iv$iv;
                    boolean bl = false;
                    Iterable list$iv$iv = resolver.resolveDeclarationsInFacade(partClass.getClassId().asSingleFqName());
                    CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
                }
                List partMembers = (List)destination$iv$iv;
                decompiledText = BuildDecompiledTextForClassFileKt.buildDecompiledTextForClassFile$buildText(classHeader, partMembers);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown header kind: " + classHeader + ", class " + classId);
            }
        }
        return decompiledText;
    }

    public static /* synthetic */ DecompiledText buildDecompiledTextForClassFile$default(VirtualFile virtualFile, ResolverForDecompiler resolverForDecompiler, int n2, Object object) {
        if ((n2 & 2) != 0) {
            resolverForDecompiler = DeserializerForClassfileDecompilerKt.DeserializerForClassfileDecompiler(virtualFile);
        }
        return BuildDecompiledTextForClassFileKt.buildDecompiledTextForClassFile(virtualFile, resolverForDecompiler);
    }

    private static final DecompiledText buildDecompiledTextForClassFile$buildText(ClsKotlinBinaryClassCache.KotlinBinaryClassHeaderData classHeader, List<? extends DeclarationDescriptor> declarations2) {
        return BuildDecompiledTextKt.buildDecompiledText(classHeader.getPackageNameWithFallback(), declarations2, decompilerRendererForClassFiles);
    }

    private static final Unit decompilerRendererForClassFiles$lambda$0(DescriptorRendererOptions $this$withOptions) {
        Intrinsics.checkNotNullParameter($this$withOptions, "$this$withOptions");
        BuildDecompiledTextKt.defaultDecompilerRendererOptions($this$withOptions);
        $this$withOptions.setTypeNormalizer(BuildDecompiledTextForClassFileKt::decompilerRendererForClassFiles$lambda$0$0);
        return Unit.INSTANCE;
    }

    private static final KotlinType decompilerRendererForClassFiles$lambda$0$0(KotlinType type) {
        KotlinType kotlinType;
        KotlinType kotlinType2;
        Intrinsics.checkNotNullParameter(type, "type");
        KotlinType kotlinType3 = kotlinType2 = FlexibleTypesKt.isFlexible(type) ? (KotlinType)FlexibleTypesKt.asFlexibleType(type).getLowerBound() : type;
        if (kotlinType2 instanceof ErrorType) {
            String[] stringArray = new String[]{'`' + StringsKt.replace$default(((ErrorType)kotlinType2).getDebugMessage(), "`", "'", false, 4, null) + '`'};
            kotlinType = ErrorUtils.createErrorType(ErrorTypeKind.UNRESOLVED_TYPE, stringArray);
        } else {
            kotlinType = kotlinType2;
        }
        return kotlinType;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[KotlinClassHeader.Kind.values().length];
            try {
                nArray[KotlinClassHeader.Kind.FILE_FACADE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KotlinClassHeader.Kind.MULTIFILE_CLASS_PART.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KotlinClassHeader.Kind.CLASS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KotlinClassHeader.Kind.MULTIFILE_CLASS.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

